/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import com.jgoodies.binding.beans.Model;
import java.util.Collection;
import java.util.LinkedList;
import org.bidib.wizard.api.model.listener.StatusListener;
import org.bidib.wizard.mvc.main.view.panel.listener.ModelClockStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusModel.class);
    public static final String PROPERTY_RUNNING = "running";
    private final Collection<StatusListener> listeners = new LinkedList<StatusListener>();
    private final Collection<ModelClockStatusListener> modelClockStatusListeners = new LinkedList<ModelClockStatusListener>();
    private boolean cd;
    private boolean running;
    private boolean rx;
    private boolean tx;
    private boolean cts;
    private boolean modelClockStartEnabled;

    public void addStatusListener(StatusListener listener) {
        this.listeners.add(listener);
    }

    public void addModelClockStatusListener(ModelClockStatusListener listener) {
        this.modelClockStatusListeners.add(listener);
    }

    public boolean isCd() {
        return this.cd;
    }

    public void setCd(boolean cd) {
        LOGGER.debug("setCd: {}", (Object)cd);
        this.cd = cd;
        this.fireCdChanged(cd);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        boolean oldValue = this.running;
        this.running = running;
        this.firePropertyChange(PROPERTY_RUNNING, oldValue, this.running);
        this.fireRunningChanged(running);
    }

    public boolean isRx() {
        return this.rx;
    }

    public void setRx(boolean rx) {
        LOGGER.trace("setRx: {}", (Object)rx);
        this.rx = rx;
        this.fireRxChanged(rx);
    }

    public boolean isTx() {
        return this.tx;
    }

    public void setTx(boolean tx) {
        LOGGER.trace("setTx: {}", (Object)tx);
        this.tx = tx;
        this.fireTxChanged(tx);
    }

    public boolean isCts() {
        return this.cts;
    }

    public void setCts(boolean cts) {
        LOGGER.trace("setCts: {}", (Object)cts);
        this.cts = cts;
        this.fireCtsChanged(cts);
    }

    public boolean isModelClockStartEnabled() {
        return this.modelClockStartEnabled;
    }

    public void setModelClockStartEnabled(boolean modelClockStartEnabled) {
        LOGGER.info("Set modelClockStartEnabled: {}", (Object)modelClockStartEnabled);
        this.modelClockStartEnabled = modelClockStartEnabled;
        this.fireModelClockStartEnabledChanged(modelClockStartEnabled);
    }

    private void fireModelClockStartEnabledChanged(boolean enabled) {
        for (ModelClockStatusListener l : this.modelClockStatusListeners) {
            l.setModelTimeStartStatus(enabled);
        }
    }

    private void fireRunningChanged(boolean running) {
        for (StatusListener l : this.listeners) {
            l.runningChanged(running);
        }
    }

    private void fireRxChanged(boolean rx) {
        for (StatusListener l : this.listeners) {
            l.rxChanged(rx);
        }
    }

    private void fireTxChanged(boolean tx) {
        for (StatusListener l : this.listeners) {
            l.txChanged(tx);
        }
    }

    private void fireCdChanged(boolean cd) {
        for (StatusListener l : this.listeners) {
            l.cdChanged(cd);
        }
    }

    private void fireCtsChanged(boolean cts) {
        for (StatusListener l : this.listeners) {
            l.ctsChanged(cts);
        }
    }
}

