/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.bidib.jbidibc.core.schema.bidib2.BiDiB;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.experimental.excel.ExcelExportFactory;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.AccessoryAcknowledge;
import org.bidib.jbidibc.messages.enums.CommandStationPom;
import org.bidib.jbidibc.messages.enums.CommandStationPt;
import org.bidib.jbidibc.messages.enums.DetachedState;
import org.bidib.jbidibc.messages.enums.PomAcknowledge;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.event.ServiceRegistrationRefreshEvent;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroRef;
import org.bidib.wizard.api.model.MacroSaveState;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeListProvider;
import org.bidib.wizard.api.model.common.NetBidibServiceInfo;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.api.model.firmware.FirmwareVersion;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.dialog.ProgressDialog;
import org.bidib.wizard.client.common.dialog.callback.ProgressExecutorListener;
import org.bidib.wizard.client.common.mvc.firmware.controller.FirmwareController;
import org.bidib.wizard.client.common.mvc.firmware.controller.listener.FirmwareControllerListener;
import org.bidib.wizard.client.common.netbidib.NetBidibServiceInfoEventListener;
import org.bidib.wizard.client.common.netbidib.NetBidibServiceInfoListener;
import org.bidib.wizard.client.common.view.BidibNodeNameUtils;
import org.bidib.wizard.client.common.view.BusyFrame;
import org.bidib.wizard.client.common.view.cvdef.CvContainer;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.exception.ConnectionException;
import org.bidib.wizard.common.exception.InternalStartupException;
import org.bidib.wizard.common.exception.UriAware;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.config.AccessoryControllerFactory;
import org.bidib.wizard.config.DccAdvControllerFactory;
import org.bidib.wizard.config.FeaturesControllerFactory;
import org.bidib.wizard.config.FirmwareControllerFactory;
import org.bidib.wizard.config.LocoControllerFactory;
import org.bidib.wizard.config.LocoTableControllerFactory;
import org.bidib.wizard.config.PomProgrammerControllerFactory;
import org.bidib.wizard.config.PtProgrammerControllerFactory;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.dcca.client.controller.DccAdvController;
import org.bidib.wizard.dialog.NodeDetailsDialog;
import org.bidib.wizard.dmx.client.config.DmxModelerControllerFactory;
import org.bidib.wizard.dmx.client.controller.DmxModelerController;
import org.bidib.wizard.firmwarerepo.core.FirmwareRepoService;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.accessory.controller.AccessoryController;
import org.bidib.wizard.mvc.accessory.controller.listener.AccessoryControllerListener;
import org.bidib.wizard.mvc.common.DialogRegistry;
import org.bidib.wizard.mvc.features.controller.FeaturesController;
import org.bidib.wizard.mvc.features.controller.listener.FeaturesControllerListener;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.locolist.controller.LocoTableController;
import org.bidib.wizard.mvc.main.controller.MainController;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.MainView;
import org.bidib.wizard.mvc.main.view.component.BulkSwitchNodeOperationsDialog;
import org.bidib.wizard.mvc.main.view.exchange.ExportNodeOptionsDialog;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.exchange.SaveConfigOnNodeHelper;
import org.bidib.wizard.mvc.main.view.panel.NodeListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.bidib.wizard.mvc.pom.controller.PomProgrammerController;
import org.bidib.wizard.mvc.pom.controller.listener.PomProgrammerControllerListener;
import org.bidib.wizard.mvc.pt.controller.PtProgrammerController;
import org.bidib.wizard.mvc.pt.controller.listener.PtProgrammerControllerListener;
import org.bidib.wizard.mvc.pt.view.PtConfirmDialog;
import org.bidib.wizard.utils.FileUtils;
import org.bidib.wizard.utils.NodeUtils;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class MainNodeListActionListener
implements NodeListActionListener,
NetBidibServiceInfoListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainNodeListActionListener.class);
    private String nodeDescription;
    private final MainView view;
    private final MainModel model;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private BoosterService boosterService;
    @Autowired
    private LocoControllerFactory locoControllerFactory;
    @Autowired
    private LocoTableControllerFactory locoTableControllerFactory;
    @Autowired
    private FirmwareControllerFactory firmwareControllerFactory;
    @Autowired
    private PtProgrammerControllerFactory ptProgrammerControllerFactory;
    @Autowired
    private PomProgrammerControllerFactory pomProgrammerControllerFactory;
    @Autowired
    private AccessoryControllerFactory accessoryControllerFactory;
    @Autowired
    private DmxModelerControllerFactory dmxModelerControllerFactory;
    @Autowired
    private DccAdvControllerFactory dccAdvControllerFactory;
    @Autowired
    private FeaturesControllerFactory featuresControllerFactory;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry;
    @Autowired
    private ConsoleService consoleService;
    @Autowired
    private FirmwareRepoService firmwareRepoService;
    @Autowired
    private ApplicationContext applicationContext;
    private final StatusBar statusBar;
    private final LookupService lookupService;
    @Autowired
    private NetBidibServiceInfoEventListener netBidibServiceInfoEventListener;
    private final AtomicLong resetUniqueIdHolder = new AtomicLong();
    private final AtomicBoolean waitForReconnectElapsed = new AtomicBoolean();
    private static final String WORKING_DIR_EXCEL_EXCHANGE_KEY = "excelExchange";

    public MainNodeListActionListener(MainView view, MainModel model, StatusBar statusBar, LookupService lookupService) {
        this.view = view;
        this.model = model;
        this.statusBar = statusBar;
        this.lookupService = lookupService;
        this.nodeDescription = Resources.getString(MainController.class, (String)"nodeDescription");
    }

    private void setWaitCursor() {
        this.view.setBusy(true);
    }

    private void setDefaultCursor() {
        this.view.setBusy(false);
    }

    private FileFilter getNodeFilter() {
        FileNameExtensionFilter nodeFilter = new FileNameExtensionFilter(this.nodeDescription, "nodex");
        return nodeFilter;
    }

    @Override
    public void enableAddressMessages(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(9, node.isAddressMessagesEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures(this.model.getConnectionId(), node, features);
    }

    @Override
    public void enableDccStart(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(65, node.isDccStartEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures(this.model.getConnectionId(), node, features);
    }

    @Override
    public void enableExternalStart(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(64, node.isExternalStartEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures(this.model.getConnectionId(), node, features);
    }

    @Override
    public void enableFeedbackMessages(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(1, node.isFeedbackMessagesEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures(this.model.getConnectionId(), node, features);
    }

    @Override
    public void disableFeedbackMirror(NodeInterface node, boolean disable) {
        this.nodeService.setFeedbackMirrorDisabled(this.model.getConnectionId(), node, disable);
    }

    @Override
    public void enableKeyMessages(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(51, node.isKeyMessagesEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures(this.model.getConnectionId(), node, features);
    }

    @Override
    public void features(NodeInterface node) {
        this.setWaitCursor();
        final FeaturesController featuresController = this.featuresControllerFactory.createFeaturesController(node, (JFrame)this.view.getFrame(), this.settingsService.getWizardSettings());
        featuresController.addFeaturesControllerListener(new FeaturesControllerListener(){

            @Override
            public void close() {
                MainNodeListActionListener.this.setDefaultCursor();
            }

            @Override
            public void readAll(NodeInterface node) {
                StopWatch sw = new StopWatch();
                sw.start();
                List features = MainNodeListActionListener.this.nodeService.queryAllFeatures(MainNodeListActionListener.this.model.getConnectionId(), node, false);
                LinkedList featureList = new LinkedList();
                featureList.addAll(features);
                node.getNode().setFeatures(featureList);
                featuresController.setFeatures(features);
                sw.stop();
                LOGGER.info("Load features has finished! Total loading duration: {}", (Object)sw);
            }

            @Override
            public void write(NodeInterface node, Feature feature) {
                LOGGER.debug("Write feature to node: {}, feature: {}", (Object)node, (Object)feature);
                MainNodeListActionListener.this.nodeService.setFeatures(MainNodeListActionListener.this.model.getConnectionId(), node, Arrays.asList(feature));
            }
        });
        featuresController.start();
    }

    @Override
    public void exportNode(NodeInterface node) {
        LOGGER.info("export node: {}", (Object)node);
        NodeExchangeHelper helper = new NodeExchangeHelper();
        String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
        helper.exportNode(this.view.getFrame(), this.model.getConnectionId(), node, this.settingsService, this.nodeService, this.switchingNodeService, this.wizardLabelWrapper, this.cvDefinitionTreeModelRegistry, this.getNodeFilter(), this.statusBar, lang);
    }

    @Override
    public void importNode(NodeInterface node) {
        try {
            NodeExchangeHelper helper = new NodeExchangeHelper();
            helper.importNode(this.view.getFrame(), this.model.getConnectionId(), node, this.settingsService, this.nodeService, this.switchingNodeService, this.cvDefinitionTreeModelRegistry, this.getNodeFilter(), this.wizardLabelWrapper, this.statusBar, this, this.lookupService);
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(MainNodeListActionListener.class, (String)"importNode.error.message", (Object[])new Object[]{message}), Resources.getString(MainNodeListActionListener.class, (String)"importNode.error.title"), 0);
        }
    }

    @Override
    public void firmwareUpdate(NodeInterface node) {
        FirmwareVersion newFirmware = node.getUpdateFirmwareVersion();
        LOGGER.info("Show the firmware update dialog for node: {}, newFirmware: {}", (Object)node, (Object)newFirmware);
        FirmwareController firmwareController = this.firmwareControllerFactory.createFirmwareController(this.firmwareRepoService, node, (JFrame)this.view.getFrame());
        firmwareController.addFirmwareControllerListener(new FirmwareControllerListener(){

            public void viewClosed() {
                LOGGER.info("The firmware update view was closed.");
                MainNodeListActionListener.this.setDefaultCursor();
            }
        });
        firmwareController.start(newFirmware);
    }

    @Override
    public void identify(NodeInterface node) {
        this.nodeService.identify(this.model.getConnectionId(), node, node.getIdentifyState());
    }

    @Override
    public void dccAdvView(NodeInterface node) {
        DccAdvController dccAdvController = this.dccAdvControllerFactory.createController(node, this.view.getDesktop());
        dccAdvController.start();
    }

    @Override
    public void ping(NodeInterface node, byte[] data) {
        this.nodeService.ping(this.model.getConnectionId(), node, data, 0);
    }

    @Override
    public void enableNode(NodeInterface node) {
        this.nodeService.enable(this.model.getConnectionId(), node);
    }

    @Override
    public void disableNode(NodeInterface node) {
        this.nodeService.disable(this.model.getConnectionId(), node);
    }

    @Override
    public Long readUniqueId(NodeInterface node) {
        return this.nodeService.readUniqueId(this.model.getConnectionId(), node);
    }

    @Override
    public void detachAttachNode(NodeInterface node, boolean detach) {
        try {
            LOGGER.info("detachAttachNode, node: {}, detach: {}", (Object)node, (Object)detach);
            Long uniqueId = this.settingsService.getNetBidibSettings().getNetBidibUniqueId();
            if (detach) {
                this.nodeService.detach(this.model.getConnectionId(), node, uniqueId);
                node.setDetachedState(DetachedState.DETACHED);
            } else {
                this.nodeService.attach(this.model.getConnectionId(), node, uniqueId);
            }
        }
        catch (RuntimeException ex) {
            String message = ex.getMessage();
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(MainNodeListActionListener.class, (String)"localLogoffRejected.error.message", (Object[])new Object[]{message}), Resources.getString(MainNodeListActionListener.class, (String)"localLogoffRejected.error.title"), 0);
        }
    }

    @Override
    public void labelChanged(NodeInterface node, String label) {
        LOGGER.info("The label has changed, node: {}, label: {}", (Object)node, (Object)label);
        int stringSize = node.getNode().getStringSize();
        if (stringSize > 0) {
            String userName = label;
            if (label.length() > stringSize) {
                userName = label.substring(0, stringSize);
                LOGGER.info("Shrinked node string from '{}' to:' {}'", (Object)label, (Object)userName);
            }
            LOGGER.info("Set the new username on node: {}", (Object)userName);
            this.nodeService.setNodeDetails(this.model.getConnectionId(), node, userName);
        }
        try {
            NodeLabels nodeLabels = this.getNodeLabels(node);
            BidibLabelUtils.replaceNodeLabel((NodeLabels)nodeLabels, (String)label);
            this.saveLabels(node);
        }
        catch (InvalidConfigurationException ex) {
            LOGGER.warn("Save node labels failed.", (Throwable)ex);
            String labelPath = ex.getReason();
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.message", (Object[])new Object[]{labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.title"), 0);
        }
    }

    @Override
    public void loco(NodeInterface node) {
        LOGGER.info("Open the loco controller, node: {}", (Object)node);
        try {
            DialogRegistry dialogRegistry = (DialogRegistry)this.applicationContext.getBean(DialogRegistry.class);
            LocoController locoController = this.locoControllerFactory.createLocoController(node.getCommandStationNode(), (JFrame)this.view.getFrame(), this.model.getNodeProvider(), dialogRegistry);
            locoController.start(null, null, null);
        }
        catch (Exception ex) {
            LOGGER.warn("Create loco controller failed.", (Throwable)ex);
        }
    }

    @Override
    public void dccAccessory(NodeInterface node, int x, int y) {
        AccessoryController accessoryController = this.accessoryControllerFactory.createAccessoryController(node, (JFrame)this.view.getFrame(), new Point(x, y));
        accessoryController.addAccessoryControllerListener(new AccessoryControllerListener(){

            @Override
            public AccessoryAcknowledge sendAccessoryRequest(NodeInterface node, AddressData dccAddress, int aspect, Integer switchTime, TimeBaseUnitEnum timeBaseUnit, TimingControlEnum timingControl) {
                LOGGER.info("send accessory request, node: {}", (Object)node);
                try {
                    AccessoryAcknowledge acknowledge = MainNodeListActionListener.this.commandStationService.setDccAccessory(MainNodeListActionListener.this.model.getConnectionId(), node.getCommandStationNode(), dccAddress, aspect, switchTime, timeBaseUnit, timingControl);
                    return acknowledge;
                }
                catch (Exception ex) {
                    LOGGER.warn("Send DCC accessory failed.", (Throwable)ex);
                    return null;
                }
            }

            @Override
            public AccessoryAcknowledge sendAccessoryRequest(NodeInterface node, AddressData dccAddress, int aspect, int coilState) {
                LOGGER.info("send accessory request, node: {}", (Object)node);
                try {
                    AccessoryAcknowledge acknowledge = MainNodeListActionListener.this.commandStationService.setDccAccessory(MainNodeListActionListener.this.model.getConnectionId(), node.getCommandStationNode(), dccAddress, aspect, coilState);
                    return acknowledge;
                }
                catch (Exception ex) {
                    LOGGER.warn("Send DCC accessory failed.", (Throwable)ex);
                    return null;
                }
            }

            @Override
            public AccessoryAcknowledge sendExtendedAccessoryRequest(NodeInterface node, AddressData dccAddress, int aspect) {
                LOGGER.info("send accessory request, node: {}", (Object)node);
                try {
                    AccessoryAcknowledge acknowledge = MainNodeListActionListener.this.commandStationService.setDccExtendedAccessory(MainNodeListActionListener.this.model.getConnectionId(), node.getCommandStationNode(), dccAddress, aspect);
                    return acknowledge;
                }
                catch (Exception ex) {
                    LOGGER.warn("Send DCC accessory failed.", (Throwable)ex);
                    return null;
                }
            }
        });
        accessoryController.start();
    }

    @Override
    public void locoCv(NodeInterface node, int x, int y) {
        DialogRegistry dialogRegistry = (DialogRegistry)this.applicationContext.getBean(DialogRegistry.class);
        PomProgrammerController pomProgrammerController = this.pomProgrammerControllerFactory.createPomProgrammerController(node.getCommandStationNode(), dialogRegistry, (JFrame)this.view.getFrame(), new Point(x, y));
        pomProgrammerController.addPomProgrammerControllerListener(new PomProgrammerControllerListener(){

            @Override
            public void sendRequest(CommandStationNodeInterface node, PomAddressData locoAddress, CommandStationPom opCode, int cvNumber, int cvValue) {
                LOGGER.info("Send POM request.");
                PomAcknowledge pomAck = MainNodeListActionListener.this.commandStationService.sendCvPomRequest(MainNodeListActionListener.this.model.getConnectionId(), node, locoAddress, opCode, cvNumber, cvValue);
                LOGGER.info("Received pomAck: {}", (Object)pomAck);
            }

            @Override
            public void close() {
            }
        });
        pomProgrammerController.start(this.view.getDesktop(), null);
    }

    @Override
    public void locoCvPt(NodeInterface node, int x, int y) {
        this.setWaitCursor();
        if (!this.settingsService.getWizardSettings().isPtModeDoNotConfirmSwitch()) {
            PtConfirmDialog ptConfirmDialog = new PtConfirmDialog(node, this.settingsService, new Point(x, y));
            if (2 == ptConfirmDialog.getResult()) {
                LOGGER.info("User cancelled ptConfirmDialog.");
                this.setDefaultCursor();
                return;
            }
        } else {
            LOGGER.info("Switch to PT programming is disabled by user!");
        }
        this.setDefaultCursor();
        PtProgrammerController ptProgrammerController = this.ptProgrammerControllerFactory.createPtProgrammerController(node, (JFrame)this.view.getFrame(), new Point(x, y));
        ptProgrammerController.addPtProgrammerControllerListener(new PtProgrammerControllerListener(){

            @Override
            public void close() {
            }

            @Override
            public void sendRequest(NodeInterface node, CommandStationPt opCode, int cvNumber, int cvValue) {
                LOGGER.info("Send PT request, opCode: {}, cvNumber: {}, cvValue: {}", new Object[]{opCode, cvNumber, cvValue});
                MainNodeListActionListener.this.commandStationService.sendCvPtRequest(MainNodeListActionListener.this.model.getConnectionId(), node.getCommandStationNode(), opCode, cvNumber, cvValue);
            }

            @Override
            public void sendCommandStationStateRequest(NodeInterface node, CommandStationStatus commandStationState) {
                LOGGER.info("Send the commandStationState: {}", (Object)commandStationState);
                MainNodeListActionListener.this.commandStationService.setCommandStationState(MainNodeListActionListener.this.model.getConnectionId(), node.getCommandStationNode(), commandStationState);
            }

            @Override
            public CommandStationStatus getCurrentCommandStationState(NodeInterface node) {
                LOGGER.info("Query the command station state.");
                return MainNodeListActionListener.this.commandStationService.queryCommandStationStateBlocking(MainNodeListActionListener.this.model.getConnectionId(), node.getCommandStationNode());
            }
        });
        ptProgrammerController.start(this.view.getDesktop());
    }

    @Override
    public void nodeDetails(NodeInterface node, int x, int y) {
        new NodeDetailsDialog(node, x, y);
    }

    @Override
    public void bulkSwitchDialog(NodeInterface node, int x, int y) {
        BulkSwitchNodeOperationsDialog dialog = new BulkSwitchNodeOperationsDialog(this.view.getDesktop(), node, this.nodeService, this.switchingNodeService, this.boosterService, this.settingsService, this.consoleService, () -> this.model.getConnectionId());
        dialog.showDialog();
    }

    @Override
    public void saveOnNode(NodeInterface node, Map<String, Object> params) {
        LOGGER.info("Save the configuration to the node: {}", (Object)node);
        SaveConfigOnNodeHelper configOnNodeHelper = new SaveConfigOnNodeHelper();
        configOnNodeHelper.saveOnNode(this.model.getConnectionId(), this.nodeService, this.switchingNodeService, node, params);
    }

    @Override
    public void dmxModeler(NodeInterface node) {
        this.setWaitCursor();
        LOGGER.info("Open the DMX modeler for node: {}", (Object)node);
        try {
            DmxModelerController dmxModelerController = this.dmxModelerControllerFactory.createDmxModelerController(node, (JFrame)this.view.getFrame(), () -> this.model.getNodeProvider(), () -> this.model.getConnectionId());
            dmxModelerController.start(this.view.getDesktop(), (NodeListProvider)this.model);
        }
        catch (Exception ex) {
            LOGGER.warn("Open DMX modeler failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.view.getFrame(), "Open DMX modeler failed.", "Open DMX modeler", 0);
        }
        finally {
            this.setDefaultCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locoList(NodeInterface node) {
        this.setWaitCursor();
        LOGGER.info("Open the loco table for node: {}", (Object)node);
        try {
            MainControllerInterface mainController = (MainControllerInterface)this.applicationContext.getBean(MainControllerInterface.class);
            LocoTableController locoTableController = this.locoTableControllerFactory.createLocoTableController(node, this.view.getDesktop(), (JFrame)this.view.getFrame(), this.applicationContext);
            locoTableController.start(mainController);
            locoTableController.queryLocoList();
        }
        catch (Exception ex) {
            LOGGER.warn("Open loco table failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.view.getFrame(), "Open loco table failed.", "Open loco table", 0);
        }
        finally {
            this.setDefaultCursor();
        }
    }

    @Override
    public void reset(NodeInterface node) {
        boolean isMc2 = ProductUtils.isMc2((long)node.getUniqueId());
        LOGGER.info("Reset the node: {}, isMc2: {}, uniqueId: {}", new Object[]{node, isMc2, ByteUtils.formatHexUniqueId((long)node.getUniqueId())});
        if (isMc2) {
            this.nodeService.reset(this.model.getConnectionId(), node, false);
            LOGGER.info("Disconnect from Tams mc2 after firmware update.");
            this.disconnectAndShowReconnectDialog(this.model.getConnectionId(), node, this.view);
        } else {
            this.nodeService.reset(this.model.getConnectionId(), node, true);
        }
    }

    private void disconnectAndShowReconnectDialog(String connectionId, NodeInterface node, MainView view) {
        LOGGER.info("Disconnect from mc2 after reset and show reconnect dialog.");
        this.netBidibServiceInfoEventListener.register((NetBidibServiceInfoListener)this);
        this.resetUniqueIdHolder.set(node.getUniqueId());
        ProgressExecutorListener listener = (continueTransmit, callback) -> {
            long startTime = System.currentTimeMillis();
            try {
                long totalDelay = 30000L;
                long sleepTime = 1000L;
                int progressStep = 3;
                int currentProgress = 0;
                do {
                    Thread.sleep(1000L);
                    long now = System.currentTimeMillis();
                    if (now - 30000L > startTime) {
                        LOGGER.info("Time has elapsed, startTime: {}, now: {}", (Object)startTime, (Object)now);
                        this.waitForReconnectElapsed.set(true);
                        this.netBidibServiceInfoEventListener.unregister((NetBidibServiceInfoListener)this);
                        this.resetUniqueIdHolder.set(0L);
                        continue;
                    }
                    callback.statusChanged(currentProgress += progressStep);
                } while (!this.waitForReconnectElapsed.get());
                callback.statusChanged(85);
                LOGGER.info("Wait for 5s before change status to 90.");
                Thread.sleep(5000L);
                callback.statusChanged(90);
                LOGGER.info("Wait for 2s before reconnect.");
                Thread.sleep(2000L);
                callback.statusChanged(100);
                this.netBidibServiceInfoEventListener.unregister((NetBidibServiceInfoListener)this);
                this.resetUniqueIdHolder.set(0L);
                LOGGER.info("Reconnect the connection with id: {}", (Object)connectionId);
                DefaultContext context = new DefaultContext();
                try {
                    Function<BidibConnection, BidibConnection> afterCreateOrFind = conn -> {
                        LOGGER.info("Open connection has passed, connectionId: {}", (Object)connectionId);
                        return conn;
                    };
                    this.connectionService.connect(connectionId, afterCreateOrFind, afterCreateOrFind, (Context)context);
                }
                catch (ConnectionException | InternalStartupException ex) {
                    LOGGER.warn("Connect failed.", ex);
                    String message = ex.getMessage();
                    if (StringUtils.isNotBlank((CharSequence)((UriAware)ex).getUri())) {
                        StringBuilder sb = new StringBuilder(((UriAware)ex).getUri());
                        sb.append("\r\n").append(ex.getMessage());
                        message = sb.toString();
                    }
                    this.showErrorDialog((JFrame)view.getFrame(), Resources.getString(MainNodeListActionListener.class, (String)"open-connection.failed", (Object[])new Object[]{message}), Resources.getString(MainNodeListActionListener.class, (String)"open-connection.title"));
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Wait for elapse of reconnect time failed.", (Throwable)ex);
            }
            finally {
                if (callback != null) {
                    LOGGER.info("Finish the callback.");
                    callback.transferFinished();
                }
                this.netBidibServiceInfoEventListener.unregister((NetBidibServiceInfoListener)this);
                this.resetUniqueIdHolder.set(0L);
            }
        };
        SwingUtilities.invokeLater(() -> {
            LOGGER.info("Create and show the progress dialog.");
            String title = Resources.getString(MainNodeListActionListener.class, (String)"reconnect.title");
            String message = Resources.getString(MainNodeListActionListener.class, (String)"reconnect.message");
            String progressPrefix = Resources.getString(MainNodeListActionListener.class, (String)"reconnect.progressPrefix");
            ProgressDialog progressDialog = new ProgressDialog((Component)view.getFrame(), true, title, message, progressPrefix, List.of(listener));
            progressDialog.start();
        });
        this.connectionService.disconnect(connectionId);
        this.waitForReconnectElapsed.set(false);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait a second before send the ServiceRegistrationRefreshEvent was interrupted.");
        }
        LOGGER.info("Publish the ServiceRegistrationRefreshEvent, node: {}", (Object)node);
        this.applicationContext.publishEvent((Object)new ServiceRegistrationRefreshEvent(connectionId, node.getUniqueId()));
    }

    private void showErrorDialog(JFrame parent, String message, String title) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(parent, message, title, 0);
        } else {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(parent, message, title, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateDocumentation(final NodeInterface node) {
        if (node != null) {
            try {
                this.setWaitCursor();
                LOGGER.info("Generate documentation for node: {}", (Object)node);
                String bidibNodeFilesDescription = Resources.getString(NodeListPanel.class, (String)"bidibNodeFilesDescription");
                FileNameExtensionFilter bidibNodesFilter = new FileNameExtensionFilter(bidibNodeFilesDescription, "xlsx");
                String nodeLabel = NodeUtils.prepareLabel(node);
                Object defaultFileName = nodeLabel + ".xlsx";
                if (StringUtils.isNotBlank((CharSequence)node.getNode().getStoredString(1))) {
                    defaultFileName = node.getNode().getStoredString(1) + ".xlsx";
                }
                defaultFileName = FileUtils.escapeInvalidFilenameCharacters((String)defaultFileName, "_");
                final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
                String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_EXCEL_EXCHANGE_KEY);
                FileDialog dialog = new FileDialog((Component)this.view.getFrame(), 1, storedWorkingDirectory, (String)defaultFileName, new FileFilter[]{bidibNodesFilter}){
                    private JCheckBox checkLoadMacroContent;
                    private JCheckBox checkLoadFeatures;
                    private JCheckBox checkLoadCVs;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void approve(String selectedFile) {
                        selectedFile = this.makeSureFileNameHasExtension(selectedFile, "xlsx");
                        try {
                            ExportNodeOptionsDialog exportNodeOptionsDialog = new ExportNodeOptionsDialog((Frame)MainNodeListActionListener.this.view.getFrame(), Resources.getString(MainNodeListActionListener.class, (String)"generateOptions.title"), node){
                                private static final long serialVersionUID = 1L;

                                @Override
                                protected Component getAdditionalPanel() {
                                    JPanel additionalPanel = new JPanel();
                                    additionalPanel.setLayout(new BoxLayout(additionalPanel, 3));
                                    if (org.bidib.jbidibc.messages.utils.NodeUtils.hasSwitchFunctions((long)node.getUniqueId())) {
                                        checkLoadMacroContent = new JCheckBox(Resources.getString(MainController.class, (String)"checkLoadMacroContent"), true);
                                        additionalPanel.add(checkLoadMacroContent);
                                    }
                                    checkLoadFeatures = new JCheckBox(Resources.getString(MainController.class, (String)"checkLoadFeatures"), true);
                                    additionalPanel.add(checkLoadFeatures);
                                    checkLoadCVs = new JCheckBox(Resources.getString(MainController.class, (String)"checkLoadCVs"), true);
                                    additionalPanel.add(checkLoadCVs);
                                    return additionalPanel;
                                }
                            };
                            exportNodeOptionsDialog.setVisible(true);
                            if (exportNodeOptionsDialog.getResult() != 0) {
                                LOGGER.info("User cancelled options.");
                                return;
                            }
                            LOGGER.info("User confirmed options.");
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Show exportNodeOptionsDialog failed.", (Throwable)ex);
                            return;
                        }
                        String workingDir = Paths.get(selectedFile, new String[0]).toString();
                        LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                        wizardSettings.setWorkingDirectory(MainNodeListActionListener.WORKING_DIR_EXCEL_EXCHANGE_KEY, workingDir);
                        File file = new File(selectedFile);
                        String fileName = file.getPath();
                        BusyFrame busyFrame = (BusyFrame)DefaultApplicationContext.getInstance().get("mainFrame", BusyFrame.class);
                        try {
                            busyFrame.setBusy(true);
                            LOGGER.info("Load the macro content of the node before export: {}", (Object)node);
                            boolean nodeHasFlatPortModel = node.getNode().isPortFlatModelAvailable();
                            LOGGER.info("Prepare the nodeState, nodeHasFlatPortModel: {}", (Object)nodeHasFlatPortModel);
                            LinkedList<Macro> macroList = new LinkedList<Macro>();
                            for (Macro macro : node.getMacros()) {
                                Macro macroWithContent = MainNodeListActionListener.this.switchingNodeService.getMacroContent(MainNodeListActionListener.this.model.getConnectionId(), node.getSwitchingNode(), macro);
                                LOGGER.info("Load macro content: {}", (Object)macroWithContent);
                                macroWithContent.setMacroSaveState(MacroSaveState.PERMANENTLY_STORED_ON_NODE);
                                macroWithContent.setFlatPortModel(nodeHasFlatPortModel);
                                macroList.add(macroWithContent);
                            }
                            LOGGER.info("Set the new macros for the node: {}", macroList);
                            node.setMacros(macroList);
                            CvContainer cvContainer = MainNodeListActionListener.this.cvDefinitionTreeModelRegistry.getCvContainer(node.getUniqueId());
                            Map cvNumberToNodeMap = cvContainer != null ? cvContainer.getCvNumberToNodeMap() : new HashMap();
                            String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
                            BiDiB bidib = NodeUtils.convertToBiDiB(node, cvNumberToNodeMap, lang, !this.checkLoadCVs.isSelected(), MainNodeListActionListener.this.wizardLabelWrapper);
                            LOGGER.info("Converted bidib: {}", (Object)bidib);
                            ExcelExportFactory.exportDocumentation((BiDiB)bidib, (String)fileName, (String)lang);
                            MainNodeListActionListener.this.statusBar.setStatusText(Resources.getString(NodeListPanel.class, (String)"export-documentation-passed", (Object[])new Object[]{fileName}), -1);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Generate documentation failed.", (Throwable)ex);
                            TaskDialogs.build((Window)JOptionPane.getFrameForComponent((Component)MainNodeListActionListener.this.view.getFrame()), (String)Resources.getString(NodeListPanel.class, (String)"export-documentation-failed.instruction"), (String)Resources.getString(NodeListPanel.class, (String)"export-documentation-failed")).title(Resources.getString(NodeListPanel.class, (String)"export-documentation.title")).exception((Throwable)ex);
                        }
                        finally {
                            busyFrame.setBusy(false);
                        }
                    }
                };
                dialog.showDialog();
            }
            catch (Exception ex) {
                LOGGER.warn("Generate documentation failed.", (Throwable)ex);
            }
            finally {
                this.setDefaultCursor();
            }
        }
    }

    @Override
    public void deleteNodeLabels(NodeInterface node) {
        if (node != null) {
            NodeLabels nodeLabels = this.getNodeLabels(node);
            String label = BidibNodeNameUtils.prepareLabel((NodeInterface)node, (NodeLabels)nodeLabels, (boolean)false, (boolean)false).getNodeLabel();
            boolean delete = TaskDialogs.ask((Window)JOptionPane.getFrameForComponent((Component)this.view.getFrame()), (String)Resources.getString(MainNodeListActionListener.class, (String)"deleteLabels"), (String)Resources.getString(MainNodeListActionListener.class, (String)"deleteLabelsOfNode", (Object[])new Object[]{label}));
            if (delete) {
                this.wizardLabelWrapper.deleteNodeLabels(Long.valueOf(node.getUniqueId()));
                for (Accessory accessory : node.getAccessories()) {
                    accessory.setLabel(null);
                    for (MacroRef aspect : accessory.getAspects()) {
                        aspect.setLabel(null);
                    }
                }
                for (Macro macro : node.getMacros()) {
                    macro.setLabel(null);
                }
                for (Flag flag : node.getFlags()) {
                    flag.setLabel(null);
                }
                for (Port port : node.getPorts()) {
                    port.setLabel(null);
                }
                node.setLabel(null);
            }
        }
    }

    private NodeLabels getNodeLabels(NodeInterface node) {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(node.getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels(NodeInterface node) {
        try {
            long uniqueId = node.getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save accessory labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reloadNode(NodeInterface node) {
        LOGGER.info("Reload the node configuration: {}", (Object)node);
        this.nodeService.reloadNode(this.model.getConnectionId(), node);
    }

    public void handleNetBidibServiceInfo(NetBidibServiceInfo serviceInfo) {
        LOGGER.info("NetBidibServiceInfo was received: {}", (Object)serviceInfo);
        try {
            String uid = (String)serviceInfo.getProps().get("uid");
            long signalledUid = Long.parseLong(uid, 16);
            LOGGER.info("The signalled uid: {}", (Object)ByteUtils.getUniqueIdAsStringCompact((long)signalledUid));
            long storedUniqueId = this.resetUniqueIdHolder.get();
            if (storedUniqueId > 0L && org.bidib.jbidibc.messages.utils.NodeUtils.compareUniqueIdIgnoreClassbits((long)storedUniqueId, (long)signalledUid)) {
                LOGGER.info("The signalled uid matches the uid of the current node.");
                this.waitForReconnectElapsed.set(true);
                this.netBidibServiceInfoEventListener.unregister((NetBidibServiceInfoListener)this);
                this.resetUniqueIdHolder.set(0L);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Handle service info failed.", (Throwable)ex);
        }
    }
}

