/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.component;

import java.text.DecimalFormat;
import java.util.function.Supplier;
import org.bidib.wizard.client.common.component.SliderAndValuePanel;
import org.bidib.wizard.model.ports.BacklightPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacklightSliderAndValuePanel
extends SliderAndValuePanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklightSliderAndValuePanel.class);
    private final DecimalFormat format = new DecimalFormat("##0");
    private final Supplier<BacklightPort> backlightPortSupplier;

    public BacklightSliderAndValuePanel(int min, int max, int value, Supplier<BacklightPort> backlightPortSupplier) {
        super(min, max, value);
        this.backlightPortSupplier = backlightPortSupplier;
    }

    protected void updateSliderTextValue(int value) {
        LOGGER.trace("updateSliderTextValue, value: {}, isSelected: {}", (Object)value);
        String newValue = this.format.format(value);
        LOGGER.trace("Set the new value: {}", (Object)newValue);
        Integer targetAbsolute = null;
        BacklightPort port = this.backlightPortSupplier.get();
        int range = port.getDimSlopeUp() - port.getDimSlopeDown();
        float factor = (float)range / 100.0f;
        float targetValue = factor * (float)value + (float)port.getDimSlopeDown();
        LOGGER.trace("Calculated range: {}, factor: {}, targetValue: {}", new Object[]{range, Float.valueOf(factor), Float.valueOf(targetValue)});
        targetAbsolute = Math.round(targetValue);
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(newValue).append("% ");
        if (targetAbsolute != null) {
            sb.append("<FONT COLOR=");
            sb.append("GRAY");
            sb.append(">(").append(targetAbsolute).append(")</FONT>");
        }
        sb.append("</html>");
        this.sliderValue.setText(sb.toString());
    }
}

