/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.exchange;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.core.schema.bidib2.BiDiB;
import org.bidib.jbidibc.core.schema.bidib2.ConfigurationVariable;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointInput;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutput;
import org.bidib.jbidibc.core.schema.bidib2.Node;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.exception.UserActionAbortedException;
import org.bidib.wizard.client.common.view.DefaultBusyFrame;
import org.bidib.wizard.client.common.view.cvdef.CvContainer;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.mvc.main.controller.MainController;
import org.bidib.wizard.mvc.main.view.MainNodeListActionListener;
import org.bidib.wizard.mvc.main.view.component.NodeErrorsDialog;
import org.bidib.wizard.mvc.main.view.component.SaveNodeConfigurationDialog;
import org.bidib.wizard.mvc.main.view.exchange.ExportNodeOptionsDialog;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.bidib.wizard.utils.FileUtils;
import org.bidib.wizard.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeExchangeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeExchangeHelper.class);
    public static final String NODE_X_EXTENSION = "nodex";
    private static final String WORKING_DIR_NODE_EXCHANGE_KEY = "nodeExchange";

    public void importNode(final DefaultBusyFrame parentComponent, final String connectionId, final NodeInterface node, SettingsService settingsService, final NodeService nodeService, final SwitchingNodeService switchingNodeService, final CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry, FileFilter nodeFilter, final WizardLabelWrapper wizardLabelWrapper, final StatusBar statusBar, final NodeListActionListener nodeListActionListener, final LookupService lookupService) {
        final HashMap importParams = new HashMap();
        final WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_NODE_EXCHANGE_KEY);
        FileDialog dialog = new FileDialog((Component)parentComponent, 0, storedWorkingDirectory, null, new FileFilter[]{nodeFilter}){
            private JCheckBox checkRestoreAccessoryContent;
            private JCheckBox checkRestoreMacroContent;
            private JCheckBox checkRestoreNodeString;
            private JCheckBox checkRestoreFeatures;
            private JCheckBox checkRestoreCVs;

            public void approve(final String fileName) {
                BiDiB bidib;
                LOGGER.info("Start importing node, fileName: {}", (Object)fileName);
                try {
                    LOGGER.info("Use BiDiB data to restore the node.");
                    File bidibFile = new File(fileName);
                    bidib = BidibFactory.loadBiDiBFile((File)bidibFile);
                    if (bidib == null || bidib.getNodes() == null || bidib.getNodes().getNode().isEmpty()) {
                        LOGGER.warn("The provided BiDiB data is not valid for node import.");
                        throw new IllegalArgumentException("The provided BiDiB data is not valid for node import.");
                    }
                }
                catch (FileNotFoundException ex) {
                    LOGGER.warn("Load the bidib instance from the file failed.", (Throwable)ex);
                    throw new IllegalStateException(ex);
                }
                try {
                    ExportNodeOptionsDialog exportNodeOptionsDialog = new ExportNodeOptionsDialog((Frame)parentComponent, Resources.getString(NodeExchangeHelper.class, (String)"importOptions.title"), node){
                        private static final long serialVersionUID = 1L;

                        @Override
                        protected Component getAdditionalPanel() {
                            boolean defaultImportCVOnly = false;
                            boolean preventImportCV = false;
                            if ((ProductUtils.isOneControl((long)node.getUniqueId()) || ProductUtils.isOneDriveTurn((long)node.getUniqueId())) && SoftwareVersion.build((int)3, (int)0, (int)0).isHigherThan(node.getNode().getSoftwareVersion())) {
                                int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent((Component)parentComponent), Resources.getString(MainNodeListActionListener.class, (String)"importOneControl.message"), Resources.getString(MainNodeListActionListener.class, (String)"importOneControl.title"), 0, 1);
                                if (result == 0) {
                                    LOGGER.info("User selected OK to uncheck all options expect the import of CV values.");
                                    defaultImportCVOnly = true;
                                    importParams.put("defaultImportCVOnly", defaultImportCVOnly);
                                }
                            } else if (ProductUtils.isReadyServoTurn((long)node.getUniqueId()) && node.getNode().getSoftwareVersion().isHigherThan(SoftwareVersion.build((int)2, (int)3, (int)2))) {
                                SoftwareVersion releaseFwVersion;
                                preventImportCV = true;
                                String releaseVersion = NodeUtils.findFirmwareReleaseOfBackup(bidib);
                                if (releaseVersion != null && (releaseFwVersion = SoftwareVersion.parse((String)releaseVersion)).isHigherOrEqualThan(SoftwareVersion.build((int)2, (int)5, (int)0))) {
                                    preventImportCV = false;
                                }
                                LOGGER.info("Current preventImportCV: {}", (Object)preventImportCV);
                            }
                            JPanel additionalPanel = new JPanel();
                            additionalPanel.setLayout(new BoxLayout(additionalPanel, 3));
                            checkRestoreNodeString = new JCheckBox(Resources.getString(MainController.class, (String)"checkRestoreNodeString"), true);
                            additionalPanel.add(checkRestoreNodeString);
                            if (org.bidib.jbidibc.messages.utils.NodeUtils.hasAccessoryFunctions((long)node.getUniqueId())) {
                                checkRestoreAccessoryContent = new JCheckBox(Resources.getString(MainController.class, (String)"checkRestoreAccessoryContent"), !defaultImportCVOnly);
                                additionalPanel.add(checkRestoreAccessoryContent);
                                checkRestoreMacroContent = new JCheckBox(Resources.getString(MainController.class, (String)"checkRestoreMacroContent"), !defaultImportCVOnly);
                                additionalPanel.add(checkRestoreMacroContent);
                                if (defaultImportCVOnly) {
                                    checkRestoreAccessoryContent.setEnabled(false);
                                    checkRestoreMacroContent.setEnabled(false);
                                }
                            }
                            checkRestoreFeatures = new JCheckBox(Resources.getString(MainController.class, (String)"checkRestoreFeatures"), false);
                            additionalPanel.add(checkRestoreFeatures);
                            if (defaultImportCVOnly) {
                                checkRestoreFeatures.setEnabled(false);
                            }
                            checkRestoreCVs = new JCheckBox(Resources.getString(MainController.class, (String)"checkRestoreCVs"), defaultImportCVOnly);
                            additionalPanel.add(checkRestoreCVs);
                            if (preventImportCV) {
                                checkRestoreCVs.setSelected(false);
                                checkRestoreCVs.setEnabled(false);
                            } else if (defaultImportCVOnly) {
                                checkRestoreCVs.setEnabled(false);
                            }
                            return additionalPanel;
                        }
                    };
                    exportNodeOptionsDialog.setVisible(true);
                    if (exportNodeOptionsDialog.getResult() != 0) {
                        LOGGER.info("User cancelled options.");
                        return;
                    }
                    LOGGER.info("User confirmed options.");
                }
                catch (Exception ex) {
                    LOGGER.warn("Show exportNodeOptionsDialog failed.", (Throwable)ex);
                    return;
                }
                try {
                    parentComponent.setBusy(true);
                    NodeExchangeHelper.this.transformMatchingProduct((Component)parentComponent, node, bidib, lookupService);
                    NodeUtils.configureFromBiDiB(connectionId, nodeService, switchingNodeService, cvDefinitionTreeModelRegistry, node, importParams, bidib, wizardLabelWrapper, this.checkRestoreCVs != null ? this.checkRestoreCVs.isSelected() : false, this.checkRestoreFeatures != null ? this.checkRestoreFeatures.isSelected() : false, this.checkRestoreNodeString != null ? this.checkRestoreNodeString.isSelected() : false, this.checkRestoreMacroContent != null ? this.checkRestoreMacroContent.isSelected() : false, this.checkRestoreAccessoryContent != null ? this.checkRestoreAccessoryContent.isSelected() : false);
                    LOGGER.info("Save the node labels.");
                    try {
                        long uniqueId = node.getUniqueId();
                        wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
                    }
                    catch (InvalidConfigurationException ex) {
                        LOGGER.warn("Save port labels failed.", (Throwable)ex);
                        String labelPath = ex.getReason();
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent((Component)parentComponent), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.message", (Object[])new Object[]{labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.title"), 0);
                    }
                    statusBar.setStatusText(String.format(Resources.getString(MainController.class, (String)"importedNodeState"), fileName), -1);
                    SaveNodeConfigurationDialog saveNodeConfigurationDialog = new SaveNodeConfigurationDialog((Frame)parentComponent, null, null, node, importParams, true){
                        private static final long serialVersionUID = 1L;

                        @Override
                        protected void fireContinue(NodeInterface node) {
                            LOGGER.info("User wants to save the macros to node: {}", (Object)node);
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            params.put("saveMacros", this.isSaveMacros());
                            params.put("saveAccessories", this.isSaveAccessories());
                            params.put("saveBacklightPorts", this.isSaveBacklightPorts());
                            params.put("saveLightPorts", this.isSaveLightPorts());
                            params.put("saveServoPorts", this.isSaveServoPorts());
                            params.put("saveSwitchPorts", this.isSaveSwitchPorts());
                            params.put("saveFeatures", this.isSaveFeatures());
                            params.put("saveConfigurationVariables", this.isSaveConfigurationVariables());
                            try {
                                parentComponent.setBusy(true);
                                statusBar.setStatusText(String.format(Resources.getString(MainController.class, (String)"writeToNode"), fileName), -1);
                                nodeListActionListener.saveOnNode(node, params);
                            }
                            catch (Throwable throwable) {
                                statusBar.setStatusText(String.format(Resources.getString(MainController.class, (String)"writeToNodeFinished"), fileName), -1);
                                parentComponent.setBusy(false);
                                throw throwable;
                            }
                            statusBar.setStatusText(String.format(Resources.getString(MainController.class, (String)"writeToNodeFinished"), fileName), -1);
                            parentComponent.setBusy(false);
                            if (params.containsKey("saveErrors")) {
                                LOGGER.warn("The save on node operation has finished with errors!!!");
                                NodeErrorsDialog nodeErrorsDialog = new NodeErrorsDialog((Frame)parentComponent, null, true);
                                nodeErrorsDialog.setErrors(Resources.getString(MainController.class, (String)"save-values-on-node-failed"), (List)params.get("saveErrors"));
                                nodeErrorsDialog.showDialog();
                            }
                        }

                        @Override
                        protected void fireCancel(NodeInterface node) {
                            LOGGER.info("User cancelled upload of changes to node: {}", (Object)node);
                        }
                    };
                    saveNodeConfigurationDialog.setSaveFeaturesEnabled(this.checkRestoreFeatures.isSelected());
                    saveNodeConfigurationDialog.setSaveCVsEnabled(this.checkRestoreCVs.isSelected());
                    saveNodeConfigurationDialog.showDialog();
                    String workingDir = Paths.get(fileName, new String[0]).getParent().toString();
                    LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                    wizardSettings.setWorkingDirectory(NodeExchangeHelper.WORKING_DIR_NODE_EXCHANGE_KEY, workingDir);
                }
                catch (UserActionAbortedException ex) {
                    LOGGER.info("User cancelled the import operation.");
                }
                catch (InvalidConfigurationException ex) {
                    LOGGER.warn("Load node configuration failed.", (Throwable)ex);
                    throw new RuntimeException(Resources.getString(MainNodeListActionListener.class, (String)ex.getReason()));
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Load node configuration failed.", (Throwable)ex);
                    throw ex;
                }
                catch (Exception ex) {
                    LOGGER.warn("Load node configuration failed.", (Throwable)ex);
                    throw new RuntimeException("Load node configuration failed.");
                }
                finally {
                    parentComponent.setBusy(false);
                }
            }
        };
        dialog.showDialog();
    }

    protected void transformMatchingProduct(Component parent, NodeInterface node, BiDiB bidib, LookupService lookupService) throws UserActionAbortedException {
        if (bidib == null || bidib.getNodes() == null || bidib.getNodes().getNode().isEmpty()) {
            LOGGER.warn("The provided BiDiB data is not valid for node import.");
            throw new IllegalArgumentException("The provided BiDiB data is not valid for node import.");
        }
        Node importNode = (Node)bidib.getNodes().getNode().get(0);
        LOGGER.info("Transform the bidib instance, node: {}, schemaNode: {}", (Object)node, (Object)importNode.getProductName());
        long sourceUniqueId = importNode.getUniqueId();
        long targetUniqueId = node.getUniqueId();
        if (ProductUtils.isProductEqual((long)targetUniqueId, (long)sourceUniqueId)) {
            if (ProductUtils.getVendorId((long)sourceUniqueId) == 251 && (ProductUtils.getPid((long)sourceUniqueId) == 114 || ProductUtils.getPid((long)sourceUniqueId) == 113) || ProductUtils.getVendorId((long)sourceUniqueId) == 13 && ProductUtils.getPid((long)sourceUniqueId) == 118) {
                SoftwareVersion importVersion = SoftwareVersion.parse((String)importNode.getFirmwareRelease());
                if (node.getNode().getSoftwareVersion().isHigherOrEqualThan(SoftwareVersion.build((int)2, (int)0, (int)0)) && importVersion.isLowerThan(SoftwareVersion.build((int)2, (int)0, (int)0))) {
                    this.transformOneDmxToV2(importNode);
                }
            }
            return;
        }
        if (ProductUtils.getVendorId((long)sourceUniqueId) == 13 && ProductUtils.getVendorId((long)targetUniqueId) == 13) {
            if (ProductUtils.getPid((long)sourceUniqueId) == 142 && ProductUtils.getPid((long)targetUniqueId) == 140 || ProductUtils.getPid((long)sourceUniqueId) == 141 && ProductUtils.getPid((long)targetUniqueId) == 117) {
                LOGGER.info("Found import of OneControl-04-16-48-24 --> OneControl-08-00-48-24 or OneControl 04-16-32-20 --> OneControl 08-00-32-20. Must change the port numbers for all ports with portnumber > 3.");
                int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(parent), Resources.getString(NodeExchangeHelper.class, (String)"import-with-transformation.message"), Resources.getString(NodeExchangeHelper.class, (String)"import-with-transformation.title"), 2, 1);
                if (result != 0) {
                    LOGGER.info("User cancelled import operation.");
                    throw new UserActionAbortedException("User cancelled import operation.");
                }
                this.transformOneControlOneDriveTurn(importNode);
            } else if (ProductUtils.getPid((long)sourceUniqueId) == 145 && ProductUtils.getPid((long)targetUniqueId) == 143 || ProductUtils.getPid((long)sourceUniqueId) == 144 && ProductUtils.getPid((long)targetUniqueId) == 122) {
                LOGGER.info("Found import of OneDriveTurn-04-16-48-24 --> OneDriveTurn-08-00-48-24 or OneDriveTurn 04-16-32-20 --> OneDriveTurn 08-00-32-20. Must change the port numbers for all ports with portnumber > 3.");
                int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(parent), Resources.getString(NodeExchangeHelper.class, (String)"import-with-transformation.message"), Resources.getString(NodeExchangeHelper.class, (String)"import-with-transformation.title"), 2, 1);
                if (result != 0) {
                    LOGGER.info("User cancelled import operation.");
                    throw new UserActionAbortedException("User cancelled import operation.");
                }
                this.transformOneControlOneDriveTurn(importNode);
            } else if (ProductUtils.getPid((long)sourceUniqueId) != ProductUtils.getPid((long)targetUniqueId)) {
                String sourceProductName = this.getProductName(lookupService, sourceUniqueId);
                String targetProductName = this.getProductName(lookupService, targetUniqueId);
                int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(parent), Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.message", (Object[])new Object[]{sourceProductName, targetProductName}), Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.title"), 2, 2);
                if (result != 0) {
                    LOGGER.info("User cancelled import operation.");
                    throw new UserActionAbortedException("User cancelled import operation.");
                }
            }
        } else if (ProductUtils.getVendorId((long)sourceUniqueId) == 251 && ProductUtils.getVendorId((long)targetUniqueId) == 251) {
            if (ProductUtils.getPid((long)sourceUniqueId) != ProductUtils.getPid((long)targetUniqueId)) {
                String sourceProductName = this.getProductName(lookupService, sourceUniqueId);
                String targetProductName = this.getProductName(lookupService, targetUniqueId);
                int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(parent), Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.message", (Object[])new Object[]{sourceProductName, targetProductName}), Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.title"), 2, 2);
                if (result != 0) {
                    LOGGER.info("User cancelled import operation.");
                    throw new UserActionAbortedException("User cancelled import operation.");
                }
            }
        } else if (ProductUtils.getVendorId((long)sourceUniqueId) != ProductUtils.getVendorId((long)targetUniqueId) && ProductUtils.getPid((long)sourceUniqueId) != ProductUtils.getPid((long)targetUniqueId)) {
            String sourceProductName = this.getProductName(lookupService, sourceUniqueId);
            String targetProductName = this.getProductName(lookupService, targetUniqueId);
            int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(parent), Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.message", (Object[])new Object[]{sourceProductName, targetProductName}), Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.title"), 2, 2);
            if (result != 0) {
                LOGGER.info("User cancelled import operation.");
                throw new UserActionAbortedException("User cancelled import operation.");
            }
        }
    }

    protected String getProductName(LookupService lookupService, long sourceUniqueId) {
        String sourceProductName = lookupService.getProduct(ProductUtils.getVendorId((long)sourceUniqueId), ProductUtils.getPid((long)sourceUniqueId)).filter(Objects::nonNull).map(pt -> pt.getName()).orElse(Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.unknown-product", (Object[])new Object[]{ProductUtils.getVendorId((long)sourceUniqueId), ProductUtils.getPid((long)sourceUniqueId)}));
        return sourceProductName;
    }

    protected void transformOneDmxToV2(Node importNode) {
        if (importNode.getConfigurationVariables() != null && !importNode.getConfigurationVariables().getConfigurationVariable().isEmpty()) {
            int channelIndex;
            LOGGER.info("Process CV values.");
            Collections.sort(importNode.getConfigurationVariables().getConfigurationVariable(), (cv1, cv2) -> Integer.compare(Integer.parseInt(cv1.getName()), Integer.parseInt(cv2.getName())));
            LOGGER.info("Number of CV values: {}", (Object)importNode.getConfigurationVariables().getConfigurationVariable().size());
            if (LOGGER.isDebugEnabled()) {
                importNode.getConfigurationVariables().getConfigurationVariable().forEach(cv -> LOGGER.debug("Current CV, num: {}, value: {}", (Object)cv.getName(), (Object)cv.getValue()));
            }
            List configurationVariables = importNode.getConfigurationVariables().getConfigurationVariable();
            ArrayList<ConfigurationVariable> configurationVariablesTarget = new ArrayList<ConfigurationVariable>();
            int startCvSource = 781;
            int startCvTarget = 771;
            for (int overlayIndex = 3; overlayIndex > -1; --overlayIndex) {
                int cvNumberSource = startCvSource;
                int cvNumberTarget = startCvTarget;
                for (channelIndex = 7; channelIndex > -1; --channelIndex) {
                    LOGGER.info("sourceCv: {} --> targetCv: {}", (Object)cvNumberSource, (Object)cvNumberTarget);
                    this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource, cvNumberTarget, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
                    this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource + 1, cvNumberTarget + 1, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
                    this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource + 2, cvNumberTarget + 4, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
                    this.transformCv(configurationVariablesTarget, cvNumberTarget + 2, cvVar -> cvVar.setValue(String.valueOf(0)));
                    this.transformCv(configurationVariablesTarget, cvNumberTarget + 3, cvVar -> cvVar.setValue(String.valueOf(0)));
                    cvNumberSource -= 3;
                    cvNumberTarget -= 5;
                }
                startCvSource -= 48;
                startCvTarget -= 40;
            }
            startCvSource = 808;
            startCvTarget = 776;
            int cvNumberSource = startCvSource;
            int cvNumberTarget = startCvTarget;
            for (int dmxChannelIndex = 0; dmxChannelIndex < 32; ++dmxChannelIndex) {
                for (channelIndex = 0; channelIndex < 26; ++channelIndex) {
                    cvNumberSource = startCvSource + channelIndex;
                    cvNumberTarget = startCvTarget + channelIndex;
                    LOGGER.info("DMX-channel, sourceCv: {} --> targetCv: {}", (Object)cvNumberSource, (Object)cvNumberTarget);
                    this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource, cvNumberTarget, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
                }
                startCvSource += 26;
                startCvTarget += 26;
            }
            startCvSource = 1640;
            startCvTarget = 1608;
            cvNumberSource = startCvSource;
            cvNumberTarget = startCvTarget;
            for (int inputMappingIndex = 0; inputMappingIndex < 8; ++inputMappingIndex) {
                cvNumberSource = startCvSource + inputMappingIndex;
                cvNumberTarget = startCvTarget + inputMappingIndex;
                LOGGER.info("input mapping, sourceCv: {} --> targetCv: {}", (Object)cvNumberSource, (Object)cvNumberTarget);
                this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource, cvNumberTarget, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
            }
            startCvSource = 1648;
            startCvTarget = 1616;
            cvNumberSource = startCvSource;
            cvNumberTarget = startCvTarget;
            for (int internalIndex = 0; internalIndex < 10; ++internalIndex) {
                cvNumberSource = startCvSource + internalIndex;
                cvNumberTarget = startCvTarget + internalIndex;
                LOGGER.info("internal, sourceCv: {} --> targetCv: {}", (Object)cvNumberSource, (Object)cvNumberTarget);
                this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource, cvNumberTarget, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
            }
            startCvSource = 1710;
            startCvTarget = 1710;
            cvNumberSource = startCvSource;
            cvNumberTarget = startCvTarget;
            ConfigurationVariable cvNumberOfConfiguredDimmers = this.getCv(configurationVariables, cvNumberSource);
            int numberOfConfiguredDimmers = Integer.parseInt(cvNumberOfConfiguredDimmers.getValue());
            LOGGER.info("Number of configured dimmers in tools storage: {}, cvNumberSource:{}", (Object)numberOfConfiguredDimmers, (Object)cvNumberSource);
            LOGGER.info("tools, sourceCv: {} --> targetCv: {}", (Object)cvNumberSource, (Object)cvNumberTarget);
            this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource, cvNumberTarget, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
            ++cvNumberSource;
            ++cvNumberTarget;
            for (int dmxDimmerIndex = 0; dmxDimmerIndex < 5; ++dmxDimmerIndex) {
                ConfigurationVariable cvNumberOfConfiguredChannels = this.getCv(configurationVariables, cvNumberSource);
                int numberOfConfiguredChannels = Integer.parseInt(cvNumberOfConfiguredChannels.getValue());
                LOGGER.info("Number of configured channels in tools storage: {}, currentChannelCountIndexCv: {}", (Object)numberOfConfiguredChannels, (Object)cvNumberSource);
                this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource, cvNumberTarget, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
                LOGGER.info("tools, sourceCv: {} --> targetCv: {}", (Object)cvNumberSource, (Object)cvNumberTarget);
                ++cvNumberSource;
                ++cvNumberTarget;
                for (int dmxDimmerChannelIndex = 0; dmxDimmerChannelIndex < 6; ++dmxDimmerChannelIndex) {
                    LOGGER.info("tools, sourceCv: {} --> targetCv: {}", (Object)cvNumberSource, (Object)cvNumberTarget);
                    this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource, cvNumberTarget, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
                    LOGGER.info("tools, sourceCv: {} --> targetCv: {}", (Object)(++cvNumberSource), (Object)(++cvNumberTarget));
                    this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource, cvNumberTarget, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
                    ++cvNumberSource;
                    ++cvNumberTarget;
                }
            }
            Collections.sort(configurationVariablesTarget, (cv1, cv2) -> Integer.compare(Integer.parseInt(cv1.getName()), Integer.parseInt(cv2.getName())));
            LOGGER.info("configurationVariablesTarget: {}", configurationVariablesTarget);
            List filteredCVs = configurationVariables.stream().filter(cv -> Integer.parseInt(cv.getName()) < 616).collect(Collectors.toList());
            LOGGER.info("Number of filtered CV values: {}", (Object)filteredCVs.size());
            configurationVariables.clear();
            configurationVariables.addAll(filteredCVs);
            configurationVariables.addAll(configurationVariablesTarget);
            LOGGER.info("Final number of CV values: {}", (Object)configurationVariables.size());
        }
    }

    private ConfigurationVariable getCv(List<ConfigurationVariable> configurationVariables, int cvNumberSource) {
        ConfigurationVariable cvVarSource = configurationVariables.stream().filter(cv -> cv.getName().equals(String.valueOf(cvNumberSource))).findFirst().orElseThrow(() -> new IllegalArgumentException("No CV available, cvNumber: " + cvNumberSource));
        return cvVarSource;
    }

    private void transformCv(List<ConfigurationVariable> configurationVariables, List<ConfigurationVariable> configurationVariablesTarget, int cvNumberSource, int cvNumberTarget, BiConsumer<ConfigurationVariable, ConfigurationVariable> action) {
        ConfigurationVariable cvVarSource = configurationVariables.stream().filter(cv -> cv.getName().equals(String.valueOf(cvNumberSource))).findFirst().orElseThrow(() -> new IllegalArgumentException("No CV available, cvNumber: " + cvNumberSource));
        ConfigurationVariable cvVarTarget = new ConfigurationVariable().withName(String.valueOf(cvNumberTarget)).withDescription(cvVarSource.getDescription()).withDefaultValue(cvVarSource.getDefaultValue()).withValue(cvVarSource.getValue()).withTimeout(cvVarSource.isTimeout());
        configurationVariablesTarget.add(cvVarTarget);
        action.accept(cvVarSource, cvVarTarget);
    }

    private void transformCv(List<ConfigurationVariable> configurationVariablesTarget, int cvNumberTarget, Consumer<ConfigurationVariable> action) {
        ConfigurationVariable cvVarTarget = new ConfigurationVariable().withName(String.valueOf(cvNumberTarget));
        configurationVariablesTarget.add(cvVarTarget);
        action.accept(cvVarTarget);
    }

    protected void transformOneControlOneDriveTurn(Node importNode) {
        if (importNode.getPorts() != null) {
            importNode.getPorts().getPort().stream().map(port -> {
                LOGGER.info("Process port: {}", port);
                if (port.getNumber() > 3) {
                    LOGGER.info("Port: change port number from {} to {}", (Object)port.getNumber(), (Object)(port.getNumber() + 4));
                    port.setNumber(port.getNumber() + 4);
                }
                return port;
            }).collect(Collectors.toList());
        } else {
            LOGGER.warn("No ports available.");
        }
        if (importNode.getMacros() != null) {
            importNode.getMacros().getMacro().forEach(macro -> {
                if (macro.getMacroPoints() != null) {
                    macro.getMacroPoints().getMacroPoint().stream().filter(mp -> mp instanceof MacroPointOutput || mp instanceof MacroPointInput).map(mp -> {
                        MacroPointInput mpi;
                        if (mp instanceof MacroPointOutput) {
                            MacroPointOutput mpo = (MacroPointOutput)mp;
                            if (mpo.getOutputNumber() > 3) {
                                LOGGER.info("Macro: change port number from {} to {}", (Object)mpo.getOutputNumber(), (Object)(mpo.getOutputNumber() + 4));
                                mpo.setOutputNumber(mpo.getOutputNumber() + 4);
                            }
                        } else if (mp instanceof MacroPointInput && (mpi = (MacroPointInput)mp).getInputNumber() > 3) {
                            LOGGER.info("Macro: change input port number from {} to {}", (Object)mpi.getInputNumber(), (Object)(mpi.getInputNumber() + 4));
                            mpi.setInputNumber(mpi.getInputNumber() + 4);
                        }
                        return mp;
                    }).collect(Collectors.toList());
                }
            });
        } else {
            LOGGER.warn("No macros available.");
        }
        if (importNode.getConfigurationVariables() != null && !importNode.getConfigurationVariables().getConfigurationVariable().isEmpty()) {
            LOGGER.info("Process CV values.");
            Collections.sort(importNode.getConfigurationVariables().getConfigurationVariable(), (cv1, cv2) -> Integer.compare(Integer.parseInt(cv1.getName()), Integer.parseInt(cv2.getName())));
            LOGGER.info("Number of CV values: {}", (Object)importNode.getConfigurationVariables().getConfigurationVariable().size());
            if (LOGGER.isDebugEnabled()) {
                importNode.getConfigurationVariables().getConfigurationVariable().forEach(cv -> LOGGER.debug("Current CV, num: {}, value: {}", (Object)cv.getName(), (Object)cv.getValue()));
            }
            List filteredCVs = importNode.getConfigurationVariables().getConfigurationVariable().stream().filter(cv -> Integer.parseInt(cv.getName()) < 10000).collect(Collectors.toList());
            LOGGER.info("Number of filtered CV values: {}", (Object)filteredCVs.size());
            importNode.getConfigurationVariables().getConfigurationVariable().clear();
            importNode.getConfigurationVariables().getConfigurationVariable().addAll(filteredCVs);
        }
    }

    public void exportNode(final DefaultBusyFrame parentComponent, final String connectionId, final NodeInterface node, SettingsService settingsService, final NodeService nodeService, final SwitchingNodeService switchingNodeService, final WizardLabelWrapper wizardLabelWrapper, final CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry, FileFilter nodeFilter, final StatusBar statusBar, final String lang) {
        LOGGER.info("export node: {}", (Object)node);
        final WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
        String fileName = NodeExchangeHelper.prepareFileName(wizardSettings, node);
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_NODE_EXCHANGE_KEY);
        FileDialog dialog = new FileDialog((Component)parentComponent, 1, storedWorkingDirectory, fileName, new FileFilter[]{nodeFilter}){
            private JCheckBox checkLoadCVs;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void approve(String fileName) {
                fileName = this.makeSureFileNameHasExtension(fileName, NodeExchangeHelper.NODE_X_EXTENSION);
                try {
                    ExportNodeOptionsDialog exportNodeOptionsDialog = new ExportNodeOptionsDialog((Frame)parentComponent, Resources.getString(NodeExchangeHelper.class, (String)"exportOptions.title"), node){
                        private static final long serialVersionUID = 1L;

                        @Override
                        protected Component getAdditionalPanel() {
                            JPanel additionalPanel = new JPanel();
                            additionalPanel.setLayout(new BoxLayout(additionalPanel, 3));
                            checkLoadCVs = new JCheckBox(Resources.getString(MainController.class, (String)"checkLoadCVs"), true);
                            additionalPanel.add(checkLoadCVs);
                            return additionalPanel;
                        }
                    };
                    exportNodeOptionsDialog.setVisible(true);
                    if (exportNodeOptionsDialog.getResult() != 0) {
                        LOGGER.info("User cancelled options.");
                        return;
                    }
                    LOGGER.info("User confirmed options.");
                }
                catch (Exception ex) {
                    LOGGER.warn("Show exportNodeOptionsDialog failed.", (Throwable)ex);
                    return;
                }
                try {
                    parentComponent.setBusy(true);
                    LOGGER.info("Save node state for node: {}, fileName: {}", (Object)node, (Object)fileName);
                    NodeUtils.loadDataFromNode(connectionId, nodeService, switchingNodeService, node, true, this.checkLoadCVs.isSelected());
                    BiDiB bidib = NodeExchangeHelper.this.prepareBiDiB(node, cvDefinitionTreeModelRegistry, lang, !this.checkLoadCVs.isSelected(), wizardLabelWrapper);
                    LOGGER.info("Export node, converted node to bidib: {}", (Object)bidib);
                    BidibFactory.saveBiDiB((BiDiB)bidib, (String)fileName, (boolean)false);
                    LOGGER.info("Save node state passed, fileName: {}", (Object)fileName);
                    String workingDir = Paths.get(fileName, new String[0]).getParent().toString();
                    LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                    wizardSettings.setWorkingDirectory(NodeExchangeHelper.WORKING_DIR_NODE_EXCHANGE_KEY, workingDir);
                    statusBar.setStatusText(String.format(Resources.getString(MainController.class, (String)"exportedNodeState"), fileName), -1);
                }
                finally {
                    parentComponent.setBusy(false);
                }
            }
        };
        dialog.showDialog();
    }

    public BiDiB prepareBiDiB(NodeInterface node, CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry, String lang, boolean skipCvValues, WizardLabelWrapper wizardLabelWrapper) {
        CvContainer cvContainer = cvDefinitionTreeModelRegistry.getCvContainer(node.getUniqueId());
        Map cvNumberToNodeMap = cvContainer != null ? cvContainer.getCvNumberToNodeMap() : new HashMap();
        BiDiB bidib = NodeUtils.convertToBiDiB(node, cvNumberToNodeMap, lang, skipCvValues, wizardLabelWrapper);
        LOGGER.debug("prepareBiDiB, converted node to bidib: {}", (Object)bidib);
        return bidib;
    }

    public static String prepareFileName(WizardSettingsInterface wizardSettings, NodeInterface node) {
        Object nodeLabel = NodeUtils.prepareLabel(node);
        boolean nodeExportAppendDateEnabled = wizardSettings.isNodeExportAppendDateEnabled();
        if (nodeExportAppendDateEnabled) {
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("_yyyyMMdd_HHmmss");
            String currentDateTime = now.format(formatter);
            nodeLabel = (String)nodeLabel + currentDateTime;
        }
        LOGGER.info("export node, prepared nodeLabel as filename: {}", nodeLabel);
        if (!FileUtils.isPathValid((String)nodeLabel) || !FileUtils.isFilenameValid((String)nodeLabel)) {
            LOGGER.warn("The default filename is not a valid filename: {}", nodeLabel);
            nodeLabel = FileUtils.escapeInvalidFilenameCharacters((String)nodeLabel, "_");
            LOGGER.info("export node, prepared escaped filename: {}", nodeLabel);
        }
        return (String)nodeLabel + ".nodex";
    }
}

