/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.menu;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.menu.ToolsMenuProvider;
import org.bidib.wizard.mvc.main.view.menu.ToolsMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidibToolsMenu
implements ToolsMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibToolsMenu.class);
    private JMenu menu;
    private final List<JMenuItem> topItems = new ArrayList<JMenuItem>();
    private final List<ToolsMenuProvider> toolsMenuProviders;

    public BidibToolsMenu(List<ToolsMenuProvider> toolsMenuProviders) {
        this.toolsMenuProviders = toolsMenuProviders;
    }

    @Override
    public JMenu getJMenu() {
        if (this.menu == null) {
            this.menu = new JMenu();
        }
        return this.menu;
    }

    @Override
    public void addTopItem(JMenuItem menuItem) {
        this.topItems.add(menuItem);
    }

    @Override
    public void prepareMenu() {
        this.menu.removeAll();
        for (JMenuItem menuItem : this.topItems) {
            this.addMenuItem(this.menu, menuItem);
        }
        for (ToolsMenuProvider provider : this.toolsMenuProviders) {
            LOGGER.info("Add provided menu item: {}", (Object)provider);
            JMenuItem menuItem = provider.getMenuItem();
            this.addMenuItem(this.menu, menuItem);
        }
    }

    private void addMenuItem(Object menu, JMenuItem menuItem) {
        if (menu instanceof JMenu) {
            ((JMenu)menu).add(menuItem);
        } else if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(menuItem);
        }
    }

    @Override
    public void selectedNodeChanged(NodeInterface selectedNode) {
        for (ToolsMenuProvider provider : this.toolsMenuProviders) {
            provider.selectedNodeChanged(selectedNode);
        }
    }
}

