/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.menu;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.bidib.wizard.mvc.main.view.menu.DockingFramesRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowListMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowListMenu.class);
    private DockingFramesRegistry dockingFramesRegistry;
    private final List<JMenuItem> topItems = new ArrayList<JMenuItem>();
    private Map<String, JMenuItem> stickyItems = new TreeMap<String, JMenuItem>();
    private final JMenu menu;

    public WindowListMenu(DockingFramesRegistry dockingFramesRegistry) {
        this.dockingFramesRegistry = dockingFramesRegistry;
        this.menu = new JMenu();
    }

    public JMenu getJMenu() {
        return this.menu;
    }

    public void addTopItem(JMenuItem menuItem) {
        this.topItems.add(menuItem);
    }

    public void addStickyItem(String dockKeyKey, JMenuItem menuItem) {
        this.stickyItems.put(dockKeyKey, menuItem);
    }

    public void prepareMenu() {
        this.menu.removeAll();
        for (JMenuItem menuItem : this.topItems) {
            this.addMenuItem(this.menu, menuItem);
        }
        for (JMenuItem menuItem : this.stickyItems.values()) {
            this.addMenuItem(this.menu, menuItem);
        }
        for (Dockable dockable : this.dockingFramesRegistry.getDockables()) {
            String dockKeyKey = dockable.getDockKey().getKey();
            if (this.stickyItems.containsKey(dockKeyKey)) continue;
            JMenuItem menuItem = new JMenuItem(dockable.getDockKey().getName());
            menuItem.setActionCommand(dockable.getDockKey().getKey());
            LOGGER.trace("Created new menu item: {}", (Object)menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String dockKey = e.getActionCommand();
                    Dockable dockable = WindowListMenu.this.dockingFramesRegistry.getDockable(new DockKey(dockKey));
                    LOGGER.trace("Select dockable: {}", (Object)dockable);
                    WindowListMenu.this.selectWindow(dockable);
                }
            });
            this.addMenuItem(this.menu, menuItem);
        }
    }

    private void selectWindow(Dockable dockable) {
        TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dockable);
        if (container != null) {
            container.setSelectedDockable(dockable);
        } else {
            LOGGER.warn("Container not available, select component directly.");
            dockable.getComponent().requestFocusInWindow();
        }
    }

    private void addMenuItem(Object menu, JMenuItem menuItem) {
        if (menu instanceof JMenu) {
            ((JMenu)menu).add(menuItem);
        } else if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(menuItem);
        }
    }
}

