/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.pairing;

import java.awt.Frame;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.netbidib.evaluator.PairingEvaluator;
import org.bidib.wizard.dialog.PairingDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PairingEvaluatorDialog
implements PairingEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PairingEvaluatorDialog.class);

    public boolean acceptPairing(NetBidibLinkData bidibLinkData, Integer pairingTimeout) {
        AtomicBoolean pairingAccepted = new AtomicBoolean();
        LOGGER.info("Show the accept pairing dialog. Provided pairingTimeout: {}", (Object)pairingTimeout);
        if (SwingUtilities.isEventDispatchThread()) {
            this.acceptPairing(bidibLinkData, pairingTimeout, pairingAccepted);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.acceptPairing(bidibLinkData, pairingTimeout, pairingAccepted));
            }
            catch (Exception ex) {
                LOGGER.warn("Show the accept pairing dialog failed.", (Throwable)ex);
            }
        }
        return pairingAccepted.get();
    }

    private void acceptPairing(NetBidibLinkData bidibLinkData, Integer pairingTimeout, AtomicBoolean pairingAccepted) {
        Frame parent = JOptionPane.getFrameForComponent(null);
        DefaultContext context = new DefaultContext();
        context.register("REQUESTOR_NAME", (Object)bidibLinkData.getRequestorName());
        context.register("DESCRIPTOR_UID", (Object)bidibLinkData.getUniqueId());
        context.register("DESCRIPTOR_PROD_STRING", (Object)bidibLinkData.getProdString());
        context.register("DESCRIPTOR_USER_STRING", (Object)bidibLinkData.getUserString());
        context.register("PAIRING_TIMEOUT", (Object)pairingTimeout);
        context.register("CONNECTION_TYPE", (Object)"server");
        LOGGER.info("Show the pairing dialog.");
        PairingDialog pairingDialog = new PairingDialog(parent, PairingDialog.PairingDialogType.PairingRequested, (Context)context, true, accepted -> {
            if (Boolean.FALSE == accepted) {
                LOGGER.info("The user cancelled the pairing dialog.");
            } else {
                LOGGER.info("The user accepted the pairing.");
                pairingAccepted.set(true);
            }
        });
        pairingDialog.setAlwaysOnTop(true);
        pairingDialog.setVisible(true);
    }
}

