/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import com.jidesoft.grid.CellStyleTableHeader;
import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TreeTableModel;
import com.jidesoft.swing.JideSwingUtilities;
import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarPanel;
import com.vlsolutions.swing.toolbars.VLToolBar;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.core.schema.CvExchangeFactory;
import org.bidib.jbidibc.core.schema.cvexchange.CVListType;
import org.bidib.jbidibc.core.schema.cvexchange.CVSType;
import org.bidib.jbidibc.core.schema.cvexchange.MasterDataType;
import org.bidib.jbidibc.core.schema.cvexchange.SaveCV;
import org.bidib.jbidibc.exchange.vendorcv.CVType;
import org.bidib.jbidibc.exchange.vendorcv.DataType;
import org.bidib.jbidibc.exchange.vendorcv.ModeType;
import org.bidib.jbidibc.exchange.vendorcv.VendorCV;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvFactory;
import org.bidib.jbidibc.exchange.vendorcv.VersionInfoType;
import org.bidib.jbidibc.experimental.excel.ExcelExportFactory;
import org.bidib.jbidibc.experimental.excel.model.CvData;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.model.listener.PortListenerProvider;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.controller.CvDefinitionPanelControllerInterface;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.ButtonUtils;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.cvdef.AbstractNode;
import org.bidib.wizard.client.common.view.cvdef.CvBidibUidEditor;
import org.bidib.wizard.client.common.view.cvdef.CvBitfieldValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvByteValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvDccLongAddrValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeHelper;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.client.common.view.cvdef.CvIntegerValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvIpAddressEditor;
import org.bidib.wizard.client.common.view.cvdef.CvLongValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvMacAddressEditor;
import org.bidib.wizard.client.common.view.cvdef.CvMasterNodeAware;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.client.common.view.cvdef.CvRadioValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvSignedCharValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvValueNumberEditor;
import org.bidib.wizard.client.common.view.cvdef.CvValueStringEditor;
import org.bidib.wizard.client.common.view.cvdef.DccAccAddrEditor;
import org.bidib.wizard.client.common.view.cvdef.DccAddrRGEditor;
import org.bidib.wizard.client.common.view.cvdef.DeviceNode;
import org.bidib.wizard.client.common.view.cvdef.GBM16TReverserEditor;
import org.bidib.wizard.client.common.view.cvdef.KeywordNodeNode;
import org.bidib.wizard.client.common.view.cvdef.LongCvNode;
import org.bidib.wizard.client.common.view.cvdef.NodeNode;
import org.bidib.wizard.client.common.view.listener.TabStatusListener;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.mvc.common.exception.NodeChangeVetoException;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvDefinitionPanelProvider;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvValueUtils;
import org.bidib.wizard.mvc.main.controller.MainController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.CvDefinitionRequestListenerAware;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabSelectionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.CvDefinitionJideTreeTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvDefinitionPanel
extends JPanel
implements TabSelectionListener,
CvDefinitionPanelProvider,
CvDefinitionRequestListenerAware,
TabPanelProvider,
TabVisibilityProvider,
TabComponentCreator,
PortListenerProvider<FeedbackPort>,
NodeListListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CvDefinitionPanel.class);
    private static final String NONE = "none";
    private final SettingsService settingsService;
    private final CvDefinitionPanelControllerInterface cvDefinitionPanelController;
    private final StatusBar statusBar;
    private Map<String, ConfigurationVariable> configVariables;
    private CvDefinitionTreeTableModel treeModel;
    private JTextField textXmlFileName;
    private JTextField textVersion;
    private JTextField textLastUpdate;
    private JTextField textAuthor;
    private JTextField textDescription;
    private final CvDefinitionJideTreeTable cvTreeTable;
    private JButton saveButton;
    private CardLayout cardLayout;
    private EditorPanels editorPanels;
    private Map<String, CvNode> cvNumberToNodeMap;
    private static final String READ = "read";
    private static final String WRITE = "write";
    private static final String LOAD = "loadFromFile";
    private static final String SAVE = "saveToFile";
    private JButton readButton;
    private JButton writeButton;
    private JButton loadFromFileButton;
    private JButton saveToFileButton;
    private JButton exportToExcelButton;
    private VLToolBar toolbarCvDefinition;
    private final TabStatusListener tabStatusListener;
    private final MainModel mainModel;
    private final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider;
    private final Map<DataType, CvValueEditor> mapDataTypeToEditor = new HashMap<DataType, CvValueEditor>();
    private final List<CvDefinitionRequestListener> cvDefinitionRequestListeners = new LinkedList<CvDefinitionRequestListener>();
    private JButton copyToUserDirCvDefinitionButton;
    private JButton deleteFromUserDirCvDefinitionButton;
    protected ValidationResultModel cvValidationModel;
    private CvDefinitionFileValueBean definitionFileValueBean = new CvDefinitionFileValueBean();
    private ImageIcon userDefinedImportIcon;
    private CvBidibUidEditor bidibUidEditor;
    private CvMacAddressEditor macAddressEditor;
    private CvIpAddressEditor ipAddressEditor;
    private GBM16TReverserEditor gbm16TReverserEditor;
    private DccAccAddrEditor dccAccAddrEditor;
    private DccAddrRGEditor dccAddrRGEditor;
    private CvValueNumberEditor<Byte> byteEditor;
    private CvValueNumberEditor<Byte> bitfieldEditor;
    private CvValueNumberEditor<Byte> radioEditor;
    private CvValueNumberEditor<Integer> integerEditor;
    private CvValueNumberEditor<Long> longEditor;
    private CvValueNumberEditor<Integer> dccLongAddrEditor;
    private CvSignedCharValueEditor signedCharEditor;
    private CvValueStringEditor stringEditor;
    private static FileFilter cvExchangeFilter;
    private static final String CV_EXCHANGE_EXTENSION = "xml";
    private static final String WORKING_DIR_CV_DEFINITION_KEY = "cvDefinition";
    public static final String PATTERN_CV_FILENAME = "^BiDiBCV-([0-9]{1,3})-.+\\.xml$";

    public CvDefinitionPanel(CvDefinitionPanelControllerInterface cvDefinitionPanelController, FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider, MainModel mainModel, TabStatusListener tabStatusListener, SettingsService settingsService, StatusBar statusBar) {
        this.settingsService = settingsService;
        this.cvDefinitionPanelController = cvDefinitionPanelController;
        this.tabStatusListener = tabStatusListener;
        this.mainModel = mainModel;
        this.feedbackPortStatusChangeProvider = feedbackPortStatusChangeProvider;
        this.statusBar = statusBar;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setOpaque(false);
        LOGGER.debug("Create the CV tree.");
        this.cvTreeTable = new CvDefinitionJideTreeTable();
        this.cvTreeTable.setSelectionMode(0);
        this.cvTreeTable.getTableHeader().setReorderingAllowed(false);
        JTableHeader header = this.cvTreeTable.getTableHeader();
        JideSwingUtilities.insertMouseListener((Component)header, (MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getSource() instanceof CellStyleTableHeader) {
                    CellStyleTableHeader _header = (CellStyleTableHeader)e.getSource();
                    Point p = e.getPoint();
                    int index = _header.originalColumnAtPoint(p);
                    if (_header.getTable() != null && index == 0 && p.x < 20) {
                        LOGGER.info("Collapse/Expand all items.");
                        TableModel model = CvDefinitionPanel.this.cvTreeTable.getModel();
                        if (model != null) {
                            boolean isCollapsed;
                            CvDefinitionTreeTableModel cvDefinitionTreeTableModel;
                            if (model instanceof SortableTableModel) {
                                model = ((SortableTableModel)model).getActualModel();
                            }
                            cvDefinitionTreeTableModel.setCollapsed(!(isCollapsed = (cvDefinitionTreeTableModel = (CvDefinitionTreeTableModel)model).isCollapsed()));
                            if (isCollapsed) {
                                CvDefinitionPanel.this.cvTreeTable.expandAll();
                            } else {
                                CvDefinitionPanel.this.cvTreeTable.collapseAll();
                            }
                        }
                        e.consume();
                    }
                }
            }
        }, (int)0);
        this.cvTreeTable.setRowHeight(this.cvTreeTable.getRowHeight() + 6);
        ListSelectionModel listSelectionModel = this.cvTreeTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LOGGER.debug("list selection, e: {}", (Object)e);
                if (e.getValueIsAdjusting()) {
                    return;
                }
                CvNode cvNode = null;
                int index = CvDefinitionPanel.this.cvTreeTable.getSelectedRow();
                DefaultExpandableRow row = (DefaultExpandableRow)CvDefinitionPanel.this.cvTreeTable.getRowAt(index);
                LOGGER.info("Selection has changed, current index: {}, row: {}", (Object)index, (Object)row);
                if (row != null) {
                    if (row instanceof CvMasterNodeAware) {
                        CvMasterNodeAware longNodeNode = (CvMasterNodeAware)row;
                        CvNode masterNode = longNodeNode.getSubCvMasterNode();
                        if (masterNode != null) {
                            LOGGER.info("Found masterNode to select: {}", (Object)masterNode);
                            cvNode = masterNode;
                            SwingUtilities.invokeLater(() -> CvDefinitionPanel.this.cvTreeTable.expandRow(index, true));
                        }
                    } else if (row instanceof KeywordNodeNode) {
                        KeywordNodeNode keywordNodeNode = (KeywordNodeNode)row;
                        if (keywordNodeNode.getMasterNode() != null) {
                            cvNode = keywordNodeNode.getMasterNode();
                        }
                    } else if (row instanceof CvNode) {
                        cvNode = (CvNode)row;
                    }
                }
                if (cvNode != null) {
                    LOGGER.info("Show node in editor: {}", cvNode);
                    DataType dataTypeName = cvNode.getCV().getType();
                    CvDefinitionPanel.this.editorPanels.show(dataTypeName.name());
                    ArrayList<CvValueEditor> editors = new ArrayList<CvValueEditor>();
                    editors.addAll(CvDefinitionPanel.this.mapDataTypeToEditor.values());
                    CvDefinitionPanel.this.saveButton.setEnabled(false);
                    CvValueStringEditor selectedEditor = null;
                    switch (dataTypeName) {
                        case INT: {
                            selectedEditor = CvDefinitionPanel.this.integerEditor;
                            break;
                        }
                        case BYTE: {
                            selectedEditor = CvDefinitionPanel.this.byteEditor;
                            break;
                        }
                        case BIT: {
                            selectedEditor = CvDefinitionPanel.this.bitfieldEditor;
                            break;
                        }
                        case SIGNED_CHAR: {
                            selectedEditor = CvDefinitionPanel.this.signedCharEditor;
                            break;
                        }
                        case DCC_ACC_ADDR: {
                            selectedEditor = CvDefinitionPanel.this.dccAccAddrEditor;
                            break;
                        }
                        case DCC_ADDR_RG: {
                            selectedEditor = CvDefinitionPanel.this.dccAddrRGEditor;
                            break;
                        }
                        case GBM_16_T_REVERSER: {
                            selectedEditor = CvDefinitionPanel.this.gbm16TReverserEditor;
                            break;
                        }
                        case RADIO: {
                            selectedEditor = CvDefinitionPanel.this.radioEditor;
                            break;
                        }
                        case LONG: {
                            selectedEditor = CvDefinitionPanel.this.longEditor;
                            break;
                        }
                        case DCC_LONG_ADDR: {
                            selectedEditor = CvDefinitionPanel.this.dccLongAddrEditor;
                            break;
                        }
                        case STRING: {
                            selectedEditor = CvDefinitionPanel.this.stringEditor;
                            break;
                        }
                        case BI_DI_B_UID: {
                            selectedEditor = CvDefinitionPanel.this.bidibUidEditor;
                            break;
                        }
                        case MAC_ADDRESS: {
                            selectedEditor = CvDefinitionPanel.this.macAddressEditor;
                            break;
                        }
                        case IP_ADDRESS: {
                            selectedEditor = CvDefinitionPanel.this.ipAddressEditor;
                            break;
                        }
                        default: {
                            LOGGER.warn("Unhandled dataTypeName: {}", (Object)dataTypeName);
                        }
                    }
                    if (selectedEditor != null) {
                        PropertyConnector.connect((Object)selectedEditor.getSaveButtonEnabledModel(), (String)"value", (Object)CvDefinitionPanel.this.saveButton, (String)"enabled");
                        selectedEditor.setValue(cvNode, CvDefinitionPanel.this.cvNumberToNodeMap);
                        for (CvValueEditor editor : editors) {
                            if (editor.equals((Object)selectedEditor)) {
                                LOGGER.info("Skip selected editor: {}", (Object)selectedEditor);
                                continue;
                            }
                            editor.setValue(null, CvDefinitionPanel.this.cvNumberToNodeMap);
                        }
                    } else {
                        LOGGER.warn("Non matching cvNode editor was selected: {}", (Object)dataTypeName);
                        CvDefinitionPanel.this.editorPanels.show(CvDefinitionPanel.NONE);
                        CvDefinitionPanel.this.clearAllEditors();
                    }
                } else {
                    LOGGER.info("Non cvNode was selected.");
                    CvDefinitionPanel.this.editorPanels.show(CvDefinitionPanel.NONE);
                    CvDefinitionPanel.this.clearAllEditors();
                }
            }
        });
        this.cvTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                CvDefinitionPanel.this.potentiallyShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CvDefinitionPanel.this.potentiallyShowPopup(e);
            }
        });
        JSplitPane splitPane = new JSplitPane(1);
        JScrollPane scrollTree = new JScrollPane((Component)((Object)this.cvTreeTable));
        splitPane.add(scrollTree);
        JPanel westPanel = new JPanel(new BorderLayout());
        westPanel.add((Component)this.createXmFileInfoPanel(), "North");
        westPanel.add((Component)this.createCvEditorPanel(mainModel), "Center");
        JScrollPane scrollCvEditors = new JScrollPane(westPanel);
        splitPane.add(scrollCvEditors);
        this.add((Component)splitPane, "Center");
        splitPane.setDividerLocation(800);
        this.toolbarCvDefinition = new VLToolBar(WORKING_DIR_CV_DEFINITION_KEY);
        this.addButtons(this.toolbarCvDefinition);
        this.addToolBar(this.toolbarCvDefinition, new ToolBarConstraints(0, 2));
        this.toolbarCvDefinition.setVisible(false);
    }

    protected void clearAllEditors() {
        ArrayList<CvValueEditor> editors = new ArrayList<CvValueEditor>();
        editors.addAll(this.mapDataTypeToEditor.values());
        for (CvValueEditor editor : editors) {
            editor.setValue(null, this.cvNumberToNodeMap);
        }
    }

    public void resetPendingChanges() {
        if (this.treeModel != null) {
            LOGGER.info("Reset pending changes on root node.");
            DefaultExpandableRow root = (DefaultExpandableRow)this.treeModel.getRoot();
            this.resetPendingChanges(root);
        }
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof CvDefinitionPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.isCvDefinitionAvailable();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    private void addToolBar(VLToolBar toolBar, ToolBarConstraints constraints) {
        ToolBarPanel topToolBarPanel = (ToolBarPanel)DefaultApplicationContext.getInstance().get("topToolBarPanel");
        topToolBarPanel.add(toolBar, constraints);
    }

    private void removeToolBar(VLToolBar toolBar) {
        ToolBarPanel topToolBarPanel = (ToolBarPanel)DefaultApplicationContext.getInstance().get("topToolBarPanel");
        topToolBarPanel.remove((Component)toolBar);
    }

    private JPanel createXmFileInfoPanel() {
        boolean formDebugPanel = false;
        FormBuilder builder = FormBuilder.create().columns("pref, 3dlu, min(30dlu;pref), 3dlu, pref, 3dlu, max(30dlu;pref), 3dlu, pref, 3dlu, pref", new Object[0]).rows("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p", new Object[0]).panel((JPanel)(formDebugPanel ? new FormDebugPanel() : new JPanel()));
        builder.border((Border)Paddings.DIALOG);
        PropertyAdapter modeModel = new PropertyAdapter((Object)this.definitionFileValueBean, "fileName", true);
        this.textXmlFileName = WizardComponentFactory.createTextField((ValueModel)modeModel, (boolean)false);
        this.textXmlFileName.setColumns(20);
        this.textXmlFileName.setEditable(false);
        this.textVersion = new JTextField(7);
        this.textVersion.setEditable(false);
        this.textLastUpdate = new JTextField(20);
        this.textLastUpdate.setEditable(false);
        this.textAuthor = new JTextField(20);
        this.textAuthor.setEditable(false);
        this.textDescription = new JTextField(30);
        this.textDescription.setEditable(false);
        this.userDefinedImportIcon = ImageUtils.createImageIcon(CvDefinitionPanel.class, (String)"/icons/16x16/user-defined.png");
        ImageIcon copyToUserDirIcon = ImageUtils.createImageIcon(CvDefinitionPanel.class, (String)"/icons/16x16/copy.png");
        ImageIcon deleteFromUserDirIcon = ImageUtils.createImageIcon(CvDefinitionPanel.class, (String)"/icons/16x16/delete.png");
        JButton importCvDefinitionButton = new JButton(this.userDefinedImportIcon);
        importCvDefinitionButton.setToolTipText(Resources.getString(this.getClass(), (String)"import.tooltip"));
        importCvDefinitionButton.addActionListener(evt -> {
            LOGGER.info("Import user-defined CV definition.");
            this.importUserDefinedCvDefinition();
        });
        this.copyToUserDirCvDefinitionButton = new JButton(copyToUserDirIcon);
        this.copyToUserDirCvDefinitionButton.setToolTipText(Resources.getString(this.getClass(), (String)"copy-to-user-dir.tooltip"));
        this.copyToUserDirCvDefinitionButton.addActionListener(evt -> {
            LOGGER.info("Copy CV definition to user directory.");
            this.copyToUserDirCvDefinition();
        });
        this.deleteFromUserDirCvDefinitionButton = new JButton(deleteFromUserDirIcon);
        this.deleteFromUserDirCvDefinitionButton.setToolTipText(Resources.getString(this.getClass(), (String)"delete-from-user-dir.tooltip"));
        this.deleteFromUserDirCvDefinitionButton.addActionListener(evt -> {
            LOGGER.info("Delete CV definition from user directory.");
            this.deleteFromUserDirCvDefinition();
        });
        builder.addSeparator(Resources.getString(this.getClass(), (String)"fileinfo.title"), new Object[0]).xyw(1, 1, 9);
        builder.add(Resources.getString(this.getClass(), (String)"fileinfo.xmlfile"), new Object[0]).xy(1, 3);
        builder.add((Component)this.textXmlFileName).xyw(3, 3, 3);
        builder.add((Component)importCvDefinitionButton).xy(7, 3);
        builder.add((Component)this.copyToUserDirCvDefinitionButton).xy(9, 3);
        builder.add((Component)this.deleteFromUserDirCvDefinitionButton).xy(11, 3);
        builder.add(Resources.getString(this.getClass(), (String)"fileinfo.version"), new Object[0]).xy(1, 5);
        builder.add((Component)this.textVersion).xy(3, 5);
        builder.add(Resources.getString(this.getClass(), (String)"fileinfo.lastchange"), new Object[0]).xy(5, 5);
        builder.add((Component)this.textLastUpdate).xyw(7, 5, 5);
        builder.add(Resources.getString(this.getClass(), (String)"fileinfo.author"), new Object[0]).xy(1, 7);
        builder.add((Component)this.textAuthor).xyw(3, 7, 9);
        builder.add(Resources.getString(this.getClass(), (String)"fileinfo.description"), new Object[0]).xy(1, 9);
        builder.add((Component)this.textDescription).xyw(3, 9, 9);
        ValidationComponentUtils.setMandatory((JComponent)this.textXmlFileName, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)this.textXmlFileName, (Object)"validation.xmlFileName_key");
        this.cvValidationModel = new DefaultValidationResultModel();
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.definitionFileValueBean, "validation");
        this.cvValidationModel.setResult(support.getResult());
        IconFeedbackPanel cvIconPanel = new IconFeedbackPanel(this.cvValidationModel, (JComponent)builder.getPanel());
        FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("p", new Object[0]);
        feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
        feedbackBuilder.border((Border)new EmptyBorder(10, 0, 0, 0));
        return feedbackBuilder.getPanel();
    }

    private JPanel createCvEditorPanel(MainModel mainModel) {
        JPanel editorContainer = new JPanel(new BorderLayout());
        editorContainer.setBorder((Border)Paddings.DIALOG);
        editorContainer.add((Component)DefaultComponentFactory.getInstance().createSeparator(Resources.getString(this.getClass(), (String)"editor.cveditor")), "North");
        this.cardLayout = new CardLayout();
        this.saveButton = new JButton(Resources.getString(this.getClass(), (String)"editor.save"));
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("save pressed.");
                try {
                    Trigger trigger = CvDefinitionPanel.this.getTrigger();
                    if (trigger == null) {
                        LOGGER.info("No trigger available. Do not save!");
                        return;
                    }
                    trigger.triggerCommit();
                    JPanel panel = CvDefinitionPanel.this.editorPanels.getCurrentPanel();
                    if (panel instanceof CvValueEditor) {
                        CvValueEditor valueEditor = (CvValueEditor)panel;
                        CvNode cvNode = valueEditor.getCvNode();
                        LOGGER.debug("Current selected cvNode: {}", (Object)cvNode);
                        if (cvNode != null) {
                            valueEditor.updateCvValues(CvDefinitionPanel.this.cvNumberToNodeMap, CvDefinitionPanel.this.treeModel);
                            LOGGER.info("Refresh the treeModel.");
                            CvDefinitionPanel.this.refreshTree();
                            LOGGER.info("Refresh the treeModel finished.");
                            if (CvDefinitionTreeHelper.hasPendingChanges((TreeTableModel)CvDefinitionPanel.this.treeModel)) {
                                CvDefinitionPanel.this.tabStatusListener.updatePendingChanges((Component)CvDefinitionPanel.this, true);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Commit failed.", (Throwable)ex);
                }
            }
        });
        JButton resetButton = new JButton(Resources.getString(this.getClass(), (String)"editor.reset"));
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Reset was pressed.");
                Trigger trigger = CvDefinitionPanel.this.getTrigger();
                if (trigger != null) {
                    trigger.triggerFlush();
                    trigger.triggerFlush();
                }
            }
        });
        JPanel buttonBar = new ButtonBarBuilder().addButton(new JComponent[]{this.saveButton, resetButton}).build();
        editorContainer.add((Component)buttonBar, "North");
        this.editorPanels = new EditorPanels(this.cardLayout);
        editorContainer.add((Component)this.editorPanels, "Center");
        this.editorPanels.add((Component)new JPanel(), NONE);
        this.editorPanels.add((Component)this.createBitfieldEditor(), DataType.BIT.name());
        this.editorPanels.add((Component)this.createByteEditor(), DataType.BYTE.name());
        this.editorPanels.add((Component)this.createIntegerEditor(), DataType.INT.name());
        this.editorPanels.add((Component)this.createSignedCharEditor(), DataType.SIGNED_CHAR.name());
        this.editorPanels.add((Component)this.createRadioEditor(), DataType.RADIO.name());
        this.editorPanels.add((Component)this.createLongEditor(), DataType.LONG.name());
        this.editorPanels.add((Component)this.createDccLongAddrEditor(), DataType.DCC_LONG_ADDR.name());
        this.editorPanels.add((Component)this.createStringEditor(), DataType.STRING.name());
        this.editorPanels.add((Component)this.createDccAccAddrEditor(), DataType.DCC_ACC_ADDR.name());
        this.editorPanels.add((Component)this.createDccAddrRGEditor(), DataType.DCC_ADDR_RG.name());
        this.editorPanels.add((Component)this.createGBM16TReverserEditor(), DataType.GBM_16_T_REVERSER.name());
        this.editorPanels.add((Component)this.createBidibUidEditor(), DataType.BI_DI_B_UID.name());
        this.editorPanels.add((Component)this.createMacAddressEditor(), DataType.MAC_ADDRESS.name());
        this.editorPanels.add((Component)this.createIpAddressEditor(), DataType.IP_ADDRESS.name());
        return editorContainer;
    }

    private Trigger getTrigger() {
        JPanel currentEditor = this.editorPanels.getCurrentPanel();
        if (currentEditor instanceof CvValueEditor) {
            return ((CvValueEditor)currentEditor).getTrigger();
        }
        return null;
    }

    private CvBidibUidEditor createBidibUidEditor() {
        this.bidibUidEditor = new CvBidibUidEditor();
        this.bidibUidEditor.setValueLabelPrefix("UID");
        this.bidibUidEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.BI_DI_B_UID, (CvValueEditor)this.bidibUidEditor);
        return this.bidibUidEditor;
    }

    private CvMacAddressEditor createMacAddressEditor() {
        this.macAddressEditor = new CvMacAddressEditor();
        this.macAddressEditor.setValueLabelPrefix("MAC");
        this.macAddressEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.MAC_ADDRESS, (CvValueEditor)this.macAddressEditor);
        return this.macAddressEditor;
    }

    private CvIpAddressEditor createIpAddressEditor() {
        this.ipAddressEditor = new CvIpAddressEditor();
        this.ipAddressEditor.setValueLabelPrefix("IP");
        this.ipAddressEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.IP_ADDRESS, (CvValueEditor)this.ipAddressEditor);
        return this.ipAddressEditor;
    }

    private GBM16TReverserEditor createGBM16TReverserEditor() {
        this.gbm16TReverserEditor = new GBM16TReverserEditor(this.feedbackPortStatusChangeProvider, new Trigger(), null, new String[]{"/icons/GBM16TReverser.png"});
        this.mapDataTypeToEditor.put(DataType.GBM_16_T_REVERSER, (CvValueEditor)this.gbm16TReverserEditor);
        return this.gbm16TReverserEditor;
    }

    private JPanel createDccAccAddrEditor() {
        this.dccAccAddrEditor = new DccAccAddrEditor();
        this.dccAccAddrEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.DCC_ACC_ADDR, (CvValueEditor)this.dccAccAddrEditor);
        return this.dccAccAddrEditor;
    }

    private JPanel createDccAddrRGEditor() {
        this.dccAddrRGEditor = new DccAddrRGEditor();
        this.dccAddrRGEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.DCC_ADDR_RG, (CvValueEditor)this.dccAddrRGEditor);
        return this.dccAddrRGEditor;
    }

    private JPanel createByteEditor() {
        this.byteEditor = new CvByteValueEditor();
        this.byteEditor.setValueLabelPrefix("Byte");
        this.byteEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.BYTE, (CvValueEditor)this.byteEditor);
        return this.byteEditor;
    }

    private JPanel createBitfieldEditor() {
        this.bitfieldEditor = new CvBitfieldValueEditor();
        this.bitfieldEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.BIT, (CvValueEditor)this.bitfieldEditor);
        return this.bitfieldEditor;
    }

    private JPanel createRadioEditor() {
        this.radioEditor = new CvRadioValueEditor();
        this.radioEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.RADIO, (CvValueEditor)this.radioEditor);
        return this.radioEditor;
    }

    private JPanel createIntegerEditor() {
        this.integerEditor = new CvIntegerValueEditor();
        this.integerEditor.setValueLabelPrefix("Integer");
        this.integerEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.INT, (CvValueEditor)this.integerEditor);
        return this.integerEditor;
    }

    private JPanel createLongEditor() {
        this.longEditor = new CvLongValueEditor();
        this.longEditor.setValueLabelPrefix("Long");
        this.longEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.LONG, (CvValueEditor)this.longEditor);
        return this.longEditor;
    }

    private JPanel createDccLongAddrEditor() {
        this.dccLongAddrEditor = new CvDccLongAddrValueEditor();
        this.dccLongAddrEditor.setValueLabelPrefix("DccLongAddr");
        this.dccLongAddrEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.DCC_LONG_ADDR, (CvValueEditor)this.dccLongAddrEditor);
        return this.dccLongAddrEditor;
    }

    private JPanel createSignedCharEditor() {
        this.signedCharEditor = new CvSignedCharValueEditor();
        this.signedCharEditor.setValueLabelPrefix("Signed Char");
        this.signedCharEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.SIGNED_CHAR, (CvValueEditor)this.signedCharEditor);
        return this.signedCharEditor;
    }

    private JPanel createStringEditor() {
        this.stringEditor = new CvValueStringEditor();
        this.stringEditor.setValueLabelPrefix("String");
        this.stringEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.STRING, (CvValueEditor)this.stringEditor);
        return this.stringEditor;
    }

    @Override
    public String getName() {
        return Resources.getString(this.getClass(), (String)"name");
    }

    private void readCvValues() {
        LOGGER.debug("Read all configured CV values.");
        ArrayList<ConfigurationVariable> configVars = new ArrayList<ConfigurationVariable>();
        configVars.addAll(this.configVariables.values());
        ConfigurationVariable.sortCvVariables(configVars);
        this.readCvValues(configVars);
    }

    private void readCvValues(List<ConfigurationVariable> configVariables) {
        LOGGER.debug("Read the CV values.");
        if (configVariables != null && configVariables.size() > 0) {
            LOGGER.info("Get the CV values for configuration variables, count: {}", (Object)configVariables.size());
            this.fireLoadConfigVariables(configVariables);
            JPanel panel = this.editorPanels.getCurrentPanel();
            if (panel instanceof CvValueEditor) {
                CvValueEditor valueEditor = (CvValueEditor)panel;
                LOGGER.info("Refresh the value after the CV values were read.");
                valueEditor.refreshValueFromSource(this.cvNumberToNodeMap);
            }
        } else {
            LOGGER.warn("No configuration variables available.");
        }
    }

    @Override
    public void checkPendingChanges() {
        boolean hasPendingChanges = CvDefinitionTreeHelper.hasPendingChanges((TreeTableModel)this.treeModel);
        if (!hasPendingChanges) {
            this.tabStatusListener.updatePendingChanges((Component)this, false);
        }
    }

    private void resetPendingChanges(DefaultExpandableRow node) {
        if (node == null) {
            return;
        }
        for (int childIndex = 0; childIndex < node.getChildrenCount(); ++childIndex) {
            DefaultExpandableRow child = (DefaultExpandableRow)node.getChildAt(childIndex);
            if (child instanceof CvNode) {
                CvNode cvNode = (CvNode)child;
                if (cvNode.getNewValue() == null) continue;
                LOGGER.debug("Reset the pending changes on node: {}", (Object)cvNode);
                cvNode.resetNewValue();
                continue;
            }
            this.resetPendingChanges(child);
        }
    }

    private void addNewValueToList(CvNode cvNode, List<ConfigurationVariable> cvList) {
        if (cvNode.getNewValue() != null) {
            String cvNumber = cvNode.getConfigVar().getName();
            String cvValue = Objects.toString(cvNode.getNewValue(), null);
            ConfigurationVariable cv = new ConfigurationVariable(cvNumber, cvValue);
            cvList.add(cv);
        }
    }

    private void addButtons(VLToolBar toolBar) {
        this.readButton = ButtonUtils.makeNavigationButton((String)"loadfromnode.png", (String)"/32x32", (String)READ, (String)Resources.getString(this.getClass(), (String)"toolbar.readallcv"), (String)Resources.getString(this.getClass(), (String)"toolbar.readallcv.alttext"));
        this.readButton.setEnabled(false);
        toolBar.add(this.readButton);
        this.readButton.addActionListener(e -> this.readCvValues());
        this.writeButton = ButtonUtils.makeNavigationButton((String)"savetonode.png", (String)"/32x32", (String)WRITE, (String)Resources.getString(this.getClass(), (String)"toolbar.writeallcv"), (String)Resources.getString(this.getClass(), (String)"toolbar.writeallcv.alttext"));
        toolBar.add(this.writeButton);
        this.writeButton.setEnabled(false);
        this.writeButton.addActionListener(e -> {
            LOGGER.info("Write the CV values.");
            DefaultExpandableRow root = (DefaultExpandableRow)this.treeModel.getRoot();
            NodeInterface selectedNode = this.mainModel.getSelectedNode();
            CvValueUtils.writeCvValues(selectedNode, root, this.cvNumberToNodeMap, (CvDefinitionPanelProvider)this);
        });
        this.loadFromFileButton = ButtonUtils.makeNavigationButton((String)"loadfromfile.png", (String)"/32x32", (String)LOAD, (String)Resources.getString(this.getClass(), (String)"toolbar.loadfromfile"), (String)Resources.getString(this.getClass(), (String)"toolbar.loadfromfile.alttext"));
        toolBar.add(this.loadFromFileButton);
        this.loadFromFileButton.setEnabled(false);
        this.loadFromFileButton.addActionListener(e -> this.loadFromFileCvValues());
        this.saveToFileButton = ButtonUtils.makeNavigationButton((String)"savetofile.png", (String)"/32x32", (String)SAVE.toLowerCase(), (String)Resources.getString(this.getClass(), (String)"toolbar.savetofile"), (String)Resources.getString(this.getClass(), (String)"toolbar.savetofile.alttext"));
        toolBar.add(this.saveToFileButton);
        this.saveToFileButton.setEnabled(false);
        this.saveToFileButton.addActionListener(e -> this.saveToFileCvValues());
        this.exportToExcelButton = ButtonUtils.makeNavigationButton((String)"exportToExcel.png", (String)"/32x32", (String)SAVE.toLowerCase(), (String)Resources.getString(this.getClass(), (String)"toolbar.exportToExcel"), (String)Resources.getString(this.getClass(), (String)"toolbar.exportToExcel.alttext"));
        toolBar.add(this.exportToExcelButton);
        this.exportToExcelButton.setEnabled(false);
        this.exportToExcelButton.addActionListener(e -> this.exportCvDataToExcel());
    }

    @Override
    public void addCvDefinitionRequestListener(CvDefinitionRequestListener l) {
        this.cvDefinitionRequestListeners.add(l);
    }

    private void fireLoadConfigVariables(List<ConfigurationVariable> configVariables) {
        for (CvDefinitionRequestListener l : this.cvDefinitionRequestListeners) {
            l.loadCvValues(configVariables);
        }
    }

    @Override
    public void writeConfigVariables(List<ConfigurationVariable> cvList) {
        this.fireWriteConfigVariables(cvList);
    }

    private void fireWriteConfigVariables(List<ConfigurationVariable> cvList) {
        for (CvDefinitionRequestListener l : this.cvDefinitionRequestListeners) {
            l.writeCvValues(cvList);
        }
    }

    private void potentiallyShowPopup(MouseEvent e) {
        DefaultExpandableRow row;
        int index;
        JPopupMenu popupMenu = null;
        if (e.isPopupTrigger() && (index = this.cvTreeTable.getSelectedRow()) > -1 && (popupMenu = this.buildPopup(row = (DefaultExpandableRow)this.cvTreeTable.getRowAt(index))).getComponentCount() > 0) {
            popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private JPopupMenu buildPopup(DefaultExpandableRow selectedComponent) {
        JPopupMenu pm = new JPopupMenu();
        if (selectedComponent instanceof CvNode) {
            CvNode cvNode = (CvNode)selectedComponent;
            JMenuItem readCv = new JMenuItem(new CvAction(ActionType.READ, Resources.getString(this.getClass(), (String)"menu.readcv"), cvNode));
            pm.add(readCv);
            if (!ModeType.RO.equals((Object)cvNode.getCV().getMode()) && !ModeType.H.equals((Object)cvNode.getCV().getMode())) {
                JMenuItem writeCv = new JMenuItem(new CvAction(ActionType.WRITE, Resources.getString(this.getClass(), (String)"menu.writecv"), cvNode));
                pm.add(writeCv);
            }
        } else if (selectedComponent instanceof NodeNode) {
            NodeNode nodeNode = (NodeNode)selectedComponent;
            JMenuItem readCv = new JMenuItem(new NodeCvAction(ActionType.READ, Resources.getString(this.getClass(), (String)"menu.readcvs"), (AbstractNode)nodeNode));
            pm.add(readCv);
            JMenuItem writeCv = new JMenuItem(new NodeCvAction(ActionType.WRITE, Resources.getString(this.getClass(), (String)"menu.writecvs"), (AbstractNode)nodeNode));
            pm.add(writeCv);
        } else if (selectedComponent instanceof DeviceNode) {
            DeviceNode deviceNode = (DeviceNode)selectedComponent;
            JMenuItem readCv = new JMenuItem(new NodeCvAction(ActionType.READ, Resources.getString(this.getClass(), (String)"menu.readcvs"), (AbstractNode)deviceNode));
            pm.add(readCv);
            JMenuItem writeCv = new JMenuItem(new NodeCvAction(ActionType.WRITE, Resources.getString(this.getClass(), (String)"menu.writecvs"), (AbstractNode)deviceNode));
            pm.add(writeCv);
        }
        return pm;
    }

    private void loadFromFileCvValues() {
        String savedCvDescription = Resources.getString(CvDefinitionPanel.class, (String)"savedCvDescription");
        cvExchangeFilter = new FileNameExtensionFilter(savedCvDescription, CV_EXCHANGE_EXTENSION);
        final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY);
        FileDialog dialog = new FileDialog((Component)((Object)this.cvTreeTable), 0, storedWorkingDirectory, null, new FileFilter[]{cvExchangeFilter}){

            public void approve(String fileName) {
                try {
                    List cvList;
                    LOGGER.info("Start importing saved CV, fileName: {}", (Object)fileName);
                    SaveCV saveCV = CvExchangeFactory.loadCV((String)fileName);
                    LOGGER.info("Loaded saveCV from file: {}", (Object)fileName);
                    if (saveCV != null && saveCV.getCVs() != null && CollectionUtils.isNotEmpty((Collection)(cvList = saveCV.getCVs().getCv()))) {
                        for (CVSType cvsType : cvList) {
                            String cvNumber = cvsType.getNumber();
                            String cvValue = cvsType.getValue();
                            CvNode cvNode = CvDefinitionPanel.this.cvNumberToNodeMap.get(cvNumber);
                            if (cvNode != null) {
                                cvNode.setNewValue((Object)cvValue);
                                continue;
                            }
                            LOGGER.warn("No cvNode available for cvNumber: {}", (Object)cvNumber);
                        }
                    }
                    String workingDir = Paths.get(fileName, new String[0]).getParent().toString();
                    LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                    wizardSettings.setWorkingDirectory(CvDefinitionPanel.WORKING_DIR_CV_DEFINITION_KEY, workingDir);
                }
                catch (Exception ex) {
                    LOGGER.warn("Load saved CV failed.", (Throwable)ex);
                    throw new RuntimeException("Load saved CV failed.");
                }
                finally {
                    CvDefinitionPanel.this.refreshTree();
                }
            }
        };
        dialog.showDialog();
    }

    public void refreshTree() {
        LOGGER.info("Refresh the tree.");
        if (this.treeModel != null) {
            this.treeModel.fireTableDataChanged();
        }
    }

    public void cvDefinitionValuesChanged(boolean read, List<String> changedNames) {
        LOGGER.info("The CV defintion values have changed, read: {}", (Object)read);
        if (this.editorPanels.getCurrentPanel() instanceof CvValueEditor) {
            CvValueEditor cvValueEditor = (CvValueEditor)this.editorPanels.getCurrentPanel();
            cvValueEditor.refreshValueFromSource(this.cvNumberToNodeMap);
        }
        this.refreshTree();
    }

    public void cvDefinitionChanged() {
        CvDefinitionTreeTableModel cvDefinitionTreeTableModel;
        LOGGER.info("The CV definition has changed.");
        if (this.configVariables != null) {
            this.configVariables = null;
        }
        this.editorPanels.show(NONE);
        if (this.readButton != null) {
            this.readButton.setEnabled(false);
        }
        if (this.writeButton != null) {
            this.writeButton.setEnabled(false);
        }
        if (this.loadFromFileButton != null) {
            this.loadFromFileButton.setEnabled(false);
        }
        if (this.saveToFileButton != null) {
            this.saveToFileButton.setEnabled(false);
        }
        if (this.exportToExcelButton != null) {
            this.exportToExcelButton.setEnabled(false);
        }
        this.cvNumberToNodeMap = null;
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node == null) {
            LOGGER.info("No node available.");
            return;
        }
        if (node.getVendorCV() == null) {
            LOGGER.info("No vendorCV data for node available.");
            return;
        }
        this.treeModel = cvDefinitionTreeTableModel = this.cvDefinitionPanelController.getCvDefinitionTreeTableModel(node);
        if (this.treeModel != null) {
            this.cvTreeTable.setModel((TableModel)this.treeModel);
            block5: for (int columnIndex = 0; columnIndex < this.cvTreeTable.getColumnCount(); ++columnIndex) {
                TableColumn column = this.cvTreeTable.getColumnModel().getColumn(columnIndex);
                int modelIndex = column.getModelIndex();
                switch (modelIndex) {
                    case 1: {
                        column.setPreferredWidth(20);
                        continue block5;
                    }
                    case 0: {
                        column.setPreferredWidth(250);
                        continue block5;
                    }
                    case 2: {
                        column.setPreferredWidth(20);
                        continue block5;
                    }
                }
            }
            cvDefinitionTreeTableModel.setCollapsed(false);
            this.cvTreeTable.expandAll();
        } else {
            LOGGER.warn("No CV definition tree model available.");
            this.cvTreeTable.setModel((TableModel)new CvDefinitionTreeTableModel());
        }
        this.cvNumberToNodeMap = this.cvDefinitionPanelController.getCvNumberToNodeMap(node);
        this.configVariables = node.getConfigVariables();
        this.textVersion.setText(null);
        this.textLastUpdate.setText(null);
        this.textAuthor.setText(null);
        this.textDescription.setText(null);
        this.definitionFileValueBean.setFileName(null);
        this.definitionFileValueBean.setFilePath(null);
        SwingUtilities.invokeLater(() -> {
            LOGGER.info("Get the configVariables from the node.");
            if (node.getVendorCV() != null && node.getVendorCV().getVendorCV() != null) {
                VendorCV vendorCV = node.getVendorCV().getVendorCV();
                VersionInfoType versionInfoType = vendorCV.getVersion();
                LOGGER.debug("versionInfoType: {}", (Object)versionInfoType);
                String lastUpdate = versionInfoType.getLastupdate();
                if (StringUtils.isNotBlank((CharSequence)lastUpdate)) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                        Date lastUpdateDate = sdf.parse(lastUpdate);
                        lastUpdate = new SimpleDateFormat("dd.MM.yyyy").format(lastUpdateDate);
                    }
                    catch (ParseException ex) {
                        LOGGER.warn("Parse last update date failed.", (Throwable)ex);
                    }
                }
                String fileName = "?";
                try {
                    fileName = node.getVendorCV().getFilename();
                }
                catch (Exception ex) {
                    LOGGER.warn("Prepare XML filename failed.", (Throwable)ex);
                }
                String filePath = "?";
                try {
                    filePath = node.getVendorCV().getFilePath();
                }
                catch (Exception ex) {
                    LOGGER.warn("Prepare XML filePath failed.", (Throwable)ex);
                }
                this.textXmlFileName.setToolTipText(filePath);
                this.textVersion.setText(versionInfoType.getVersion());
                this.textLastUpdate.setText(lastUpdate);
                this.textAuthor.setText(versionInfoType.getAuthor());
                this.textDescription.setText(versionInfoType.getDescription());
                this.definitionFileValueBean.setFileName(fileName);
                this.definitionFileValueBean.setFilePath(filePath);
                LOGGER.info("Number of configuration variables for this node: {}", (Object)this.configVariables.size());
                if (this.readButton != null) {
                    this.readButton.setEnabled(this.configVariables.size() > 0);
                }
                if (this.writeButton != null) {
                    this.writeButton.setEnabled(this.configVariables.size() > 0);
                }
                if (this.loadFromFileButton != null) {
                    this.loadFromFileButton.setEnabled(this.configVariables.size() > 0);
                }
                if (this.saveToFileButton != null) {
                    this.saveToFileButton.setEnabled(this.configVariables.size() > 0);
                }
                if (this.exportToExcelButton != null) {
                    this.exportToExcelButton.setEnabled(this.configVariables.size() > 0);
                }
                if (this.copyToUserDirCvDefinitionButton != null) {
                    this.copyToUserDirCvDefinitionButton.setEnabled(true);
                }
                if (this.deleteFromUserDirCvDefinitionButton != null) {
                    this.deleteFromUserDirCvDefinitionButton.setEnabled(false);
                }
                if (this.cvValidationModel != null) {
                    PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.definitionFileValueBean, "validation");
                    if (this.definitionFileValueBean.isUserDefinedFile()) {
                        support.addWarning("xmlFileName_key", "filename_is_user_defined;" + this.definitionFileValueBean.filePath);
                        if (this.copyToUserDirCvDefinitionButton != null) {
                            this.copyToUserDirCvDefinitionButton.setEnabled(false);
                        }
                        if (this.deleteFromUserDirCvDefinitionButton != null) {
                            this.deleteFromUserDirCvDefinitionButton.setEnabled(true);
                        }
                    }
                    this.cvValidationModel.setResult(support.getResult());
                }
            } else {
                LOGGER.info("No vendor CV available.");
            }
        });
    }

    private void saveToFileCvValues() {
        String saveCvDescription = Resources.getString(CvDefinitionPanel.class, (String)"saveCvDescription");
        cvExchangeFilter = new FileNameExtensionFilter(saveCvDescription, CV_EXCHANGE_EXTENSION);
        final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY);
        FileDialog dialog = new FileDialog((Component)((Object)this.cvTreeTable), 1, storedWorkingDirectory, null, new FileFilter[]{cvExchangeFilter}){

            public void approve(String fileName) {
                try {
                    String selectedFile = this.makeSureFileNameHasExtension(fileName, CvDefinitionPanel.CV_EXCHANGE_EXTENSION);
                    LOGGER.info("Start save CV, fileName: {}", (Object)selectedFile);
                    SaveCV saveCV = new SaveCV();
                    saveCV.setMasterData(new MasterDataType().withUID(ByteUtils.formatHexUniqueId((long)CvDefinitionPanel.this.mainModel.getSelectedNode().getUniqueId())));
                    CVListType cvListType = new CVListType();
                    saveCV.setCVs(cvListType);
                    ArrayList<ConfigurationVariable> cvList = new ArrayList<ConfigurationVariable>();
                    cvList.addAll(CvDefinitionPanel.this.configVariables.values());
                    ConfigurationVariable.sortCvVariables(cvList);
                    for (ConfigurationVariable cv : cvList) {
                        CVSType cvsType = new CVSType().withNumber(cv.getName()).withValue(cv.getValue());
                        cvListType.getCv().add(cvsType);
                    }
                    CvExchangeFactory.saveCV((SaveCV)saveCV, (File)new File(selectedFile));
                    LOGGER.info("Saved CV values to file: {}", (Object)selectedFile);
                    String workingDir = Paths.get(selectedFile, new String[0]).getParent().toString();
                    LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                    wizardSettings.setWorkingDirectory(CvDefinitionPanel.WORKING_DIR_CV_DEFINITION_KEY, workingDir);
                }
                catch (Exception ex) {
                    LOGGER.warn("Save CV values to file failed.", (Throwable)ex);
                    throw new RuntimeException("Save CV values to file failed.");
                }
            }
        };
        dialog.showDialog();
    }

    private void exportCvDataToExcel() {
        String saveCvDescription = Resources.getString(CvDefinitionPanel.class, (String)"saveCvDescription");
        cvExchangeFilter = new FileNameExtensionFilter(saveCvDescription, "xlsx");
        final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY);
        FileDialog dialog = new FileDialog((Component)((Object)this.cvTreeTable), 1, storedWorkingDirectory, null, new FileFilter[]{cvExchangeFilter}){

            public void approve(String fileName) {
                try {
                    String selectedFile = this.makeSureFileNameHasExtension(fileName, "xlsx");
                    LOGGER.info("Start save CV, fileName: {}", (Object)selectedFile);
                    CvDefinitionTreeTableModel cvDefinitionTreeTableModel = CvDefinitionPanel.this.treeModel;
                    ArrayList<CvData> configurationVariables = new ArrayList<CvData>();
                    for (DefaultExpandableRow row : cvDefinitionTreeTableModel.getRows()) {
                        if (row instanceof CvNode) {
                            LOGGER.info("Current row is CvNode: {}", (Object)row);
                            CvNode cvNode = (CvNode)row;
                            String description = (String)cvNode.getValueAt(0);
                            LOGGER.info("Current CV: {}", (Object)description);
                            CvData cvData = new CvData();
                            cvData.setCvDescription(description);
                            cvData.setCvDefaultValue(cvNode.getValueAt(2) != null ? cvNode.getValueAt(2).toString() : null);
                            cvData.setCvName((String)cvNode.getValueAt(1));
                            cvData.setCvValue((String)cvNode.getValueAt(3));
                            configurationVariables.add(cvData);
                            continue;
                        }
                        if (row instanceof DeviceNode) {
                            LOGGER.info("Current row is DeviceNode: {}", (Object)row);
                            continue;
                        }
                        if (!(row instanceof NodeNode)) continue;
                        LOGGER.info("Current row is NodeNode: {}", (Object)row);
                    }
                    String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
                    Node coreNode = CvDefinitionPanel.this.mainModel.getSelectedNode().getNode();
                    org.bidib.jbidibc.core.schema.bidib2.Node schemaNode = new org.bidib.jbidibc.core.schema.bidib2.Node();
                    schemaNode.withUserName(coreNode.getStoredString(1)).withProductName(coreNode.getStoredString(0)).withManufacturerId(Integer.valueOf(NodeUtils.getVendorId((long)coreNode.getUniqueId()))).withProductId(Integer.valueOf(NodeUtils.getPid((long)coreNode.getUniqueId(), (int)coreNode.getRelevantPidBits()))).withUniqueId(coreNode.getUniqueId()).withFirmwareRelease(coreNode.getSoftwareVersion().toString()).withProtocol(coreNode.getProtocolVersion().toString());
                    ExcelExportFactory.exportConfigurationVariables((org.bidib.jbidibc.core.schema.bidib2.Node)schemaNode, configurationVariables, (String)selectedFile, (String)lang);
                    LOGGER.info("Exported CV values to file: {}", (Object)selectedFile);
                    String workingDir = Paths.get(fileName, new String[0]).getParent().toString();
                    LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                    wizardSettings.setWorkingDirectory(CvDefinitionPanel.WORKING_DIR_CV_DEFINITION_KEY, workingDir);
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(CvDefinitionPanel.class, (String)"exportToExcel.passed", (Object[])new Object[]{selectedFile}), Resources.getString(CvDefinitionPanel.class, (String)"exportToExcel.title"), 1);
                }
                catch (Exception ex) {
                    LOGGER.warn("Export CV values to file failed.", (Throwable)ex);
                    throw new RuntimeException("Export CV values to file failed.");
                }
            }
        };
        dialog.showDialog();
    }

    @Override
    public void tabSelected(boolean selected) {
        LOGGER.info("Tab is selected: {}", (Object)selected);
        this.toolbarCvDefinition.setVisible(selected);
    }

    private void importUserDefinedCvDefinition() {
        XmlFileFilter ff = new XmlFileFilter();
        final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY);
        final CvDefinitionPanel parentComponent = this;
        FileDialog dialog = new FileDialog(parentComponent, 0, storedWorkingDirectory, null, new FileFilter[]{ff}){

            public void approve(String fileName) {
                File file = new File(fileName);
                String selectedFile = file.getName();
                LOGGER.info("Selected file to import: {}", (Object)selectedFile);
                VendorCvFactory.isVendorCvFileValid((File)file);
                String labelPath = CvDefinitionPanel.this.settingsService.getMiscSettings().getBidibConfigDir();
                StringBuilder sb = new StringBuilder(labelPath);
                sb.append("/data/BiDiBNodeVendorData/");
                NodeInterface node = CvDefinitionPanel.this.mainModel.getSelectedNode();
                long uniqueId = node.getUniqueId();
                SoftwareVersion softwareVersion = node.getNode().getSoftwareVersion();
                StringBuilder targetFilename = new StringBuilder("BiDiBCV-");
                targetFilename.append(NodeUtils.getVendorId((long)uniqueId)).append("-").append(NodeUtils.getPid((long)uniqueId)).append("-").append(softwareVersion.toString()).append(".xml");
                LOGGER.info("Store file at path: {}, targetFile: {}", (Object)sb.toString(), (Object)targetFilename.toString());
                File target = new File(sb.toString(), targetFilename.toString());
                try {
                    if (target.exists()) {
                        LOGGER.info("Delete existing file: {}", (Object)target);
                        FileUtils.deleteQuietly((File)target);
                    }
                    LOGGER.info("Copy the CV file to target: {}", (Object)target);
                    FileUtils.copyFile((File)file, (File)target, (boolean)false);
                    LOGGER.info("Copy the CV file to target passed.");
                    StopWatch sw = new StopWatch();
                    sw.start();
                    DefaultContext context = new DefaultContext();
                    CvDefinitionPanel.this.cvDefinitionPanelController.reloadCvDefinition((Context)context, node);
                    sw.stop();
                    List vendorCVErrors = (List)context.get("vendorCVErrors", List.class, Collections.emptyList());
                    if (CollectionUtils.isNotEmpty((Collection)vendorCVErrors)) {
                        LOGGER.warn("Load vendor CV data from files failed: {}", (Object)vendorCVErrors);
                        CvDefinitionPanel.this.statusBar.setStatusText(String.format(Resources.getString(MainController.class, (String)"load-config-finished-load-vendorcv-failed"), node, sw), -2);
                    } else {
                        CvDefinitionPanel.this.statusBar.setStatusText(String.format(Resources.getString(MainController.class, (String)"load-config-finished-no-vendorcv"), node, sw), -1);
                    }
                    String workingDir = Paths.get(fileName, new String[0]).getParent().toString();
                    LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                    wizardSettings.setWorkingDirectory(CvDefinitionPanel.WORKING_DIR_CV_DEFINITION_KEY, workingDir);
                }
                catch (IOException ex) {
                    LOGGER.warn("Copy file failed.", (Throwable)ex);
                    throw new RuntimeException("Copy file failed.");
                }
            }

            protected boolean handleException(RuntimeException ex) {
                JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(parentComponent), Resources.getString(CvDefinitionPanel.class, (String)"import-to-user-dir.failed"), Resources.getString(CvDefinitionPanel.class, (String)"import-to-user-dir.title"), 0);
                return true;
            }
        };
        dialog.showDialog();
    }

    private void copyToUserDirCvDefinition() {
        int result = JOptionPane.showConfirmDialog(this, Resources.getString(this.getClass(), (String)"copy-to-user-dir.message"), Resources.getString(this.getClass(), (String)"copy-to-user-dir.title"), 2, 3);
        if (result == 0) {
            LOGGER.info("Copy cv definition to user dir.");
            NodeInterface node = this.mainModel.getSelectedNode();
            DefaultContext context = new DefaultContext();
            try {
                this.cvDefinitionPanelController.copyCvDefinitionToUserDir((Context)context, node);
                LOGGER.info("Copy finished, reload the CV definition.");
                this.cvDefinitionPanelController.reloadCvDefinition((Context)context, node);
            }
            catch (Exception ex) {
                LOGGER.warn("Copy CV definition to user dir failed.");
                JOptionPane.showMessageDialog(this, Resources.getString(CvDefinitionPanel.class, (String)"copy-to-user-dir.failed"), Resources.getString(CvDefinitionPanel.class, (String)"copy-to-user-dir.title"), 1);
            }
        } else {
            LOGGER.info("User canceled copy cv definition to user dir.");
        }
    }

    private void deleteFromUserDirCvDefinition() {
        int result = JOptionPane.showConfirmDialog(this, Resources.getString(this.getClass(), (String)"delete-from-user-dir.message"), Resources.getString(this.getClass(), (String)"delete-from-user-dir.title"), 2, 3);
        if (result == 0) {
            LOGGER.info("Delete cv definition from user dir.");
            NodeInterface node = this.mainModel.getSelectedNode();
            DefaultContext context = new DefaultContext();
            try {
                this.cvDefinitionPanelController.deleteCvDefinitionFromUserDir((Context)context, node);
                LOGGER.info("Delete finished, reload the CV definition.");
                this.cvDefinitionPanelController.reloadCvDefinition((Context)context, node);
            }
            catch (Exception ex) {
                LOGGER.warn("Delete CV definition from user dir failed.");
                JOptionPane.showMessageDialog(this, Resources.getString(CvDefinitionPanel.class, (String)"delete-from-user-dir.failed"), Resources.getString(CvDefinitionPanel.class, (String)"delete-from-user-dir.title"), 1);
            }
        } else {
            LOGGER.info("User canceled delete cv definition from user dir.");
        }
    }

    public PortListener<FeedbackPort> getPortListener() {
        return this.gbm16TReverserEditor.getPortListener();
    }

    public void listChanged() {
    }

    public void nodeWillChange(NodeInterface node) {
        boolean pendingChanges = CvDefinitionTreeHelper.hasPendingChanges((TreeTableModel)this.treeModel);
        if (pendingChanges) {
            throw new NodeChangeVetoException("Pending changes in CV definition detected.");
        }
    }

    public void nodeChanged(NodeInterface node) {
        LOGGER.info("The selected node has changed, reset the pending changes.");
        this.resetPendingChanges();
    }

    public void nodeStateChanged(NodeInterface node) {
    }

    public void listNodeAdded(NodeInterface node) {
    }

    public void listNodeRemoved(NodeInterface node) {
    }

    public static final class CvDefinitionFileValueBean
    extends Model {
        private static final long serialVersionUID = 1L;
        public static final String PROPERTYNAME_FILENAME = "fileName";
        public static final String PROPERTYNAME_FILEPATH = "filePath";
        private String fileName;
        private String filePath;

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            String oldValue = this.fileName;
            this.fileName = fileName;
            this.firePropertyChange(PROPERTYNAME_FILENAME, oldValue, fileName);
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            String oldValue = this.filePath;
            this.filePath = filePath;
            this.firePropertyChange(PROPERTYNAME_FILEPATH, oldValue, filePath);
        }

        public boolean isUserDefinedFile() {
            return StringUtils.isNotEmpty((CharSequence)this.filePath) && !this.filePath.startsWith("/bidib/");
        }
    }

    private class EditorPanels
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Map<Object, Component> panels;
        private String currentPanelName;

        public EditorPanels(CardLayout layout) {
            super(layout);
            this.panels = new LinkedHashMap<Object, Component>();
        }

        @Override
        public void add(Component comp, Object constraints) {
            LOGGER.debug("Add new panel to editor panels, name: {}, panel: {}", constraints, (Object)comp);
            this.panels.put(constraints, comp);
            if (this.currentPanelName == null) {
                this.currentPanelName = constraints.toString();
            }
            super.add(comp, constraints);
        }

        public void show(Object constraints) {
            LOGGER.debug("Show: {}", constraints);
            String newPanelName = constraints.toString();
            if (this.panels.containsKey(newPanelName)) {
                if (this.getLayout() instanceof CardLayout) {
                    ((CardLayout)this.getLayout()).show(this, constraints.toString());
                }
                this.currentPanelName = newPanelName;
            } else {
                LOGGER.warn("No panel available for constraint: {}", (Object)newPanelName);
                this.show(CvDefinitionPanel.NONE);
            }
        }

        public JPanel getCurrentPanel() {
            if (this.currentPanelName != null) {
                return (JPanel)this.panels.get(this.currentPanelName);
            }
            return null;
        }
    }

    private class CvAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private CvNode cvNode;
        private ActionType actionType;

        public CvAction(ActionType actionType, String name, CvNode cvNode) {
            super(name);
            this.actionType = actionType;
            this.cvNode = cvNode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LOGGER.debug("Add config var of selected cvNode: {}", (Object)this.cvNode);
            ArrayList<Object> cvNodes = new ArrayList<Object>();
            CVType cv = this.cvNode.getCV();
            switch (cv.getType()) {
                case INT: 
                case DCC_ACC_ADDR: 
                case DCC_ADDR_RG: {
                    CvNode highCvNode = CvDefinitionPanel.this.cvNumberToNodeMap.get(this.cvNode.getCV().getHigh());
                    CvNode lowCvNode = CvDefinitionPanel.this.cvNumberToNodeMap.get(this.cvNode.getCV().getLow());
                    cvNodes.add(highCvNode);
                    cvNodes.add(lowCvNode);
                    break;
                }
                case LONG: {
                    if (!(this.cvNode instanceof LongCvNode)) break;
                    LongCvNode longCvNode = ((LongCvNode)this.cvNode).getMasterNode();
                    cvNodes.add(longCvNode);
                    for (CvNode slaveNode : longCvNode.getSlaveNodes()) {
                        cvNodes.add(slaveNode);
                    }
                    break;
                }
                default: {
                    cvNodes.add(this.cvNode);
                }
            }
            LOGGER.debug("Nodes to update: {}", cvNodes);
            switch (this.actionType.ordinal()) {
                case 0: {
                    ArrayList<ConfigurationVariable> cvSet = new ArrayList<ConfigurationVariable>();
                    for (CvNode cvNode : cvNodes) {
                        cvSet.add(cvNode.getConfigVar());
                    }
                    CvDefinitionPanel.this.readCvValues(cvSet);
                    break;
                }
                case 1: {
                    ArrayList<ConfigurationVariable> cvList = new ArrayList<ConfigurationVariable>();
                    for (CvNode cvNode : cvNodes) {
                        if (ModeType.RO.equals((Object)cvNode.getCV().getMode()) || ModeType.H.equals((Object)cvNode.getCV().getMode())) continue;
                        CvDefinitionPanel.this.addNewValueToList(cvNode, cvList);
                    }
                    NodeInterface nodeInterface = CvDefinitionPanel.this.mainModel.getSelectedNode();
                    CvValueUtils.writeCvValues(nodeInterface, cvList, CvDefinitionPanel.this.cvNumberToNodeMap, (CvDefinitionPanelProvider)CvDefinitionPanel.this);
                    break;
                }
            }
        }
    }

    public static enum ActionType {
        READ,
        WRITE;

    }

    private class NodeCvAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final AbstractNode nodeNode;
        private ActionType actionType;

        public NodeCvAction(ActionType actionType, String name, AbstractNode nodeNode) {
            super(name);
            this.actionType = actionType;
            this.nodeNode = nodeNode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LOGGER.debug("Add config var of selected cvNode: {}", (Object)this.nodeNode);
            ArrayList cvNodes = new ArrayList();
            CvDefinitionTreeHelper.addCvOfSubnode((AbstractNode)this.nodeNode, cvNodes, CvDefinitionPanel.this.cvNumberToNodeMap);
            LOGGER.debug("Nodes to update: {}", cvNodes);
            switch (this.actionType.ordinal()) {
                case 0: {
                    ArrayList<ConfigurationVariable> cvSet = new ArrayList<ConfigurationVariable>();
                    for (CvNode node : cvNodes) {
                        cvSet.add(node.getConfigVar());
                    }
                    CvDefinitionPanel.this.readCvValues(cvSet);
                    break;
                }
                case 1: {
                    ArrayList<ConfigurationVariable> cvList = new ArrayList<ConfigurationVariable>();
                    for (CvNode node : cvNodes) {
                        if (ModeType.RO.equals((Object)node.getCV().getMode()) || ModeType.H.equals((Object)node.getCV().getMode())) continue;
                        CvDefinitionPanel.this.addNewValueToList(node, cvList);
                    }
                    NodeInterface selectedNode = CvDefinitionPanel.this.mainModel.getSelectedNode();
                    CvValueUtils.writeCvValues(selectedNode, cvList, CvDefinitionPanel.this.cvNumberToNodeMap, (CvDefinitionPanelProvider)CvDefinitionPanel.this);
                    break;
                }
            }
        }
    }

    private final class XmlFileFilter
    extends FileFilter {
        public static final String SUFFIX_XML = "xml";

        private XmlFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            boolean result = false;
            if (file != null) {
                Matcher m;
                String extension;
                if (file.isDirectory()) {
                    result = true;
                } else if (file.toString() != null && "xml".equalsIgnoreCase(extension = FilenameUtils.getExtension((String)file.toString())) && (m = Pattern.compile(CvDefinitionPanel.PATTERN_CV_FILENAME).matcher(file.getName())).matches()) {
                    LOGGER.info("The pattern matches!");
                    result = true;
                }
            }
            return result;
        }

        @Override
        public String getDescription() {
            return Resources.getString(CvDefinitionPanel.class, (String)"filter") + " (*.xml)";
        }
    }
}

