/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.FeedbackAddressDataWithDynState;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.table.AbstractEmptyTable;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.slider.SliderRenderer;
import org.bidib.wizard.mvc.main.controller.listener.GlobalDetectorPanelListener;
import org.bidib.wizard.mvc.main.model.GlobalDetectorModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalDetectorPanel
implements TabVisibilityProvider,
TabPanelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalDetectorPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "fill:50dlu:grow";
    private final GlobalDetectorPanelListener controller;
    private final GlobalDetectorModel globalDetectorModel;
    private final TabVisibilityListener tabVisibilityListener;
    private JPanel contentPanel;
    private final AdvancedTableModel<FeedbackAddressDataWithDynState> decodersTableModel;

    public GlobalDetectorPanel(GlobalDetectorPanelListener controller, GlobalDetectorModel globalDetectorModel, MainModel model, TabVisibilityListener tabVisibilityListener) {
        this.controller = controller;
        this.globalDetectorModel = globalDetectorModel;
        this.tabVisibilityListener = tabVisibilityListener;
        LOGGER.debug("Create new GlobalDetectorPanel.");
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns("fill:50dlu:grow", new Object[0]).rows("fill:50dlu:grow", new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns("fill:50dlu:grow", new Object[0]).rows("fill:50dlu:grow", new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        EventList<FeedbackAddressDataWithDynState> addressDataEventList = globalDetectorModel.getAddressDataEventList();
        SortedList sortedAddressData = new SortedList(addressDataEventList, (Comparator)new AddressDataComparator());
        this.decodersTableModel = GlazedListsSwing.eventTableModelWithThreadProxyList((EventList)sortedAddressData, (TableFormat)new FeedbackAddressDataTableFormat());
        final DetectorTable feedbackAddressDataTable = new DetectorTable(this.decodersTableModel);
        feedbackAddressDataTable.adjustRowHeight();
        final DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)((Object)feedbackAddressDataTable)));
        feedbackAddressDataTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                overlayTable.setOverlayVisible(feedbackAddressDataTable.getModel().getRowCount() == 0);
            }
        });
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + feedbackAddressDataTable.getEmptyTableText() + ":f:gray}")));
        dialogBuilder.add((Component)overlayTable).xy(1, 1);
        this.contentPanel = dialogBuilder.build();
        this.contentPanel.setName(this.getName());
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    public String getName() {
        return Resources.getString(this.getClass(), (String)"name");
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = this.globalDetectorModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.isGlobalDetectorAvailable();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    public void listChanged() {
        LOGGER.debug("List has changed, remove all rows and add rows again.");
        boolean isTabVisible = this.isTabVisible();
        this.tabVisibilityListener.setTabVisible(this.contentPanel, isTabVisible);
    }

    private void fireOpenLocoDialog(FeedbackAddressDataWithDynState addressData) {
        this.controller.openLocoDialog((FeedbackAddressData)addressData);
    }

    private void fireOpenPomDialog(FeedbackAddressDataWithDynState addressData) {
        this.controller.openPomDialog((FeedbackAddressData)addressData);
    }

    private static class AddressDataComparator
    implements Comparator<FeedbackAddressData> {
        private AddressDataComparator() {
        }

        @Override
        public int compare(FeedbackAddressData pos1, FeedbackAddressData pos2) {
            return pos1.getAddress() - pos2.getAddress();
        }
    }

    private static class FeedbackAddressDataTableFormat
    implements TableFormat<FeedbackAddressDataWithDynState> {
        private final String[] columnNames = new String[]{Resources.getString(FeedbackAddressDataTableFormat.class, (String)"column.decoder"), Resources.getString(FeedbackAddressDataTableFormat.class, (String)"column.speed"), Resources.getString(FeedbackAddressDataTableFormat.class, (String)"column.dynstate")};

        private FeedbackAddressDataTableFormat() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: 
                case 1: 
                case 2: {
                    return this.columnNames[column];
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(FeedbackAddressDataWithDynState feedbackAddressData, int column) {
            switch (column) {
                case 0: {
                    return feedbackAddressData.getAddress();
                }
                case 1: {
                    return feedbackAddressData.getSpeed();
                }
                case 2: {
                    return feedbackAddressData.getDynStates();
                }
            }
            throw new IllegalStateException();
        }
    }

    private final class DetectorTable
    extends AbstractEmptyTable {
        private static final long serialVersionUID = 1L;
        private final DecoderListMenu menu;

        public DetectorTable(AdvancedTableModel<FeedbackAddressDataWithDynState> decodersTableModel) {
            super(decodersTableModel, Resources.getString(GlobalDetectorPanel.class, (String)"emptyTable"));
            this.menu = this.createMenu();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    DetectorTable.this.handleMouseEvent(e, DetectorTable.this.menu);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    DetectorTable.this.handleMouseEvent(e, DetectorTable.this.menu);
                }
            });
            this.addMenuListener(this.menu);
        }

        public void adjustRowHeight() {
            SliderRenderer sliderEditor = new SliderRenderer(0, 255, 10);
            int rowHeight = sliderEditor.getTableCellRendererComponent((JTable)((Object)this), (Object)Integer.valueOf((int)1), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height + 6;
            LOGGER.info("Set row height: {}", (Object)rowHeight);
            this.setRowHeight(rowHeight);
        }

        protected DecoderListMenu createMenu() {
            return new DecoderListMenu("No decoder selected.");
        }

        protected GlobalDetectorListMenuListener createMenuListener() {
            return new GlobalDetectorListMenuListener(){

                @Override
                public void openLocoDialog() {
                    LOGGER.info("Open the loco controller.");
                    int row = DetectorTable.this.getRow(DetectorTable.this.popupEvent.getPoint());
                    if (row > -1) {
                        int actualRow = DetectorTable.this.getActualRowAt(row);
                        FeedbackAddressDataWithDynState feedbackAddressData = (FeedbackAddressDataWithDynState)GlobalDetectorPanel.this.decodersTableModel.getElementAt(actualRow);
                        int addressData = feedbackAddressData.getAddress();
                        if (addressData > 0) {
                            GlobalDetectorPanel.this.fireOpenLocoDialog(feedbackAddressData);
                        } else {
                            LOGGER.info("No address available.");
                            GlobalDetectorPanel.this.fireOpenLocoDialog(null);
                        }
                    } else {
                        LOGGER.warn("The row is not available!");
                    }
                }

                @Override
                public void openPomDialog() {
                    LOGGER.info("Open the POM controller.");
                    int row = DetectorTable.this.getRow(DetectorTable.this.popupEvent.getPoint());
                    if (row > -1) {
                        int actualRow = DetectorTable.this.getActualRowAt(row);
                        FeedbackAddressDataWithDynState feedbackAddressData = (FeedbackAddressDataWithDynState)GlobalDetectorPanel.this.decodersTableModel.getElementAt(actualRow);
                        int addressData = feedbackAddressData.getAddress();
                        if (addressData > 0) {
                            GlobalDetectorPanel.this.fireOpenPomDialog(feedbackAddressData);
                        } else {
                            LOGGER.info("No address available.");
                            GlobalDetectorPanel.this.fireOpenPomDialog(null);
                        }
                    } else {
                        LOGGER.warn("The row is not available!");
                    }
                }
            };
        }

        protected void addMenuListener(DecoderListMenu portListMenu) {
            portListMenu.addMenuListener(this.createMenuListener());
        }

        private void handleMouseEvent(MouseEvent e, DecoderListMenu portListMenu) {
            if (e.isPopupTrigger() && this.getRowCount() > 0) {
                this.popupEvent = e;
                int row = this.getRow(e.getPoint());
                int column = this.getColumn(e.getPoint());
                this.showPortListMenu(e, portListMenu, row, column);
            }
        }

        protected void showPortListMenu(MouseEvent e, DecoderListMenu portListMenu, int row, int column) {
            column = 0;
            Object value = this.getValueAt(row, column);
            int actualRow = this.getActualRowAt(row);
            value = GlobalDetectorPanel.this.decodersTableModel.getElementAt(actualRow);
            LOGGER.info("Show port list menu, row: {}, actualRow: {}, current decoder: {}", new Object[]{row, actualRow, value});
            if (row >= 0 && column >= 0 && value instanceof FeedbackAddressDataWithDynState) {
                if (row >= 0 && this.getSelectedRowCount() == 0) {
                    this.setRowSelectionInterval(row, row);
                }
                FeedbackAddressDataWithDynState addressDataWithDynState = (FeedbackAddressDataWithDynState)value;
                String label = Resources.getString(GlobalDetectorPanel.class, (String)"decoder") + addressDataWithDynState.getAddress();
                portListMenu.setLabel(label);
                this.grabFocus();
                portListMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private static class GlobalDetectorListMenuListener {
        private GlobalDetectorListMenuListener() {
        }

        public void openLocoDialog() {
        }

        public void openPomDialog() {
        }
    }

    private static class DecoderListMenu
    extends BasicPopupMenu {
        private static final long serialVersionUID = 1L;
        protected final Collection<GlobalDetectorListMenuListener> menuListeners = new LinkedList<GlobalDetectorListMenuListener>();
        private JMenuItem openLocoDialog = new JMenuItem(Resources.getString(DecoderListMenu.class, (String)"openLocoDialog") + " ...");
        private JMenuItem openPomDialog;

        public DecoderListMenu(String label) {
            super(label);
            this.openLocoDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.fireOpenLocoDialog();
                }
            });
            this.add(this.openLocoDialog);
            this.openPomDialog = new JMenuItem(Resources.getString(DecoderListMenu.class, (String)"openPomDialog") + " ...");
            this.openPomDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.fireOpenPomDialog();
                }
            });
            this.add(this.openPomDialog);
        }

        public void addMenuListener(GlobalDetectorListMenuListener l) {
            this.menuListeners.add(l);
        }

        private void fireOpenLocoDialog() {
            for (GlobalDetectorListMenuListener l : this.menuListeners) {
                if (!(l instanceof GlobalDetectorListMenuListener)) continue;
                l.openLocoDialog();
            }
        }

        private void fireOpenPomDialog() {
            for (GlobalDetectorListMenuListener l : this.menuListeners) {
                if (!(l instanceof GlobalDetectorListMenuListener)) continue;
                l.openPomDialog();
            }
        }
    }
}

