/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.statusbar;

import com.jidesoft.status.LabelStatusBarItem;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.bidib.wizard.api.model.common.PreferencesPortType;
import org.bidib.wizard.api.notification.TimeEvent;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.common.model.settings.ConnectionConfiguration;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.core.model.settings.GlobalSettings;
import org.bidib.wizard.core.utils.AopUtils;
import org.bidib.wizard.mvc.main.view.panel.listener.ModelClockStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalClockStatusBarItem
extends LabelStatusBarItem
implements ModelClockStatusListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalClockStatusBarItem.class);
    private static final long serialVersionUID = 1L;
    private final DateTimeFormatter format = DateTimeFormatter.ofPattern("ccc HH:mm:ss");
    private boolean startEnabled;
    private final SettingsService settingsService;
    private final Supplier<String> connectionId;

    public DigitalClockStatusBarItem(SettingsService settingsService, Supplier<String> connectionId) {
        this.settingsService = settingsService;
        this.connectionId = connectionId;
        this.startEnabled = true;
        this.checkSelectedPortType();
        GlobalSettingsInterface gs = settingsService.getGlobalSettings();
        try {
            GlobalSettings globalSettings = (GlobalSettings)AopUtils.getTargetObject((Object)gs);
            globalSettings.addPropertyChangeListener("selectedPortType", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DigitalClockStatusBarItem.this.checkSelectedPortType();
                }
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Add property change listeners failed.", (Throwable)ex);
        }
    }

    public String getItemName() {
        return "DigitalClock";
    }

    public void setBoldFont() {
        this.setFont(new Font("SansSerif", 1, 20));
    }

    public boolean isStartEnabled() {
        return this.startEnabled;
    }

    public void setStartEnabled(boolean startEnabled) {
        this.startEnabled = startEnabled;
    }

    public void start() {
        LOGGER.info("Start the digital clock.");
    }

    public void stop() {
        LOGGER.info("Stop the digital clock.");
        LOGGER.info("Stop the clock passed.");
        SwingUtilities.invokeLater(() -> this.setText(null));
    }

    public void setModelTime(TimeEvent timeEvent) {
        SwingUtilities.invokeLater(() -> this.updateText(timeEvent.getTimestamp()));
    }

    private void updateText(LocalDateTime date) {
        SwingUtils.executeInEDT(() -> {
            if (date != null) {
                this.setText(this.format.format(date));
            } else {
                this.setText(null);
            }
        });
    }

    @Override
    public void setModelTimeStartStatus(boolean enabled) {
        LOGGER.info("Set the start enabled flag: {}", (Object)enabled);
        this.startEnabled = enabled;
    }

    private void checkSelectedPortType() {
        PreferencesPortType selectedPortType = ConnectionConfiguration.toPreferencesPortType((List)this.settingsService.getGlobalSettings().getConnectionConfigurations(), (String)this.connectionId.get());
        if (selectedPortType != null && PreferencesPortType.ConnectionPortType.SerialOverTcp.equals((Object)selectedPortType.getConnectionPortType())) {
            LOGGER.info("The current selected port type is: {}. Do not start the clock.", (Object)selectedPortType);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.stop();
        }
    }
}

