/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import com.jidesoft.grid.TableColumnChooser;
import io.reactivex.rxjava3.subjects.Subject;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.renderer.BidibStatusTableRenderer;
import org.bidib.wizard.client.common.view.renderer.PortConfigErrorAwareRenderer;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.mvc.main.model.SoundPortTableModel;
import org.bidib.wizard.mvc.main.view.table.PortComboBoxWithButtonEditorRenderer;
import org.bidib.wizard.mvc.main.view.table.SoundPortEditorPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundPortTable
extends AbstractPortHierarchicalTable<SoundPort> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundPortTable.class);
    private final SoundPortTableModel soundPortTableModel;

    public SoundPortTable(SoundPortTableModel soundPortTableModel, String emptyTableText) {
        super((SimpleHierarchicalPortTableModel)soundPortTableModel, emptyTableText);
        this.soundPortTableModel = soundPortTableModel;
    }

    public void clearTable() {
    }

    protected SoundPortEditorPanel createPortEditorPanel(SoundPort port, int row, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        SoundPortEditorPanel editorPanel = new SoundPortEditorPanel(port, soundPort -> this.soundPortTableModel.updatePortConfig((SoundPort)soundPort), soundPort -> this.soundPortTableModel.fireTestButtonPressed((SoundPort)soundPort), soundPort -> this.soundPortTableModel.refreshRow((SoundPort)soundPort, changedRow -> this.repaint(this.getCellRect(changedRow, 0, true))), portConfigChangeEventSubject, nodeSelectionProvider);
        editorPanel.createComponent();
        return editorPanel;
    }

    public void prepareTableColumns() {
        TableColumn tc = this.getColumnModel().getColumn(0);
        tc.setCellRenderer((TableCellRenderer)new PortConfigErrorAwareRenderer(0));
        tc.setIdentifier(0);
        tc = this.getColumnModel().getColumn(3);
        tc.setIdentifier(3);
        tc.setCellRenderer((TableCellRenderer)new BidibStatusTableRenderer(SoundPortStatus.class, "status.", 5){
            private static final long serialVersionUID = 1L;

            protected boolean isPortEnabled(ConfigurablePort<?> port) {
                return !(port instanceof Port) || Port.getConfiguredPortType((Port)((Port)port)) == LcOutputType.SOUNDPORT;
            }
        });
        tc.setMinWidth(100);
        tc.setMaxWidth(120);
        TableColumn buttonColumn = this.getColumnModel().getColumn(4);
        buttonColumn.setIdentifier(4);
        buttonColumn.setMinWidth(180);
        buttonColumn.setMaxWidth(200);
        PortComboBoxWithButtonEditorRenderer<BidibStatus> editor = new PortComboBoxWithButtonEditorRenderer<BidibStatus>(this.getActions((BidibStatus)SoundPortStatus.PLAY), ">", SoundPortStatus.class, Integer.valueOf(5)){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isPortEnabled(ConfigurablePort<?> port) {
                return !(port instanceof Port) || Port.getConfiguredPortType((Port)((Port)port)) == LcOutputType.SOUNDPORT;
            }
        };
        buttonColumn.setCellEditor(editor);
        buttonColumn.setCellRenderer((TableCellRenderer)((Object)editor));
        TableColumnChooser.hideColumn((JTable)((Object)this), (int)5);
    }
}

