/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.nodedebug.view;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.StyledLabelBuilder;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.component.ColorPane;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.client.common.view.text.ChangeDocumentListener;
import org.bidib.wizard.mvc.common.view.text.CopyAllAction;
import org.bidib.wizard.mvc.common.view.text.HistoryModel;
import org.bidib.wizard.mvc.common.view.text.HistoryTextField;
import org.bidib.wizard.mvc.common.view.text.JTextFieldLimitDocument;
import org.bidib.wizard.mvc.nodedebug.model.DebugConsoleModel;
import org.bidib.wizard.mvc.nodedebug.view.listener.DebugConsoleViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugConsoleView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugConsoleView.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, max(100dlu;pref), 3dlu, 20dlu, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:50dlu:grow, 3dlu, pref, 3dlu, pref";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, fill:80dlu:grow";
    private final DockKey DOCKKEY = new DockKey("DebugConsoleView");
    private final DebugConsoleModel debugConsoleModel;
    private final JComponent contentPanel;
    private final ColorPane coloredTextPane;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private ValueModel sendTextValueModel;
    private JTextField sendText;
    private final JButton transmitButton = new JButton(Resources.getString(this.getClass(), (String)"transmit"));
    private final List<DebugConsoleViewListener> listeners = new LinkedList<DebugConsoleViewListener>();

    public DebugConsoleView(DebugConsoleModel debugConsoleModel) {
        this.debugConsoleModel = debugConsoleModel;
        this.DOCKKEY.setName(Resources.getString(this.getClass(), (String)"title"));
        this.DOCKKEY.setFloatEnabled(true);
        this.DOCKKEY.setAutoHideEnabled(false);
        LOGGER.info("Create new instance of DebugConsoleView.");
        this.coloredTextPane = new ColorPane();
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.DIALOG);
        this.sendTextValueModel = new PropertyAdapter((Object)debugConsoleModel, "sendText", true);
        HistoryModel.setMax(20);
        this.sendText = new HistoryTextField("sendText", false, true);
        JTextFieldLimitDocument textDoc = new JTextFieldLimitDocument(32);
        this.sendText.setDocument(textDoc);
        Bindings.bind((JTextField)this.sendText, (ValueModel)this.sendTextValueModel, (boolean)false);
        this.sendText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugConsoleView.this.fireTransmit();
            }
        });
        DefaultOverlayable sendTextOverlayable = new DefaultOverlayable((JComponent)this.sendText);
        sendTextOverlayable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + Resources.getString(this.getClass(), (String)"transmitText.prompt") + ":f:gray}")), 7);
        sendTextOverlayable.setOverlayLocationInsets(new Insets(0, -5, 0, 5));
        textDoc.addDocumentListener((DocumentListener)new ChangeDocumentListener(doc -> sendTextOverlayable.setOverlayVisible(doc.getLength() < 1)));
        sendTextOverlayable.setOverlayVisible(textDoc.getLength() < 1);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"transmitText"), new Object[0]).xy(1, 1);
        dialogBuilder.add((Component)sendTextOverlayable).xyw(3, 1, 15);
        dialogBuilder.add((Component)this.transmitButton).xy(19, 1);
        this.transmitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugConsoleView.this.fireTransmit();
            }
        });
        this.transmitButton.setEnabled(false);
        this.coloredTextPane.setEditable(false);
        JScrollPane scrollPaneConsole = new JScrollPane((Component)this.coloredTextPane);
        scrollPaneConsole.setAutoscrolls(true);
        dialogBuilder.add((Component)scrollPaneConsole).xyw(1, 3, 19);
        PropertyConnector.connect((Object)((Object)debugConsoleModel), (String)"transmitEnabled", (Object)this.transmitButton, (String)"enabled");
        this.transmitButton.setEnabled(debugConsoleModel.isTransmitEnabled());
        JPanel contentPanelTemp = dialogBuilder.build();
        contentPanelTemp.setOpaque(false);
        JideScrollPane scrollPane = new JideScrollPane((Component)contentPanelTemp);
        this.contentPanel = scrollPane;
        debugConsoleModel.addPropertyChangeListener("consoleContent", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IndexedPropertyChangeEvent ipce;
                DebugConsoleModel.ConsoleLine newLine;
                LOGGER.info("Property was changed: {}", (Object)evt);
                if (evt instanceof IndexedPropertyChangeEvent && (newLine = (DebugConsoleModel.ConsoleLine)(ipce = (IndexedPropertyChangeEvent)evt).getNewValue()) != null) {
                    LOGGER.info("Add new line: {}", (Object)newLine);
                    String now = DebugConsoleView.this.dateFormat.format(new Date());
                    DebugConsoleView.this.coloredTextPane.append(newLine.getColor(), now + " - " + newLine.getMessage() + "\n");
                }
            }
        });
        debugConsoleModel.addPropertyChangeListener("consoleContentSize", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer value;
                LOGGER.info("Property was changed: {}", (Object)evt);
                if (evt.getNewValue() != null && (value = (Integer)evt.getNewValue()) == 0) {
                    DebugConsoleView.this.coloredTextPane.clear();
                }
            }
        });
        BasicPopupMenu popupMenu = new BasicPopupMenu();
        JMenuItem clearConsole = new JMenuItem(Resources.getString(this.getClass(), (String)"clear_console"));
        clearConsole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugConsoleView.this.fireClearConsole();
            }
        });
        popupMenu.add(clearConsole);
        JMenuItem copyAllToClipboard = new JMenuItem(Resources.getString(this.getClass(), (String)"copyAllToClipboard"));
        copyAllToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugConsoleView.this.fireCopyAllToClipboard();
            }
        });
        popupMenu.add(copyAllToClipboard);
        this.coloredTextPane.setComponentPopupMenu((JPopupMenu)popupMenu);
    }

    public Component getComponent() {
        return this.contentPanel;
    }

    public DockKey getDockKey() {
        return this.DOCKKEY;
    }

    public void addDebugConsoleViewListener(DebugConsoleViewListener l) {
        this.listeners.add(l);
    }

    public void close() {
    }

    private void fireClearConsole() {
        LOGGER.info("clear the console.");
        this.debugConsoleModel.clear();
        this.coloredTextPane.clear();
    }

    private void fireCopyAllToClipboard() {
        LOGGER.info("Copy all content to clipboard.");
        ActionEvent copyAll = new ActionEvent(this.coloredTextPane, 0, "copy-all-to-clipboard");
        CopyAllAction action = new CopyAllAction();
        action.actionPerformed(copyAll);
    }

    private void fireTransmit() {
        for (DebugConsoleViewListener listener : this.listeners) {
            listener.transmit();
        }
        this.sendText.setText(null);
    }
}

