/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.ping.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.event.AbstractBidibMessageEvent;
import org.bidib.jbidibc.messages.event.SysIdentifyStateMessageEvent;
import org.bidib.jbidibc.messages.event.SysPongMessageEvent;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.common.exception.ConnectionException;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.core.model.connection.MessageAdapter;
import org.bidib.wizard.core.model.connection.MessageEventConsumer;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.ping.model.DefaultPingTablePreferences;
import org.bidib.wizard.mvc.ping.model.NodePingModel;
import org.bidib.wizard.mvc.ping.model.NodePingState;
import org.bidib.wizard.mvc.ping.model.PingTableModel;
import org.bidib.wizard.mvc.ping.model.PingTablePreferences;
import org.bidib.wizard.mvc.ping.view.PingTableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;

public class PingTableController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PingTableController.class);
    private final MainControllerInterface mainController;
    private DockableStateChangeListener dockableStateChangeListener;
    private PingTableView pingTableView;
    private PingTableModel pingTableModel;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private MiscSettingsInterface miscSettings;
    private MessageAdapter messageAdapter;
    private final Supplier<String> connectionId;
    private PropertyChangeListener pingIntervalListener;
    private PropertyChangeListener nodePingStatusListener;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final DockingDesktop desktop;
    private ScheduledExecutorService pingWorkers;
    private final NodeListListener nodeListListener;
    private Map<NodeInterface, ScheduledFuture<?>> scheduledPingWorkers = new HashMap();

    public PingTableController(MainControllerInterface mainController, Supplier<String> connectionId, ApplicationEventPublisher applicationEventPublisher, DockingDesktop desktop) {
        this.mainController = mainController;
        this.connectionId = connectionId;
        this.applicationEventPublisher = applicationEventPublisher;
        this.desktop = desktop;
        this.nodeListListener = new DefaultNodeListListener(){

            public void listNodeAdded(NodeInterface node) {
                LOGGER.info("The nodelist has a new node: {}", (Object)node);
                PingTableController.this.nodeNew(node);
            }

            public void listNodeRemoved(NodeInterface node) {
                LOGGER.info("The nodelist has a node removed: {}", (Object)node);
                PingTableController.this.nodeLost(node);
            }
        };
    }

    public void start() {
        String searchKey = "PingTableView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = this.desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing ping table view.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        LOGGER.info("Create new PingTableView.");
        PingTablePreferences pingTablePreferences = this.loadPingTablePreferences();
        int pingInterval = this.miscSettings.getPingInterval();
        this.pingTableModel = new PingTableModel(pingTablePreferences);
        this.pingTableModel.setDefaultPingInterval(pingInterval);
        this.pingTableView = new PingTableView(this.pingTableModel);
        DockableState[] dockables = this.desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (dockables.length > 1) {
            DockableState boosterTableView = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_BOOSTER_TABLE_VIEW.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the booster table view dockable.");
                boosterTableView = dockable;
                break;
            }
            Dockable dock = this.desktop.getDockables()[1].getDockable();
            if (boosterTableView != null) {
                LOGGER.info("Add the ping table view to the booster table view panel.");
                dock = boosterTableView.getDockable();
                TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                int order = 0;
                if (container != null) {
                    order = container.getTabCount();
                }
                LOGGER.info("Add new ping table panel at order: {}", (Object)order);
                this.desktop.createTab(dock, (Dockable)this.pingTableView, order, true);
            } else {
                this.desktop.split(dock, (Dockable)this.pingTableView, DockingConstants.SPLIT_RIGHT);
            }
        } else {
            this.desktop.addDockable((Dockable)this.pingTableView, RelativeDockablePosition.RIGHT);
        }
        this.pingIntervalListener = evt -> {
            int currentPingInterval = this.miscSettings.getPingInterval();
            this.pingTableModel.setDefaultPingInterval(currentPingInterval);
        };
        this.miscSettings.addPropertyChangeListener("pingInterval", this.pingIntervalListener);
        this.mainController.addNodeListListener(this.nodeListListener);
        try {
            this.connectionService.subscribeConnectionStatusChanges(connectionInfo -> {
                if (connectionInfo.getConnectionId().equals(this.connectionId.get())) {
                    LOGGER.info("Current state: {}", (Object)connectionInfo.getConnectionState());
                    switch (connectionInfo.getConnectionState().getActualPhase()) {
                        case CONNECTED: {
                            LOGGER.info("The communication was opened.");
                            break;
                        }
                        case DISCONNECTED: {
                            LOGGER.info("The communication was closed. Remove all nodes from the ping table.");
                            if (this.pingWorkers != null) {
                                LOGGER.info("Shutdown and free the ping workers.");
                                this.pingWorkers.shutdownNow();
                                try {
                                    this.pingWorkers.awaitTermination(2L, TimeUnit.SECONDS);
                                }
                                catch (InterruptedException ex) {
                                    LOGGER.warn("Wait for termination of ping workers failed.", (Throwable)ex);
                                }
                                this.pingWorkers = null;
                            }
                            LinkedList<NodePingModel> pingNodes = new LinkedList<NodePingModel>(this.pingTableModel.getNodes());
                            SwingUtils.executeInEDT(() -> {
                                for (NodePingModel pingNode : pingNodes) {
                                    this.pingTableModel.removeNode(pingNode.getNode());
                                }
                            });
                            break;
                        }
                    }
                }
            }, error -> LOGGER.warn("The connection status change caused an error.", error));
        }
        catch (Exception ex) {
            LOGGER.warn("Register controller as connection status listener failed.", (Throwable)ex);
        }
        this.messageAdapter = new MessageAdapter(this.connectionService, this.connectionId, "pingTable"){

            protected void prepareMessageMap(Map<Class<? extends AbstractBidibMessageEvent>, MessageEventConsumer<AbstractBidibMessageEvent, NodeInterface>> messageActionMap) {
                LOGGER.info("Prepare the message map.");
            }

            protected void handleBidibMessageEvent(AbstractBidibMessageEvent event) {
                LOGGER.debug("Handle the message event: {}", (Object)event);
                if (event instanceof SysPongMessageEvent) {
                    SysPongMessageEvent evt = (SysPongMessageEvent)event;
                    byte[] address = evt.getAddress();
                    int marker = evt.getMarker();
                    LOGGER.info("Set the pong marker: {}", (Object)marker);
                    PingTableController.this.pingTableModel.setPongMarker(address, marker, cme -> PingTableController.this.applicationEventPublisher.publishEvent(cme));
                } else if (event instanceof SysIdentifyStateMessageEvent) {
                    SysIdentifyStateMessageEvent evt = (SysIdentifyStateMessageEvent)event;
                    byte[] address = evt.getAddress();
                    IdentifyState identifyState = evt.getIdentifyState();
                    LOGGER.info("Received the identifyState: {}, address: {}", (Object)identifyState, (Object)NodeUtils.formatAddress((byte[])address));
                    PingTableController.this.pingTableModel.checkIdentifyWaitTime(address);
                }
            }

            protected void onDisconnect() {
                super.onDisconnect();
            }
        };
        this.messageAdapter.start();
        try {
            List nodes = this.nodeService.getAllNodes(this.connectionId.get());
            if (CollectionUtils.isNotEmpty((Collection)nodes)) {
                for (NodeInterface node : nodes) {
                    LOGGER.info("Initially add node.");
                    this.nodeNew(node);
                }
            }
        }
        catch (ConnectionException ex) {
            LOGGER.warn("Get the nodes from the main connection failed: {}", (Object)ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.warn("Get the nodes from the main connection failed.", (Throwable)ex);
        }
        this.nodePingStatusListener = evt -> {
            LOGGER.info("The node ping state has changed, node: {}", evt.getNewValue());
            NodeInterface node = (NodeInterface)evt.getNewValue();
            NodePingModel nodePingModel = this.pingTableModel.getNodes().stream().filter(npm -> npm.getNode().equals((Object)node)).findFirst().orElse(null);
            if (nodePingModel != null) {
                NodePingState nodePingState = nodePingModel.getNodePingState();
                switch (nodePingState) {
                    case ON: {
                        this.startPingWorker(nodePingModel);
                        break;
                    }
                    default: {
                        this.stopPingWorker(nodePingModel);
                    }
                }
            }
        };
        this.pingTableModel.addPropertyChangeListener("nodePingStatus", this.nodePingStatusListener);
        this.dockableStateChangeListener = new DockableStateChangeListener(){

            public void dockableStateChanged(DockableStateChangeEvent event) {
                if (event.getNewState().getDockable().equals((Object)PingTableController.this.pingTableView) && event.getNewState().isClosed()) {
                    LOGGER.info("PingTableView was closed, free resources.");
                    PingTableController.this.cleanup();
                }
            }
        };
        this.desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
    }

    private void cleanup() {
        LOGGER.info("Cleanup.");
        if (this.desktop != null) {
            try {
                this.desktop.removeDockableStateChangeListener(this.dockableStateChangeListener);
            }
            catch (Exception ex) {
                LOGGER.warn("Remove dockableStateChangeListener from desktop failed: " + String.valueOf(this.dockableStateChangeListener), (Throwable)ex);
            }
            finally {
                this.dockableStateChangeListener = null;
            }
        }
        if (this.pingIntervalListener != null) {
            try {
                this.miscSettings.removePropertyChangeListener("pingInterval", this.pingIntervalListener);
            }
            catch (Exception ex) {
                LOGGER.warn("Remove pingInterval listener failed.", (Throwable)ex);
            }
            this.pingIntervalListener = null;
        }
        if (this.nodePingStatusListener != null) {
            try {
                this.pingTableModel.removePropertyChangeListener("nodePingStatus", this.nodePingStatusListener);
            }
            catch (Exception ex) {
                LOGGER.warn("Remove nodePingStatus listener failed.", (Throwable)ex);
            }
            this.nodePingStatusListener = null;
        }
        try {
            if (this.nodeListListener != null) {
                this.mainController.removeNodeListListener(this.nodeListListener);
            }
            if (this.messageAdapter != null) {
                this.messageAdapter.dispose();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Register controller as node listener failed.", (Throwable)ex);
        }
        if (this.pingWorkers != null) {
            LOGGER.info("Shutdown and free the ping workers because the ping table view is closed.");
            this.pingWorkers.shutdownNow();
            try {
                this.pingWorkers.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for termination of ping workers failed.", (Throwable)ex);
            }
            this.pingWorkers = null;
        }
    }

    private PingTablePreferences loadPingTablePreferences() {
        LOGGER.info("Load the ping table preferences.");
        String pingTablePreferencesPath = new File(this.miscSettings.getBidibConfigDir(), "/data/misc").getPath();
        LOGGER.info("Set the location of the ping table preferences: {}", (Object)pingTablePreferencesPath);
        Path path = Paths.get(pingTablePreferencesPath, new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOGGER.warn("Create directories to load the ping table preferences failed.", (Throwable)ex);
            throw new IllegalStateException("Create directories to load the ping table preferences failed.");
        }
        File pingTablePreferencesFile = new File(pingTablePreferencesPath, ".wizard2PingTablePreferences");
        LOGGER.info("Load pingTablePreferences from file: {}", (Object)pingTablePreferencesFile);
        DefaultPingTablePreferences pingTablePreferences = new DefaultPingTablePreferences(pingTablePreferencesFile);
        try {
            pingTablePreferences.load();
        }
        catch (Exception ex) {
            LOGGER.warn("Load pingTablePreferences failed. Current pingTablePreferences file: {}", (Object)pingTablePreferencesFile.getPath(), (Object)ex);
        }
        return pingTablePreferences;
    }

    private void startPingWorker(NodePingModel nodePingModel) {
        if (this.pingWorkers == null) {
            LOGGER.info("Create the ping workers thread pool.");
            this.pingWorkers = Executors.newScheduledThreadPool(0, new ThreadFactoryBuilder().setNameFormat("pingWorkers-thread-%d").build());
        }
        this.stopPingWorker(nodePingModel);
        long period = nodePingModel.getPingInterval().intValue();
        if (period < 100L) {
            period = 100L;
        }
        Runnable command = () -> {
            try {
                long now = System.currentTimeMillis();
                int additionalTotalBytesCount = nodePingModel.getAdditionalTotalBytesCount();
                byte[] payload = nodePingModel.getNextIncData();
                int sentMessageLen = 3 + nodePingModel.getNode().getAddr().length + payload.length;
                int totalRepetitions = additionalTotalBytesCount > 0 ? additionalTotalBytesCount / sentMessageLen : 0;
                int nextPingIndex = nodePingModel.getData() + totalRepetitions;
                nodePingModel.setData(nextPingIndex);
                LOGGER.info("Ping the node: {}, additionalTotalBytesCount: {}, payload: {}, totalRepetitions: {}, nextPingIndex: {}", new Object[]{nodePingModel, additionalTotalBytesCount, ByteUtils.bytesToHex((byte[])payload), totalRepetitions, nextPingIndex});
                this.nodeService.ping(this.connectionId.get(), nodePingModel.getNode(), payload, additionalTotalBytesCount);
                nodePingModel.setLastPingTimestamp(now);
            }
            catch (Exception ex) {
                LOGGER.warn("Ping node failed: {}", (Object)nodePingModel, (Object)ex);
            }
        };
        ScheduledFuture<?> pingFuture = this.pingWorkers.scheduleAtFixedRate(command, 500L, period, TimeUnit.MILLISECONDS);
        this.scheduledPingWorkers.put(nodePingModel.getNode(), pingFuture);
    }

    private void stopPingWorker(NodePingModel nodePingModel) {
        ScheduledFuture<?> oldWorker = this.scheduledPingWorkers.remove(nodePingModel.getNode());
        if (oldWorker != null) {
            LOGGER.info("Cancel the ping worker: {}", oldWorker);
            oldWorker.cancel(true);
        }
    }

    private void nodeLost(NodeInterface node) {
        LOGGER.info("Remove node from model: {}", (Object)node);
        if (node != null) {
            SwingUtils.executeInEDT(() -> this.pingTableModel.removeNode(node));
        }
    }

    private void nodeNew(NodeInterface node) {
        LOGGER.info("New node in system detected: {}", (Object)node);
        SwingUtils.executeInEDT(() -> this.internalNewNode(node));
    }

    private void internalNewNode(NodeInterface node) {
        if (node != null) {
            this.pingTableModel.addNode(node);
        }
    }
}

