/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.model.command;

import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.AddressMode;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.wizard.mvc.pom.model.AddressProgBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomOperationIfElseCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomAddressModeCommand
extends PomOperationIfElseCommand<AddressProgBeanModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomAddressModeCommand.class);
    private int bitPosition;
    private AddressMode addressMode;

    public PomAddressModeCommand(PomAddressData decoderAddress, PomOperation pomOperation, int cvNumber, int bitPosition, int cvValue) {
        super(decoderAddress, pomOperation, cvNumber, cvValue);
        this.bitPosition = bitPosition;
    }

    public PomAddressModeCommand(PomAddressData decoderAddress, PomOperation pomOperation, int cvNumber, int cvValue) {
        super(decoderAddress, pomOperation, cvNumber, cvValue);
    }

    @Override
    public void setCvValueResult(Integer cvValueResult) {
        LOGGER.info("Address mode, result: {}", (Object)cvValueResult);
        if (cvValueResult != null) {
            int bitMask = PomAddressModeCommand.prepareCompareBitMask(this.bitPosition);
            int cvValue = cvValueResult;
            int val = (cvValue & bitMask) >> this.bitPosition;
            LOGGER.info("Set address mode from value: {}", (Object)val);
            this.setAddressMode(AddressMode.valueOf((int)val));
            cvValueResult = val;
        }
        super.setCvValueResult(cvValueResult);
    }

    public void setAddressMode(AddressMode addressMode) {
        LOGGER.info("Set the addressMode: {}", (Object)addressMode);
        this.addressMode = addressMode;
    }

    public AddressMode getAddressMode() {
        return this.addressMode;
    }

    @Override
    public void postExecute(AddressProgBeanModel addressProgBeanModel) {
        super.postExecute(addressProgBeanModel);
        if (this.addressMode != null) {
            LOGGER.debug("Set the addressMode: {}", (Object)this.addressMode);
            addressProgBeanModel.setAddressMode(this.addressMode);
        }
    }

    protected static int prepareCompareBitMask(int bitNumber) {
        int compareValue = 1 << bitNumber;
        return compareValue;
    }

    @Override
    public boolean isExpectedResult() {
        if (PomOperation.WR_BIT.equals((Object)this.getPomOperation()) || PomOperation.WR_BYTE.equals((Object)this.getPomOperation())) {
            LOGGER.info("Don't compare expected for write operations.");
            return true;
        }
        try {
            LOGGER.info("isExpectedResult, compare values, expected: {}, received: {}", (Object)this.getCvValue(), (Object)this.getCvValueResult());
            return this.getCvValue() == this.getCvValueResult().intValue();
        }
        catch (Exception ex) {
            LOGGER.warn("Compare expected and result cv value failed.", (Throwable)ex);
            return false;
        }
    }
}

