/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.model.command;

import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.wizard.mvc.pom.model.AddressProgBeanModel;
import org.bidib.wizard.mvc.pom.model.CurrentAddressBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomAddressValueCommand;
import org.bidib.wizard.mvc.pom.model.command.PomOperationContinueAfterTimeoutCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomAddressPanelChangeAddressCommand
extends PomAddressValueCommand
implements PomOperationContinueAfterTimeoutCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomAddressPanelChangeAddressCommand.class);
    private final CurrentAddressBeanModel currentAddressBeanModel;

    public PomAddressPanelChangeAddressCommand(PomAddressData decoderAddress, PomOperation pomOperation, int cvNumber, int cvValue, PomAddressValueCommand.ValueType valueType, CurrentAddressBeanModel currentAddressBeanModel) {
        super(decoderAddress, pomOperation, cvNumber, cvValue, valueType);
        this.currentAddressBeanModel = currentAddressBeanModel;
    }

    @Override
    public void postExecute(AddressProgBeanModel addressProgBeanModel) {
        super.postExecute(addressProgBeanModel);
        LOGGER.info("postExecute, progStateResult: {}", (Object)this.getProgStateResult());
        if (PomProgState.POM_PROG_OKAY.equals((Object)this.getProgStateResult())) {
            LOGGER.info("The POM operation was executed successfully.");
            if (this.currentAddressBeanModel != null) {
                Integer addressValue = addressProgBeanModel.getAddress();
                LOGGER.info("Update the address value in the dialog: {}", (Object)addressValue);
                this.currentAddressBeanModel.setDccAddress(addressValue);
                this.currentAddressBeanModel.setAddressChanged(Boolean.TRUE);
            }
        }
    }
}

