/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.view.panel;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResultModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.jbidibc.messages.utils.CollectionUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.pom.model.CurrentAddressBeanModel;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomOperationCommand;
import org.bidib.wizard.mvc.pom.model.command.PomOperationContinueAfterTimeoutCommand;
import org.bidib.wizard.mvc.pom.model.command.PomOperationIfElseCommand;
import org.bidib.wizard.mvc.pom.model.listener.ProgCommandListener;
import org.bidib.wizard.mvc.pom.view.panel.LogAreaAware;
import org.bidib.wizard.mvc.pom.view.panel.PomProgStateConverter;
import org.bidib.wizard.mvc.pom.view.panel.PomResultProxyModel;
import org.bidib.wizard.mvc.pom.view.panel.PomValidationResultModel;
import org.bidib.wizard.mvc.pom.view.panel.listener.PomRequestListener;
import org.bidib.wizard.mvc.pom.view.panel.listener.PomResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractPomPanel<M extends ProgCommandAwareBeanModel>
implements PomResultListener {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_TIMEOUT = 1000;
    public static final int DEFAULT_SUSI_READ_FIRST_TIMEOUT = 300;
    private static final String ENCODED_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_ROW_SPECS = "pref, 3dlu";
    private final List<PomRequestListener> listeners = new LinkedList<PomRequestListener>();
    protected final PomProgrammerModel cvProgrammerModel;
    protected final PomResultProxyModel pomResultProxyModel;
    protected final JButton readButton = new JButton(Resources.getString(AbstractPomPanel.class, (String)"read"));
    protected final JButton writeButton = new JButton(Resources.getString(AbstractPomPanel.class, (String)"write"));
    protected ValueModel readButtonEnabled;
    protected ValueModel writeButtonEnabled;
    protected ValueModel currentOperationModel;
    protected JLabel currentOperationLabel;
    private ImageIcon progOperationErrorIcon;
    private ImageIcon progOperationSuccessfulIcon;
    private ImageIcon progOperationWaitIcon;
    protected ImageIcon progOperationUnknownIcon;
    private ImageIcon progOperationEmptyIcon;
    private JTextArea loggerArea;
    private static final String NEWLINE = "\n";
    protected boolean activeTab;
    private M progCommandAwareBeanModel;
    protected CurrentAddressBeanModel currentAddressBeanModel;
    private Timer readTimeout;
    private Object readTimeoutLock = new Object();

    public AbstractPomPanel(PomProgrammerModel cvProgrammerModel, CurrentAddressBeanModel currentAddressBeanModel) {
        this.cvProgrammerModel = cvProgrammerModel;
        this.currentAddressBeanModel = currentAddressBeanModel;
        this.pomResultProxyModel = new PomResultProxyModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isAllowUpdate() {
                return AbstractPomPanel.this.isActive();
            }
        };
        this.initializeIcons();
    }

    private void initializeIcons() {
        this.progOperationErrorIcon = ImageUtils.createImageIcon(AbstractPomPanel.class, (String)"/icons/accessory-error.png");
        this.progOperationSuccessfulIcon = ImageUtils.createImageIcon(AbstractPomPanel.class, (String)"/icons/accessory-successful.png");
        this.progOperationWaitIcon = ImageUtils.createImageIcon(AbstractPomPanel.class, (String)"/icons/accessory-wait.png");
        this.progOperationUnknownIcon = ImageUtils.createImageIcon(AbstractPomPanel.class, (String)"/icons/information.png");
        this.progOperationEmptyIcon = ImageUtils.createImageIcon(AbstractPomPanel.class, (String)"/icons/empty.png");
    }

    protected void postConstruct() {
    }

    public ProgCommandAwareBeanModel getProgCommandAwareBeanModel() {
        return this.progCommandAwareBeanModel;
    }

    public void setProgCommandAwareBeanModel(M progCommandAwareBeanModel) {
        this.progCommandAwareBeanModel = progCommandAwareBeanModel;
    }

    public void addPomRequestListener(PomRequestListener l) {
        this.listeners.add(l);
    }

    protected List<PomRequestListener> getPomRequestListeners() {
        return this.listeners;
    }

    @Override
    public void setActive(boolean active) {
        this.LOGGER.info("Set the active flag: {}", (Object)active);
        this.activeTab = active;
    }

    @Override
    public boolean isActive() {
        return this.activeTab;
    }

    protected abstract void createWorkerPanel(FormBuilder var1, int[] var2, PomValidationResultModel var3);

    public JPanel createPanel(PomValidationResultModel parentValidationModel) {
        this.cvProgrammerModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                switch (evt.getPropertyName()) {
                    case "pomProgState": {
                        AbstractPomPanel.this.pomResultProxyModel.setPomProgState((PomProgState)evt.getNewValue());
                        break;
                    }
                    case "cvNumber": {
                        AbstractPomPanel.this.pomResultProxyModel.setCvNumber((Integer)evt.getNewValue());
                        break;
                    }
                    case "cvValue": {
                        AbstractPomPanel.this.pomResultProxyModel.setCvValue((Integer)evt.getNewValue());
                        break;
                    }
                }
            }
        });
        FormBuilder builder = null;
        boolean debug = false;
        if (debug) {
            panel = new LogAreaAwareDebugPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void clearLogArea() {
                    AbstractPomPanel.this.clearLogArea();
                }
            };
            builder = FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)((Object)panel));
        } else {
            panel = new LogAreaAwarePanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void clearLogArea() {
                    AbstractPomPanel.this.clearLogArea();
                }
            };
            builder = FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)((Object)panel));
        }
        builder.border((Border)Paddings.TABBED_DIALOG);
        int[] rowHolder = new int[]{1};
        this.createWorkerPanel(builder, rowHolder, parentValidationModel);
        int currentRow = rowHolder[0];
        currentRow += 2;
        this.currentOperationModel = new PropertyAdapter((Object)this.pomResultProxyModel, "pomProgState", true);
        ConverterValueModel valueConverterModel = new ConverterValueModel(this.currentOperationModel, (BindingConverter)new PomProgStateConverter());
        this.currentOperationLabel = WizardComponentFactory.createLabel((ValueModel)valueConverterModel);
        this.currentOperationLabel.setIcon(this.progOperationEmptyIcon);
        builder.appendRows("pref, 5dlu", new Object[0]);
        builder.add(Resources.getString(AbstractPomPanel.class, (String)"prog-result"), new Object[0]).xy(1, currentRow);
        builder.add((Component)this.currentOperationLabel).xyw(3, currentRow, 5);
        this.loggerArea = new JTextArea(20, 45);
        this.loggerArea.setFont(UIManager.getDefaults().getFont("Label.font"));
        JScrollPane scrollPane = new JScrollPane(20, 32);
        scrollPane.getViewport().add(this.loggerArea);
        this.loggerArea.setEditable(false);
        builder.appendRows("fill:200px:grow", new Object[0]);
        builder.add((Component)scrollPane).xyw(1, currentRow += 2, 7);
        this.doBindButtons();
        this.cvProgrammerModel.addProgCommandListener(new ProgCommandListener(){

            @Override
            public void progPomFinished(PomProgState pomProgState) {
                AbstractPomPanel.this.LOGGER.info("The prog command has finished, pomProgState: {}", (Object)pomProgState);
                if (!AbstractPomPanel.this.isActive()) {
                    return;
                }
                if (!PomProgState.POM_PROG_START.equals((Object)pomProgState) && !PomProgState.POM_PROG_RUNNING.equals((Object)pomProgState)) {
                    PomOperationCommand<? extends ProgCommandAwareBeanModel> executingProgCommand = ((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getExecutingProgCommand();
                    if (executingProgCommand != null) {
                        AbstractPomPanel.this.LOGGER.info("The executingProgCommand: {}", executingProgCommand);
                        executingProgCommand.setProgStateResult(pomProgState);
                        boolean ignoreError = false;
                        if (executingProgCommand instanceof PomOperationIfElseCommand) {
                            PomOperationIfElseCommand ifElseCommand = (PomOperationIfElseCommand)executingProgCommand;
                            AbstractPomPanel.this.LOGGER.info("The executing command is a if-else-command: {}", (Object)ifElseCommand);
                            if (!PomProgState.POM_PROG_OKAY.equals((Object)ifElseCommand.getProgStateResult()) || !ifElseCommand.isExpectedResult()) {
                                AbstractPomPanel.this.LOGGER.info("The command was not successful executed or expected result was not received!");
                                List failureCommands = ifElseCommand.getProgCommandsFailure();
                                if (CollectionUtils.hasElements(failureCommands)) {
                                    AbstractPomPanel.this.LOGGER.info("Found failure commands to be executed: {}", failureCommands);
                                    List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = ((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getProgCommands();
                                    progCommands.clear();
                                    progCommands.addAll(failureCommands);
                                    ignoreError = true;
                                }
                            } else {
                                AbstractPomPanel.this.LOGGER.info("The command was successful executed!");
                                List successCommands = ifElseCommand.getProgCommandsSuccess();
                                if (CollectionUtils.hasElements(successCommands)) {
                                    AbstractPomPanel.this.LOGGER.info("Found success commands to be executed: {}", successCommands);
                                    List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = ((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getProgCommands();
                                    progCommands.clear();
                                    progCommands.addAll(successCommands);
                                }
                            }
                        }
                        if (PomProgState.POM_PROG_OKAY.equals((Object)executingProgCommand.getProgStateResult())) {
                            AbstractPomPanel.this.LOGGER.info("PostExecute the command.");
                            executingProgCommand.postExecute((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel));
                        } else if (!ignoreError) {
                            AbstractPomPanel.this.LOGGER.warn("Clear remaining prog commands because command has finished with an error: {}", executingProgCommand);
                            if (CollectionUtils.hasElements(((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getProgCommands())) {
                                ((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getProgCommands().clear();
                            }
                            AbstractPomPanel.this.addLogText("Error detected. Please try again.", new Object[0]);
                        }
                        ((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getExecutedProgCommands().add(executingProgCommand);
                        executingProgCommand = null;
                    }
                    if (CollectionUtils.hasElements(((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getProgCommands())) {
                        AbstractPomPanel.this.LOGGER.info("Prepare the next command.");
                        AbstractPomPanel.this.startTimeoutControl(1000);
                        AbstractPomPanel.this.LOGGER.info("Fire the next command.");
                        AbstractPomPanel.this.fireNextCommand();
                    } else {
                        AbstractPomPanel.this.LOGGER.info("No more commands to send, enable the input elements.");
                        AbstractPomPanel.this.stopTimeoutControl();
                        AbstractPomPanel.this.enableInputElements();
                    }
                }
            }
        });
        this.cvProgrammerModel.addPropertyChangeListener("cvValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                block8: {
                    block7: {
                        if (!AbstractPomPanel.this.isActive()) {
                            return;
                        }
                        AbstractPomPanel.this.LOGGER.info("The CV value has been changed: {}", evt.getNewValue());
                        if (((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getCurrentOperation() == null) break block7;
                        switch (((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getCurrentOperation()) {
                            case RD_BIT: 
                            case RD_BYTE: {
                                ((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getExecutingProgCommand().setCvValueResult((Integer)evt.getNewValue());
                                if (evt.getNewValue() != null) {
                                    AbstractPomPanel.this.addLogText("Read operation returned: {}", ((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getExecutingProgCommand().getCvValueResult());
                                    break;
                                }
                                break block8;
                            }
                            case WR_BYTE: {
                                break;
                            }
                            case WR_BIT: {
                                break;
                            }
                        }
                        break block8;
                    }
                    AbstractPomPanel.this.LOGGER.info("No operation performed.");
                }
            }
        });
        if (parentValidationModel != null) {
            parentValidationModel.addPropertyChangeListener("validState", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AbstractPomPanel.this.triggerValidation();
                }
            });
            parentValidationModel.addPropertyChangeListener("validStateNoWarnOrErrors", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AbstractPomPanel.this.triggerValidation();
                }
            });
        }
        JPanel panel = null;
        if (this.getValidationResultModel() != null) {
            this.LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel(this.getValidationResultModel(), (JComponent)builder.build());
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]);
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            panel = feedbackBuilder.build();
        } else {
            panel = builder.build();
        }
        this.postConstruct();
        return panel;
    }

    protected void doBindButtons() {
        if (this.readButtonEnabled != null) {
            PropertyConnector.connect((Object)this.readButtonEnabled, (String)"value", (Object)this.readButton, (String)"enabled");
        }
        PropertyConnector.connect((Object)this.writeButtonEnabled, (String)"value", (Object)this.writeButton, (String)"enabled");
    }

    protected abstract void triggerValidation();

    protected ValidationResultModel getValidationResultModel() {
        return null;
    }

    @Override
    public void addLogText(String logLine, Object ... args) {
        this.LOGGER.info("Add text to loggerArea, logLine: {}, args: {}", (Object)logLine, (Object)args);
        if (args != null) {
            logLine = MessageFormatter.arrayFormat((String)logLine, (Object[])args).getMessage();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS - ");
        StringBuilder message = new StringBuilder(sdf.format(new Date()));
        message.append(logLine).append(NEWLINE);
        SwingUtils.executeInEDT(() -> {
            this.loggerArea.append(message.toString());
            this.loggerArea.setCaretPosition(this.loggerArea.getDocument().getLength());
        });
    }

    public void clearLogArea() {
        if (this.loggerArea != null) {
            this.loggerArea.setText(null);
        }
    }

    protected abstract Object getCurrentOperation();

    @Override
    public void signalPomProgStateChanged(PomProgState pomProgState) {
        if (!this.isActive()) {
            this.LOGGER.info("Do not process result because this is not the active tab.");
            return;
        }
        switch (pomProgState) {
            case POM_PROG_OKAY: {
                this.currentOperationLabel.setIcon(this.progOperationSuccessfulIcon);
                this.addLogText("Prog operation passed: " + String.valueOf(this.getCurrentOperation()), new Object[0]);
                this.enableInputElements();
                break;
            }
            case POM_PROG_STOPPED: 
            case POM_PROG_NO_ANSWER: {
                this.currentOperationLabel.setIcon(this.progOperationErrorIcon);
                this.addLogText("Prog operation failed: {}", pomProgState.name());
                this.enableInputElements();
                break;
            }
            case POM_PROG_START: {
                this.currentOperationLabel.setIcon(this.progOperationUnknownIcon);
                this.addLogText("Prog operation started: " + String.valueOf(this.getCurrentOperation()), new Object[0]);
                break;
            }
            case POM_PROG_RUNNING: {
                this.currentOperationLabel.setIcon(this.progOperationWaitIcon);
                this.addLogText("Prog operation is running ...", new Object[0]);
            }
        }
    }

    protected void sendRequest(PomAddressData decoderAddress, PomOperation operation, int cvNumber, int cvValue) {
        this.cvProgrammerModel.setCvNumber(cvNumber);
        this.cvProgrammerModel.setCvValue(null);
        for (PomRequestListener listener : this.getPomRequestListeners()) {
            listener.sendRequest(this, decoderAddress, operation, cvNumber, cvValue);
        }
    }

    protected void disableInputElements() {
        this.LOGGER.info("Disable input elements.");
        if (this.readButtonEnabled != null) {
            this.readButtonEnabled.setValue((Object)false);
        }
        if (this.writeButtonEnabled != null) {
            this.writeButtonEnabled.setValue((Object)false);
        }
    }

    protected void enableInputElements() {
        this.LOGGER.info("Enable input elements.");
    }

    protected void fireNextCommand() {
        this.disableInputElements();
        List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = ((ProgCommandAwareBeanModel)((Object)this.progCommandAwareBeanModel)).getProgCommands();
        this.LOGGER.info("Prepared commands for addressing the decoder: {}", progCommands);
        PomOperationCommand<? extends ProgCommandAwareBeanModel> progCommand = progCommands.remove(0);
        ((ProgCommandAwareBeanModel)((Object)this.progCommandAwareBeanModel)).setCurrentOperation(progCommand.getPomOperation());
        switch (progCommand.getPomOperation()) {
            case WR_BYTE: 
            case WR_BIT: {
                ((ProgCommandAwareBeanModel)((Object)this.progCommandAwareBeanModel)).setExecution(ProgCommandAwareBeanModel.ExecutionType.WRITE);
                break;
            }
            default: {
                ((ProgCommandAwareBeanModel)((Object)this.progCommandAwareBeanModel)).setExecution(ProgCommandAwareBeanModel.ExecutionType.READ);
            }
        }
        ((ProgCommandAwareBeanModel)((Object)this.progCommandAwareBeanModel)).setExecutingProgCommand(progCommand);
        this.addLogText("Prog write request: {}", progCommand);
        this.sendRequest(progCommand.getDecoderAddress(), progCommand.getPomOperation(), progCommand.getCvNumber(), progCommand.getCvValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTimeoutControl(int timeout) {
        this.LOGGER.info("Timeout control is started, timeout: {}.", (Object)timeout);
        Object object = this.readTimeoutLock;
        synchronized (object) {
            if (this.readTimeout != null) {
                this.LOGGER.info("The timeout control is already assigned: {}", (Object)this.readTimeout);
                if (this.readTimeout.isRunning()) {
                    this.LOGGER.info("The timeout control is already running and will be stopped.");
                    this.readTimeout.stop();
                }
                this.readTimeout = null;
            }
            this.readTimeout = new Timer(timeout, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractPomPanel.this.LOGGER.info("Timeout control has expired.");
                    AbstractPomPanel.this.addLogText("Timeout control has expired. No answer from decoder received.", new Object[0]);
                    PomOperationCommand<? extends ProgCommandAwareBeanModel> currentExecutingProgCommand = ((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getExecutingProgCommand();
                    if (currentExecutingProgCommand != null && currentExecutingProgCommand.decrementRetryCount() > -1) {
                        List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = ((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getProgCommands();
                        AbstractPomPanel.this.LOGGER.info("Add current executing command at head: {}", currentExecutingProgCommand);
                        progCommands.add(0, currentExecutingProgCommand);
                    }
                    if (CollectionUtils.hasElements(((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getProgCommands())) {
                        AbstractPomPanel.this.LOGGER.info("Prepare the next command to send.");
                        AbstractPomPanel.this.startTimeoutControl(1000);
                        AbstractPomPanel.this.fireNextCommand();
                    } else if (((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getExecutingProgCommand() instanceof PomOperationIfElseCommand) {
                        boolean ignoreError = false;
                        PomOperationCommand<? extends ProgCommandAwareBeanModel> executingProgCommand = ((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getExecutingProgCommand();
                        AbstractPomPanel.this.LOGGER.info("The executingProgCommand: {}", executingProgCommand);
                        if (executingProgCommand instanceof PomOperationIfElseCommand) {
                            PomOperationIfElseCommand ifElseCommand = (PomOperationIfElseCommand)executingProgCommand;
                            AbstractPomPanel.this.LOGGER.info("The executing command is a if-else-command: {}", (Object)ifElseCommand);
                            List failureCommands = ifElseCommand.getProgCommandsFailure();
                            if (CollectionUtils.hasElements(failureCommands)) {
                                AbstractPomPanel.this.LOGGER.info("Found failure commands to be executed: {}", failureCommands);
                                if (failureCommands.get(0) instanceof PomOperationContinueAfterTimeoutCommand) {
                                    AbstractPomPanel.this.LOGGER.info("The first failure command is a PomOperationContinueAfterTimeoutCommand. This is no error, we can proceed.");
                                    List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = ((ProgCommandAwareBeanModel)((Object)AbstractPomPanel.this.progCommandAwareBeanModel)).getProgCommands();
                                    progCommands.clear();
                                    progCommands.addAll(failureCommands);
                                    ignoreError = true;
                                }
                            }
                        }
                        if (!ignoreError) {
                            AbstractPomPanel.this.LOGGER.info("No more commands to send, enable the input elements.");
                            AbstractPomPanel.this.cvProgrammerModel.setPomProgState(PomProgState.POM_PROG_NO_ANSWER);
                        } else {
                            AbstractPomPanel.this.LOGGER.info("Start the timeout control and fire the next command.");
                            AbstractPomPanel.this.startTimeoutControl(1000);
                            AbstractPomPanel.this.fireNextCommand();
                        }
                    } else {
                        AbstractPomPanel.this.LOGGER.info("No more commands to send, enable the input elements.");
                        AbstractPomPanel.this.cvProgrammerModel.setPomProgState(PomProgState.POM_PROG_NO_ANSWER);
                    }
                }
            });
            this.readTimeout.setRepeats(false);
            this.readTimeout.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTimeoutControl() {
        this.LOGGER.info("Timeout control is stopped.");
        Object object = this.readTimeoutLock;
        synchronized (object) {
            if (this.readTimeout != null) {
                this.LOGGER.info("The timeout control is assigned and will be stopped: {}", (Object)this.readTimeout);
                this.readTimeout.stop();
                this.readTimeout = null;
            }
        }
    }

    private static class LogAreaAwareDebugPanel
    extends FormDebugPanel
    implements LogAreaAware {
        private static final long serialVersionUID = 1L;

        private LogAreaAwareDebugPanel() {
        }

        @Override
        public void clearLogArea() {
        }
    }

    private static class LogAreaAwarePanel
    extends JPanel
    implements LogAreaAware {
        private static final long serialVersionUID = 1L;

        private LogAreaAwarePanel() {
        }

        @Override
        public void clearLogArea() {
        }
    }
}

