/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.IntegerRangeFilter;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.text.ChangeDocumentListener;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.mvc.preferences.model.PreferencesModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiscSettingsPanel
extends AbstractSettingsPanel<MiscSettingsInterface> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiscSettingsPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow, 3dlu, pref";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu";
    private final PreferencesModel model;
    private final MiscSettingsInterface miscSettings;
    private JPanel contentPanel;

    public MiscSettingsPanel(PreferencesModel model, MiscSettingsInterface miscSettings, Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);
        this.model = model;
        this.miscSettings = miscSettings;
    }

    public JPanel createPanel() {
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.preparePresentationModel(this.miscSettings);
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"bidibConfigDir") + ":", new Object[0]).xy(1, 1);
        BufferedValueModel bidibConfigDirModel = this.presentationModel.getBufferedModel("bidibConfigDir");
        final JTextField bidibConfigDir = WizardComponentFactory.createTextField((ValueModel)bidibConfigDirModel, (boolean)false);
        dialogBuilder.add((Component)bidibConfigDir).xy(3, 1);
        JButton selectDirectoryButton = new JButton(Resources.getString(MiscSettingsPanel.class, (String)"select-config-directory"));
        selectDirectoryButton.setToolTipText(Resources.getString(MiscSettingsPanel.class, (String)"select-config-directory.tooltip"));
        selectDirectoryButton.addActionListener(evt -> {
            String bidibConfigDirectory = bidibConfigDirModel.getString();
            FileFilter[] ff = null;
            FileDialog dialog = new FileDialog(this.contentPanel, 1, bidibConfigDirectory, null, ff){

                public void approve(String selectedFile) {
                    File file = new File(selectedFile);
                    if (file != null && file.isDirectory()) {
                        String configDirLocation = file.getPath();
                        LOGGER.info("Set the bidib config directory location: {}", (Object)configDirLocation);
                        bidibConfigDir.setText(configDirLocation);
                    }
                }
            };
            dialog.setApproveButtonText(Resources.getString(MiscSettingsPanel.class, (String)"select-config-directory"));
            dialog.showDialog();
        });
        dialogBuilder.add((Component)selectDirectoryButton).xy(5, 1);
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"bidibLabelsDir") + ":", new Object[0]).xy(1, 3);
        BufferedValueModel bidibLabelsDirModel = this.presentationModel.getBufferedModel("bidibLabelsDir");
        final JTextField bidibLabelsDir = WizardComponentFactory.createTextField((ValueModel)bidibLabelsDirModel, (boolean)false);
        Document textDoc = bidibLabelsDir.getDocument();
        DefaultOverlayable labelsDirOverlayable = new DefaultOverlayable((JComponent)bidibLabelsDir);
        labelsDirOverlayable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + Resources.getString(((Object)((Object)this)).getClass(), (String)"bidibLabelsDir.prompt") + ":f:gray}")), 7);
        labelsDirOverlayable.setOverlayLocationInsets(new Insets(0, -5, 0, 0));
        textDoc.addDocumentListener((DocumentListener)new ChangeDocumentListener(doc -> labelsDirOverlayable.setOverlayVisible(doc.getLength() < 1)));
        labelsDirOverlayable.setOverlayVisible(textDoc.getLength() < 1);
        dialogBuilder.add((Component)labelsDirOverlayable).xy(3, 3);
        JButton selectLabelsDirectoryButton = new JButton(Resources.getString(MiscSettingsPanel.class, (String)"select-labels-directory"));
        selectLabelsDirectoryButton.setToolTipText(Resources.getString(MiscSettingsPanel.class, (String)"select-labels-directory.tooltip"));
        selectLabelsDirectoryButton.addActionListener(evt -> {
            String bidibLabelsDirectory = bidibLabelsDirModel.getString();
            if (StringUtils.isBlank((CharSequence)bidibLabelsDirectory)) {
                bidibLabelsDirectory = bidibConfigDirModel.getString();
            }
            FileFilter[] ff = null;
            FileDialog dialog = new FileDialog(this.contentPanel, 1, bidibLabelsDirectory, null, ff){

                public void approve(String selectedFile) {
                    File file = new File(selectedFile);
                    if (file != null && file.isDirectory()) {
                        String labelsDirLocation = file.getPath();
                        LOGGER.info("Set the bidib labels directory location: {}", (Object)labelsDirLocation);
                        bidibLabelsDir.setText(labelsDirLocation);
                    }
                }
            };
            dialog.setApproveButtonText(Resources.getString(MiscSettingsPanel.class, (String)"select-labels-directory"));
            dialog.showDialog();
        });
        dialogBuilder.add((Component)selectLabelsDirectoryButton).xy(5, 3);
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"logFilePath") + ":", new Object[0]).xy(1, 5);
        BufferedValueModel logFilePathModel = this.presentationModel.getBufferedModel("logFilePath");
        final JTextField logFilePath = WizardComponentFactory.createTextField((ValueModel)logFilePathModel, (boolean)false);
        logFilePath.setPreferredSize(new Dimension(300, logFilePath.getPreferredSize().height));
        dialogBuilder.add((Component)logFilePath).xy(3, 5);
        JButton selectLogFilePathButton = new JButton(Resources.getString(MiscSettingsPanel.class, (String)"select-logfile-directory"));
        selectLogFilePathButton.setToolTipText(Resources.getString(MiscSettingsPanel.class, (String)"select-logfile-directory.tooltip"));
        selectLogFilePathButton.addActionListener(evt -> {
            String logFileDirectory = logFilePathModel.getString();
            FileFilter[] ff = null;
            FileDialog dialog = new FileDialog(this.contentPanel, 1, logFileDirectory, null, ff){

                public void approve(String selectedFile) {
                    File file = new File(selectedFile);
                    if (file != null && file.isDirectory()) {
                        String logFileDirLocation = file.getPath();
                        LOGGER.info("Set the logfile directory location: {}", (Object)logFileDirLocation);
                        logFilePath.setText(logFileDirLocation);
                    }
                }
            };
            dialog.setApproveButtonText(Resources.getString(MiscSettingsPanel.class, (String)"select-logfile-directory"));
            dialog.showDialog();
        });
        dialogBuilder.add((Component)selectLogFilePathButton).xy(5, 5);
        BufferedValueModel logFileAppendModel = this.presentationModel.getBufferedModel("logFileAppend");
        JCheckBox logFileAppend = WizardComponentFactory.createCheckBox((ValueModel)logFileAppendModel, (String)Resources.getString(((Object)((Object)this)).getClass(), (String)"logFileAppend"));
        logFileAppend.setToolTipText(Resources.getString(((Object)((Object)this)).getClass(), (String)"logFileAppend.tooltip"));
        dialogBuilder.add((Component)logFileAppend).xyw(1, 7, 5);
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"workspacePath") + ":", new Object[0]).xy(1, 9);
        BufferedValueModel workspacePathModel = this.presentationModel.getBufferedModel("workspacePath");
        final JTextField workspacePath = WizardComponentFactory.createTextField((ValueModel)workspacePathModel, (boolean)false);
        workspacePath.setPreferredSize(new Dimension(300, workspacePath.getPreferredSize().height));
        dialogBuilder.add((Component)workspacePath).xy(3, 9);
        JButton selectWorkspaceDirectoryButton = new JButton(Resources.getString(MiscSettingsPanel.class, (String)"select-workspace-directory"));
        selectWorkspaceDirectoryButton.setToolTipText(Resources.getString(MiscSettingsPanel.class, (String)"select-workspace-directory.tooltip"));
        selectWorkspaceDirectoryButton.addActionListener(evt -> {
            String workspaceDirectory = workspacePathModel.getString();
            FileFilter[] ff = null;
            FileDialog dialog = new FileDialog(this.contentPanel, 1, workspaceDirectory, null, ff){

                public void approve(String selectedFile) {
                    File file = new File(selectedFile);
                    if (file != null && file.isDirectory()) {
                        String workspaceLocation = file.getPath();
                        LOGGER.info("Set the workspace location: {}", (Object)workspaceLocation);
                        workspacePath.setText(workspaceLocation);
                    }
                }
            };
            dialog.setApproveButtonText(Resources.getString(MiscSettingsPanel.class, (String)"select-workspace-directory"));
            dialog.showDialog();
        });
        dialogBuilder.add((Component)selectWorkspaceDirectoryButton).xy(5, 9);
        BufferedValueModel loadWorkspaceAtStartupModel = this.presentationModel.getBufferedModel("loadWorkspaceAtStartup");
        JCheckBox loadWorkspaceAtStartup = WizardComponentFactory.createCheckBox((ValueModel)loadWorkspaceAtStartupModel, (String)Resources.getString(((Object)((Object)this)).getClass(), (String)"loadWorkspaceAtStartup"));
        loadWorkspaceAtStartup.setToolTipText(Resources.getString(((Object)((Object)this)).getClass(), (String)"loadWorkspaceAtStartup.tooltip"));
        dialogBuilder.add((Component)loadWorkspaceAtStartup).xyw(1, 11, 5);
        BufferedValueModel ignoreWaitTimeoutModel = this.presentationModel.getBufferedModel("ignoreWaitTimeout");
        JCheckBox ignoreWaitTimeout = WizardComponentFactory.createCheckBox((ValueModel)ignoreWaitTimeoutModel, (String)Resources.getString(((Object)((Object)this)).getClass(), (String)"ignoreWaitTimeout"));
        dialogBuilder.add((Component)ignoreWaitTimeout).xyw(1, 13, 5);
        BufferedValueModel ignoreWrongReceiveMessageNumberModel = this.presentationModel.getBufferedModel("ignoreWrongReceiveMessageNumber");
        JCheckBox ignoreWrongReceiveMessageNumber = WizardComponentFactory.createCheckBox((ValueModel)ignoreWrongReceiveMessageNumberModel, (String)Resources.getString(((Object)((Object)this)).getClass(), (String)"ignoreWrongReceiveMessageNumber"));
        dialogBuilder.add((Component)ignoreWrongReceiveMessageNumber).xyw(1, 15, 5);
        ConverterValueModel responseTimeoutConverterModel = new ConverterValueModel((ValueModel)this.presentationModel.getBufferedModel("responseTimeout"), (BindingConverter)new StringToIntegerConverter());
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"responseTimeout") + ":", new Object[0]).xy(1, 17);
        JTextField responseTimeout = new JTextField();
        responseTimeout.setDocument((Document)new InputValidationDocument(4, "0123456789"));
        Bindings.bind((JTextField)responseTimeout, (ValueModel)responseTimeoutConverterModel, (boolean)false);
        dialogBuilder.add((Component)responseTimeout).xy(3, 17);
        ConverterValueModel firmwarePacketTimeoutConverterModel = new ConverterValueModel((ValueModel)this.presentationModel.getBufferedModel("firmwarePacketTimeout"), (BindingConverter)new StringToIntegerConverter());
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"firmwarePacketTimeout") + ":", new Object[0]).xy(1, 19);
        JTextField firmwarePacketTimeout = new JTextField();
        firmwarePacketTimeout.setDocument((Document)new InputValidationDocument(4, "0123456789"));
        Bindings.bind((JTextField)firmwarePacketTimeout, (ValueModel)firmwarePacketTimeoutConverterModel, (boolean)false);
        dialogBuilder.add((Component)firmwarePacketTimeout).xy(3, 19);
        BufferedValueModel serialUseHardwareFlowControlModel = this.presentationModel.getBufferedModel("serialUseHardwareFlowControl");
        JCheckBox serialUseHardwareFlowControl = WizardComponentFactory.createCheckBox((ValueModel)serialUseHardwareFlowControlModel, (String)Resources.getString(((Object)((Object)this)).getClass(), (String)"serialUseHardwareFlowControl"));
        dialogBuilder.add((Component)serialUseHardwareFlowControl).xyw(1, 21, 5);
        BufferedValueModel selectionHolderSerialProvider = this.presentationModel.getBufferedModel("selectedSerialPortProvider");
        SelectionInList serialProviderSelection = new SelectionInList(this.model.getSerialProviderList());
        ComboBoxAdapter comboBoxAdapterSerialProvider = new ComboBoxAdapter((ListModel)serialProviderSelection, (ValueModel)selectionHolderSerialProvider);
        JComboBox comboSerialProvider = new JComboBox();
        comboSerialProvider.setModel(comboBoxAdapterSerialProvider);
        dialogBuilder.add(Resources.getString(MiscSettingsPanel.class, (String)"serialPortProvider") + ":", new Object[0]).xy(1, 23);
        dialogBuilder.add(comboSerialProvider).xy(3, 23);
        ConverterValueModel fetchNodesWorkerThreadPoolSizeConverterModel = new ConverterValueModel((ValueModel)this.presentationModel.getBufferedModel("fetchNodesWorkerThreadPoolSize"), (BindingConverter)new StringToIntegerConverter());
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"fetchNodesWorkerThreadPoolSize") + ":", new Object[0]).xy(1, 25);
        JTextField fetchNodesWorkerThreadPoolSize = new JTextField();
        InputValidationDocument numericDocument = new InputValidationDocument(4, "0123456789");
        numericDocument.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(1, 20));
        fetchNodesWorkerThreadPoolSize.setDocument((Document)numericDocument);
        Bindings.bind((JTextField)fetchNodesWorkerThreadPoolSize, (ValueModel)fetchNodesWorkerThreadPoolSizeConverterModel, (boolean)false);
        dialogBuilder.add((Component)fetchNodesWorkerThreadPoolSize).xy(3, 25);
        ConverterValueModel pingIntervalConverterModel = new ConverterValueModel((ValueModel)this.presentationModel.getBufferedModel("pingInterval"), (BindingConverter)new StringToIntegerConverter());
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"pingInterval") + ":", new Object[0]).xy(1, 27);
        JTextField pingInterval = new JTextField();
        pingInterval.setDocument((Document)new InputValidationDocument(5, "0123456789"));
        Bindings.bind((JTextField)pingInterval, (ValueModel)pingIntervalConverterModel, (boolean)false);
        dialogBuilder.add((Component)pingInterval).xy(3, 27);
        this.contentPanel = dialogBuilder.build();
        this.contentPanel.setOpaque(false);
        return this.contentPanel;
    }
}

