/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.view.panel;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TablePopupMenuInstaller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.client.common.text.WizardBindings;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.mvc.common.view.converter.StringToLocalDateTimeConverter;
import org.bidib.wizard.mvc.common.view.converter.StringToProtocolVersionConverter;
import org.bidib.wizard.mvc.preferences.model.PairingStoreEntryModel;
import org.bidib.wizard.mvc.preferences.model.PairingStoreModel;
import org.bidib.wizard.mvc.preferences.view.panel.PairingStoreTableMenu;
import org.bidib.wizard.mvc.preferences.view.panel.PairingStoreTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PairingStoreSettingsPanel
extends AbstractSettingsPanel<PairingStoreModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PairingStoreSettingsPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow, 3dlu, pref";
    private static final String ENCODED_DIALOG_ROW_SPECS = "fill:100dlu:grow, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private final PairingStoreModel pairingStoreModel;
    private JPanel contentPanel;
    private SelectionInList<PairingStoreEntryModel> pairingSelection;
    private PresentationModel<PairingStoreEntryModel> detailsModel;
    private BufferedValueModel bufferedPairingsModel;
    private SortableTable pairingStoreTable;

    public PairingStoreSettingsPanel(PairingStoreModel pairingStoreModel, Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);
        this.pairingStoreModel = pairingStoreModel;
    }

    public JPanel createPanel() {
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.preparePresentationModel((Object)this.pairingStoreModel);
        this.bufferedPairingsModel = this.presentationModel.getBufferedModel("pairings");
        this.pairingSelection = new SelectionInList((ValueModel)this.bufferedPairingsModel);
        this.pairingStoreTable = new SortableTable((TableModel)((Object)new PairingStoreTableModel(this.pairingSelection, Resources.getString(((Object)((Object)this)).getClass(), (String)"uid"), Resources.getString(((Object)((Object)this)).getClass(), (String)"requestorName"), Resources.getString(((Object)((Object)this)).getClass(), (String)"productName"), Resources.getString(((Object)((Object)this)).getClass(), (String)"userName"), Resources.getString(((Object)((Object)this)).getClass(), (String)"protocolVersion"), Resources.getString(((Object)((Object)this)).getClass(), (String)"paired"), Resources.getString(((Object)((Object)this)).getClass(), (String)"lastSeen"))));
        this.detailsModel = new PresentationModel(this.pairingSelection);
        WizardBindings.bind((SortableTable)this.pairingStoreTable, this.pairingSelection);
        dialogBuilder.add((Component)new JScrollPane((Component)this.pairingStoreTable)).xyw(1, 1, 5);
        final PairingStoreTableMenu pairingStoreTableMenu = new PairingStoreTableMenu(this);
        TablePopupMenuInstaller installer = new TablePopupMenuInstaller((JTable)this.pairingStoreTable){

            protected JPopupMenu createPopupMenu() {
                return pairingStoreTableMenu;
            }

            protected void customizeMenuItems(JTable table, JPopupMenu popup, int clickingRow, int clickingColumn) {
                LOGGER.info("Customize the popup menu: {}", (Object)popup);
                if (clickingRow > -1 && table.getSelectedRow() != clickingRow) {
                    table.setRowSelectionInterval(clickingRow, clickingRow);
                }
                super.customizeMenuItems(table, popup, clickingRow, clickingColumn);
            }
        };
        BufferedValueModel bufferedUidModel = this.detailsModel.getBufferedModel("uid");
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"uid") + ":", new Object[0]).xy(1, 3);
        JTextField uid = WizardComponentFactory.createTextField((ValueModel)bufferedUidModel, (boolean)false);
        uid.setEditable(false);
        dialogBuilder.add((Component)uid).xyw(3, 3, 3);
        BufferedValueModel bufferedRequestorNameModel = this.detailsModel.getBufferedModel("requestorName");
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"requestorName") + ":", new Object[0]).xy(1, 5);
        JTextField requestorName = WizardComponentFactory.createTextField((ValueModel)bufferedRequestorNameModel, (boolean)false);
        requestorName.setEditable(false);
        dialogBuilder.add((Component)requestorName).xyw(3, 5, 3);
        BufferedValueModel bufferedProductNameModel = this.detailsModel.getBufferedModel("productName");
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"productName") + ":", new Object[0]).xy(1, 7);
        JTextField productName = WizardComponentFactory.createTextField((ValueModel)bufferedProductNameModel, (boolean)false);
        productName.setEditable(false);
        dialogBuilder.add((Component)productName).xyw(3, 7, 3);
        BufferedValueModel bufferedUserNameModel = this.detailsModel.getBufferedModel("userName");
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"userName") + ":", new Object[0]).xy(1, 9);
        JTextField userName = WizardComponentFactory.createTextField((ValueModel)bufferedUserNameModel, (boolean)false);
        userName.setEditable(false);
        dialogBuilder.add((Component)userName).xyw(3, 9, 3);
        ConverterValueModel protocolVersionModel = new ConverterValueModel((ValueModel)this.detailsModel.getBufferedModel("protocolVersion"), (BindingConverter)new StringToProtocolVersionConverter());
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"protocolVersion") + ":", new Object[0]).xy(1, 11);
        JTextField protocolVersion = WizardComponentFactory.createTextField((ValueModel)protocolVersionModel, (boolean)false);
        protocolVersion.setEditable(false);
        dialogBuilder.add((Component)protocolVersion).xyw(3, 11, 3);
        BufferedValueModel bufferedPairedModel = this.detailsModel.getBufferedModel("paired");
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"paired") + ":", new Object[0]).xy(1, 13);
        JCheckBox paired = WizardComponentFactory.createCheckBox((ValueModel)bufferedPairedModel, null);
        paired.setEnabled(false);
        dialogBuilder.add((Component)paired).xyw(3, 13, 3);
        ConverterValueModel lastSeenModel = new ConverterValueModel((ValueModel)this.detailsModel.getBufferedModel("lastSeen"), (BindingConverter)new StringToLocalDateTimeConverter());
        dialogBuilder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"lastSeen") + ":", new Object[0]).xy(1, 15);
        JTextField lsatSeen = WizardComponentFactory.createTextField((ValueModel)lastSeenModel, (boolean)false);
        lsatSeen.setEditable(false);
        dialogBuilder.add((Component)lsatSeen).xyw(3, 15, 3);
        this.contentPanel = dialogBuilder.build();
        this.contentPanel.setOpaque(false);
        return this.contentPanel;
    }

    public void removeSelectedEntry() {
        PairingStoreEntryModel selected = (PairingStoreEntryModel)((Object)this.pairingSelection.getSelection());
        if (selected != null) {
            LOGGER.info("Remove selected model from pairing store: {}", (Object)selected);
            List pairingList = (List)this.bufferedPairingsModel.getValue();
            LOGGER.info("Fetched buffered value: {}", (Object)pairingList);
            pairingList.remove((Object)selected);
            this.bufferedPairingsModel.setValue((Object)pairingList);
            this.pairingSelection.clearSelection();
            int size = this.pairingSelection.getSize();
            this.pairingSelection.fireContentsChanged(0, size > 0 ? size - 1 : 0);
        }
    }
}

