/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pt.view;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.service.SettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtConfirmDialog
extends EscapeDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PtConfirmDialog.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 10dlu, min(300dlu;pref)";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 10dlu, top:35dlu, 5dlu, pref, 5dlu, pref";
    private int result = 2;
    private ValueModel checkDoNotAskInFutureValueModel;
    private final SettingsService settingsService;

    public PtConfirmDialog(final NodeInterface node, SettingsService settingsService, Point itemPosition) {
        super(null, Resources.getString(PtConfirmDialog.class, (String)"title"), true);
        this.settingsService = settingsService;
        this.getContentPane().setLayout(new BorderLayout());
        FormBuilder builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel(new JPanel());
        builder.border((Border)Paddings.DIALOG);
        JLabel iconLabel = new JLabel(UIManager.getIcon("OptionPane.warningIcon"));
        int row = 1;
        builder.add((Component)iconLabel).xywh(1, row, 1, 2);
        JLabel messageLabel = new JLabel(Resources.getString(((Object)((Object)this)).getClass(), (String)"message-warn"));
        Font font = messageLabel.getFont();
        font = font.deriveFont(16.0f);
        messageLabel.setFont(font);
        messageLabel.setForeground(Color.RED);
        builder.add((Component)messageLabel).xy(3, row);
        JLabel messageInfoLabel = new JLabel(Resources.getString(((Object)((Object)this)).getClass(), (String)"message"));
        builder.add((Component)messageInfoLabel).xy(3, row += 2);
        row += 2;
        this.checkDoNotAskInFutureValueModel = new ValueHolder(settingsService.getWizardSettings().isPtModeDoNotConfirmSwitch());
        if (!((Boolean)this.checkDoNotAskInFutureValueModel.getValue()).booleanValue()) {
            JCheckBox checkDoNotAskInFuture = WizardComponentFactory.createCheckBox((ValueModel)this.checkDoNotAskInFutureValueModel, (String)Resources.getString(((Object)((Object)this)).getClass(), (String)"do-not-ask"));
            builder.add((Component)checkDoNotAskInFuture).xy(3, row);
            row += 2;
        } else {
            this.checkDoNotAskInFutureValueModel = null;
        }
        JButton continueButton = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"continue"));
        continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PtConfirmDialog.this.setVisible(false);
                PtConfirmDialog.this.fireContinue(node);
            }
        });
        JButton cancel = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PtConfirmDialog.this.setVisible(false);
                PtConfirmDialog.this.fireCancel();
            }
        });
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{continueButton, cancel}).build();
        builder.add((Component)buttons).xy(3, row);
        this.getContentPane().add(builder.build());
        this.pack();
        this.setLocation(itemPosition);
        this.setMinimumSize(this.getSize());
        this.setVisible(true);
    }

    private void fireContinue(NodeInterface node) {
        LOGGER.info("Continue operation");
        this.result = 0;
        if (this.checkDoNotAskInFutureValueModel != null && ((Boolean)this.checkDoNotAskInFutureValueModel.getValue()).booleanValue()) {
            LOGGER.info("Do not show confirm dialog in the future.");
            this.settingsService.getWizardSettings().setPtModeDoNotConfirmSwitch(true);
            this.settingsService.storeSettings();
        }
    }

    private void fireCancel() {
    }

    public int getResult() {
        return this.result;
    }
}

