/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.controller;

import com.jgoodies.common.collect.ArrayListModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.logger.LoggerWrapper;
import org.bidib.jbidibc.messages.AccessoryState;
import org.bidib.jbidibc.messages.AccessoryStateOptions;
import org.bidib.jbidibc.messages.accessory.ByteOptionsValue;
import org.bidib.jbidibc.messages.accessory.OptionsValue;
import org.bidib.jbidibc.messages.enums.AccessoryExecutionState;
import org.bidib.jbidibc.messages.enums.AccessoryStateOptionsKeys;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.AccessoryListListener;
import org.bidib.wizard.api.model.listener.AccessoryListener;
import org.bidib.wizard.api.model.listener.CvDefinitionListener;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.DefaultBusyFrame;
import org.bidib.wizard.client.common.view.listener.TabStatusListener;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.model.stepcontrol.TurnTableType;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.stepcontrol.controller.CvConsoleController;
import org.bidib.wizard.mvc.stepcontrol.controller.StepControlControllerInterface;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlModel;
import org.bidib.wizard.mvc.stepcontrol.view.InvalidAspectException;
import org.bidib.wizard.mvc.stepcontrol.view.StepControlPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StepControlController
implements CvDefinitionListener,
StepControlControllerInterface,
PortListListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepControlController.class);
    private StepControlPanel stepControlPanel;
    private final StepControlModel stepControlModel;
    private final MainModel mainModel;
    private final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider;
    private final AccessoryListener accessoryListener;
    private final AccessoryListListener accessoryListListener;
    private NodeInterface controlledNode;
    private Accessory controlledAccessory;
    private Accessory operationalAccessory;
    private Accessory soundAccessory;
    private final ScheduledExecutorService accessoryStateWorkers = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("accessoryStateWorkers-thread-%d").build());
    @Autowired
    private SwitchingNodeService switchingService;
    @Autowired
    private SettingsService settingsService;
    private final StatusBar statusBar;
    private final Supplier<String> connectionId;
    private final org.bidib.jbidibc.messages.logger.Logger accessoryStateOptionsLogger;
    private ScheduledFuture<?> taskFuture;

    public StepControlController(final MainModel mainModel, FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider, StatusBar statusBar, final Supplier<String> connectionId) {
        this.mainModel = mainModel;
        this.feedbackPortStatusChangeProvider = feedbackPortStatusChangeProvider;
        this.statusBar = statusBar;
        this.connectionId = connectionId;
        this.stepControlModel = new StepControlModel();
        this.stepControlModel.setMaxConfiguredAspects(48);
        this.accessoryStateOptionsLogger = new LoggerWrapper(LOGGER);
        this.accessoryListener = new AccessoryListener(){

            public void macrosChanged() {
            }

            public void labelChanged(String label) {
            }

            public void accessoryStateChanged(Integer accessoryId, Integer aspect) {
                LOGGER.info("The accessory state has changed, accessory: {}, aspect: {}", (Object)accessoryId, (Object)aspect);
                if (accessoryId == null) {
                    LOGGER.info("No accessoryId delivered, skip processing.");
                    return;
                }
                if (accessoryId == 0) {
                    AtomicBoolean emergencyStop = new AtomicBoolean();
                    if (aspect != null) {
                        if (aspect == 254) {
                            LOGGER.warn("Emergency stop was signalled!");
                            emergencyStop.set(true);
                            if (StepControlController.this.stepControlModel != null) {
                                SwingUtils.executeInEDT(() -> StepControlController.this.stepControlModel.setOperationalMode(StepControlModel.OperationModeEnum.emergencyStop));
                            }
                            StepControlController.this.cancelScheduleAccessoryStateCheck();
                        } else if (aspect == 255) {
                            LOGGER.warn("Illegal aspect was signalled!");
                        }
                    }
                    if (StepControlController.this.controlledAccessory != null) {
                        SwingUtils.executeInEDT(() -> StepControlController.this.updateAnimation(accessoryId, aspect, emergencyStop.get()));
                    }
                } else if (accessoryId == 1) {
                    LOGGER.info("Received accessory id 1: operational accessory, aspect: {}", (Object)aspect);
                    SwingUtils.executeInEDT(() -> StepControlController.this.processOperationalAccessory(aspect));
                } else if (accessoryId == 2) {
                    LOGGER.info("Received sound accessory change, current aspect: {}", (Object)aspect);
                    if (aspect != null) {
                        boolean soundInActive = aspect == 0;
                        SwingUtils.executeInEDT(() -> StepControlController.this.stepControlModel.setSoundActive(soundInActive));
                    } else {
                        SwingUtils.executeInEDT(() -> StepControlController.this.stepControlModel.setSoundActive(true));
                    }
                } else {
                    LOGGER.info("Received accessory id > 0");
                }
            }
        };
        this.accessoryListListener = new AccessoryListListener(){

            public void pendingChangesChanged() {
            }

            public void listChanged() {
                LOGGER.info("The accessory list has changed.");
                SwingUtils.executeInEDT(() -> this.internalListChanged());
            }

            private void internalListChanged() {
                if (StepControlController.this.controlledAccessory != null) {
                    StepControlController.this.controlledAccessory.removeAccessoryListener(StepControlController.this.accessoryListener);
                    StepControlController.this.controlledAccessory = null;
                }
                if (StepControlController.this.operationalAccessory != null) {
                    StepControlController.this.operationalAccessory.removeAccessoryListener(StepControlController.this.accessoryListener);
                    StepControlController.this.operationalAccessory = null;
                }
                if (StepControlController.this.soundAccessory != null) {
                    StepControlController.this.soundAccessory.removeAccessoryListener(StepControlController.this.accessoryListener);
                    StepControlController.this.soundAccessory = null;
                }
                LOGGER.info("Reset the operational mode. Old value: {}", (Object)StepControlController.this.stepControlModel.getOperationalMode());
                StepControlController.this.stepControlModel.setOperationalMode(StepControlModel.OperationModeEnum.unknown);
                StepControlController.this.stepControlModel.setSelectedAspect(null);
                StepControlController.this.stepControlModel.setSoundActive(true);
                if (StepControlController.this.controlledNode != null) {
                    LOGGER.info("The currently controlled node is a StepControl.");
                    CvConsoleController.ensureConsoleVisible();
                    if (CollectionUtils.isNotEmpty((Collection)StepControlController.this.controlledNode.getAccessories())) {
                        Integer operationModeAccessoryNumber;
                        Accessory accessory = (Accessory)StepControlController.this.controlledNode.getAccessories().get(0);
                        LOGGER.info("Add listener to controlled accessory: {}", (Object)accessory);
                        ArrayList<Accessory> accessoryToQueryState = new ArrayList<Accessory>();
                        StepControlController.this.controlledAccessory = accessory;
                        StepControlController.this.controlledAccessory.addAccessoryListener(StepControlController.this.accessoryListener);
                        StepControlController.this.operationalAccessory = mainModel.getAccessories().get(1);
                        StepControlController.this.operationalAccessory.addAccessoryListener(StepControlController.this.accessoryListener);
                        accessoryToQueryState.add(StepControlController.this.operationalAccessory);
                        StepControlController.this.soundAccessory = mainModel.getAccessories().get(2);
                        if (StepControlController.this.soundAccessory != null) {
                            StepControlController.this.soundAccessory.addAccessoryListener(StepControlController.this.accessoryListener);
                            accessoryToQueryState.add(StepControlController.this.soundAccessory);
                        }
                        if ((operationModeAccessoryNumber = accessory.getOperationModeAccessoryNumber()) != null) {
                            LOGGER.info("The accessory has an operationModeAccessoryNumber: {}. Read only the operational accessory.", (Object)operationModeAccessoryNumber);
                            StepControlController.this.switchingService.queryAccessoryState((String)connectionId.get(), StepControlController.this.controlledNode.getSwitchingNode(), accessoryToQueryState);
                        } else {
                            LOGGER.info("Query the accessory state of the operational and execution accessory.");
                            accessoryToQueryState.add(StepControlController.this.controlledAccessory);
                            StepControlController.this.switchingService.queryAccessoryState((String)connectionId.get(), StepControlController.this.controlledNode.getSwitchingNode(), accessoryToQueryState);
                        }
                    }
                }
            }

            public void accessoryChanged(Integer accessoryId) {
            }
        };
    }

    public void start(TabStatusListener tabStatusListener) {
        LOGGER.info("Use changeProvider: {}", (Object)this.feedbackPortStatusChangeProvider);
        this.stepControlPanel = new StepControlPanel(this.mainModel, this.stepControlModel, this.settingsService, tabStatusListener, this.feedbackPortStatusChangeProvider, this, this.statusBar);
        this.stepControlPanel.createComponent();
        final PortListListener motorPortListListener = new PortListListener(){

            public void listChanged() {
                if (StepControlController.this.controlledNode != null) {
                    ArrayList motorPorts = new ArrayList();
                    motorPorts.addAll(StepControlController.this.controlledNode.getMotorPorts());
                    if (CollectionUtils.isNotEmpty(motorPorts)) {
                        MotorPort motorPort = (MotorPort)motorPorts.get(0);
                        LOGGER.info("Fetched first motor port: {}", (Object)motorPort);
                        StepControlController.this.stepControlModel.setMotorPort(motorPort);
                    } else {
                        StepControlController.this.stepControlModel.setMotorPort(null);
                    }
                } else {
                    StepControlController.this.stepControlModel.setMotorPort(null);
                }
            }

            public void refreshPorts() {
                LOGGER.info("Refresh ports.");
                this.listChanged();
            }

            public Class<?> getPortClass() {
                return MotorPort.class;
            }
        };
        final PortListListener soundPortListListener = new PortListListener(){

            public void listChanged() {
                LOGGER.info("The list of sound port has changed.");
                ArrayList<SoundPort> soundPorts = new ArrayList<SoundPort>();
                if (StepControlController.this.controlledNode != null) {
                    soundPorts.addAll(StepControlController.this.controlledNode.getSoundPorts());
                    LOGGER.info("Fetched sound ports: {}", soundPorts);
                }
                StepControlController.this.stepControlModel.setSoundPorts(soundPorts);
            }

            public void refreshPorts() {
                LOGGER.info("Refresh ports.");
                this.listChanged();
            }

            public Class<?> getPortClass() {
                return SoundPort.class;
            }
        };
        this.mainModel.addNodeListListener((NodeListListener)new DefaultNodeListListener(){

            public void nodeChanged(NodeInterface node) {
                NodeInterface selectedNode = StepControlController.this.mainModel.getSelectedNode();
                if (selectedNode != null && selectedNode.equals((Object)StepControlController.this.controlledNode)) {
                    LOGGER.warn("The selected node is the controlled node. Skip update of node data.");
                    return;
                }
                LOGGER.info("The selected node has changed, current controlledAccessory: {}, selectedNode: {}", (Object)StepControlController.this.controlledAccessory, (Object)selectedNode);
                if (StepControlController.this.controlledAccessory != null) {
                    StepControlController.this.controlledAccessory.removeAccessoryListener(StepControlController.this.accessoryListener);
                    StepControlController.this.controlledAccessory = null;
                }
                if (StepControlController.this.controlledNode != null) {
                    StepControlController.this.controlledNode.removeAccessoryListListener(StepControlController.this.accessoryListListener);
                    StepControlController.this.controlledNode.removeCvDefinitionListener((CvDefinitionListener)StepControlController.this);
                    LOGGER.info("Remove the StepControlController as portListListener for MotorPorts.");
                    StepControlController.this.controlledNode.removePortListListener(MotorPort.class, motorPortListListener);
                    StepControlController.this.stepControlModel.setMotorPort(null);
                    LOGGER.info("Remove the StepControlController as portListListener for SoundPorts.");
                    StepControlController.this.controlledNode.removePortListListener(SoundPort.class, soundPortListListener);
                    StepControlController.this.stepControlModel.setSoundPorts(null);
                    StepControlController.this.controlledNode = null;
                }
                if (selectedNode != null && ProductUtils.isStepControl((long)selectedNode.getUniqueId())) {
                    LOGGER.info("The currently selected node is a StepControl.");
                    StepControlController.this.controlledNode = selectedNode;
                    StepControlController.this.controlledNode.addCvDefinitionListener((CvDefinitionListener)StepControlController.this);
                    StepControlController.this.controlledNode.addAccessoryListListener(StepControlController.this.accessoryListListener);
                    StepControlController.this.accessoryListListener.listChanged();
                    if (CollectionUtils.isNotEmpty((Collection)StepControlController.this.controlledNode.getAccessories())) {
                        Accessory accessory;
                        StepControlController.this.controlledAccessory = accessory = (Accessory)StepControlController.this.controlledNode.getAccessories().get(0);
                        accessory.addAccessoryListener(StepControlController.this.accessoryListener);
                    } else {
                        LOGGER.info("No accessories on controlled node found.");
                    }
                    LOGGER.info("Add the StepControlController as portListListener for MotorPorts.");
                    StepControlController.this.controlledNode.addPortListListener(MotorPort.class, motorPortListListener);
                    if (CollectionUtils.isNotEmpty((Collection)StepControlController.this.controlledNode.getMotorPorts())) {
                        StepControlController.this.stepControlModel.setMotorPort((MotorPort)StepControlController.this.controlledNode.getMotorPorts().get(0));
                    }
                    LOGGER.info("Add the StepControlController as portListListener for SoundPorts.");
                    StepControlController.this.controlledNode.addPortListListener(SoundPort.class, soundPortListListener);
                    StepControlController.this.stepControlModel.setSoundPorts(StepControlController.this.controlledNode.getSoundPorts());
                }
            }
        });
    }

    public StepControlPanel getComponent() {
        return this.stepControlPanel;
    }

    @Override
    public void triggerLoadCvValues() {
        LOGGER.info("Load the CV for the StepControl.");
        if (this.stepControlPanel != null) {
            LOGGER.info("Let the stepControlPanel initiate loading the CV values: {}", (Object)this.stepControlPanel);
            this.stepControlPanel.triggerLoadCvValues();
        }
    }

    public void cvDefinitionValuesChanged(boolean read, List<String> changedNames) {
        LOGGER.info("The CV definition values have changed, read: {}, changedNames: {}", (Object)read, changedNames);
        if (this.stepControlPanel != null) {
            LOGGER.info("Notify the stepControl panel of the changed CV defintion values: {}", (Object)this.stepControlPanel);
            SwingUtils.executeInEDT(() -> this.stepControlPanel.cvDefinitionValuesChanged(read, changedNames));
        }
    }

    @Override
    public ArrayListModel<StepControlAspect> getConfigureAspectsListModel() {
        LOGGER.info("Prepare the configured aspects list model. Current turnTableType: {}", (Object)this.stepControlModel.getTurnTableType());
        ArrayList<StepControlAspect> aspects = new ArrayList<StepControlAspect>();
        aspects.addAll(this.stepControlModel.getStepControlAspects());
        if (TurnTableType.round == this.stepControlModel.getTurnTableType()) {
            int totalSteps = this.stepControlModel.getTotalSteps() != null ? this.stepControlModel.getTotalSteps().intValue() : 0;
            LOGGER.info("Current totalSteps: {}, number of stepControlAspects: {}", (Object)totalSteps, (Object)aspects.size());
            int currentAspectIndex = 0;
            for (StepControlAspect currentAspect : this.stepControlModel.getStepControlAspects()) {
                LOGGER.info("Prepare aspect opposite to save from aspect: {}", (Object)currentAspect);
                if (currentAspect.getOppositeAspect() != null) {
                    aspectOpposite = (StepControlAspect)currentAspect.getOppositeAspect();
                    aspectOpposite.setPosition(currentAspect.getOppositePosition());
                    aspectOpposite.setPolarity(currentAspect.getOppositePolarity());
                    if (!aspectOpposite.isValid()) {
                        LOGGER.warn("The opposite aspect is not valid: {}", (Object)aspectOpposite);
                        throw new InvalidAspectException("The opposite aspect is not valid: " + String.valueOf(aspectOpposite), currentAspectIndex);
                    }
                    LOGGER.info("Prepared the aspect opposite to save: {}", (Object)aspectOpposite);
                    aspects.add(aspectOpposite);
                    if (currentAspect.getPosition() >= (long)(totalSteps / 2)) {
                        throw new InvalidAspectException("The aspect is not valid: " + String.valueOf(currentAspect), currentAspectIndex);
                    }
                    if (aspectOpposite.getPosition() >= (long)totalSteps) {
                        throw new InvalidAspectException("The aspect is not valid: " + String.valueOf(aspectOpposite), currentAspectIndex);
                    }
                } else {
                    LOGGER.warn("The opposite aspect is not available for aspect: {}", (Object)currentAspect);
                    aspectOpposite = new StepControlAspect(null, currentAspect.getOppositePosition(), currentAspect.getOppositePolarity());
                    if (!aspectOpposite.isValid()) {
                        LOGGER.warn("The opposite aspect is not valid: {}", (Object)aspectOpposite);
                        throw new InvalidAspectException("The opposite aspect is not valid: " + String.valueOf(aspectOpposite), currentAspectIndex);
                    }
                    currentAspect.setOppositeAspect(aspectOpposite);
                    LOGGER.info("Prepared the aspect opposite to save: {}", (Object)aspectOpposite);
                    aspects.add(aspectOpposite);
                    if (currentAspect.getPosition() >= (long)(totalSteps / 2)) {
                        throw new InvalidAspectException("The aspect is not valid: " + String.valueOf(currentAspect), currentAspectIndex);
                    }
                    if (aspectOpposite.getPosition() >= (long)totalSteps) {
                        throw new InvalidAspectException("The aspect is not valid: " + String.valueOf(aspectOpposite), currentAspectIndex);
                    }
                }
                ++currentAspectIndex;
            }
        } else if (TurnTableType.pendular == this.stepControlModel.getTurnTableType()) {
            LOGGER.info("The turnTableType is pendular. Make sure that we have only 2 aspects.");
            if (this.stepControlModel.getStepControlAspects().size() > 2) {
                aspects.addAll(this.stepControlModel.getStepControlAspects().subList(0, 2));
            }
            for (StepControlAspect aspect : aspects) {
                aspect.setOppositeAspect(null);
                aspect.setOppositePosition(null);
                aspect.setOppositePolarity(null);
            }
            LOGGER.info("The turnTableType is pendular. Prepared aspects: {}", aspects);
        }
        Collections.sort(aspects, new Comparator<StepControlAspect>(){

            @Override
            public int compare(StepControlAspect o1, StepControlAspect o2) {
                return Long.compare(o1.getPosition(), o2.getPosition());
            }
        });
        ArrayListModel arrayListModel = new ArrayListModel();
        arrayListModel.addAll(aspects);
        return arrayListModel;
    }

    public NodeInterface getSelectedNode() {
        return this.mainModel.getSelectedNode();
    }

    public void scheduleAccessoryStateCheck() {
        Integer pushInterval = this.stepControlModel.getPushInterval();
        if (pushInterval != null && pushInterval > 0) {
            LOGGER.info("The updates of the accessory state are delivered via push notification.");
            return;
        }
        this.taskFuture = this.accessoryStateWorkers.schedule(() -> {
            try {
                LOGGER.info("Check the state of the controlledAccessory: {}", (Object)this.controlledAccessory);
                this.taskFuture = null;
                if (this.controlledNode != null) {
                    this.switchingService.queryAccessoryState(this.connectionId.get(), this.controlledNode.getSwitchingNode(), Arrays.asList(this.controlledAccessory));
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Check the state of the controlledAccessory failed for bidibNode: {}", (Object)this.controlledNode, (Object)ex);
            }
        }, 250L, TimeUnit.MILLISECONDS);
    }

    private void cancelScheduleAccessoryStateCheck() {
        LOGGER.info("Cancel the accessory state check.");
        try {
            if (this.taskFuture != null) {
                this.taskFuture.cancel(true);
                this.taskFuture = null;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Stop scheduled task failed.", (Throwable)ex);
        }
    }

    @Override
    public void setMotorPortValue(MotorPort motorPort) {
        LOGGER.info("Set the motor port value: {}", (Object)motorPort);
        this.switchingService.setPortStatus(this.connectionId.get(), this.controlledNode.getSwitchingNode(), (Port)motorPort);
    }

    public Class<?> getPortClass() {
        return MotorPort.class;
    }

    @Override
    public void triggerSoundPort(int portId, SoundPortStatus soundPortStatus) {
        LOGGER.info("Activate the sound port value: {}, soundPortStatus: {}", (Object)portId, (Object)soundPortStatus);
        SoundPort soundPort = new SoundPort();
        soundPort.setId(portId);
        soundPort.setStatus((BidibStatus)soundPortStatus);
        this.switchingService.setPortStatus(this.connectionId.get(), this.controlledNode.getSwitchingNode(), (Port)soundPort);
    }

    public void listChanged() {
    }

    public void refreshPorts() {
    }

    @Override
    public void setSoundActive(boolean soundActive) {
        LOGGER.info("Activate the sound accessory, soundActive: {}", (Object)soundActive);
        if (this.controlledNode != null) {
            try {
                DefaultBusyFrame.setWaitCursor((Component)this.stepControlPanel.getComponent());
                Accessory accessory = new Accessory();
                accessory.setId(Integer.valueOf(2));
                this.switchingService.setAccessoryAspect(this.connectionId.get(), this.controlledNode.getSwitchingNode(), accessory, soundActive ? 2 : 0);
            }
            finally {
                DefaultBusyFrame.setDefaultCursor((Component)this.stepControlPanel.getComponent());
            }
        } else {
            LOGGER.warn("Activate the sound accessory is skipped. The controlled node is not avaialable.");
        }
    }

    @Override
    public void activateAspect(Accessory accessory, int aspectNumber) {
        LOGGER.info("Start accessory with aspect: {}, accessory: {}", (Object)aspectNumber, (Object)accessory);
        try {
            DefaultBusyFrame.setWaitCursor((Component)this.stepControlPanel.getComponent());
            this.switchingService.setAccessoryAspect(this.connectionId.get(), this.getSelectedNode().getSwitchingNode(), accessory, aspectNumber);
        }
        finally {
            DefaultBusyFrame.setDefaultCursor((Component)this.stepControlPanel.getComponent());
        }
    }

    @Override
    public void storeAccessory(Accessory accessory) {
        LOGGER.info("Store the accessory: {}", (Object)accessory);
        try {
            DefaultBusyFrame.setWaitCursor((Component)this.stepControlPanel.getComponent());
            this.switchingService.saveAccessory(this.connectionId.get(), this.getSelectedNode().getSwitchingNode(), accessory);
        }
        finally {
            DefaultBusyFrame.setDefaultCursor((Component)this.stepControlPanel.getComponent());
        }
    }

    private void updateAnimation(Integer accessoryId, Integer aspect, boolean emergencyStop) {
        AccessoryStateOptions.Options stateOptions;
        if (this.controlledAccessory == null) {
            LOGGER.info("The controlledAccessory is null, skip update animation.");
            this.cancelScheduleAccessoryStateCheck();
            return;
        }
        AccessoryState state = this.controlledAccessory.getAccessoryState();
        AccessoryStateOptions options = this.controlledAccessory.getAccessoryStateOptions();
        AccessoryExecutionState executionState = this.controlledAccessory.getAccessoryExecutionState();
        LOGGER.info("Current accessory state: {},  options: {}, executionState: {}", new Object[]{state, options, executionState});
        this.stepControlPanel.executionStateChanged(executionState, accessoryId, aspect, state);
        if (options != null && (stateOptions = options.getOptions(this.accessoryStateOptionsLogger)) != null) {
            try {
                Integer currentAngle = null;
                OptionsValue optionsValue = (OptionsValue)stateOptions.getOptionsValue(AccessoryStateOptionsKeys.STATE_OPTION_CURRENT_ANGLE);
                if (optionsValue != null) {
                    currentAngle = ByteOptionsValue.getIntValue((OptionsValue)optionsValue);
                    double currentDegrees = 1.5 * (double)currentAngle.intValue();
                    LOGGER.info("Current angle: {}, degrees: {}", (Object)currentAngle, (Object)currentDegrees);
                    if (this.stepControlModel != null) {
                        this.stepControlModel.setTurntableCurrentDegrees(currentDegrees);
                    }
                    this.stepControlPanel.setTurntableDegrees(currentDegrees);
                }
                if ((optionsValue = (OptionsValue)stateOptions.getOptionsValue(AccessoryStateOptionsKeys.STATE_OPTION_TARGET_ANGLE)) != null) {
                    int targetAngle = ByteOptionsValue.getIntValue((OptionsValue)optionsValue);
                    double targetDegrees = 1.5 * (double)targetAngle;
                    LOGGER.info("Target angle: {}, degrees: {}, currentAngle: {}, emergencyStop: {}", new Object[]{targetAngle, targetDegrees, currentAngle, emergencyStop});
                    if (this.stepControlModel != null) {
                        this.stepControlModel.setTurntableTargetDegrees(targetDegrees);
                    }
                    if (currentAngle != null && !emergencyStop && executionState == AccessoryExecutionState.RUNNING) {
                        if (targetAngle != currentAngle) {
                            LOGGER.info("targetAngle != currentAngle, start the scheduler.");
                            this.scheduleAccessoryStateCheck();
                        } else if (executionState == AccessoryExecutionState.RUNNING) {
                            LOGGER.info("executionState is running, start the scheduler.");
                            this.scheduleAccessoryStateCheck();
                        }
                    } else {
                        LOGGER.info("The execution state is no longer running! Current executionState: {}", (Object)executionState);
                        this.cancelScheduleAccessoryStateCheck();
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Get the current turntable angle failed.", (Throwable)ex);
            }
        }
    }

    private void processOperationalAccessory(Integer aspect) {
        block10: {
            block9: {
                if (aspect == null) break block9;
                switch (aspect) {
                    case 1: {
                        if (this.stepControlModel != null) {
                            StepControlModel.OperationModeEnum oldOpMode = this.stepControlModel.getOperationalMode();
                            LOGGER.info("Set the step control operational mode, oldOpMode: {}, newMode: {}", (Object)oldOpMode, (Object)StepControlModel.OperationModeEnum.operational);
                            this.stepControlModel.setOperationalMode(StepControlModel.OperationModeEnum.operational);
                            if (this.controlledNode != null && this.operationalAccessory != null && this.controlledAccessory != null && oldOpMode != StepControlModel.OperationModeEnum.operational) {
                                LOGGER.info("Query the controlled accessory state.");
                                this.switchingService.queryAccessoryState(this.connectionId.get(), this.controlledNode.getSwitchingNode(), Arrays.asList(this.controlledAccessory));
                                break;
                            }
                            LOGGER.info("Do not query the controlled accessory state.");
                            break;
                        }
                        break block10;
                    }
                    case 2: {
                        if (this.stepControlModel != null) {
                            LOGGER.info("Set the step control to homing mode.");
                            this.stepControlModel.setOperationalMode(StepControlModel.OperationModeEnum.homingInProgress);
                            break;
                        }
                        break block10;
                    }
                    default: {
                        if (this.stepControlModel != null) {
                            LOGGER.info("Set the step control to non-operational mode.");
                            this.stepControlModel.setOperationalMode(StepControlModel.OperationModeEnum.emergencyStop);
                            break;
                        }
                        break block10;
                    }
                }
                break block10;
            }
            if (this.stepControlModel != null) {
                LOGGER.info("Set the step control to non-operational mode.");
                this.stepControlModel.setOperationalMode(StepControlModel.OperationModeEnum.emergencyStop);
            }
        }
    }
}

