/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.model;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;

public enum MotorSizeType implements BidibEnum
{
    nema8("nema8", 8, 200, 50),
    nema11("nema11", 11, 500, 100),
    nema13("nema13", 13, 500, 100),
    nema17("nema17", 17, 800, 200),
    nema23("nema23", 23, 1200, 300);

    private final byte type;
    private final String key;
    private final int currentMoving;
    private final int currentStopped;

    private MotorSizeType(String key, int type, int currentMoving, int currentStopped) {
        this.key = key;
        this.type = ByteUtils.getLowByte((int)type);
        this.currentMoving = currentMoving;
        this.currentStopped = currentStopped;
    }

    public byte getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public int getCvValue() {
        return ByteUtils.getInt((byte)this.type);
    }

    public int getCurrentMoving() {
        return this.currentMoving;
    }

    public int getCurrentStopped() {
        return this.currentStopped;
    }

    public String toString() {
        return Resources.getString(((Object)((Object)this)).getClass(), (String)this.key);
    }

    public static MotorSizeType fromValue(byte type) {
        MotorSizeType result = null;
        for (MotorSizeType e : MotorSizeType.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a MotorSizeType enum");
        }
        return result;
    }
}

