/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.WindowUtils;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.model.stepcontrol.TurnTableType;
import org.bidib.wizard.mvc.common.view.wizard.CancelAction;
import org.bidib.wizard.mvc.common.view.wizard.FinishAction;
import org.bidib.wizard.mvc.common.view.wizard.JWizardComponents;
import org.bidib.wizard.mvc.common.view.wizard.JWizardPanel;
import org.bidib.wizard.mvc.stepcontrol.model.AccelarationScaleEnum;
import org.bidib.wizard.mvc.stepcontrol.model.ConfigurationWizardModel;
import org.bidib.wizard.mvc.stepcontrol.model.Gearing;
import org.bidib.wizard.mvc.stepcontrol.model.MicroStepsEnum;
import org.bidib.wizard.mvc.stepcontrol.model.MotorSizeType;
import org.bidib.wizard.mvc.stepcontrol.model.MovementScaleEnum;
import org.bidib.wizard.mvc.stepcontrol.view.StepControlCvUtils;
import org.bidib.wizard.mvc.stepcontrol.view.wizard.CustomLogoJWizardDialog;
import org.bidib.wizard.mvc.stepcontrol.view.wizard.StepMotorCharacteristicsPanel;
import org.bidib.wizard.mvc.stepcontrol.view.wizard.SummaryPanel;
import org.bidib.wizard.mvc.stepcontrol.view.wizard.TableTypePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationWizard {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationWizard.class);
    private final ConfigurationWizardModel configurationWizardModel;

    public ConfigurationWizard(ConfigurationWizardModel configurationWizardModel) {
        this.configurationWizardModel = configurationWizardModel;
    }

    public void showWizard(Component parent) {
        Frame frame = JOptionPane.getFrameForComponent(parent);
        ImageIcon turntableLogo = ImageUtils.createImageIcon(this.getClass(), (String)"/icons/stepcontrol/turntable.png");
        ImageIcon transferTableLogo = ImageUtils.createImageIcon(this.getClass(), (String)"/icons/stepcontrol/transfertable.png");
        final CustomLogoJWizardDialog wizardDialog = new CustomLogoJWizardDialog(frame, new ImageIcon[]{transferTableLogo, turntableLogo}, true);
        wizardDialog.getWizardComponents().setFinishAction(new FinishAction(wizardDialog.getWizardComponents()){

            @Override
            public void performAction() {
                ConfigurationWizard.this.configurationWizardModel.setWizardStatus(ConfigurationWizardModel.WizardStatus.finished);
                wizardDialog.dispose();
            }
        });
        wizardDialog.getWizardComponents().setCancelAction(new CancelAction(wizardDialog.getWizardComponents()){

            @Override
            public void performAction() {
                ConfigurationWizard.this.configurationWizardModel.setWizardStatus(ConfigurationWizardModel.WizardStatus.aborted);
                wizardDialog.dispose();
            }
        });
        wizardDialog.getWizardComponents().getFinishButton().setText(Resources.getString(this.getClass(), (String)"L_FinishButton"));
        wizardDialog.getWizardComponents().getFinishButton().setMnemonic(Resources.getString(this.getClass(), (String)"L_FinishButtonMnem").charAt(0));
        SwingUtilities.updateComponentTreeUI(wizardDialog);
        wizardDialog.setTitle(Resources.getString(this.getClass(), (String)"title"));
        wizardDialog.getWizardComponents().addWizardPanel(new TableTypePanel((JWizardComponents)wizardDialog.getWizardComponents(), this.configurationWizardModel));
        wizardDialog.getWizardComponents().addWizardPanel(new StepMotorCharacteristicsPanel((JWizardComponents)wizardDialog.getWizardComponents(), this.configurationWizardModel));
        wizardDialog.getWizardComponents().addWizardPanel(new SummaryPanel((JWizardComponents)wizardDialog.getWizardComponents(), this.configurationWizardModel));
        Dimension prefDimension = null;
        for (JWizardPanel panel : wizardDialog.getWizardComponents().getWizardPanelList()) {
            if (prefDimension != null && !(prefDimension.getWidth() < panel.getPanel().getPreferredSize().getWidth())) continue;
            prefDimension = panel.getPanel().getPreferredSize();
        }
        LOGGER.info("Current prefDimension: {}", prefDimension);
        if (prefDimension != null) {
            wizardDialog.setSize(prefDimension.width + 300, 480);
        }
        wizardDialog.setDefaultCloseOperation(2);
        WindowUtils.centerOnCurrentScreen((Component)parent, (Component)wizardDialog);
        wizardDialog.setVisible(true);
        LOGGER.info("The wizard has finished, configurationWizardModel: {}", (Object)this.configurationWizardModel);
    }

    public ConfigurationWizardModel getConfigurationWizardModel() {
        return this.configurationWizardModel;
    }

    public static ConfigurationWizardModel prepareConfigurationModel(NodeInterface selectedNode, TurnTableType turnTableType, Map<String, CvNode> cvNumberToJideNodeMap, Map<String, CvNode> mapKeywordToNode) {
        ConfigurationWizardModel configurationWizardModel = new ConfigurationWizardModel(selectedNode);
        configurationWizardModel.setTurnTableType(turnTableType);
        Integer nemaType = StepControlCvUtils.getConfigVarByteValue(mapKeywordToNode, cvNumberToJideNodeMap, "nematype");
        try {
            MotorSizeType motorSizeType = MotorSizeType.fromValue(ByteUtils.getLowByte((Integer)nemaType));
            configurationWizardModel.setMotorSizeType(motorSizeType);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("Invalid motor size in configuration. Fallback to NEMA13. Provided error message: {}", (Object)ex.getMessage());
            configurationWizardModel.setMotorSizeType(MotorSizeType.nema13);
        }
        Integer stepCount = StepControlCvUtils.getConfigVarIntValue(mapKeywordToNode, cvNumberToJideNodeMap, "stepcount");
        configurationWizardModel.setStepCount(stepCount);
        Gearing gearing = null;
        Integer gearPrimary = StepControlCvUtils.getConfigVarIntValue(mapKeywordToNode, cvNumberToJideNodeMap, "gear_primary");
        Integer gearSecondary = StepControlCvUtils.getConfigVarIntValue(mapKeywordToNode, cvNumberToJideNodeMap, "gear_secondary");
        if (gearPrimary == null || gearPrimary < 1) {
            LOGGER.info("No gearing defined because primary value = 0.");
        } else if (gearPrimary != null && gearPrimary > 0 || gearSecondary != null && gearSecondary > 0) {
            gearing = new Gearing("yes");
            gearing.setGearRatioPrimary(gearPrimary != null ? gearPrimary : 1);
            gearing.setGearRatioSecondary(gearSecondary != null ? gearSecondary : 1);
            gearing.setBackLash(0);
        }
        Integer backlash = StepControlCvUtils.getConfigVarIntValue(mapKeywordToNode, cvNumberToJideNodeMap, "backlash");
        if (backlash != null && backlash > 0) {
            if (gearing != null) {
                LOGGER.info("Set the backlash value.");
                gearing.setBackLash(backlash);
            } else {
                LOGGER.info("No gearing available to set the backlash value.");
            }
        }
        if (gearing == null) {
            LOGGER.info("No gearing defined.");
            gearing = new Gearing("no");
        }
        configurationWizardModel.setGearing(gearing);
        MicroStepsEnum microStepsEnum = StepControlCvUtils.getValidMicroStepping(mapKeywordToNode, cvNumberToJideNodeMap);
        configurationWizardModel.setMicroStepping(microStepsEnum);
        Integer unitSystemValue = StepControlCvUtils.getConfigVarByteValue(mapKeywordToNode, cvNumberToJideNodeMap, "unit");
        if (unitSystemValue != null) {
            int bitSpeed = ByteUtils.getBit((int)unitSystemValue, (int)0);
            configurationWizardModel.setSpeedScale(bitSpeed > 0 ? MovementScaleEnum.scale0_1 : MovementScaleEnum.scale1);
            int bitAccelaration = ByteUtils.getBit((int)unitSystemValue, (int)4);
            configurationWizardModel.setAccelerationScale(bitAccelaration > 0 ? AccelarationScaleEnum.SCALE0_1 : AccelarationScaleEnum.SCALE1);
        } else {
            configurationWizardModel.setSpeedScale(MovementScaleEnum.scale1);
            configurationWizardModel.setAccelerationScale(AccelarationScaleEnum.SCALE1);
        }
        Integer speedValue = StepControlCvUtils.getConfigVarIntValue(mapKeywordToNode, cvNumberToJideNodeMap, "speed");
        if (speedValue != null) {
            configurationWizardModel.setSpeed(speedValue);
        } else {
            configurationWizardModel.setSpeed(null);
        }
        Integer accelValue = StepControlCvUtils.getConfigVarIntValue(mapKeywordToNode, cvNumberToJideNodeMap, "accel");
        if (accelValue != null) {
            configurationWizardModel.setAccel(accelValue);
        } else {
            configurationWizardModel.setAccel(null);
        }
        Integer decelValue = StepControlCvUtils.getConfigVarIntValue(mapKeywordToNode, cvNumberToJideNodeMap, "decel");
        if (decelValue != null) {
            configurationWizardModel.setDecel(decelValue);
        } else {
            configurationWizardModel.setDecel(null);
        }
        return configurationWizardModel;
    }
}

