/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BoundedRangeAdapter;
import com.jgoodies.binding.list.IndirectListModel;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterFactory;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Objects;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TablePopupMenuInstaller;
import com.jidesoft.grid.TableStyleProvider;
import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideToggleButton;
import com.jidesoft.swing.NullJideButton;
import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarPanel;
import com.vlsolutions.swing.toolbars.VLToolBar;
import eu.hansolo.steelseries.extras.Led;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.exchange.vendorcv.CVType;
import org.bidib.jbidibc.exchange.vendorcv.DataType;
import org.bidib.jbidibc.messages.AccessoryState;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.AccessoryExecutionState;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.api.model.listener.DefaultFeedbackPortListener;
import org.bidib.wizard.api.model.listener.FeedbackPortListener;
import org.bidib.wizard.api.model.listener.PortValueListener;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.utils.NodeUtils;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.converter.StringToUnsignedLongConverter;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.IntegerRangeFilter;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.client.common.view.BusyFrame;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.client.common.view.cvdef.CvNodeUtils;
import org.bidib.wizard.client.common.view.cvdef.LongCvNode;
import org.bidib.wizard.client.common.view.listener.TabStatusListener;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.model.settings.ExperimentalSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.script.switching.AccessoryScripting;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.model.stepcontrol.TurnTableType;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvDefinitionPanelProvider;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvValueUtils;
import org.bidib.wizard.mvc.main.controller.CvDefinitionPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.component.DefaultTabSelectionPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabSelectionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.stepcontrol.controller.StepControlControllerInterface;
import org.bidib.wizard.mvc.stepcontrol.model.AccelarationScaleEnum;
import org.bidib.wizard.mvc.stepcontrol.model.AspectExecutionModel;
import org.bidib.wizard.mvc.stepcontrol.model.AspectReference;
import org.bidib.wizard.mvc.stepcontrol.model.ConfigurationWizardModel;
import org.bidib.wizard.mvc.stepcontrol.model.CvConsoleModel;
import org.bidib.wizard.mvc.stepcontrol.model.MicroStepsEnum;
import org.bidib.wizard.mvc.stepcontrol.model.MotorSizeType;
import org.bidib.wizard.mvc.stepcontrol.model.MovementScaleEnum;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlModel;
import org.bidib.wizard.mvc.stepcontrol.view.AngleRenderer;
import org.bidib.wizard.mvc.stepcontrol.view.AspectCallbackListener;
import org.bidib.wizard.mvc.stepcontrol.view.AspectCellRenderer;
import org.bidib.wizard.mvc.stepcontrol.view.AspectEditorPanel;
import org.bidib.wizard.mvc.stepcontrol.view.AspectTable;
import org.bidib.wizard.mvc.stepcontrol.view.AspectTableModel;
import org.bidib.wizard.mvc.stepcontrol.view.ConfigurationWizard;
import org.bidib.wizard.mvc.stepcontrol.view.InvalidAspectException;
import org.bidib.wizard.mvc.stepcontrol.view.MotorSlider;
import org.bidib.wizard.mvc.stepcontrol.view.PositionOutOfRangeException;
import org.bidib.wizard.mvc.stepcontrol.view.ScriptPanel;
import org.bidib.wizard.mvc.stepcontrol.view.SpeedRangeValidationUtils;
import org.bidib.wizard.mvc.stepcontrol.view.StepControlAspectCellRenderer;
import org.bidib.wizard.mvc.stepcontrol.view.StepControlCvUtils;
import org.bidib.wizard.mvc.stepcontrol.view.TurntableIconPanel;
import org.bidib.wizard.mvc.stepcontrol.view.excel.DataExchangeException;
import org.bidib.wizard.mvc.stepcontrol.view.excel.ExcelAspectReader;
import org.bidib.wizard.mvc.stepcontrol.view.excel.ImportAspect;
import org.bidib.wizard.utils.FileUtils;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class StepControlPanel
implements TabSelectionListener,
CvDefinitionPanelProvider,
TabPanelProvider,
TabVisibilityProvider,
PortValueListener<MotorPort>,
AccessoryScripting {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepControlPanel.class);
    private static final String EMERGENCY_STOP = "<html><font color='red'><b>EMERGENCY STOP</b></font></html>";
    private static final String OPERATING = "<html><b>OPERATING</b></html>";
    private static final String HOMING_IN_PROGRESS = "<html><b>HOMING</b></html>";
    private static final String UNKNOWN = "<html><b>UNKNOWN</b></html>";
    private static final String READ = "read";
    private static final String WRITE = "write";
    private static final long INACTIVE_POSITION_VALUE = 0xFFFFFFFFL;
    private final StepControlModel stepControlModel;
    private final TabStatusListener tabStatusListener;
    private final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider;
    private AspectTable aspectTable;
    private JPanel component;
    private NodeInterface selectedNode;
    private IndirectListModel<StepControlAspect> aspectSelection;
    private PresentationModel<StepControlModel> stepControlPresentationModel;
    private ImageIcon accessoryErrorIcon;
    private ImageIcon accessorySuccessfulIcon;
    private ImageIcon accessoryWaitIcon;
    private ImageIcon accessoryUnknownIcon;
    private ImageIcon emergencyStopIcon;
    private ImageIcon normalOperatingIcon;
    private ImageIcon homingInProgressIcon;
    private ImageIcon selectedIcon;
    private ImageIcon unselectedIcon;
    private ImageIcon emptyIcon;
    private ImageIcon errorIcon;
    private JLabel operationalStateIconLabel = new JLabel();
    private JLabel executionStateIconLabel = new JLabel();
    private final List<CvDefinitionRequestListener> cvDefinitionRequestListeners = new ArrayList<CvDefinitionRequestListener>();
    private Map<String, CvNode> mapKeywordToNode;
    private final List<ConfigurationVariable> requiredConfigVariables = new ArrayList<ConfigurationVariable>();
    private final MainModel mainModel;
    private boolean initialized;
    private final StatusBar statusBar;
    private final List<String> fieldsToUpdate = new ArrayList<String>();
    private final List<Led> occupancyLeds = new ArrayList<Led>();
    private JButton readCvButton;
    private JButton writeCvButton;
    private VLToolBar toolbarCvDefinition;
    private double degreeOffset;
    private TurntableIconPanel turntableIconPanel;
    private AngleRenderer angleRenderer;
    private boolean showMotorSliderEditor = false;
    private MotorSlider motorSliderEditor;
    private MotorPort selectedMotorPort;
    private StepControlControllerInterface stepControlController;
    private Map<String, JideButton> functionButtonMap = new HashMap<String, JideButton>();
    private JPanel functionButtonParentPanel;
    private JSlider speedSlider;
    private ValueModel speedModel;
    private BoundedRangeAdapter boundedRangeAdapterSpeed;
    private IntegerRangeFilter speedRangeFilter;
    private JSlider accelSlider;
    private BoundedRangeAdapter boundedRangeAdapterAccel;
    private JSlider decelSlider;
    private BoundedRangeAdapter boundedRangeAdapterDecel;
    private JideToggleButton soundActiveButton;
    private JButton setPosition;
    private JButton rotateTurnTableFlipButton;
    private JButton leftStepsPosition;
    private JButton leftSingleStepPosition;
    private JButton rightSingleStepPosition;
    private JButton rightStepsPosition;
    private ScriptPanel scriptPanel;
    private final SettingsService settingsService;
    private final AspectExecutionModel aspectExecutionModel;
    private TableModelListener aspectTableModelListener;
    private JPanel detailsPanel;
    private FormBuilder positionFormBuilder;
    private JPanel buttonBarContainer;
    private final AtomicBoolean cvValuesLoaded = new AtomicBoolean();
    private static final String WORKING_DIR_STEPCONTROL_EXPORT_KEY = "stepControlExchange";

    public StepControlPanel(MainModel mainModel, StepControlModel stepControlModel, SettingsService settingsService, TabStatusListener tabStatusListener, FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider, StepControlControllerInterface stepControlController, StatusBar statusBar) {
        this.tabStatusListener = tabStatusListener;
        this.mainModel = mainModel;
        this.feedbackPortStatusChangeProvider = feedbackPortStatusChangeProvider;
        this.stepControlController = stepControlController;
        this.stepControlModel = stepControlModel;
        this.settingsService = settingsService;
        this.aspectExecutionModel = new AspectExecutionModel();
        this.aspectExecutionModel.setAccessoryId(0);
        this.statusBar = statusBar;
    }

    private SortableTableModel getSortableTableModel() {
        return (SortableTableModel)this.aspectTable.getModel();
    }

    public boolean equals(Object other) {
        return other instanceof StepControlPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = ProductUtils.isStepControl((long)node.getUniqueId());
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    public void createComponent() {
        DefaultTabSelectionPanel container = new DefaultTabSelectionPanel(this){
            private static final long serialVersionUID = 1L;

            public boolean equals(Object other) {
                TabComponentCreator creator;
                return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof StepControlPanel;
            }

            public int hashCode() {
                return super.hashCode();
            }

            @Override
            public void tabSelected(boolean selected) {
                LOGGER.info("Select tab, current component: is StepControlPanel, selected: {}", (Object)selected);
                StepControlPanel.this.tabSelected(selected);
            }
        };
        boolean debug = false;
        FormBuilder formBuilder = FormBuilder.create().columns("p, 3dlu, fill:p:g", new Object[0]).rows("p, 3dlu, p", new Object[0]).panel((JPanel)((Object)(debug ? new DebugPanel(this) : container)));
        formBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.initializeAccessoryStateIcons();
        this.aspectSelection = new SelectionInList(this.stepControlModel.getStepControlAspectsListModel());
        this.stepControlPresentationModel = new PresentationModel((ValueModel)new ValueHolder((Object)this.stepControlModel, true));
        this.operationalStateIconLabel = new JLabel(UNKNOWN);
        formBuilder.add(Resources.getString(StepControlPanel.class, (String)"operational_state"), new Object[0]).xy(1, 1);
        formBuilder.add((Component)this.operationalStateIconLabel).xy(3, 1);
        this.operationalStateIconLabel.setIcon(this.accessoryUnknownIcon);
        this.executionStateIconLabel = new JLabel();
        formBuilder.add(Resources.getString(StepControlPanel.class, (String)"execution_state"), new Object[0]).xy(1, 3);
        formBuilder.add((Component)this.executionStateIconLabel).xy(3, 3);
        this.executionStateIconLabel.setIcon(this.accessoryUnknownIcon);
        formBuilder.appendRows("5dlu", new Object[0]);
        JPanel overlayAspectTable = this.createAspectTable();
        this.detailsPanel = this.createDetailsPanel();
        JideSplitPane jideSplitPane = new JideSplitPane(1);
        jideSplitPane.add((Component)overlayAspectTable, (Object)"flexible");
        jideSplitPane.add((Component)new JScrollPane(this.detailsPanel), (Object)"flexible");
        jideSplitPane.setShowGripper(true);
        formBuilder.appendRows("fill:300dlu:g", new Object[0]);
        formBuilder.add((Component)jideSplitPane).xyw(1, 5, 3);
        this.component = formBuilder.build();
        this.component.setName(this.getName());
        this.stepControlModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("Property has changed, evt: {}", (Object)evt);
                block11 : switch (evt.getPropertyName()) {
                    case "operationalMode": {
                        switch (StepControlPanel.this.stepControlModel.getOperationalMode()) {
                            case homingInProgress: {
                                LOGGER.info("Set the operational state label to homing in progress mode.");
                                StepControlPanel.this.operationalStateIconLabel.setIcon(StepControlPanel.this.homingInProgressIcon);
                                StepControlPanel.this.operationalStateIconLabel.setText(StepControlPanel.HOMING_IN_PROGRESS);
                                break block11;
                            }
                            case operational: {
                                LOGGER.info("Set the operational state label to operating mode.");
                                StepControlPanel.this.operationalStateIconLabel.setIcon(StepControlPanel.this.normalOperatingIcon);
                                StepControlPanel.this.operationalStateIconLabel.setText(StepControlPanel.OPERATING);
                                break block11;
                            }
                            case emergencyStop: {
                                LOGGER.info("Set the operational state label to emergency mode.");
                                StepControlPanel.this.operationalStateIconLabel.setIcon(StepControlPanel.this.emergencyStopIcon);
                                StepControlPanel.this.operationalStateIconLabel.setText(StepControlPanel.EMERGENCY_STOP);
                                break block11;
                            }
                        }
                        LOGGER.info("Set the operational state label to unknown.");
                        StepControlPanel.this.operationalStateIconLabel.setIcon(StepControlPanel.this.accessoryUnknownIcon);
                        StepControlPanel.this.operationalStateIconLabel.setText(StepControlPanel.UNKNOWN);
                        break;
                    }
                    case "selectedAspect": {
                        if (StepControlPanel.this.stepControlModel.getSelectedAspect() != null) break;
                        StepControlPanel.this.executionStateIconLabel.setToolTipText(null);
                        StepControlPanel.this.executionStateIconLabel.setIcon(null);
                        StepControlPanel.this.executionStateIconLabel.setText(StepControlPanel.UNKNOWN);
                        break;
                    }
                    case "currentDegrees": {
                        break;
                    }
                    case "targetDegrees": {
                        break;
                    }
                    case "motorPort": {
                        break;
                    }
                    case "soundPorts": {
                        List<SoundPort> soundPorts = StepControlPanel.this.stepControlModel.getSoundPorts();
                        LOGGER.info("The sound ports have changed, soundPorts: {}", soundPorts);
                        StepControlPanel.this.functionButtonParentPanel.removeAll();
                        if (CollectionUtils.isNotEmpty(soundPorts)) {
                            ArrayList<JideButton> functionButtons = new ArrayList<JideButton>();
                            StepControlPanel.this.createFunctionButtonPanel(StepControlPanel.this.functionButtonParentPanel, functionButtons);
                        }
                        StepControlPanel.this.functionButtonParentPanel.revalidate();
                        break;
                    }
                    case "turnTableType": {
                        StepControlPanel.this.turnTableTypeChanged(StepControlPanel.this.aspectTable, false);
                        break;
                    }
                    case "soundActive": {
                        if (!(evt.getNewValue() instanceof Boolean)) break;
                        boolean soundActive = StepControlPanel.this.stepControlModel.isSoundActive();
                        LOGGER.info("The sound active flag has changed: {}", (Object)soundActive);
                        if (StepControlPanel.this.soundActiveButton == null) break;
                        StepControlPanel.this.soundActiveButton.setSelected(!soundActive);
                        break;
                    }
                    case "currentPosition": {
                        LOGGER.info("The current position was changed.");
                        break;
                    }
                    default: {
                        LOGGER.info("The property has changed: {}. This will set the pending changes marker on the tab.", (Object)evt.getPropertyName());
                        StepControlPanel.this.tabStatusListener.updatePendingChanges((Component)StepControlPanel.this.component, true);
                    }
                }
            }
        });
        this.speedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!StepControlPanel.this.initialized || StepControlPanel.this.selectedNode == null) {
                    LOGGER.info("The panel is not initialized or no node is selected, discard the state change of speed.");
                    return;
                }
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting() && StepControlPanel.this.initialized) {
                    StepControlPanel.this.firePerformSpeed();
                }
            }
        });
        this.accelSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!StepControlPanel.this.initialized || StepControlPanel.this.selectedNode == null) {
                    LOGGER.info("The panel is not initialized or no node is selected, discard the state change of accel.");
                    return;
                }
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting() && StepControlPanel.this.initialized) {
                    StepControlPanel.this.firePerformAccel();
                }
            }
        });
        this.decelSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!StepControlPanel.this.initialized || StepControlPanel.this.selectedNode == null) {
                    LOGGER.info("The panel is not initialized or no node is selected, discard the state change of decel.");
                    return;
                }
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting() && StepControlPanel.this.initialized) {
                    StepControlPanel.this.firePerformDecel();
                }
            }
        });
        this.toolbarCvDefinition = new VLToolBar("stepControlCvDefinition");
        this.addToolBarButtons(this.toolbarCvDefinition);
        this.addToolBar(this.toolbarCvDefinition, new ToolBarConstraints(0, 2));
        this.toolbarCvDefinition.setVisible(false);
        this.feedbackPortStatusChangeProvider.addFeedbackPortListener((FeedbackPortListener)new DefaultFeedbackPortListener(){

            public Class<?> getPortClass() {
                return FeedbackPort.class;
            }

            public void statusChanged(NodeInterface node, FeedbackPort port) {
                if (StepControlPanel.this.selectedNode != null && ProductUtils.isStepControl((long)StepControlPanel.this.selectedNode.getUniqueId())) {
                    if (port.getId() < StepControlPanel.this.occupancyLeds.size()) {
                        FeedbackPortStatus status = (FeedbackPortStatus)port.getStatus();
                        LOGGER.info("The status of the feedback port has changed: {}, status: {}", (Object)port, (Object)status);
                        Led occupancyLed = StepControlPanel.this.occupancyLeds.get(port.getId());
                        if (occupancyLed != null) {
                            SwingUtilities.invokeLater(() -> occupancyLed.setLedOn(status == FeedbackPortStatus.OCCUPIED));
                        }
                    } else {
                        LOGGER.debug("Port number of feedback port is out of range: {}", (Object)port.getId());
                    }
                } else {
                    LOGGER.info("Do not update occupancy leds because the selected node is not a StepControl.");
                }
            }
        });
    }

    private JPanel createDetailsPanel() {
        boolean debugDetail = false;
        FormBuilder detailFormBuilder = FormBuilder.create().columns("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p:g", new Object[0]).rows("p, 3dlu, p, 3dlu, p, 3dlu, p", new Object[0]).panel((JPanel)(debugDetail ? new FormDebugPanel() : new JPanel()));
        detailFormBuilder.border((Border)Paddings.DLU4);
        ImageIcon iconConfigurationWizard = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/16x16/wrench.png");
        JButton startConfigurationWizard = new JButton(Resources.getString(StepControlPanel.class, (String)"button.wizard"), iconConfigurationWizard);
        startConfigurationWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Open configuration wizard.");
                StepControlPanel.this.fireConfigurationWizard();
            }
        });
        detailFormBuilder.add((Component)this.buildLeftAlignedButtonBar(startConfigurationWizard)).xyw(1, 1, 13);
        boolean debugPosition = false;
        this.positionFormBuilder = FormBuilder.create().columns("max(40dlu;p), 3dlu, p, 6dlu, p, 3dlu, max(40dlu;p), 3dlu, p:g", new Object[0]).rows("p", new Object[0]).panel((JPanel)(debugPosition ? new FormDebugPanel() : new JPanel()));
        this.positionFormBuilder.border((Border)Paddings.EMPTY);
        ConverterValueModel currentPositionConverterModel = new ConverterValueModel((ValueModel)this.stepControlPresentationModel.getModel("currentPosition"), (BindingConverter)new StringToUnsignedLongConverter());
        JTextField currentPosition = WizardComponentFactory.createTextField((ValueModel)currentPositionConverterModel);
        currentPosition.setEditable(false);
        this.positionFormBuilder.add((Component)currentPosition).xy(1, 1);
        JButton getPosition = new JButton(Resources.getString(StepControlPanel.class, (String)"get_position"));
        getPosition.setToolTipText(Resources.getString(StepControlPanel.class, (String)"get_position.tooltip"));
        getPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Get the position value.");
                StepControlPanel.this.fireGetPosition();
            }
        });
        this.positionFormBuilder.add((Component)getPosition).xy(3, 1);
        ValueHolder directPositionModel = new ValueHolder();
        ConverterValueModel directPositionConverterModel = new ConverterValueModel((ValueModel)directPositionModel, (BindingConverter)new StringToUnsignedLongConverter());
        JTextField directPosition = WizardComponentFactory.createTextField((ValueModel)directPositionConverterModel, (boolean)false);
        this.positionFormBuilder.addLabel(Resources.getString(StepControlPanel.class, (String)"direct"), new Object[0]).xy(5, 1);
        this.positionFormBuilder.add((Component)directPosition).xy(7, 1);
        this.setPosition = new JButton(Resources.getString(StepControlPanel.class, (String)"set_position"));
        this.setPosition.setToolTipText(Resources.getString(StepControlPanel.class, (String)"set_position.tooltip"));
        this.setPosition.addActionListener(new ActionListener(){
            final /* synthetic */ ValueModel val$directPositionModel;
            {
                this.val$directPositionModel = valueModel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Long directPosition = (Long)this.val$directPositionModel.getValue();
                if (directPosition != null) {
                    LOGGER.info("Set the direct position value: {}", (Object)directPosition);
                    StepControlPanel.this.fireSetDirectPosition(directPosition.intValue());
                }
            }
        });
        ImageIcon turntableRotateFlipIcon = ImageUtils.loadImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/turntable-rotate-half.png", (int)16, (int)16);
        this.rotateTurnTableFlipButton = new JButton(turntableRotateFlipIcon);
        this.rotateTurnTableFlipButton.setToolTipText(Resources.getString(StepControlPanel.class, (String)"rotateFlip.tooltip"));
        this.rotateTurnTableFlipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Rotate turntable flip");
                StepControlPanel.this.firePerformFlipRotate();
            }
        });
        this.leftStepsPosition = new JButton(Resources.getString(StepControlPanel.class, (String)"left_steps_position"));
        this.leftStepsPosition.setToolTipText(Resources.getString(StepControlPanel.class, (String)"left_steps_position.tooltip"));
        this.leftStepsPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("10 steps in left position.");
                Long directPosition = StepControlPanel.this.stepControlModel.getCurrentPosition();
                if (directPosition != null) {
                    int newPosition = directPosition.intValue();
                    LOGGER.info("Set the position value: {}", (Object)(newPosition -= 10));
                    StepControlPanel.this.fireSetDirectPosition(newPosition);
                }
            }
        });
        this.leftSingleStepPosition = new JButton(Resources.getString(StepControlPanel.class, (String)"left_single_step_position"));
        this.leftSingleStepPosition.setToolTipText(Resources.getString(StepControlPanel.class, (String)"left_single_step_position.tooltip"));
        this.leftSingleStepPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Single step in left position.");
                Long directPosition = StepControlPanel.this.stepControlModel.getCurrentPosition();
                if (directPosition != null) {
                    int newPosition = directPosition.intValue();
                    LOGGER.info("Set the position value: {}", (Object)(--newPosition));
                    StepControlPanel.this.fireSetDirectPosition(newPosition);
                }
            }
        });
        this.rightSingleStepPosition = new JButton(Resources.getString(StepControlPanel.class, (String)"right_single_step_position"));
        this.rightSingleStepPosition.setToolTipText(Resources.getString(StepControlPanel.class, (String)"right_single_step_position.tooltip"));
        this.rightSingleStepPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Single step in right position.");
                Long directPosition = StepControlPanel.this.stepControlModel.getCurrentPosition();
                if (directPosition != null) {
                    int newPosition = directPosition.intValue();
                    LOGGER.info("Set the position value: {}", (Object)(++newPosition));
                    StepControlPanel.this.fireSetDirectPosition(newPosition);
                }
            }
        });
        this.rightStepsPosition = new JButton(Resources.getString(StepControlPanel.class, (String)"right_steps_position"));
        this.rightStepsPosition.setToolTipText(Resources.getString(StepControlPanel.class, (String)"right_steps_position.tooltip"));
        this.rightStepsPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("10 steps in right position.");
                Long directPosition = StepControlPanel.this.stepControlModel.getCurrentPosition();
                if (directPosition != null) {
                    int newPosition = directPosition.intValue();
                    LOGGER.info("Set the position value: {}", (Object)(newPosition += 10));
                    StepControlPanel.this.fireSetDirectPosition(newPosition);
                }
            }
        });
        this.buttonBarContainer = new JPanel();
        this.buildPositionsButtonBar(this.buttonBarContainer, this.positionFormBuilder);
        this.positionFormBuilder.add((Component)this.buttonBarContainer).xy(9, 1);
        detailFormBuilder.addLabel(Resources.getString(StepControlPanel.class, (String)"position"), new Object[0]).xy(1, 3);
        detailFormBuilder.add((Component)this.positionFormBuilder.build()).xyw(3, 3, 11);
        JPanel speedSlidersPanel = this.createSpeedSlidersPanel();
        detailFormBuilder.add((Component)speedSlidersPanel).xyw(1, 5, 13);
        Led occupancy1 = new Led();
        occupancy1.setPreferredSize(new Dimension(32, 32));
        Led occupancy2 = new Led();
        occupancy2.setPreferredSize(new Dimension(32, 32));
        Led occupancy3 = new Led();
        occupancy3.setPreferredSize(new Dimension(32, 32));
        Led occupancy4 = new Led();
        occupancy4.setPreferredSize(new Dimension(32, 32));
        this.occupancyLeds.add(occupancy1);
        this.occupancyLeds.add(occupancy2);
        this.occupancyLeds.add(occupancy3);
        this.occupancyLeds.add(occupancy4);
        detailFormBuilder.addLabel(Resources.getString(StepControlPanel.class, (String)"occupancy"), new Object[0]).xy(1, 7);
        detailFormBuilder.add((Component)this.buildLeftAlignedButtonBar(new JComponent[]{occupancy1, occupancy2, occupancy3, occupancy4})).xyw(3, 7, 11);
        detailFormBuilder.appendRows("3dlu, top:p:g", new Object[0]);
        JPanel turnTablePanel = this.createTurnTablePanel();
        detailFormBuilder.add((Component)turnTablePanel).xyw(1, 9, 13);
        return detailFormBuilder.build();
    }

    private JComponent buildPositionsButtonBar(JPanel container, FormBuilder positionFormBuilder) {
        JComponent buttonBar = TurnTableType.pendular != this.stepControlModel.getTurnTableType() ? this.buildLeftAlignedButtonBar(container, this.setPosition, this.leftStepsPosition, this.leftSingleStepPosition, this.rightSingleStepPosition, this.rightStepsPosition, this.rotateTurnTableFlipButton) : this.buildLeftAlignedButtonBar(container, this.setPosition, this.leftStepsPosition, this.leftSingleStepPosition, this.rightSingleStepPosition, this.rightStepsPosition);
        return buttonBar;
    }

    private JPanel createSpeedSlidersPanel() {
        boolean debug = false;
        final FormBuilder detailFormBuilder = FormBuilder.create().columns("p, 3dlu, p, 3dlu, min(p;30dlu), 3dlu, p:g:fill", new Object[0]).rows("p, 3dlu, p, 3dlu, p", new Object[0]).panel((JPanel)(debug ? new FormDebugPanel() : new JPanel()));
        detailFormBuilder.border((Border)Paddings.EMPTY);
        int row = 1;
        if (this.showMotorSliderEditor) {
            detailFormBuilder.appendRows("3dlu, p", new Object[0]);
            this.motorSliderEditor = new MotorSlider(-SpeedSteps.DCC128.getSteps(), SpeedSteps.DCC128.getSteps());
            this.motorSliderEditor.setEnabled(false);
            JPanel sliderComponent = this.motorSliderEditor.getComponent();
            detailFormBuilder.addLabel("Motor", new Object[0]).xy(1, row);
            detailFormBuilder.add((Component)sliderComponent).xyw(3, row, 3);
            row += 2;
        }
        this.speedModel = this.stepControlPresentationModel.getModel("speed");
        this.speedSlider = new JSlider();
        this.speedSlider.setOpaque(false);
        int maxSpeed = 2001;
        int minSpeed = 1;
        LOGGER.info("Use initial speed range, min: {}, max: {}", (Object)minSpeed, (Object)maxSpeed);
        this.boundedRangeAdapterSpeed = new BoundedRangeAdapter(this.speedModel, 0, minSpeed, maxSpeed);
        this.speedSlider.setModel((BoundedRangeModel)this.boundedRangeAdapterSpeed);
        JLabel speedLabel = WizardComponentFactory.createLabel((ValueModel)ConverterFactory.createStringConverter((ValueModel)this.speedModel, (Format)new DecimalFormat("#####")));
        speedLabel.setPreferredSize(new Dimension(40, speedLabel.getPreferredSize().height));
        speedLabel.setHorizontalAlignment(4);
        detailFormBuilder.addLabel(Resources.getString(StepControlPanel.class, (String)"speed"), new Object[0]).xy(1, row);
        detailFormBuilder.add((Component)speedLabel).xy(3, row);
        ConverterValueModel speedConverterModel = new ConverterValueModel(this.speedModel, (BindingConverter)new StringToIntegerConverter());
        JTextField speedText = WizardComponentFactory.createTextField((ValueModel)speedConverterModel);
        InputValidationDocument speedDocument = new InputValidationDocument(5, "0123456789");
        this.speedRangeFilter = new IntegerRangeFilter(minSpeed, maxSpeed);
        speedDocument.setDocumentFilter((DocumentFilter)this.speedRangeFilter);
        speedText.setDocument((Document)speedDocument);
        detailFormBuilder.add((Component)speedText).xy(5, row);
        detailFormBuilder.add((Component)this.speedSlider).xy(7, row);
        row += 2;
        AbstractValueModel accelModel = this.stepControlPresentationModel.getModel("accel");
        this.accelSlider = new JSlider(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValueIsAdjusting(boolean b) {
                try {
                    super.setValueIsAdjusting(b);
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the new value failed.", (Throwable)ex);
                    this.showErrorDialog(detailFormBuilder.getPanel(), Resources.getString(StepControlPanel.class, (String)"adjust-accel-value-failed.title"), Resources.getString(StepControlPanel.class, (String)"adjust-accel-value-failed.instruction"), Resources.getString(StepControlPanel.class, (String)"adjust-accel-value-failed.text"), ex);
                }
            }

            @Override
            public void setValue(int n) {
                try {
                    super.setValue(n);
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the new value failed.", (Throwable)ex);
                    this.showErrorDialog(detailFormBuilder.getPanel(), Resources.getString(StepControlPanel.class, (String)"adjust-accel-value-failed.title"), Resources.getString(StepControlPanel.class, (String)"adjust-accel-value-failed.instruction"), Resources.getString(StepControlPanel.class, (String)"adjust-accel-value-failed.text"), ex);
                }
            }

            private void showErrorDialog(JComponent component, String title, String instruction, String text, Exception ex) {
                TaskDialogs.build((Window)JOptionPane.getFrameForComponent(component), (String)instruction, (String)text).title(title).showException((Throwable)ex);
            }
        };
        this.boundedRangeAdapterAccel = new BoundedRangeAdapter((ValueModel)accelModel, 1, 1, 65536);
        this.accelSlider.setModel((BoundedRangeModel)this.boundedRangeAdapterAccel);
        this.accelSlider.setOpaque(false);
        JLabel accelLabel = WizardComponentFactory.createLabel((ValueModel)ConverterFactory.createStringConverter((ValueModel)accelModel, (Format)new DecimalFormat("#####")));
        accelLabel.setHorizontalAlignment(4);
        detailFormBuilder.addLabel(Resources.getString(StepControlPanel.class, (String)"accel"), new Object[0]).xy(1, row);
        detailFormBuilder.add((Component)accelLabel).xy(3, row);
        ConverterValueModel accelConverterModel = new ConverterValueModel((ValueModel)accelModel, (BindingConverter)new StringToIntegerConverter());
        JTextField accelText = WizardComponentFactory.createTextField((ValueModel)accelConverterModel);
        InputValidationDocument accelDocument = new InputValidationDocument(5, "0123456789");
        accelDocument.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(0, 65535));
        accelText.setDocument((Document)accelDocument);
        detailFormBuilder.add((Component)accelText).xy(5, row);
        detailFormBuilder.add((Component)this.accelSlider).xy(7, row);
        row += 2;
        AbstractValueModel decelModel = this.stepControlPresentationModel.getModel("decel");
        this.decelSlider = new JSlider(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValueIsAdjusting(boolean b) {
                try {
                    super.setValueIsAdjusting(b);
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the new value failed.", (Throwable)ex);
                    this.showErrorDialog(detailFormBuilder.getPanel(), Resources.getString(StepControlPanel.class, (String)"adjust-decel-value-failed.title"), Resources.getString(StepControlPanel.class, (String)"adjust-decel-value-failed.instruction"), Resources.getString(StepControlPanel.class, (String)"adjust-decel-value-failed.text"), ex);
                }
            }

            @Override
            public void setValue(int n) {
                try {
                    super.setValue(n);
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the new value failed.", (Throwable)ex);
                    this.showErrorDialog(detailFormBuilder.getPanel(), Resources.getString(StepControlPanel.class, (String)"adjust-decel-value-failed.title"), Resources.getString(StepControlPanel.class, (String)"adjust-decel-value-failed.instruction"), Resources.getString(StepControlPanel.class, (String)"adjust-decel-value-failed.text"), ex);
                }
            }

            private void showErrorDialog(JComponent component, String title, String instruction, String text, Exception ex) {
                TaskDialogs.build((Window)JOptionPane.getFrameForComponent(component), (String)instruction, (String)text).title(title).showException((Throwable)ex);
            }
        };
        this.boundedRangeAdapterDecel = new BoundedRangeAdapter((ValueModel)decelModel, 1, 1, 65536);
        this.decelSlider.setModel((BoundedRangeModel)this.boundedRangeAdapterDecel);
        this.decelSlider.setOpaque(false);
        JLabel decelLabel = WizardComponentFactory.createLabel((ValueModel)ConverterFactory.createStringConverter((ValueModel)decelModel, (Format)new DecimalFormat("#####")));
        decelLabel.setHorizontalAlignment(4);
        detailFormBuilder.addLabel(Resources.getString(StepControlPanel.class, (String)"decel"), new Object[0]).xy(1, row);
        detailFormBuilder.add((Component)decelLabel).xy(3, row);
        ConverterValueModel decelConverterModel = new ConverterValueModel((ValueModel)decelModel, (BindingConverter)new StringToIntegerConverter());
        JTextField decelText = WizardComponentFactory.createTextField((ValueModel)decelConverterModel);
        InputValidationDocument decelDocument = new InputValidationDocument(5, "0123456789");
        decelDocument.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(0, 65535));
        decelText.setDocument((Document)decelDocument);
        detailFormBuilder.add((Component)decelText).xy(5, row);
        detailFormBuilder.add((Component)this.decelSlider).xy(7, row);
        JPanel speedSliderPanel = detailFormBuilder.build();
        CollapsiblePane pane = new CollapsiblePane(Resources.getString(StepControlPanel.class, (String)"pane-speed-and-accelaration"));
        ImageIcon speedAndAccelarationIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/16x16/wrench.png");
        pane.setIcon((Icon)speedAndAccelarationIcon);
        pane.setContentPane((JComponent)JideSwingUtilities.createTopPanel((Component)speedSliderPanel));
        try {
            pane.setCollapsed(true);
        }
        catch (PropertyVetoException ex) {
            LOGGER.warn("Collapse pane was vetoed.", (Throwable)ex);
        }
        return pane;
    }

    private JPanel createTurnTablePanel() {
        boolean debugTTFB = false;
        FormBuilder turntableFormBuilder = FormBuilder.create().columns("p, 3dlu, p, 10dlu, p:g", new Object[0]).rows("top:p:g", new Object[0]).panel((JPanel)(debugTTFB ? new FormDebugPanel() : new JPanel()));
        this.turntableIconPanel = this.prepareTurntableIconPanel();
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setMinimumSize(new Dimension(140, 140));
        contentPanel.setPreferredSize(new Dimension(140, 140));
        contentPanel.setOpaque(true);
        contentPanel.add((Component)this.turntableIconPanel, "Center");
        turntableFormBuilder.add((Component)contentPanel).xy(1, 1);
        this.functionButtonParentPanel = new JPanel();
        turntableFormBuilder.add((Component)this.functionButtonParentPanel).xy(3, 1);
        if (this.settingsService.getWizardSettings().isPowerUser()) {
            this.scriptPanel = new ScriptPanel(this, this.settingsService);
            JPanel panel = this.scriptPanel.createPanel();
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(this.getClass(), (String)"script") + ":"));
            turntableFormBuilder.add((Component)panel).xy(5, 1);
        } else {
            LOGGER.info("The script panel for StepControl is skipped because the user is not a power user.");
        }
        return turntableFormBuilder.build();
    }

    private TurntableIconPanel prepareTurntableIconPanel() {
        ExperimentalSettingsInterface experimentalSettings = this.settingsService.getExperimentalSettings();
        experimentalSettings.addPropertyChangeListener("turntableAngleOffset", evt -> {
            this.degreeOffset = experimentalSettings.getTurntableAngleOffset();
            double currentDegrees = this.stepControlModel.getTurntableCurrentDegrees();
            this.setTurntableDegrees(currentDegrees);
        });
        this.degreeOffset = experimentalSettings.getTurntableAngleOffset();
        ImageIcon turntableBackgroundIcon = ImageUtils.loadImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/turntable-bg.png", (int)120, (int)120);
        ImageIcon turntableBackgroundLinearIcon = ImageUtils.loadImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/turntable-bg-linear.png", (int)120, (int)120);
        ImageIcon turntableBackgroundPendularIcon = ImageUtils.loadImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/turntable-bg-pendular.png", (int)120, (int)120);
        ImageIcon turntableBasicIcon = ImageUtils.loadImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/turntable-platform.png", (int)110, (int)110);
        ImageIcon turntablePendularIcon = ImageUtils.loadImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/turntable-cableways.png", (int)40, (int)60);
        TurntableIconPanel turntableIconPanel = new TurntableIconPanel(turntableBackgroundIcon, turntableBackgroundLinearIcon, turntableBackgroundPendularIcon, turntableBasicIcon, turntablePendularIcon, this.degreeOffset, TurnTableType.unknown);
        turntableIconPanel.prepareComponent();
        turntableIconPanel.setMinimumSize(new Dimension(140, 140));
        turntableIconPanel.setPreferredSize(new Dimension(140, 140));
        turntableIconPanel.setBounds(0, 0, 140, 140);
        return turntableIconPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnTableTypeChanged(AspectTable aspectTable, boolean initial) {
        TurnTableType turnTableType = this.stepControlModel.getTurnTableType();
        LOGGER.info("The turntable type has changed: {}", (Object)turnTableType);
        aspectTable.turnTableTypeChanged(turnTableType);
        if (this.turntableIconPanel != null) {
            this.turntableIconPanel.setTurnTableType(turnTableType);
        }
        if (this.rotateTurnTableFlipButton != null) {
            this.buttonBarContainer.removeAll();
            this.buildPositionsButtonBar(this.buttonBarContainer, this.positionFormBuilder);
            this.detailsPanel.updateUI();
        }
        if (!initial && this.selectedNode != null) {
            int maxConfiguredAspects = 48;
            switch (turnTableType) {
                case round: {
                    maxConfiguredAspects = 24;
                    break;
                }
                case pendular: {
                    maxConfiguredAspects = 2;
                    break;
                }
            }
            this.stepControlModel.setMaxConfiguredAspects(maxConfiguredAspects);
            LOGGER.info("The turnTableType was set to: {}, maxConfiguredAspects: {}", (Object)turnTableType, (Object)maxConfiguredAspects);
            Map<String, CvNode> cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
            AtomicBoolean errorDetected = new AtomicBoolean();
            List<StepControlAspect> configuredAspects = this.prepareConfiguredAspects(cvNumberToNodeMap, errorDetected);
            try {
                aspectTable.getModel().removeTableModelListener(this.aspectTableModelListener);
                this.stepControlModel.setStepControlAspects(configuredAspects);
            }
            finally {
                aspectTable.getModel().addTableModelListener(this.aspectTableModelListener);
            }
            this.aspectTable.expandAllRows();
        }
    }

    private JPanel createAspectTable() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        final AspectTableModel tableModel = new AspectTableModel(this.aspectSelection, new String[]{Resources.getString(StepControlPanel.class, (String)"aspect"), Resources.getString(StepControlPanel.class, (String)"position"), Resources.getString(StepControlPanel.class, (String)"angle"), Resources.getString(StepControlPanel.class, (String)"polarity")}, this.stepControlModel);
        AddAspectCallbackListener aspectCallbackListener = new AddAspectCallbackListener();
        this.selectedIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/arrow_straight.png");
        this.unselectedIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/arrow_switch.png");
        this.aspectTable = new AspectTable(tableModel, Resources.getString(StepControlPanel.class, (String)"emptyTable"), this.selectedIcon, this.unselectedIcon, aspectCallbackListener);
        this.aspectTable.setTableStyleProvider((TableStyleProvider)new RowStripeTableStyleProvider(new Color[]{UIManager.getColor("tableRowStripe.background"), UIManager.getColor("tableRowStripe.alternativeBackground")}));
        this.aspectTable.setName("Aspect Table");
        this.aspectTable.setRowHeight(24);
        this.aspectTable.setSortingEnabled(false);
        this.aspectTable.setAutoResort(true);
        this.aspectTable.sortColumn(1);
        this.aspectTable.setShowSortOrderNumber(false);
        this.aspectTable.setRestoreSelectionAndRowHeightAutomatically(true);
        this.aspectTable.setSelectionMode(0);
        this.aspectTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = StepControlPanel.this.aspectTable.getSelectedRow();
                if (row != -1) {
                    StepControlPanel.this.aspectTable.expandRow(row);
                }
            }
        });
        this.aspectTable.createComponentFactory(this.stepControlModel);
        this.aspectTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.aspectTable.getColumnModel().getColumn(0).setMaxWidth(80);
        this.aspectTable.getColumnModel().getColumn(0).setCellRenderer(new AspectCellRenderer(this.stepControlModel));
        this.aspectTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.aspectTable.getColumnModel().getColumn(1).setCellRenderer(new StepControlAspectCellRenderer(this.stepControlModel, this.emptyIcon, this.errorIcon));
        this.aspectTable.setFillsViewportHeight(true);
        this.aspectTable.setFillsViewportWithStripe(false);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.aspectTable));
        final DefaultOverlayable overlayAspectTable = new DefaultOverlayable((JComponent)scrollPane);
        this.aspectTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                overlayAspectTable.setOverlayVisible(StepControlPanel.this.aspectTable.getModel().getRowCount() == 0);
            }
        });
        NullJideButton createAspectLinkButton = new NullJideButton(this.aspectTable.getEmptyTableText());
        createAspectLinkButton.setButtonStyle(3);
        createAspectLinkButton.addActionListener(evt -> this.fireCreateNewAspect());
        overlayAspectTable.addOverlayComponent((JComponent)createAspectLinkButton);
        contentPanel.add((Component)overlayAspectTable, "Center");
        TablePopupMenuInstaller installer = new TablePopupMenuInstaller((JTable)((Object)this.aspectTable)){

            protected JPopupMenu createPopupMenu() {
                LOGGER.info("Create the popup menu.");
                return new AspectTablePopupMenu();
            }

            protected void customizeMenuItems(JTable table, JPopupMenu popup, int clickingRow, int clickingColumn) {
                LOGGER.info("Customize the popup menu: {}", (Object)popup);
                if (clickingRow > -1 && table.getSelectedRow() != clickingRow) {
                    int selectedRow = StepControlPanel.this.aspectTable.getSelectedRow();
                    if (selectedRow > -1 && !StepControlPanel.this.aspectTable.checkAspectEditorIsDirty(selectedRow)) {
                        LOGGER.info("Check if aspect editor is dirty failed. Do not show the add aspect editor.");
                        popup.removeAll();
                        return;
                    }
                    table.setRowSelectionInterval(clickingRow, clickingRow);
                }
                super.customizeMenuItems(table, popup, clickingRow, clickingColumn);
            }
        };
        this.turnTableTypeChanged(this.aspectTable, true);
        this.aspectSelection.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                LOGGER.info("intervalRemoved, e: {}", (Object)e);
                tableModel.fireTableDataChanged();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                LOGGER.info("intervalAdded");
                tableModel.fireTableDataChanged();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                LOGGER.info("contentsChanged, resort the table.");
                StepControlPanel.this.aspectTable.resort();
                LOGGER.info("contentsChanged, scroll to top.");
                StepControlPanel.this.aspectTable.scrollToTop();
            }
        });
        return contentPanel;
    }

    protected void firePerformFlipRotate() {
        LOGGER.info("Rotate the turntable half.");
        this.fireGetPosition();
        Long value = this.stepControlModel.getCurrentPosition();
        if (value == null) {
            LOGGER.warn("The position value is null.");
            return;
        }
        Long totalSteps = this.stepControlModel.getTotalSteps();
        if (totalSteps == null) {
            LOGGER.warn("The total steps value is null.");
            return;
        }
        int currentPosition = value.intValue();
        if (this.stepControlModel.getSelectedAspect() != null && this.stepControlModel.getSelectedAspect().getPosition() == (long)currentPosition) {
            AspectReference oppositeAspect = this.stepControlModel.getSelectedAspect().getOppositeAspect();
            LOGGER.info("Flip turntable to opposite aspect: {}", (Object)oppositeAspect);
            this.firePerformAspect((StepControlAspect)oppositeAspect);
            return;
        }
        long targetPosition = (long)currentPosition + totalSteps / 2L;
        if (targetPosition >= totalSteps) {
            targetPosition -= totalSteps.longValue();
        }
        LOGGER.info("Calculated target position: {}", (Object)targetPosition);
        try {
            this.moveToTargetPosition((int)targetPosition);
        }
        catch (PositionOutOfRangeException ex) {
            LOGGER.info("Set direct position failed: {}", (Object)targetPosition);
            JOptionPane.showMessageDialog(this.component, Resources.getString(StepControlPanel.class, (String)"set_position_failed_message", (Object[])new Object[]{targetPosition}), Resources.getString(StepControlPanel.class, (String)"set_position_title"), 0);
        }
    }

    protected void fireGetPosition() {
        LOGGER.info("Read the current position value.");
        try {
            ArrayList cvList = new ArrayList();
            UnaryOperator prepareFunction = cvList1 -> this.prepareGetCurrentPosition((List<ConfigurationVariable>)cvList1);
            UnaryOperator loadFunction = cvList1 -> this.fireLoadConfigVariablesPosition((List<ConfigurationVariable>)cvList1);
            Function prepareAndLoad = prepareFunction.andThen(loadFunction);
            List result = (List)prepareAndLoad.apply(cvList);
            LOGGER.info("Fetched the current position: {}", (Object)result);
            Long currentPosition = Long.parseLong(((ConfigurationVariable)result.get(0)).getValue());
            this.stepControlModel.setCurrentPosition(currentPosition);
        }
        catch (Exception ex) {
            LOGGER.warn("Get the new {} value failed.", (Object)"STEPPOS", (Object)ex);
        }
    }

    private List<ConfigurationVariable> prepareGetCurrentPosition(List<ConfigurationVariable> cvList) {
        LOGGER.info("prepareGetCurrentPosition, current items in fieldsToUpdate: {}", this.fieldsToUpdate);
        this.fieldsToUpdate.clear();
        ConfigurationVariable cv = new ConfigurationVariable("STEPPOS", null);
        this.addConfigVariableDistinct(cvList, cv);
        Map<String, CvNode> cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
        CvNode cvNode = cvNumberToNodeMap.get("STEPPOS");
        if (cvNode == null) {
            CVType cvType = new CVType();
            cvType.setNumber("STEPPOS");
            cvType.setType(DataType.STRING);
            cvNode = new CvNode(cvType, cv);
            LOGGER.info("Add the transient CvNode for current position: {}", (Object)cvNode);
            cvNumberToNodeMap.put("STEPPOS", cvNode);
        }
        return cvList;
    }

    protected void fireSetDirectPosition(Integer directPosition) {
        if (directPosition == null) {
            LOGGER.warn("The position value is null.");
            return;
        }
        int currentPosition = directPosition;
        try {
            this.moveToTargetPosition(currentPosition);
        }
        catch (PositionOutOfRangeException ex) {
            LOGGER.info("Set direct position failed: {}", (Object)currentPosition);
            JOptionPane.showMessageDialog(this.component, Resources.getString(StepControlPanel.class, (String)"set_position_failed_message", (Object[])new Object[]{currentPosition}), Resources.getString(StepControlPanel.class, (String)"set_position_title"), 0);
        }
    }

    protected void moveToTargetPosition(int targetPosition) throws PositionOutOfRangeException {
        LOGGER.info("Write the new target position value: {}", (Object)targetPosition);
        int maxPosition = 0;
        Long totalSteps = this.stepControlModel.getTotalSteps();
        if (totalSteps != null) {
            maxPosition = totalSteps.intValue();
        }
        if (targetPosition < 0 || targetPosition > maxPosition) {
            LOGGER.warn("Position is outside range: {}", (Object)targetPosition);
            throw new PositionOutOfRangeException(targetPosition, 0L, maxPosition - 1, -1);
        }
        try {
            ArrayList<ConfigurationVariable> cvList = new ArrayList<ConfigurationVariable>();
            ConfigurationVariable cv = new ConfigurationVariable("STEPPOS", Integer.toString(targetPosition));
            cvList.add(cv);
            Map<String, CvNode> cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
            CvNode cvNode = cvNumberToNodeMap.get("STEPPOS");
            if (cvNode == null) {
                CVType cvType = new CVType();
                cvType.setNumber("STEPPOS");
                cvType.setType(DataType.STRING);
                cvNode = new CvNode(cvType, cv);
                LOGGER.info("Add the transient CvNode for current position: {}", (Object)cvNode);
                cvNumberToNodeMap.put("STEPPOS", cvNode);
            } else {
                cvNode.setNewValue((Object)Integer.toString(targetPosition));
            }
            this.fireWriteConfigVariablesPosition(cvList);
        }
        catch (Exception ex) {
            LOGGER.warn("Set the new {} value failed.", (Object)"STEPPOS", (Object)ex);
        }
    }

    public void setTurntableDegrees(double degree) {
        LOGGER.info("Set degree: {}", (Object)degree);
        if (this.turntableIconPanel != null) {
            if ((degree += this.degreeOffset) > 359.0) {
                degree -= 360.0;
            }
            this.turntableIconPanel.setDegrees(degree);
            this.turntableIconPanel.repaintTurntable();
        }
    }

    private void initializeAccessoryStateIcons() {
        this.accessoryErrorIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/accessory-error.png");
        this.accessorySuccessfulIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/accessory-successful.png");
        this.accessoryWaitIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/accessory-wait.png");
        this.accessoryUnknownIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/accessory-unknown.png");
        this.emergencyStopIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/emergency-stop.png", (int)16, (int)16);
        this.normalOperatingIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/green-leaf.png");
        this.homingInProgressIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/red-leaf.png");
        this.emptyIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/empty.png");
        this.errorIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/error-leaf.png");
    }

    private void firePerformAspect(StepControlAspect stepControlAspect) {
        LOGGER.info("Aspect is performed on stepControlAspect: {}", (Object)stepControlAspect);
        int aspectNumber = -1;
        for (int rowIndex = 0; rowIndex < this.aspectTable.getRowCount(); ++rowIndex) {
            StepControlAspect currentAspect = (StepControlAspect)this.getSortableTableModel().getValueAt(rowIndex, 1);
            if (!Objects.equals((Object)currentAspect.getPosition(), (Object)stepControlAspect.getPosition())) continue;
            aspectNumber = rowIndex;
            LOGGER.info("Found the aspect to activate at row: {}, aspectNumber: {}", (Object)rowIndex, (Object)aspectNumber);
            break;
        }
        this.firePerformAspect(aspectNumber);
    }

    private void firePerformOppositeAspect(StepControlAspect stepControlAspect) {
        LOGGER.info("Opposite aspect is performed on stepControlAspect: {}", (Object)stepControlAspect);
        int aspectNumber = -1;
        int totalRows = this.aspectTable.getRowCount();
        for (int rowIndex = 0; rowIndex < totalRows; ++rowIndex) {
            StepControlAspect currentAspect = (StepControlAspect)this.getSortableTableModel().getValueAt(rowIndex, 1);
            if (!Objects.equals((Object)currentAspect.getOppositePosition(), (Object)stepControlAspect.getOppositePosition())) continue;
            aspectNumber = rowIndex + totalRows;
            LOGGER.info("Found the opposite aspect to activate at row: {}, aspectNumber: {}", (Object)rowIndex, (Object)aspectNumber);
            break;
        }
        this.firePerformAspect(aspectNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePerformAspect(int aspectNumber) {
        LOGGER.info("The controlling aspect is performed, current aspectNumber: {}", (Object)aspectNumber);
        Accessory accessory = new Accessory();
        accessory.setId(Integer.valueOf(0));
        if (aspectNumber < 0 || aspectNumber > 48) {
            LOGGER.warn("The current aspect has no valid aspectNumber assigned (0..{}). Abort perform aspect: {}", (Object)48, (Object)aspectNumber);
            return;
        }
        this.stepControlController.activateAspect(accessory, aspectNumber);
        AspectExecutionModel aspectExecutionModel = this.aspectExecutionModel;
        synchronized (aspectExecutionModel) {
            this.aspectExecutionModel.setAspectId(aspectNumber);
        }
    }

    private void firePerformSpeed() {
        int speed = this.stepControlModel.getSpeed();
        LOGGER.info("Write the speed value: {}", (Object)speed);
        this.writeCvValue("speed", speed);
    }

    private void firePerformAccel() {
        int accel = this.stepControlModel.getAccel();
        this.writeCvValue("accel", accel);
    }

    private void firePerformDecel() {
        int decel = this.stepControlModel.getDecel();
        this.writeCvValue("decel", decel);
    }

    private void writeCvValue(String keyword, int modelValue) {
        try {
            ArrayList<ConfigurationVariable> cvList = new ArrayList<ConfigurationVariable>();
            CvNode speedNode = StepControlCvUtils.getNode(this.mapKeywordToNode, keyword);
            CvValueUtils.compareAndAddNewValue(speedNode, Integer.toString(modelValue), cvList, this.getCvNumberToNodeMap(this.selectedNode));
            LOGGER.info("Write CV value, keyword: {}, modelValue: {}, cvList: {}", new Object[]{keyword, modelValue, cvList});
            if (CollectionUtils.isNotEmpty(cvList)) {
                this.fireWriteConfigVariables(cvList);
            } else {
                LOGGER.warn("No CV values to write found.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Set the new {} value failed.", (Object)keyword, (Object)ex);
        }
    }

    private void readCurrentValuesFromCV(NodeInterface node) {
        LOGGER.info("Read the values from CV for node: {}", (Object)node);
        if (node == null || !ProductUtils.isStepControl((long)node.getUniqueId())) {
            LOGGER.warn("No node available or not a StepControl: {}", (Object)node);
            if (this.mapKeywordToNode != null) {
                this.mapKeywordToNode.clear();
            }
            return;
        }
        LOGGER.info("Get the cvDefinitionTreeTableModel from the node: {}", (Object)node);
        CvDefinitionPanelController cvDefinitionPanelController = (CvDefinitionPanelController)DefaultApplicationContext.getInstance().get("cvDefinitionPanelController", CvDefinitionPanelController.class);
        CvDefinitionTreeTableModel cvDefinitionTreeTableModel = cvDefinitionPanelController.getCvDefinitionTreeTableModel(node);
        LOGGER.info("Current cvDefinitionTreeTableModel: {}", (Object)cvDefinitionTreeTableModel);
        if (cvDefinitionTreeTableModel != null) {
            this.mapKeywordToNode = new LinkedHashMap<String, CvNode>();
            DefaultExpandableRow rootNode = (DefaultExpandableRow)cvDefinitionTreeTableModel.getRoot();
            if (rootNode != null) {
                CvNodeUtils.harvestKeywordNodes((DefaultExpandableRow)rootNode, this.mapKeywordToNode);
            }
            LOGGER.info("Found keywords in nodes: {}", this.mapKeywordToNode.keySet());
            CvNode cvNodeSpeed = StepControlCvUtils.getNode(this.mapKeywordToNode, "speed");
            int maxSpeed = 2001;
            int minSpeed = 1;
            if (cvNodeSpeed != null) {
                try {
                    maxSpeed = Integer.parseInt(cvNodeSpeed.getCV().getMax()) + 1;
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the max speed from CV definition failed.", (Throwable)ex);
                }
                try {
                    minSpeed = Integer.parseInt(cvNodeSpeed.getCV().getMin());
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the min speed from CV definition failed.", (Throwable)ex);
                }
            }
            this.boundedRangeAdapterSpeed.setMinimum(minSpeed);
            this.boundedRangeAdapterSpeed.setMaximum(maxSpeed);
            this.speedRangeFilter.setMin(minSpeed);
            this.speedRangeFilter.setMax(maxSpeed);
        } else {
            LOGGER.warn("No cvDefinitionTreeTableModel available for node: {}", (Object)node);
        }
        if (MapUtils.isNotEmpty(this.mapKeywordToNode)) {
            ArrayList<ConfigurationVariable> configVariables = new ArrayList<ConfigurationVariable>();
            Map<String, CvNode> cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
            for (CvNode cvNode : this.mapKeywordToNode.values()) {
                this.prepareConfigVariables(cvNode, configVariables, cvNumberToNodeMap);
            }
            this.requiredConfigVariables.clear();
            if (CollectionUtils.isNotEmpty(configVariables)) {
                this.requiredConfigVariables.addAll(configVariables);
            }
            this.prepareGetCurrentPosition(configVariables);
            this.fireLoadConfigVariables(configVariables);
        } else {
            LOGGER.warn("No values available in mapKeywordToNode!");
        }
    }

    private void prepareConfigVariables(CvNode cvNode, List<ConfigurationVariable> configVariables, Map<String, CvNode> cvNumberToNodeMap) {
        try {
            switch (cvNode.getCV().getType()) {
                case LONG: {
                    LongCvNode masterNode = ((LongCvNode)cvNode).getMasterNode();
                    this.addConfigVariableDistinct(configVariables, masterNode.getConfigVar());
                    for (CvNode slaveNode : masterNode.getSlaveNodes()) {
                        this.addConfigVariableDistinct(configVariables, slaveNode.getConfigVar());
                    }
                    break;
                }
                case INT: {
                    this.addConfigVariableDistinct(configVariables, cvNode.getConfigVar());
                    int highCvNum = Integer.parseInt(cvNode.getCV().getHigh());
                    int cvNumber = Integer.parseInt(cvNode.getCV().getNumber());
                    if (highCvNum == cvNumber) {
                        CvNode lowCvNode = cvNumberToNodeMap.get(cvNode.getCV().getLow());
                        this.addConfigVariableDistinct(configVariables, lowCvNode.getConfigVar());
                        break;
                    }
                    CvNode highCvNode = cvNumberToNodeMap.get(cvNode.getCV().getHigh());
                    if (highCvNode == null) {
                        LOGGER.warn("The highCvNode is not available: {}", (Object)cvNode.getCV());
                    }
                    this.addConfigVariableDistinct(configVariables, highCvNode.getConfigVar());
                    break;
                }
                default: {
                    this.addConfigVariableDistinct(configVariables, cvNode.getConfigVar());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Prepare config variables to read from node failed.", (Throwable)ex);
        }
    }

    private void addConfigVariableDistinct(List<ConfigurationVariable> configVariables, ConfigurationVariable cv) {
        if (!configVariables.contains(cv)) {
            configVariables.add(cv);
        } else {
            LOGGER.info("Skip add CV because it's in the list already: {}", (Object)cv);
        }
    }

    public void addCvDefinitionRequestListener(CvDefinitionRequestListener l) {
        this.cvDefinitionRequestListeners.add(l);
    }

    private List<ConfigurationVariable> fireLoadConfigVariables(List<ConfigurationVariable> configVariables) {
        LOGGER.info("Load the config variables.");
        Iterator<CvDefinitionRequestListener> iterator = this.cvDefinitionRequestListeners.iterator();
        if (iterator.hasNext()) {
            CvDefinitionRequestListener l = iterator.next();
            return l.loadCvValues(configVariables);
        }
        return Collections.emptyList();
    }

    private JComponent buildLeftAlignedButtonBar(JPanel container, JComponent ... button) {
        return new ButtonBarBuilder(container).addButton(button).addGlue().build();
    }

    private JComponent buildLeftAlignedButtonBar(JComponent ... button) {
        return new ButtonBarBuilder().addButton(button).addGlue().build();
    }

    @Override
    public JPanel getComponent() {
        return this.component;
    }

    public String getName() {
        return Resources.getString(this.getClass(), (String)"name");
    }

    @Override
    public void tabSelected(boolean selected) {
        LOGGER.info("Tab is selected: {}, initialized: {}", (Object)selected, (Object)this.initialized);
        this.toolbarCvDefinition.setVisible(selected);
        if (selected) {
            if (this.selectedNode == null) {
                LOGGER.info("The tab is selected but the selected node is not available. Call cvDefinitionChanged() to initially load the data of the selected node.");
                this.cvDefinitionChanged();
            }
            this.triggerLoadCvValues();
        }
        if (!(selected || this.selectedNode == null || this.mainModel.getSelectedNode() != null && this.mainModel.getSelectedNode().equals((Object)this.selectedNode))) {
            LOGGER.info("The tab is no longer selected and the selected node is null or has changed, reset the selected node!");
            this.selectedNode = null;
            LOGGER.info("Clear the mode and set operational mode to unknown.");
            this.stepControlModel.setOperationalMode(StepControlModel.OperationModeEnum.unknown);
        }
    }

    public void triggerLoadCvValues() {
        NodeInterface node = this.selectedNode;
        LOGGER.info("Load the CV values for node: {}, initialized: {}, cvValuesLoaded: {}", new Object[]{node, this.initialized, this.cvValuesLoaded});
        if (!this.cvValuesLoaded.get() && !this.initialized && this.selectedNode != null) {
            LOGGER.info("The CV values will be read from node.");
            this.statusBar.setStatusText(Resources.getString(StepControlPanel.class, (String)"loading_cvvalues"));
            this.cvValuesLoaded.set(true);
            SwingUtilities.invokeLater(() -> this.readCurrentValuesFromCV(node));
        } else {
            LOGGER.info("Skip loading CV values because the initialized is true.");
        }
    }

    private void fireCreateNewAspect() {
        if (this.stepControlModel.getStepControlAspects().size() < this.stepControlModel.getMaxConfiguredAspects()) {
            int selectedRow = this.aspectTable.getSelectedRow();
            if (selectedRow > -1 && !this.aspectTable.checkAspectEditorIsDirty(selectedRow)) {
                LOGGER.info("Check if aspect editor is dirty failed. Do not show the add aspect editor.");
                return;
            }
            LOGGER.info("Create the editorPanel to create a new aspect.");
            StepControlAspect stepControlAspect = new StepControlAspect(null, null, StepControlAspect.Polarity.normal);
            AddAspectCallbackListener aspectCallbackListener = new AddAspectCallbackListener();
            AspectEditorPanel aspectEditorPanel = this.aspectTable.createAspectEditorPanel(aspectCallbackListener, stepControlAspect, this.stepControlModel, AspectEditorPanel.EditorType.editorNew);
            AddAspectDialog aspectDialog = new AddAspectDialog(JOptionPane.getFrameForComponent(this.component), Resources.getString(StepControlPanel.class, (String)"dialog_add_aspect"), true, aspectEditorPanel);
            aspectCallbackListener.setAddAspectDialog(aspectDialog);
            aspectDialog.setVisible(true);
            if (aspectDialog.getResult() == 0) {
                LOGGER.info("User added new aspect: {}", (Object)stepControlAspect);
            } else {
                LOGGER.info("User cancelled add new aspect.");
            }
            aspectDialog.cleanup();
        } else {
            LOGGER.warn("Maximum number of aspects reached.");
            JOptionPane.showMessageDialog(this.component, Resources.getString(StepControlPanel.class, (String)"max_aspect_message"), Resources.getString(StepControlPanel.class, (String)"max_aspect_title"), 0);
        }
    }

    private void selectAspectByPosition(StepControlAspect stepControlAspect) {
        for (int rowIndex = 0; rowIndex < this.aspectTable.getRowCount(); ++rowIndex) {
            Object position = this.getSortableTableModel().getValueAt(rowIndex, 1);
            LOGGER.info("Current position: {}", position);
            Assert.isInstanceOf(StepControlAspect.class, (Object)position);
            if (!Objects.equals((Object)position, (Object)stepControlAspect)) continue;
            LOGGER.info("Found configured aspect to select with the same position: {} at rowIndex: {}", position, (Object)rowIndex);
            this.aspectTable.setRowSelectionInterval(rowIndex, rowIndex);
            LOGGER.info("Expand row: {}", (Object)rowIndex);
            this.aspectTable.expandRow(rowIndex);
            this.aspectTable.scrollRowToVisible(rowIndex);
            break;
        }
        LOGGER.info("Select aspect by position has finished.");
    }

    private void fireRemoveAspect() {
        LOGGER.info("Remove aspect.");
        int selectedRow = this.aspectTable.getSelectedRow();
        if (selectedRow > -1) {
            int sortedRow = this.getSortableTableModel().getSortedRowAt(selectedRow);
            AspectTableModel aspectTableModel = (AspectTableModel)this.getSortableTableModel().getActualModel();
            Object aspect = aspectTableModel.getChildValueAt(sortedRow);
            if (aspect instanceof StepControlAspect) {
                StepControlAspect stepControlAspect = (StepControlAspect)aspect;
                LOGGER.info("Remove aspect from stepControlModel: {}", (Object)stepControlAspect);
                this.stepControlModel.removeStepControlAspect(stepControlAspect);
            }
        }
    }

    private void fireRemoveAllAspects() {
        LOGGER.info("Remove all aspects.");
        int totalRows = this.aspectTable.getRowCount();
        if (totalRows > 0) {
            boolean continueDeleteAspects = TaskDialogs.build((Window)JOptionPane.getFrameForComponent(this.component), (String)Resources.getString(StepControlPanel.class, (String)"deleteAllAspects-confirm.instruction"), (String)Resources.getString(StepControlPanel.class, (String)"deleteAllAspects-confirm")).title(Resources.getString(StepControlPanel.class, (String)"deleteAllAspects-confirm.title")).isConfirmed();
            LOGGER.info("The user confirmed to continue delete all aspects: {}", (Object)continueDeleteAspects);
            if (continueDeleteAspects) {
                this.removeAllAspects();
            }
        }
    }

    private void removeAllAspects() {
        this.aspectTable.collapseAllRows();
        this.stepControlModel.setStepControlAspects(null);
    }

    private void fireImportAspectsFromExcel() {
        LOGGER.info("Import all aspects from excel.");
        final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_STEPCONTROL_EXPORT_KEY);
        FileNameExtensionFilter ff = new FileNameExtensionFilter(Resources.getString(StepControlPanel.class, (String)"filter") + " (*.xlsx)", "xlsx");
        FileDialog dialog = new FileDialog(this.component, 0, storedWorkingDirectory, null, new FileFilter[]{ff}){

            public void approve(String selectedFile) {
                File file = new File(selectedFile);
                selectedFile = file.getName();
                try {
                    StepControlPanel.this.loadAspectsFromExcel(file);
                    String exportDir = file.getParent();
                    LOGGER.info("Save current exportDir: {}", (Object)exportDir);
                    wizardSettings.setWorkingDirectory(StepControlPanel.WORKING_DIR_STEPCONTROL_EXPORT_KEY, exportDir);
                }
                catch (PositionOutOfRangeException ex) {
                    LOGGER.warn("Load aspects from excel file failed because invalid data was detected.", (Throwable)ex);
                    TaskDialogs.build((Window)JOptionPane.getFrameForComponent(StepControlPanel.this.getComponent()), (String)Resources.getString(StepControlPanel.class, (String)"import-aspects-from-excel-invalid-data.instruction"), (String)(Resources.getString(StepControlPanel.class, (String)"import-aspects-from-excel-invalid-data.text") + Resources.getString(StepControlPanel.class, (String)"position-out-of-range.text", (Object[])new Object[]{ex.getAspectNumber(), ex.getPosition(), ex.getMin(), ex.getMax()}))).title(Resources.getString(StepControlPanel.class, (String)"import-aspects-from-excel-failed.title")).showException((Throwable)ex);
                }
                catch (IOException | DataExchangeException ex) {
                    LOGGER.warn("Load aspects from excel file failed.", (Throwable)ex);
                    TaskDialogs.build((Window)JOptionPane.getFrameForComponent(StepControlPanel.this.getComponent()), (String)Resources.getString(StepControlPanel.class, (String)"import-aspects-from-excel-failed.instruction"), (String)Resources.getString(StepControlPanel.class, (String)"import-aspects-from-excel-failed.text")).title(Resources.getString(StepControlPanel.class, (String)"import-aspects-from-excel-failed.title")).showException((Throwable)ex);
                }
            }
        };
        dialog.showDialog();
    }

    private void fireExportAspectsToExcel() {
        LOGGER.info("Export all aspects to excel.");
        final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_STEPCONTROL_EXPORT_KEY);
        Object filename = "StepControl-export-" + NodeUtils.getNodeName((NodeInterface)this.selectedNode) + ".xlsx";
        if (!FileUtils.isFilenameValid((String)filename)) {
            filename = FileUtils.escapeInvalidFilenameCharacters((String)filename, "_");
        }
        FileNameExtensionFilter ff = new FileNameExtensionFilter(Resources.getString(StepControlPanel.class, (String)"filter") + " (*.xlsx)", "xlsx");
        FileDialog dialog = new FileDialog(this.component, 1, storedWorkingDirectory, (String)filename, new FileFilter[]{ff}){

            public void approve(String selectedFile) {
                File file = new File(selectedFile);
                selectedFile = file.getName();
                selectedFile = this.makeSureFileNameHasExtension(selectedFile, "xlsx");
                try {
                    StepControlPanel.this.writeAspectsToExcel(file);
                    String exportDir = file.getParent();
                    LOGGER.info("Save current exportDir: {}", (Object)exportDir);
                    wizardSettings.setWorkingDirectory(StepControlPanel.WORKING_DIR_STEPCONTROL_EXPORT_KEY, exportDir);
                }
                catch (Exception ex) {
                    LOGGER.warn("Save aspects to excel file failed.", (Throwable)ex);
                    TaskDialogs.build((Window)JOptionPane.getFrameForComponent(StepControlPanel.this.getComponent()), (String)Resources.getString(StepControlPanel.class, (String)"export-aspects-to-excel-failed.instruction"), (String)Resources.getString(StepControlPanel.class, (String)"export-aspects-to-excel-failed.text")).title(Resources.getString(StepControlPanel.class, (String)"export-aspects-to-excel-failed.title")).showException((Throwable)ex);
                }
            }
        };
        dialog.showDialog();
    }

    private void loadAspectsFromExcel(File excelFile) throws IOException, PositionOutOfRangeException {
        LOGGER.info("Load aspects from excel file: {}", (Object)excelFile);
        List<ImportAspect> importAspects = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(excelFile));){
            ExcelAspectReader reader = new ExcelAspectReader();
            importAspects = reader.readAspects(is);
        }
        if (CollectionUtils.isNotEmpty(importAspects)) {
            LOGGER.info("Import the aspects.");
            ArrayList<ImportAspect> importAspectsOpposite = new ArrayList<ImportAspect>();
            if (TurnTableType.round == this.stepControlModel.getTurnTableType()) {
                int totalSteps = this.stepControlModel.getTotalSteps().intValue();
                int oppositePositionStartPosition = totalSteps / 2;
                int size = importAspects.size();
                LOGGER.info("Number of import aspects: {}", (Object)size);
                importAspectsOpposite.addAll(importAspects.subList(size / 2, size));
                importAspects.removeAll(importAspectsOpposite);
                int aspectNumber = 0;
                for (ImportAspect importAspect : importAspects) {
                    if (importAspect.getPosition() < 0 || importAspect.getPosition() >= oppositePositionStartPosition) {
                        LOGGER.warn("Invalid values detected: {}", (Object)importAspect);
                        throw new PositionOutOfRangeException(importAspect.getPosition(), 0L, oppositePositionStartPosition - 1, aspectNumber);
                    }
                    ++aspectNumber;
                }
                for (ImportAspect importAspect : importAspectsOpposite) {
                    if (importAspect.getPosition() < oppositePositionStartPosition || importAspect.getPosition() >= totalSteps) {
                        LOGGER.warn("Invalid values detected: {}", (Object)importAspect);
                        throw new PositionOutOfRangeException(importAspect.getPosition(), oppositePositionStartPosition, totalSteps - 1, aspectNumber);
                    }
                    ++aspectNumber;
                }
            }
            LOGGER.info("Current importAspects: {}", importAspects);
            LOGGER.info("Current importAspectsOpposite: {}", importAspectsOpposite);
            this.removeAllAspects();
            ArrayList<StepControlAspect> stepControlAspects = new ArrayList<StepControlAspect>();
            int index = 0;
            for (ImportAspect importAspect : importAspects) {
                StepControlAspect stepControlAspect = new StepControlAspect(null, Long.valueOf(importAspect.getPosition()), importAspect.isInverse() ? StepControlAspect.Polarity.inverted : StepControlAspect.Polarity.normal);
                if (TurnTableType.round == this.stepControlModel.getTurnTableType()) {
                    ImportAspect importAspectOpposite = (ImportAspect)importAspectsOpposite.get(index);
                    stepControlAspect.setOppositePosition(Long.valueOf(importAspectOpposite.getPosition()));
                    stepControlAspect.setOppositePolarity(importAspectOpposite.isInverse() ? StepControlAspect.Polarity.inverted : StepControlAspect.Polarity.normal);
                }
                stepControlAspects.add(stepControlAspect);
                ++index;
            }
            this.stepControlModel.setStepControlAspects(stepControlAspects);
            this.getSortableTableModel().fireTableDataChanged();
            this.aspectTable.expandAllRows();
        } else {
            LOGGER.info("No aspects loaded.");
        }
    }

    private void writeAspectsToExcel(File excelFile) {
        LOGGER.info("Write aspects to excel file: {}", (Object)excelFile);
        ArrayList<ImportAspect> importAspects = new ArrayList<ImportAspect>();
        int aspectNumber = 0;
        for (StepControlAspect aspect : this.stepControlModel.getStepControlAspects()) {
            importAspects.add(new ImportAspect(aspectNumber, aspect.getPosition().intValue(), aspect.getPolarity() == StepControlAspect.Polarity.inverted));
            ++aspectNumber;
        }
        if (TurnTableType.round == this.stepControlModel.getTurnTableType()) {
            for (StepControlAspect aspect : this.stepControlModel.getStepControlAspects()) {
                importAspects.add(new ImportAspect(aspectNumber, aspect.getOppositePosition().intValue(), aspect.getOppositePolarity() == StepControlAspect.Polarity.inverted));
                ++aspectNumber;
            }
        }
        Map<String, CvNode> cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
        Integer stepCount = StepControlCvUtils.getConfigVarIntValue(this.mapKeywordToNode, cvNumberToNodeMap, "stepcount");
        MicroStepsEnum microStepsEnum = StepControlCvUtils.getValidMicroStepping(this.mapKeywordToNode, cvNumberToNodeMap);
        ExcelAspectReader.MotorData motorData = new ExcelAspectReader.MotorData(stepCount, microStepsEnum.getSteps(), this.stepControlModel.getTotalSteps().intValue(), this.stepControlModel.getTurnTableType());
        ExcelAspectReader reader = new ExcelAspectReader();
        reader.writeAspects(this.selectedNode, excelFile, importAspects, motorData);
    }

    private void fireConfigurationWizard() {
        LOGGER.info("Open the configuration wizard.");
        try {
            Map<String, CvNode> cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
            ConfigurationWizardModel configurationWizardModel = ConfigurationWizard.prepareConfigurationModel(this.selectedNode, this.stepControlModel.getTurnTableType(), cvNumberToNodeMap, this.mapKeywordToNode);
            ConfigurationWizard wizard = new ConfigurationWizard(configurationWizardModel);
            wizard.showWizard(this.component);
            if (configurationWizardModel.getWizardStatus() == ConfigurationWizardModel.WizardStatus.finished) {
                this.writeConfigurationValues(configurationWizardModel, cvNumberToNodeMap, this.mapKeywordToNode);
            } else {
                LOGGER.info("The configurationWizardModel is not available.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Show configuration wizard failed.", (Throwable)ex);
            TaskDialogs.build((Window)JOptionPane.getFrameForComponent(this.getComponent()), (String)Resources.getString(StepControlPanel.class, (String)"show-config-wizard-failed.instruction"), (String)Resources.getString(StepControlPanel.class, (String)"show-config-wizard-failed.text")).title(Resources.getString(StepControlPanel.class, (String)"show-config-wizard-failed.title")).showException((Throwable)ex);
        }
    }

    public void cvDefinitionChanged() {
        LOGGER.info("The cv definition has changed, selected node: {}", (Object)this.selectedNode);
        if (this.selectedNode != null && this.selectedNode.equals((Object)this.mainModel.getSelectedNode()) || this.selectedNode == null && (this.mainModel.getSelectedNode() == null || !ProductUtils.isStepControl((long)this.mainModel.getSelectedNode().getUniqueId()))) {
            LOGGER.info("The node in the model has not changed or is not a StepControl.");
            return;
        }
        if (this.selectedNode != null) {
            LOGGER.info("Remove the port value listener from the previous selected node.");
            this.selectedNode.removePortValueListener(MotorPort.class, (PortValueListener)this);
        }
        LOGGER.info("Reset the cv values loaded flag.");
        this.cvValuesLoaded.set(false);
        this.initialized = false;
        if (this.readCvButton != null) {
            this.readCvButton.setEnabled(false);
        }
        if (this.writeCvButton != null) {
            this.writeCvButton.setEnabled(false);
        }
        this.selectedNode = null;
        NodeInterface currentSelectedNode = this.mainModel.getSelectedNode();
        if (ProductUtils.isStepControl((long)currentSelectedNode.getUniqueId())) {
            this.selectedNode = currentSelectedNode;
        }
        try {
            this.aspectTable.getModel().removeTableModelListener(this.aspectTableModelListener);
            this.stepControlModel.clearModel();
        }
        finally {
            this.aspectTable.getModel().addTableModelListener(this.aspectTableModelListener);
        }
        this.requiredConfigVariables.clear();
        if (this.mapKeywordToNode != null) {
            LOGGER.info("Clear the mapKeywordToNode.");
            this.mapKeywordToNode.clear();
        }
        this.resetPendingChanges();
        this.updateToolbarButtons();
        if (this.selectedNode != null && ProductUtils.isStepControl((long)this.selectedNode.getUniqueId())) {
            LOGGER.info("The currently selected node is a StepControl.");
            this.selectedNode.addPortValueListener(MotorPort.class, (PortValueListener)this);
            this.fieldsToUpdate.add("configured_aspects");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cvDefinitionValuesChanged(boolean read, List<String> changedNames) {
        LOGGER.info("The cv definition values have changed, read: {}, changedNames: {}", (Object)read, changedNames);
        this.cvDefinitionChanged();
        if (this.selectedNode == null || !ProductUtils.isStepControl((long)this.selectedNode.getUniqueId())) {
            LOGGER.info("The currently selected node is not a StepControl.");
            return;
        }
        Map<String, CvNode> cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
        AtomicBoolean errorDetected = new AtomicBoolean();
        if (changedNames.contains("STEPPOS")) {
            try {
                long currentPosition = StepControlCvUtils.getConfigVarLongValueFromStringByCvKey(cvNumberToNodeMap, "STEPPOS");
                this.stepControlModel.setCurrentPosition(currentPosition);
                LOGGER.info("The current position was read and no more CV values are updated! The current position is: {}", (Object)currentPosition);
            }
            catch (Exception ex) {
                LOGGER.warn("Update the current position failed.", (Throwable)ex);
            }
        }
        if (MapUtils.isEmpty(this.mapKeywordToNode)) {
            LOGGER.info("No mapKeywordToNode value available.");
            return;
        }
        if (changedNames.contains(this.getCvName("totalsteps"))) {
            try {
                Long totalSteps = StepControlCvUtils.getConfigVarLongValue(this.mapKeywordToNode, "totalsteps");
                LOGGER.info("Current total steps: {}", (Object)totalSteps);
                this.stepControlModel.setTotalSteps(totalSteps);
                if (this.angleRenderer != null) {
                    this.angleRenderer.setTotalSteps(totalSteps);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Set the total step count failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("tabletype"))) {
            try {
                Integer value = StepControlCvUtils.getConfigVarIntValue(this.mapKeywordToNode, cvNumberToNodeMap, "tabletype");
                TurnTableType turnTableType = TurnTableType.fromValue((byte)ByteUtils.getLowByte((Integer)value));
                this.stepControlModel.setTurnTableType(turnTableType);
                int maxConfiguredAspects = 48;
                switch (turnTableType) {
                    case round: {
                        maxConfiguredAspects = 24;
                        break;
                    }
                    case pendular: {
                        maxConfiguredAspects = 2;
                        break;
                    }
                }
                this.stepControlModel.setMaxConfiguredAspects(maxConfiguredAspects);
                LOGGER.info("The turnTableType was set to: {}, maxConfiguredAspects: {}", (Object)turnTableType, (Object)maxConfiguredAspects);
            }
            catch (Exception ex) {
                LOGGER.warn("Set the turnTableType failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("speed"))) {
            try {
                Integer speed = StepControlCvUtils.getConfigVarIntValue(this.mapKeywordToNode, cvNumberToNodeMap, "speed");
                this.stepControlModel.setSpeed(speed);
            }
            catch (Exception ex) {
                LOGGER.warn("Set the speed failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("accel"))) {
            try {
                Integer accel = StepControlCvUtils.getConfigVarIntValue(this.mapKeywordToNode, cvNumberToNodeMap, "accel");
                this.stepControlModel.setAccel(accel);
            }
            catch (Exception ex) {
                LOGGER.warn("Set the accel failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("decel"))) {
            try {
                Integer decel = StepControlCvUtils.getConfigVarIntValue(this.mapKeywordToNode, cvNumberToNodeMap, "decel");
                this.stepControlModel.setDecel(decel);
            }
            catch (Exception ex) {
                LOGGER.warn("Set the decel failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("stepcount")) || changedNames.contains(this.getCvName("unit"))) {
            Integer stepCount = StepControlCvUtils.getConfigVarIntValue(this.mapKeywordToNode, cvNumberToNodeMap, "stepcount");
            MicroStepsEnum microStepsEnum = StepControlCvUtils.getValidMicroStepping(this.mapKeywordToNode, cvNumberToNodeMap);
            Integer unitSystemValue = StepControlCvUtils.getConfigVarByteValue(this.mapKeywordToNode, cvNumberToNodeMap, "unit");
            MovementScaleEnum movementScale = MovementScaleEnum.scale1;
            if (unitSystemValue != null) {
                int bitSpeed = ByteUtils.getBit((int)unitSystemValue, (int)0);
                movementScale = bitSpeed > 0 ? MovementScaleEnum.scale0_1 : MovementScaleEnum.scale1;
            }
            long maxSpeedValid = SpeedRangeValidationUtils.calculateValidMaxSpeed(microStepsEnum.getSteps(), stepCount, movementScale);
            int currentMaxSpeed = this.boundedRangeAdapterSpeed.getMaximum();
            LOGGER.info("Current speed range maximum in bounded range adapter is: {}", (Object)currentMaxSpeed);
            if ((long)currentMaxSpeed > maxSpeedValid) {
                LOGGER.info("The configured maxSpeed ({}) in bounded range adapter exceeds the limit: {}. Update the maxSpeed in bounded range adapter to limit.", (Object)currentMaxSpeed, (Object)maxSpeedValid);
                this.boundedRangeAdapterSpeed.setMaximum((int)maxSpeedValid);
                this.speedRangeFilter.setMax((int)maxSpeedValid);
                int currentSpeed = this.stepControlModel.getSpeed();
                if ((long)currentSpeed > maxSpeedValid) {
                    LOGGER.warn("Set the current speed to the maximum valid speed: {}", (Object)maxSpeedValid);
                    this.stepControlModel.setSpeed((int)maxSpeedValid);
                }
                if (this.speedSlider != null) {
                    this.speedSlider.updateUI();
                }
            }
            try {
                long accelDecelLimit = 191500L;
                AccelarationScaleEnum accelarationScale = AccelarationScaleEnum.SCALE1;
                if (unitSystemValue != null) {
                    int bitAccelaration = ByteUtils.getBit((int)unitSystemValue, (int)4);
                    AccelarationScaleEnum accelarationScaleEnum = accelarationScale = bitAccelaration > 0 ? AccelarationScaleEnum.SCALE0_1 : AccelarationScaleEnum.SCALE1;
                }
                if (accelarationScale == AccelarationScaleEnum.SCALE0_1) {
                    accelDecelLimit = 19150L;
                }
                long accelarationFactor = SpeedRangeValidationUtils.calculateValidAccelarationFactor(microStepsEnum.getSteps(), stepCount);
                long minAccel = accelarationFactor * (long)this.stepControlModel.getAccel();
                LOGGER.info("The calculated minAccel: {}, current accelDecelLimit: {}", (Object)minAccel, (Object)accelDecelLimit);
                if (minAccel < accelDecelLimit) {
                    long adjustedAccelValue = accelDecelLimit / accelarationFactor;
                    LOGGER.warn("Set the current accel value to minimum: {}", (Object)adjustedAccelValue);
                    this.stepControlModel.setAccel((int)adjustedAccelValue);
                }
                long minDecel = accelarationFactor * (long)this.stepControlModel.getDecel();
                LOGGER.info("The calculated minDecel: {}, current accelDecelLimit: {}", (Object)minDecel, (Object)accelDecelLimit);
                if (minDecel < accelDecelLimit) {
                    long adjustedDecelValue = accelDecelLimit / accelarationFactor;
                    LOGGER.warn("Set the current decel value to minimum: {}", (Object)adjustedDecelValue);
                    this.stepControlModel.setDecel((int)adjustedDecelValue);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Set or adjust the decel value failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("push_interval"))) {
            try {
                Integer pushInterval = StepControlCvUtils.getConfigVarByteValue(this.mapKeywordToNode, cvNumberToNodeMap, "push_interval");
                this.stepControlModel.setPushInterval(pushInterval);
            }
            catch (Exception ex) {
                LOGGER.warn("Set the push interval failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("bridge"))) {
            Integer cvNodeBridge = StepControlCvUtils.getConfigVarByteValue(this.mapKeywordToNode, cvNumberToNodeMap, "bridge");
            LOGGER.info("Current cvNodeBridge: {}", (Object)cvNodeBridge);
            if (cvNodeBridge != null) {
                int bridge = 0;
                try {
                    bridge = cvNodeBridge;
                    LOGGER.info("Current bridge value: {}", (Object)bridge);
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the bridge value from CVs failed.", (Throwable)ex);
                }
            }
        }
        if (!this.initialized && read) {
            LOGGER.info("The values were read, update the aspects in the table.");
            this.fieldsToUpdate.add("configured_aspects");
        }
        if (this.fieldsToUpdate.contains("configured_aspects")) {
            LOGGER.info("Prepare the configured aspects.");
            List<StepControlAspect> configuredAspects = this.prepareConfiguredAspects(cvNumberToNodeMap, errorDetected);
            try {
                this.aspectTable.getModel().removeTableModelListener(this.aspectTableModelListener);
                this.stepControlModel.setStepControlAspects(configuredAspects);
            }
            finally {
                this.aspectTable.getModel().addTableModelListener(this.aspectTableModelListener);
            }
            this.fieldsToUpdate.remove("configured_aspects");
            this.getSortableTableModel().fireTableDataChanged();
            this.aspectTable.expandAllRows();
        }
        if (!this.initialized && !errorDetected.get()) {
            this.initialized = true;
            LOGGER.info("The panel was initialized. Reset the pending changes flag on the tab.");
            this.tabStatusListener.updatePendingChanges((Component)this.component, false);
        } else if (read) {
            LOGGER.info("The CV values were read from the node. Reset the pending changes flag on the tab.");
            this.tabStatusListener.updatePendingChanges((Component)this.component, false);
        } else if (!this.checkHasPendingAspects(cvNumberToNodeMap)) {
            LOGGER.info("No pending aspect changes detected. Reset the pending changes flag on the tab.");
            this.tabStatusListener.updatePendingChanges((Component)this.component, false);
        }
        this.updateToolbarButtons();
    }

    private void updateToolbarButtons() {
        if (this.selectedNode != null) {
            if (this.readCvButton != null) {
                this.readCvButton.setEnabled(MapUtils.isNotEmpty((Map)this.selectedNode.getConfigVariables()));
            }
            if (this.writeCvButton != null) {
                this.writeCvButton.setEnabled(MapUtils.isNotEmpty((Map)this.selectedNode.getConfigVariables()));
            }
        }
    }

    private String getCvName(String keyword) {
        CvNode cvNode = StepControlCvUtils.getNode(this.mapKeywordToNode, keyword);
        if (cvNode != null) {
            return cvNode.getConfigVar().getName();
        }
        return null;
    }

    private List<StepControlAspect> prepareConfiguredAspects(Map<String, CvNode> cvNumberToJideNodeMap, AtomicBoolean errorDetected) {
        boolean roundTurnTable = TurnTableType.round == this.stepControlModel.getTurnTableType();
        long oppositePositionStartPosition = -1L;
        Long totalSteps = this.stepControlModel.getTotalSteps();
        if (totalSteps != null && totalSteps > 0L) {
            oppositePositionStartPosition = totalSteps / 2L;
        }
        LOGGER.info("Prepare the aspects for turntable type: {}, totalSteps: {}, oppositePositionStartPosition: {}", new Object[]{this.stepControlModel.getTurnTableType(), totalSteps, oppositePositionStartPosition});
        StepControlAspect firstOppositeStepControlAspect = null;
        int maxAspectCount = 0;
        ArrayList<StepControlAspect> configuredAspects = new ArrayList<StepControlAspect>();
        int maxIndex = 48;
        for (int index = 0; index < maxIndex; ++index) {
            try {
                Integer targetPolarity = StepControlCvUtils.getConfigVarIntValue(this.mapKeywordToNode, cvNumberToJideNodeMap, String.format("target_polarity_%d", index));
                Long targetPosition = StepControlCvUtils.getConfigVarLongValue(this.mapKeywordToNode, String.format("target_position_%d", index));
                if (targetPosition < 0xFFFFFFFFL) {
                    StepControlAspect stepControlAspect = new StepControlAspect(null, (long)targetPosition, StepControlAspect.Polarity.valueOf(targetPolarity));
                    stepControlAspect.setStatus(StepControlAspect.AspectPersistanceStatus.statusPersistent);
                    LOGGER.info("Current index: {}, adding new stepControlAspect: {}", (Object)index, (Object)stepControlAspect);
                    configuredAspects.add(stepControlAspect);
                    if (!roundTurnTable || firstOppositeStepControlAspect != null || stepControlAspect.getPosition() < oppositePositionStartPosition) continue;
                    firstOppositeStepControlAspect = stepControlAspect;
                    LOGGER.info("Found the first opposite position aspect based on the position and totalSteps at position: {}, firstOppositeStepControlAspect: {}", (Object)stepControlAspect.getPosition(), (Object)firstOppositeStepControlAspect);
                    maxAspectCount = configuredAspects.size() - 1;
                    continue;
                }
                LOGGER.info("No active position at index {}, skip further creation of aspects, position: {}", (Object)index, (Object)targetPosition);
                break;
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Prepare configured step control aspect failed: {}", (Object)ex.getMessage());
                errorDetected.set(true);
                continue;
            }
            catch (Exception ex) {
                LOGGER.warn("Prepare configured step control aspect failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (TurnTableType.round == this.stepControlModel.getTurnTableType()) {
            int maxTrackPositions = configuredAspects.size();
            LOGGER.info("Number of aspects read from cv values: {}", (Object)maxTrackPositions);
            if (maxAspectCount == 0 && maxTrackPositions > 0) {
                maxAspectCount = maxTrackPositions / 2;
            }
            ArrayList<StepControlAspect> mergedConfiguredAspects = new ArrayList<StepControlAspect>();
            boolean foundFirstOppositePosition = false;
            for (int index = 0; index < maxAspectCount; ++index) {
                StepControlAspect stepControlAspect = (StepControlAspect)configuredAspects.get(index);
                StepControlAspect stepControlAspectOpposite = null;
                if (index + maxAspectCount < maxTrackPositions) {
                    stepControlAspectOpposite = (StepControlAspect)configuredAspects.get(index + maxAspectCount);
                }
                LOGGER.info("Fetched stepControlAspect: {}, stepControlAspectOpposite: {}", (Object)stepControlAspect, stepControlAspectOpposite);
                if (stepControlAspectOpposite != null && stepControlAspectOpposite.getPosition() != null && stepControlAspectOpposite.getPosition() >= oppositePositionStartPosition) {
                    if (!foundFirstOppositePosition) {
                        LOGGER.info("The first opposite position was found: {}", (Object)stepControlAspectOpposite);
                        foundFirstOppositePosition = true;
                    }
                    LOGGER.info("Merge the values from opposite aspect: {}, stepControlAspect: {}", (Object)stepControlAspectOpposite, (Object)stepControlAspect);
                    stepControlAspect.setOppositePosition(stepControlAspectOpposite.getPosition());
                    stepControlAspect.setOppositePolarity(stepControlAspectOpposite.getPolarity());
                    LOGGER.info("Set the opposite aspect on aspect: {}", (Object)stepControlAspect);
                    stepControlAspect.setOppositeAspect(stepControlAspectOpposite);
                }
                LOGGER.info("Adding merged stepControlAspect: {}", (Object)stepControlAspect);
                mergedConfiguredAspects.add(stepControlAspect);
            }
            configuredAspects.clear();
            configuredAspects.addAll(mergedConfiguredAspects);
        } else if (TurnTableType.linear != this.stepControlModel.getTurnTableType() && TurnTableType.pendular == this.stepControlModel.getTurnTableType() && configuredAspects.size() > 2) {
            ArrayList subListAspects = new ArrayList(configuredAspects.subList(0, 2));
            configuredAspects.clear();
            configuredAspects.addAll(subListAspects);
        }
        return configuredAspects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executionStateChanged(AccessoryExecutionState executionState, Integer accessoryId, Integer aspect, AccessoryState accessoryState) {
        LOGGER.info("The execution state has changed: {}, accessoryId: {}, aspect: {}", new Object[]{executionState, accessoryId, aspect});
        if (aspect == null || executionState == null) {
            executionState = AccessoryExecutionState.IDLE;
        }
        this.executionStateIconLabel.setToolTipText(null);
        switch (executionState) {
            case ERROR: {
                this.executionStateIconLabel.setIcon(this.accessoryErrorIcon);
                this.executionStateIconLabel.setText(Resources.getString(StepControlPanel.class, (String)"unknown_error_aspect", (Object[])new Object[]{aspect}));
                if (accessoryState == null) break;
                this.executionStateIconLabel.setToolTipText(accessoryState.getErrorInformation());
                break;
            }
            case RUNNING: {
                this.executionStateIconLabel.setIcon(this.accessoryWaitIcon);
                this.executionStateIconLabel.setText(Resources.getString(StepControlPanel.class, (String)"executing_aspect", (Object[])new Object[]{aspect}));
                break;
            }
            case SUCCESSFUL: {
                this.executionStateIconLabel.setIcon(this.accessorySuccessfulIcon);
                this.executionStateIconLabel.setText(Resources.getString(StepControlPanel.class, (String)"active_aspect", (Object[])new Object[]{aspect}));
                break;
            }
            case UNKNOWN: {
                this.executionStateIconLabel.setIcon(this.accessoryUnknownIcon);
                this.executionStateIconLabel.setText(null);
                break;
            }
            default: {
                this.executionStateIconLabel.setIcon(null);
                this.executionStateIconLabel.setText(null);
            }
        }
        AspectExecutionModel aspectExecutionModel = this.aspectExecutionModel;
        synchronized (aspectExecutionModel) {
            if (this.aspectExecutionModel.getAccessoryId() == accessoryId && this.aspectExecutionModel.getAspectId() == aspect) {
                LOGGER.info("Update the aspectExecutionModel.");
                this.aspectExecutionModel.setExecutionState(executionState);
                this.aspectExecutionModel.setAccessoryState(accessoryState);
            }
        }
    }

    private void addToolBarButtons(VLToolBar toolBar) {
        this.readCvButton = this.makeNavigationButton("loadfromnode", "/32x32", READ, Resources.getString(this.getClass(), (String)"toolbar.readallcv"), Resources.getString(this.getClass(), (String)"toolbar.readallcv.alttext"));
        this.readCvButton.setEnabled(false);
        toolBar.add(this.readCvButton);
        this.readCvButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StepControlPanel.this.readCurrentValuesFromCV(StepControlPanel.this.selectedNode);
            }
        });
        this.writeCvButton = this.makeNavigationButton("savetonode", "/32x32", WRITE, Resources.getString(this.getClass(), (String)"toolbar.writeallcv"), Resources.getString(this.getClass(), (String)"toolbar.writeallcv.alttext"));
        toolBar.add(this.writeCvButton);
        this.writeCvButton.setEnabled(false);
        this.writeCvButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StepControlPanel.this.prepareAndWriteCvValuesToNode(false);
                }
                catch (InvalidAspectException ex) {
                    LOGGER.warn("Write CV value to node failed because an invalid aspect was detected.", (Throwable)ex);
                    int currentAspectIndex = ex.getAspectIndex();
                    if (currentAspectIndex > -1) {
                        LOGGER.info("Invalid data in currentAspectIndex: {}", (Object)currentAspectIndex);
                        StepControlPanel.this.aspectTable.expandRow(currentAspectIndex);
                        StepControlPanel.this.aspectTable.scrollRowToVisible(currentAspectIndex);
                    }
                    TaskDialogs.build((Window)JOptionPane.getFrameForComponent(StepControlPanel.this.getComponent()), (String)Resources.getString(StepControlPanel.class, (String)"write-aspect-failed.instruction"), (String)Resources.getString(StepControlPanel.class, (String)"write-aspect-failed.text", (Object[])new Object[]{currentAspectIndex})).title(Resources.getString(StepControlPanel.class, (String)"write-aspect-failed.title")).showException((Throwable)ex);
                }
                catch (Exception ex) {
                    LOGGER.warn("Write CV value to node failed.", (Throwable)ex);
                    TaskDialogs.build((Window)JOptionPane.getFrameForComponent(StepControlPanel.this.getComponent()), (String)Resources.getString(StepControlPanel.class, (String)"write-cv-failed.instruction"), (String)Resources.getString(StepControlPanel.class, (String)"write-cv-failed.text")).title(Resources.getString(StepControlPanel.class, (String)"write-cv-failed.title")).showException((Throwable)ex);
                }
            }
        });
    }

    private JButton makeNavigationButton(String imageName, String pathExt, String actionCommand, String toolTipText, String altText) {
        String imgLocation = "/icons/" + imageName + ".png";
        if (pathExt != null) {
            imgLocation = "/icons" + pathExt + "/" + imageName + ".png";
        }
        URL imageURL = StepControlPanel.class.getResource(imgLocation);
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, altText));
        } else {
            button.setText(altText);
            LOGGER.warn("Resource not found: {}", (Object)imgLocation);
        }
        return button;
    }

    private void addToolBar(VLToolBar toolBar, ToolBarConstraints constraints) {
        ToolBarPanel topToolBarPanel = (ToolBarPanel)DefaultApplicationContext.getInstance().get("topToolBarPanel");
        topToolBarPanel.add(toolBar, constraints);
    }

    private void prepareAndWriteCvValuesToNode(boolean writeOnlyAspects) {
        LOGGER.info("Write the CV values, writeOnlyAspects: {}", (Object)writeOnlyAspects);
        Map<String, CvNode> cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
        ArrayList<ConfigurationVariable> cvList = new ArrayList<ConfigurationVariable>();
        int aspectIndex = 0;
        ArrayListModel<StepControlAspect> aspects = this.stepControlController.getConfigureAspectsListModel();
        for (StepControlAspect currentAspect : aspects) {
            LOGGER.info("Prepare aspect to save: {}", (Object)currentAspect);
            this.prepareCvValues(aspectIndex, currentAspect, cvList, cvNumberToNodeMap);
            ++aspectIndex;
        }
        if (aspectIndex < 48) {
            StepControlAspect currentAspect = new StepControlAspect(null, 0xFFFFFFFFL, StepControlAspect.Polarity.normal);
            LOGGER.info("Add the terminating aspect: {}", (Object)currentAspect);
            this.prepareCvValues(aspectIndex, currentAspect, cvList, cvNumberToNodeMap);
            ++aspectIndex;
        }
        if (!writeOnlyAspects) {
            CvNode tableTypeNode = StepControlCvUtils.getNode(this.mapKeywordToNode, "tabletype");
            TurnTableType turnTableType = this.stepControlModel.getTurnTableType();
            CvValueUtils.compareAndAddNewValue(tableTypeNode, Integer.toString(turnTableType.getCvValue()), cvList, cvNumberToNodeMap);
            CvNode speedNode = StepControlCvUtils.getNode(this.mapKeywordToNode, "speed");
            int speed = this.stepControlModel.getSpeed();
            CvValueUtils.compareAndAddNewValue(speedNode, Integer.toString(speed), cvList, cvNumberToNodeMap);
            CvNode accelNode = StepControlCvUtils.getNode(this.mapKeywordToNode, "accel");
            int accel = this.stepControlModel.getAccel();
            CvValueUtils.compareAndAddNewValue(accelNode, Integer.toString(accel), cvList, cvNumberToNodeMap);
            CvNode decelNode = StepControlCvUtils.getNode(this.mapKeywordToNode, "decel");
            int decel = this.stepControlModel.getDecel();
            CvValueUtils.compareAndAddNewValue(decelNode, Integer.toString(decel), cvList, cvNumberToNodeMap);
        } else {
            LOGGER.info("Only write aspects to node.");
        }
        StepControlPanel cvDefinitionPanelProvider = this;
        CvValueUtils.writeCvValues(this.selectedNode, cvList, cvNumberToNodeMap, (CvDefinitionPanelProvider)cvDefinitionPanelProvider);
        if (!this.hasPendingChanges()) {
            LOGGER.info("Set the persistence status of all aspects to persistent.");
            for (StepControlAspect currentAspect : this.stepControlModel.getStepControlAspects()) {
                currentAspect.setStatus(StepControlAspect.AspectPersistanceStatus.statusPersistent);
            }
        } else {
            LOGGER.info("Pending changes detected after write CV values to node.");
        }
    }

    private boolean checkHasPendingAspects(Map<String, CvNode> cvNumberToNodeMap) {
        int aspectIndex = 0;
        ArrayListModel<StepControlAspect> aspects = this.stepControlController.getConfigureAspectsListModel();
        for (StepControlAspect currentAspect : aspects) {
            LOGGER.info("Prepare aspect to save: {}", (Object)currentAspect);
            boolean changeDetected = this.checkChangedCvValues(aspectIndex, currentAspect, cvNumberToNodeMap);
            if (changeDetected) {
                return true;
            }
            ++aspectIndex;
        }
        if (aspectIndex < 48) {
            StepControlAspect currentAspect = new StepControlAspect(null, 0xFFFFFFFFL, StepControlAspect.Polarity.normal);
            LOGGER.info("Add the terminating aspect: {}", (Object)currentAspect);
            boolean changeDetected = this.checkChangedCvValues(aspectIndex, currentAspect, cvNumberToNodeMap);
            if (changeDetected) {
                return true;
            }
            ++aspectIndex;
        }
        return false;
    }

    private Map<String, CvNode> getCvNumberToNodeMap(NodeInterface node) {
        CvDefinitionPanelController cvDefinitionPanelController = (CvDefinitionPanelController)DefaultApplicationContext.getInstance().get("cvDefinitionPanelController", CvDefinitionPanelController.class);
        Map<String, CvNode> cvNumberToNodeMap = cvDefinitionPanelController.getCvNumberToNodeMap(node);
        return cvNumberToNodeMap;
    }

    private void writeConfigurationValues(ConfigurationWizardModel configurationWizardModel, Map<String, CvNode> cvNumberToNodeMap, Map<String, CvNode> mapKeywordToNode) {
        Integer microStepping;
        LOGGER.info("Write the values from the configuration wizard model to the node.");
        ArrayList<ConfigurationVariable> cvList = new ArrayList<ConfigurationVariable>();
        CvNode tableTypeNode = StepControlCvUtils.getNode(mapKeywordToNode, "tabletype");
        TurnTableType turnTableType = configurationWizardModel.getTurnTableType();
        this.stepControlModel.setTurnTableType(turnTableType);
        CvValueUtils.compareAndAddNewValue(tableTypeNode, Integer.toString(turnTableType.getCvValue()), cvList, cvNumberToNodeMap);
        CvNode nemaTypeNode = StepControlCvUtils.getNode(mapKeywordToNode, "nematype");
        MotorSizeType motorSizeType = configurationWizardModel.getMotorSizeType();
        CvValueUtils.compareAndAddNewValue(nemaTypeNode, Integer.toString(motorSizeType.getCvValue()), cvList, cvNumberToNodeMap);
        CvNode stepCountNode = StepControlCvUtils.getNode(mapKeywordToNode, "stepcount");
        Integer stepCount = configurationWizardModel.getStepCount();
        if (stepCount == null || stepCount == 0) {
            LOGGER.warn("Adjusting invalid stepCount to default value 1.");
            stepCount = 1;
        }
        CvValueUtils.compareAndAddNewValue(stepCountNode, Integer.toString(stepCount), cvList, cvNumberToNodeMap);
        CvNode gearPrimaryNode = StepControlCvUtils.getNode(mapKeywordToNode, "gear_primary");
        Integer gearRatioPrimary = configurationWizardModel.getGearing().getGearRatioPrimary();
        CvValueUtils.compareAndAddNewValue(gearPrimaryNode, Integer.toString(gearRatioPrimary), cvList, cvNumberToNodeMap);
        CvNode gearSecondaryNode = StepControlCvUtils.getNode(mapKeywordToNode, "gear_secondary");
        Integer gearRatioSecondary = configurationWizardModel.getGearing().getGearRatioSecondary();
        CvValueUtils.compareAndAddNewValue(gearSecondaryNode, Integer.toString(gearRatioSecondary), cvList, cvNumberToNodeMap);
        LongCvNode totalStepsNode = (LongCvNode)StepControlCvUtils.getNode(mapKeywordToNode, "totalsteps");
        Integer totalStepCount = configurationWizardModel.getTotalStepCount();
        CvValueUtils.compareAndAddNewValue(totalStepsNode, totalStepCount, cvList);
        if ("yes".equals(configurationWizardModel.getGearing().getKey())) {
            backlashNode = StepControlCvUtils.getNode(mapKeywordToNode, "backlash");
            backlash = configurationWizardModel.getGearing().getBackLash();
            CvValueUtils.compareAndAddNewValue(backlashNode, Integer.toString(backlash), cvList, cvNumberToNodeMap);
        } else {
            LOGGER.info("No gearing selected.");
            backlashNode = StepControlCvUtils.getNode(mapKeywordToNode, "backlash");
            backlash = 0;
            CvValueUtils.compareAndAddNewValue(backlashNode, Integer.toString(backlash), cvList, cvNumberToNodeMap);
        }
        CvNode microSteppingNode = StepControlCvUtils.getNode(mapKeywordToNode, "microstepping");
        Integer n = microStepping = configurationWizardModel.getMicroStepping() != null ? configurationWizardModel.getMicroStepping().getSteps() : null;
        if (microStepping == null || microStepping == 0) {
            LOGGER.warn("Adjusting invalid microstepping to default value 64.");
            microStepping = 64;
        }
        CvValueUtils.compareAndAddNewValue(microSteppingNode, Integer.toString(microStepping), cvList, cvNumberToNodeMap);
        CvNode accelNode = StepControlCvUtils.getNode(mapKeywordToNode, "accel");
        int accel = configurationWizardModel.getAccel();
        CvValueUtils.compareAndAddNewValue(accelNode, Integer.toString(accel), cvList, cvNumberToNodeMap);
        CvNode decelNode = StepControlCvUtils.getNode(mapKeywordToNode, "decel");
        int decel = configurationWizardModel.getDecel();
        CvValueUtils.compareAndAddNewValue(decelNode, Integer.toString(decel), cvList, cvNumberToNodeMap);
        CvValueUtils.writeCvValues(this.selectedNode, cvList, cvNumberToNodeMap, (CvDefinitionPanelProvider)this);
        try {
            Long totalSteps = StepControlCvUtils.getConfigVarLongValue(mapKeywordToNode, "totalsteps");
            if (this.angleRenderer != null) {
                this.angleRenderer.setTotalSteps(totalSteps);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Set the total step count failed.", (Throwable)ex);
        }
    }

    private void prepareCvValues(int aspectIndex, StepControlAspect currentAspect, List<ConfigurationVariable> cvList, Map<String, CvNode> cvNumberToNodeMap) {
        String keywordPolarity = String.format("target_polarity_%d", aspectIndex);
        CvNode polarityNode = StepControlCvUtils.getNode(this.mapKeywordToNode, keywordPolarity);
        StepControlAspect.Polarity polarity = currentAspect.getPolarity();
        CvValueUtils.compareAndAddNewValue(polarityNode, Integer.toString(polarity.getCvValue()), cvList, cvNumberToNodeMap);
        String keywordPosition = String.format("target_position_%d", aspectIndex);
        LongCvNode positionNode = (LongCvNode)StepControlCvUtils.getNode(this.mapKeywordToNode, keywordPosition);
        Long position = currentAspect.getPosition();
        LOGGER.debug("The new position is: {}", (Object)position);
        if (position != null) {
            CvValueUtils.compareAndAddNewValue((CvNode)positionNode, Long.toString(position), cvList, cvNumberToNodeMap);
        } else {
            LOGGER.warn("No position of aspect available. Current aspect: {}", (Object)currentAspect);
        }
    }

    private boolean checkChangedCvValues(int aspectIndex, StepControlAspect currentAspect, Map<String, CvNode> cvNumberToNodeMap) {
        StepControlAspect.Polarity polarity;
        String keywordPolarity = String.format("target_polarity_%d", aspectIndex);
        CvNode polarityNode = StepControlCvUtils.getNode(this.mapKeywordToNode, keywordPolarity);
        boolean changeDetected = CvValueUtils.hasChangedNewValue(polarityNode, Integer.toString((polarity = currentAspect.getPolarity()).getCvValue()), cvNumberToNodeMap);
        if (changeDetected) {
            return true;
        }
        String keywordPosition = String.format("target_position_%d", aspectIndex);
        LongCvNode positionNode = (LongCvNode)StepControlCvUtils.getNode(this.mapKeywordToNode, keywordPosition);
        Long position = currentAspect.getPosition();
        LOGGER.debug("The new position is: {}", (Object)position);
        if (position != null) {
            changeDetected = CvValueUtils.hasChangedNewValue((CvNode)positionNode, Long.toString(position), cvNumberToNodeMap);
            if (changeDetected) {
                return true;
            }
        } else {
            LOGGER.warn("No position of aspect available. Current aspect: {}", (Object)currentAspect);
        }
        return false;
    }

    @Override
    public void checkPendingChanges() {
        boolean hasPendingChanges = this.hasPendingChanges();
        if (!hasPendingChanges) {
            this.resetPendingChanges();
        }
    }

    private void resetPendingChanges() {
        LOGGER.info("Reset pending changes.");
        this.tabStatusListener.updatePendingChanges((Component)this.component, false);
    }

    private boolean hasPendingChanges() {
        Map<String, CvNode> cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
        return this.checkHasPendingAspects(cvNumberToNodeMap);
    }

    @Override
    public void writeConfigVariables(List<ConfigurationVariable> cvList) {
        this.fireWriteConfigVariables(cvList);
    }

    private void fireWriteConfigVariables(List<ConfigurationVariable> cvList) {
        CvConsoleModel cvConsoleModel = CvConsoleModel.getConsoleModel();
        for (ConfigurationVariable cv : cvList) {
            cvConsoleModel.addConsoleLine(ConsoleColor.black, String.format(">> CV %s : %s", cv.getName(), cv.getValue()));
        }
        for (CvDefinitionRequestListener l : this.cvDefinitionRequestListeners) {
            l.writeCvValues(cvList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWriteConfigVariablesPosition(List<ConfigurationVariable> cvList) {
        LOGGER.info("Write cvValue for current position: {}", cvList);
        Frame frame = JOptionPane.getFrameForComponent(this.getComponent());
        try {
            if (frame instanceof BusyFrame) {
                ((BusyFrame)frame).setBusy(true);
            }
            Map<String, CvNode> cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
            StepControlPanel cvDefinitionPanelProvider = this;
            CvValueUtils.writeCvValues(this.selectedNode, cvList, cvNumberToNodeMap, (CvDefinitionPanelProvider)cvDefinitionPanelProvider);
            String currentPositionValue = null;
            for (ConfigurationVariable configVar : cvList) {
                LOGGER.info("Update the configVar in the model: {}", (Object)configVar);
                this.selectedNode.getConfigVariables().put(configVar.getName(), configVar);
                currentPositionValue = configVar.getValue();
            }
            try {
                CvNode currentPositionNode = StepControlCvUtils.getNode(cvNumberToNodeMap, "STEPPOS");
                currentPositionNode.getConfigVar().setValue(currentPositionValue);
                Long currentPosition = Long.parseLong(currentPositionValue);
                LOGGER.info("Set the current position: {}", (Object)currentPosition);
                this.stepControlModel.setCurrentPosition(currentPosition);
                LOGGER.info("The current position was read and no more CV values are updated! The current position is: {}", (Object)currentPosition);
            }
            catch (Exception ex) {
                LOGGER.warn("Update the current position failed.", (Throwable)ex);
            }
        }
        finally {
            if (frame instanceof BusyFrame) {
                ((BusyFrame)frame).setBusy(false);
            }
        }
    }

    private List<ConfigurationVariable> fireLoadConfigVariablesPosition(List<ConfigurationVariable> configVariables) {
        LOGGER.info("Load the config variables for the positions.");
        Iterator<CvDefinitionRequestListener> iterator = this.cvDefinitionRequestListeners.iterator();
        if (iterator.hasNext()) {
            CvDefinitionRequestListener l = iterator.next();
            return l.loadCvValues(configVariables);
        }
        return Collections.emptyList();
    }

    public void labelChanged(MotorPort port, String label) {
    }

    public void valueChanged(NodeInterface node, MotorPort port) {
        LOGGER.info("The motor port value has changed: {}", (Object)port);
    }

    public void configChanged(NodeInterface node, MotorPort port) {
    }

    public Class<?> getPortClass() {
        return MotorPort.class;
    }

    private JPanel createFunctionButtonPanel(JPanel parentPanel, List<JideButton> functionButtons) {
        Feature feature;
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref", new Object[0]).rows("p, 3dlu, p", new Object[0]).panel(parentPanel);
        formBuilder.addSeparator(Resources.getString(this.getClass(), (String)"additionalFunctions"), new Object[0]).xyw(1, 1, 15);
        int totalSoundPorts = 0;
        if (this.selectedNode != null && (feature = Feature.findFeature((Collection)this.selectedNode.getNode().getFeatures(), (int)FeatureEnum.FEATURE_CTRL_SOUND_COUNT.getNumber())) != null) {
            totalSoundPorts = feature.getValue();
        }
        LOGGER.info("Total number of sound ports: {}", (Object)totalSoundPorts);
        ImageIcon iconSoundMute = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/sound_mute.png");
        ImageIcon iconSoundOn = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/sound.png");
        this.soundActiveButton = new JideToggleButton(Resources.getString(this.getClass(), (String)"soundActive"));
        this.soundActiveButton.setButtonStyle(1);
        this.soundActiveButton.setSelectedIcon((Icon)iconSoundMute);
        this.soundActiveButton.setIcon((Icon)iconSoundOn);
        this.soundActiveButton.addActionListener(evt -> {
            boolean isSoundMute = this.soundActiveButton.isSelected();
            LOGGER.info("Pressed the sound active button, isSoundMute: {}", (Object)isSoundMute);
            this.stepControlController.setSoundActive(!isSoundMute);
        });
        boolean soundActive = this.stepControlModel.isSoundActive();
        this.soundActiveButton.setSelected(!soundActive);
        formBuilder.add((Component)this.soundActiveButton).xyw(1, 3, 5);
        formBuilder.appendRows("10dlu, p", new Object[0]);
        int columns = 8;
        int currentSoundPortId = 0;
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 8; ++column) {
                final int functionIndex = row * 8 + column;
                String buttonText = "F" + functionIndex;
                JideButton functionButton = new JideButton(buttonText);
                functionButton.setButtonStyle(1);
                functionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LOGGER.info("Trigger sound port with index: {}", (Object)functionIndex);
                        SoundPortStatus soundPortStatus = SoundPortStatus.PLAY;
                        StepControlPanel.this.stepControlController.triggerSoundPort(functionIndex, soundPortStatus);
                    }
                });
                functionButtons.add(functionButton);
                this.functionButtonMap.put(buttonText, functionButton);
                formBuilder.add((Component)functionButton).xy(column * 2 + 1, row * 2 + 5);
                if (++currentSoundPortId < totalSoundPorts) continue;
                LOGGER.info("Maximum number of sound ports reached.");
                break;
            }
            formBuilder.appendRows("3dlu, p", new Object[0]);
            if (currentSoundPortId < totalSoundPorts) continue;
            LOGGER.info("Maximum number of sound ports reached.");
            break;
        }
        return formBuilder.build();
    }

    public void setActiveAspect(SwitchingNodeInterface node, int accessoryNumber, int aspectNumber) {
        LOGGER.info("Set the active aspect: {}", (Object)aspectNumber);
        if (SwingUtilities.isEventDispatchThread()) {
            this.firePerformAspect(aspectNumber);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.firePerformAspect(aspectNumber));
            }
            catch (InterruptedException | InvocationTargetException ex) {
                LOGGER.warn("Activate aspect failed, accessoryNumber: {}, aspectNumber: {}", new Object[]{accessoryNumber, aspectNumber, ex});
                throw new RuntimeException("Activate aspect failed, accessoryNumber: " + accessoryNumber + ", aspect: " + aspectNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessoryExecutionState getAccessoryExecutionState(SwitchingNodeInterface node, int accessoryNumber) {
        AspectExecutionModel aspectExecutionModel = this.aspectExecutionModel;
        synchronized (aspectExecutionModel) {
            return this.aspectExecutionModel.getExecutionState();
        }
    }

    private static class DebugPanel
    extends FormDebugPanel
    implements TabSelectionListener {
        private static final long serialVersionUID = 1L;
        private final TabSelectionListener tabSelectionListener;

        public DebugPanel(TabSelectionListener tabSelectionListener) {
            this.tabSelectionListener = tabSelectionListener;
        }

        @Override
        public void tabSelected(boolean selected) {
            LOGGER.debug("Select tab, current component: is StepControlPanel.");
            this.tabSelectionListener.tabSelected(selected);
        }
    }

    private final class AddAspectCallbackListener
    implements AspectCallbackListener<StepControlAspect> {
        private AddAspectDialog aspectDialog;

        private AddAspectCallbackListener() {
        }

        private void setAddAspectDialog(AddAspectDialog aspectDialog) {
            LOGGER.info("Set the aspect dialog: {}", (Object)aspectDialog);
            this.aspectDialog = aspectDialog;
        }

        @Override
        public void activateAspect(StepControlAspect stepControlAspect) {
            LOGGER.info("Activate the aspect is called for new aspect: {}", (Object)stepControlAspect);
            if (stepControlAspect.isValid() && (StepControlPanel.this.stepControlModel.getTurnTableType() != TurnTableType.round || stepControlAspect.isOppositeValid()) && stepControlAspect.getStatus() == StepControlAspect.AspectPersistanceStatus.statusPersistent) {
                StepControlPanel.this.firePerformAspect(stepControlAspect);
            } else {
                LOGGER.warn("Do not perform the aspect because the stepControlAspect is not stored: {}", (Object)stepControlAspect);
            }
        }

        @Override
        public void activateOppositeAspect(StepControlAspect stepControlAspect) {
            LOGGER.info("Activate the aspect is called for new aspect: {}", (Object)stepControlAspect);
            if (stepControlAspect.isValid() && stepControlAspect.isOppositeValid() && stepControlAspect.getStatus() == StepControlAspect.AspectPersistanceStatus.statusPersistent) {
                StepControlPanel.this.firePerformOppositeAspect(stepControlAspect);
            } else {
                LOGGER.warn("Do not perform the aspect because the stepControlAspect is not stored: {}", (Object)stepControlAspect);
            }
        }

        @Override
        public void saveChanges(StepControlAspect originalAspect, Function<StepControlAspect, StepControlAspect> func) throws Exception {
            StepControlAspect changedAspect = func.apply(originalAspect);
            if (this.aspectDialog == null) {
                LOGGER.info("Save the changed aspect: {}", (Object)changedAspect);
                StepControlPanel.this.stepControlModel.updateStepControlAspect(originalAspect, changedAspect);
                StepControlPanel.this.selectAspectByPosition(originalAspect);
            } else {
                this.aspectDialog.setResult(0);
                LOGGER.info("Add the new aspect to the model: {}", (Object)changedAspect);
                StepControlPanel.this.stepControlModel.addStepControlAspect(changedAspect);
                StepControlPanel.this.selectAspectByPosition(changedAspect);
                this.aspectDialog.setVisible(false);
            }
            LOGGER.info("Set the pending changes flag.");
            StepControlPanel.this.tabStatusListener.updatePendingChanges((Component)StepControlPanel.this.component, true);
        }

        @Override
        public void discardChanges(Callable<StepControlAspect> func) throws Exception {
            LOGGER.info("User decided to discard changes. Close the aspect dialog.");
            func.call();
            if (this.aspectDialog != null) {
                this.aspectDialog.setResult(2);
                this.aspectDialog.setVisible(false);
            }
        }

        @Override
        public void verifyUniquePosition(StepControlAspect originalAspect, Long position, Long positionOpposite) {
            this.verifyUniqueAspectPosition(originalAspect, position, positionOpposite);
        }

        private void verifyUniqueAspectPosition(StepControlAspect originalAspect, Long position, Long positionOpposite) {
            if (position == null) {
                throw new IllegalArgumentException("Provided position value is not available.");
            }
            if (TurnTableType.round == StepControlPanel.this.stepControlModel.getTurnTableType()) {
                for (StepControlAspect currentAspect : StepControlPanel.this.stepControlModel.getStepControlAspects()) {
                    if ((!Objects.equals((Object)currentAspect.getPosition(), (Object)position) || currentAspect == originalAspect) && (!Objects.equals((Object)currentAspect.getOppositePosition(), (Object)positionOpposite) || currentAspect == originalAspect)) continue;
                    LOGGER.warn("Found configured aspect with the same position or opposite position: {}", (Object)currentAspect);
                    throw new IllegalArgumentException("Found configured aspect with the same position.");
                }
                for (StepControlAspect currentAspect : StepControlPanel.this.stepControlModel.getStepControlAspects()) {
                    if ((!Objects.equals((Object)currentAspect.getOppositePosition(), (Object)position) || currentAspect == originalAspect) && (!Objects.equals((Object)currentAspect.getPosition(), (Object)positionOpposite) || currentAspect == originalAspect)) continue;
                    LOGGER.warn("Found configured aspect with the same position or opposite position: {}", (Object)currentAspect);
                    throw new IllegalArgumentException("Found configured aspect with the same position.");
                }
            } else {
                for (StepControlAspect currentAspect : StepControlPanel.this.stepControlModel.getStepControlAspects()) {
                    if (!Objects.equals((Object)currentAspect.getPosition(), (Object)position) || currentAspect == originalAspect) continue;
                    LOGGER.warn("Found configured aspect with the same position: {}", (Object)currentAspect);
                    throw new IllegalArgumentException("Found configured aspect with the same position.");
                }
            }
        }

        @Override
        public Long getCurrentTurntablePosition() {
            return StepControlPanel.this.stepControlModel.getCurrentPosition();
        }
    }

    private final class AddAspectDialog
    extends EscapeDialog {
        private static final long serialVersionUID = 1L;
        private int result;
        private final AspectEditorPanel aspectEditorPanel;

        public AddAspectDialog(Frame parent, String title, boolean modal, AspectEditorPanel aspectEditorPanel) {
            super(parent, title, modal);
            this.result = 2;
            this.aspectEditorPanel = aspectEditorPanel;
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(aspectEditorPanel);
            aspectEditorPanel.setDefaultButton();
            this.pack();
            this.setLocationRelativeTo(parent);
            this.setMinimumSize(this.getSize());
        }

        protected void setResult(int result) {
            this.result = result;
        }

        public int getResult() {
            return this.result;
        }

        public void cleanup() {
            if (this.aspectEditorPanel != null) {
                this.aspectEditorPanel.cleanup();
            }
        }
    }

    private final class AspectTablePopupMenu
    extends BasicPopupMenu {
        private static final long serialVersionUID = 1L;
        private JMenuItem newLabel = new JMenuItem(Resources.getString(StepControlPanel.class, (String)"newAspect") + " ...");
        private JMenuItem deleteLabel;
        private JMenuItem deleteAllLabel;
        private JMenuItem importAspectsFromExcelMenuItem;
        private JMenuItem exportAspectsToExcelMenuItem;

        public AspectTablePopupMenu() {
            this.newLabel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.info("Add new aspect.");
                    StepControlPanel.this.fireCreateNewAspect();
                }
            });
            this.add(this.newLabel);
            this.deleteLabel = new JMenuItem(Resources.getString(StepControlPanel.class, (String)"deleteAspect") + " ...");
            this.deleteLabel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StepControlPanel.this.fireRemoveAspect();
                }
            });
            this.add(this.deleteLabel);
            this.deleteAllLabel = new JMenuItem(Resources.getString(StepControlPanel.class, (String)"deleteAllAspects") + " ...");
            this.deleteAllLabel.setToolTipText(Resources.getString(StepControlPanel.class, (String)"deleteAllAspects.tooltip"));
            this.deleteAllLabel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StepControlPanel.this.fireRemoveAllAspects();
                }
            });
            this.add(this.deleteAllLabel);
            this.addSeparator();
            this.importAspectsFromExcelMenuItem = new JMenuItem(Resources.getString(StepControlPanel.class, (String)"importAspectsFromExcel") + " ...");
            this.importAspectsFromExcelMenuItem.setToolTipText(Resources.getString(StepControlPanel.class, (String)"importAspectsFromExcel.tooltip"));
            this.importAspectsFromExcelMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StepControlPanel.this.fireImportAspectsFromExcel();
                }
            });
            this.add(this.importAspectsFromExcelMenuItem);
            this.exportAspectsToExcelMenuItem = new JMenuItem(Resources.getString(StepControlPanel.class, (String)"exportAspectsToExcel") + " ...");
            this.exportAspectsToExcelMenuItem.setToolTipText(Resources.getString(StepControlPanel.class, (String)"exportAspectsToExcel.tooltip"));
            this.exportAspectsToExcelMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StepControlPanel.this.fireExportAspectsToExcel();
                }
            });
            this.add(this.exportAspectsToExcelMenuItem);
        }

        public void setDeleteEnabled(boolean enabled) {
            this.deleteLabel.setEnabled(enabled);
        }

        public void setDeleteAllEnabled(boolean enabled) {
            this.deleteAllLabel.setEnabled(enabled);
        }
    }
}

