/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.worklist.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bidib.wizard.api.event.WorkListItemEvent;
import org.bidib.wizard.mvc.worklist.model.WorkItemModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemListModel
extends Model {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkItemListModel.class);
    private static final long serialVersionUID = 1L;
    private ArrayListModel<WorkItemModel> workItemList = new ArrayListModel();

    public ArrayListModel<WorkItemModel> getWorkItemListModel() {
        return this.workItemList;
    }

    public List<WorkItemModel> getWorkItems() {
        return Collections.unmodifiableList(this.workItemList);
    }

    public boolean contains(WorkListItemEvent item) {
        long count = 0L;
        count = item.isDistinctItem() ? this.workItemList.stream().filter(wi -> wi.getWorkListItemEvent().getComponent().equals(item.getComponent()) && wi.getWorkListItemEvent().getClass() == item.getClass()).count() : this.workItemList.stream().filter(wi -> wi.getWorkListItemEvent().getComponent().equals(item.getComponent()) && wi.getWorkListItemEvent().getClass() == item.getClass() && item.compareAdditonalProperties(wi.getWorkListItemEvent())).count();
        return count > 0L;
    }

    public boolean addWorkListItem(WorkListItemEvent item) {
        LOGGER.info("Add worklist item: {}", (Object)item);
        if (!this.contains(item)) {
            if (WorkListItemEvent.Status.done != item.getStatus()) {
                LOGGER.info("The new item is not in the work item list.");
                WorkItemModel workItemModel = new WorkItemModel(item);
                this.addWorkListItem(workItemModel);
                return true;
            }
            LOGGER.info("The new item has status 'done' and is not added to the worklist.");
            return false;
        }
        if (item.isRemoveDuplicates()) {
            WorkItemModel workItemModel;
            ArrayList<WorkItemModel> models = new ArrayList<WorkItemModel>((Collection<WorkItemModel>)this.workItemList);
            ArrayList<Object> toRemove = new ArrayList<Object>();
            for (Object workItemModel2 : models) {
                if (workItemModel2.getWorkListItemEvent().getClass() != item.getClass()) continue;
                LOGGER.info("Prepare remove duplicate: {}", workItemModel2);
                toRemove.add(workItemModel2);
            }
            boolean keepItem = false;
            if (toRemove.size() > 1) {
                for (WorkItemModel workItemModel2 : toRemove) {
                    this.removeWorkListItem(workItemModel2);
                }
            } else if (toRemove.size() == 1) {
                workItemModel = (WorkItemModel)((Object)toRemove.get(0));
                if (workItemModel.getWorkListItemEvent().isIgnored(item)) {
                    keepItem = true;
                    LOGGER.info("Keep the existing workItem with state 'ignore'. New item: {}", (Object)item);
                } else {
                    this.removeWorkListItem(workItemModel);
                }
            }
            if (keepItem || WorkListItemEvent.Status.done == item.getStatus()) {
                LOGGER.info("The workItem was not added.");
                return false;
            }
            workItemModel = new WorkItemModel(item);
            this.addWorkListItem(workItemModel);
            return !keepItem;
        }
        LOGGER.info("Skip adding duplicate item: {}", (Object)item);
        return false;
    }

    public void addWorkListItem(WorkItemModel workItemModel) {
        this.workItemList.add((Object)workItemModel);
    }

    public void removeWorkListItem(WorkItemModel workItemModel) {
        this.workItemList.remove((Object)workItemModel);
    }

    public void addWorkListItems(List<WorkListItemEvent> items) {
        for (WorkListItemEvent item : items) {
            this.addWorkListItem(item);
        }
    }

    public void clear() {
        this.workItemList.clear();
    }
}

