/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.path.PathInputPanel;
import com.izforge.izpack.panels.target.TargetPanelAutomation;
import com.izforge.izpack.panels.target.TargetPanelHelper;
import com.izforge.izpack.util.file.FileUtils;
import java.io.File;
import java.util.logging.Logger;

public class MyTargetPanel
extends PathInputPanel {
    private static final long serialVersionUID = 3256443616359429170L;
    private static final Logger logger = Logger.getLogger(MyTargetPanel.class.getName());

    public MyTargetPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, resources, log);
    }

    public void panelActivate() {
        String path = TargetPanelHelper.getPath((InstallData)this.installData);
        if (path != null) {
            this.pathSelectionPanel.setPath(path);
        }
        super.panelActivate();
    }

    public boolean isValidated() {
        boolean result = false;
        if (TargetPanelHelper.isIncompatibleInstallation((String)this.pathSelectionPanel.getPath())) {
            logger.info("Found incompatible installation. Remove all files.");
            result = FileUtils.deleteRecursively((File)new File(this.pathSelectionPanel.getPath()));
            if (!result) {
                String message = this.getString("TargetPanel.incompatibleInstallation");
                if (message != null && message.equals("TargetPanel.incompatibleInstallation")) {
                    message = "Eine inkompatible Installation wurde erkannt. Deinstallieren sie diese oder w&auml;hlen Sie ein anderes Installations-Verzeichnis.";
                }
                this.emitError(this.getString("installer.error"), message);
            } else {
                this.installData.setInstallPath(this.pathSelectionPanel.getPath());
                result = true;
            }
        } else if (super.isValidated()) {
            this.installData.setInstallPath(this.pathSelectionPanel.getPath());
            result = true;
        }
        return result;
    }

    public void makeXMLData(IXMLElement panelRoot) {
        new TargetPanelAutomation().makeXMLData((InstallData)this.installData, panelRoot);
    }

    public String getSummaryBody() {
        return this.installData.getInstallPath();
    }
}

