/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.target.TargetPanel;
import com.izforge.izpack.panels.target.TargetPanelHelper;
import com.izforge.izpack.util.file.FileUtils;
import java.io.File;
import java.util.logging.Logger;

public class MyTargetPanel
extends TargetPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MyTargetPanel.class.getName());

    public MyTargetPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, resources, log);
    }

    public boolean isValidated() {
        boolean result = false;
        if (TargetPanelHelper.isIncompatibleInstallation((String)this.pathSelectionPanel.getPath())) {
            LOGGER.info("Found incompatible installation. Remove all files.");
            result = FileUtils.deleteRecursively((File)new File(this.pathSelectionPanel.getPath()));
            if (!result) {
                String message = this.getString("TargetPanel.incompatibleInstallation");
                if (message != null && message.equals("TargetPanel.incompatibleInstallation")) {
                    message = "Eine inkompatible Installation wurde erkannt. Deinstallieren sie diese oder w&auml;hlen Sie ein anderes Installations-Verzeichnis.";
                }
                this.emitError(this.getString("installer.error"), message);
            } else {
                this.installData.setInstallPath(this.pathSelectionPanel.getPath());
                result = true;
            }
        } else if (super.isValidated()) {
            this.installData.setInstallPath(this.pathSelectionPanel.getPath());
            result = true;
        }
        return result;
    }
}

