/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.target.TargetPanel;
import com.izforge.izpack.panels.target.TargetPanelHelper;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class MyTargetPanel
extends TargetPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MyTargetPanel.class.getName());

    public MyTargetPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, resources, log);
        LabelFactory.setLabelFontSize((float)0.9f);
        LabelFactory.setLabelFontSize((float)1.0f);
    }

    public void saveData() {
        String path = this.pathSelectionPanel.getPath();
        if (OsVersion.IS_OSX) {
            if (path != null && !path.endsWith(".app/Contents")) {
                LOGGER.info("Adding '.app' to path because of OSX.");
                this.installData.setInstallPath(path + ".app/Contents");
            } else {
                this.installData.setInstallPath(path);
            }
        } else {
            this.installData.setInstallPath(path);
        }
    }

    public boolean isValidated() {
        boolean result = false;
        if (TargetPanelHelper.isIncompatibleInstallation((String)this.pathSelectionPanel.getPath(), (Boolean)true)) {
            LOGGER.info("Found incompatible installation. Remove all files.");
            result = FileUtils.deleteQuietly((File)new File(this.pathSelectionPanel.getPath()));
            if (!result) {
                String message = this.getString("TargetPanel.incompatibleInstallation");
                if (message != null && message.equals("TargetPanel.incompatibleInstallation")) {
                    message = "Eine inkompatible Installation wurde erkannt. Deinstallieren sie diese oder w&auml;hlen Sie ein anderes Installations-Verzeichnis.";
                }
                this.emitError(this.getString("installer.error"), message);
            } else {
                this.installData.setInstallPath(this.pathSelectionPanel.getPath());
                result = true;
            }
        } else if (super.isValidated()) {
            this.installData.setInstallPath(this.pathSelectionPanel.getPath());
            result = true;
        }
        return result;
    }
}

