/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.localhost.client.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.enums.MessageClassEnum;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeListProvider;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.localhost.LocalHostSubscriptionEventProvider;
import org.bidib.wizard.localhost.client.controller.listener.LocalHostClientControllerListener;
import org.bidib.wizard.localhost.client.model.SubscribedClientTableModel;
import org.bidib.wizard.localhost.client.view.LocalHostClientView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LocalHostClientController
implements LocalHostClientControllerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalHostClientController.class);
    private final DockingDesktop desktop;
    private LocalHostClientView localHostClientView;
    private SubscribedClientTableModel subscribedClientTableModel;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private List<LocalHostSubscriptionEventProvider> localHostSubscriptionEventProviders;
    private CompositeDisposable compDisposable;
    private final NodeListProvider nodeListProvider;
    private NodeListListener nodeListListener;

    public LocalHostClientController(DockingDesktop desktop, NodeListProvider nodeListProvider) {
        this.desktop = desktop;
        this.nodeListProvider = nodeListProvider;
    }

    public void start() {
        String searchKey = "LocalHostClientView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = this.desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing LocalHost client view instead of open a new one.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        this.subscribedClientTableModel = new SubscribedClientTableModel();
        LOGGER.info("Create new LocalHostClientView.");
        this.localHostClientView = new LocalHostClientView(this.desktop, this, this.subscribedClientTableModel);
        this.localHostClientView.initComponents();
        DockableState[] dockables = this.desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (dockables.length > 1) {
            DockableState tabPanelNodeDetails = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_TAB_PANEL.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the tab panel dockable.");
                tabPanelNodeDetails = dockable;
                break;
            }
            Dockable dock = this.desktop.getDockables()[1].getDockable();
            if (tabPanelNodeDetails != null) {
                LOGGER.info("Add the localHostClientView next to the node details panel.");
                dock = tabPanelNodeDetails.getDockable();
                TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                int order = 0;
                if (container != null) {
                    order = container.getTabCount();
                }
                LOGGER.info("Add new nodesClientView at order: {}", (Object)order);
                this.desktop.createTab(dock, (Dockable)this.localHostClientView, order, true);
            } else {
                this.desktop.split(dock, (Dockable)this.localHostClientView, DockingConstants.SPLIT_RIGHT);
            }
        } else {
            this.desktop.addDockable((Dockable)this.localHostClientView, RelativeDockablePosition.RIGHT);
        }
        this.nodeListListener = new DefaultNodeListListener(){

            public void listNodeAdded(NodeInterface node) {
                LOGGER.info("The nodelist has a new node: {}", (Object)node);
            }

            public void listNodeRemoved(NodeInterface node) {
                LOGGER.info("The nodelist has a node removed: {}", (Object)node);
                LocalHostClientController.this.nodeLost(node);
            }
        };
        this.nodeListProvider.addNodeListListener(this.nodeListListener);
        if (this.connectionService.isConnected("main")) {
            this.subscribeLocalHostSubscriberChanges();
        }
        this.connectionService.subscribeConnectionStatusChanges(ci -> {
            if ("main".equals(ci.getConnectionId())) {
                switch (ci.getConnectionState().getActualPhase()) {
                    case CONNECTED: {
                        this.subscribeLocalHostSubscriberChanges();
                        break;
                    }
                    case DISCONNECTED: {
                        this.unsubscribeLocalHostSubscriberChanges();
                        break;
                    }
                }
            }
        }, th -> {});
    }

    private void subscribeLocalHostSubscriberChanges() {
        LOGGER.info("subscribeLocalHostSubscriberChanges.");
        if (this.compDisposable != null) {
            LOGGER.info("The subsription for localhost subscriber changes is already done.");
            return;
        }
        this.compDisposable = new CompositeDisposable();
        if (CollectionUtils.isNotEmpty(this.localHostSubscriptionEventProviders)) {
            this.localHostSubscriptionEventProviders.forEach(provider -> {
                LOGGER.info("Current localHostSubscriptionEventProvider: {}", provider);
                Disposable dispSubscriptionEvents = provider.subscribeSubscriberEvents(se -> {
                    LOGGER.info("Received a subscription event: {}", se);
                    switch (se.getAction()) {
                        case add: {
                            this.internalAddSubscriber(se.getNodeAddress(), se.getUniqueId(), se.getMessageClass());
                            break;
                        }
                        case remove: {
                            this.internalRemoveSubscriber(se.getNodeAddress(), se.getUniqueId(), se.getMessageClass());
                            break;
                        }
                    }
                }, error -> LOGGER.warn("The status event signalled a failure: {}", error));
                this.compDisposable.add(dispSubscriptionEvents);
                Map subscriptions = provider.getSubscriptions();
                subscriptions.forEach((mc, addresses) -> addresses.forEach(addr -> this.internalAddSubscriber(addr.getAddress(), addr.getUniqueId(), (MessageClassEnum)mc)));
            });
        } else {
            LOGGER.warn("No localHostSubscriptionEventProvider instances available.");
        }
    }

    private void unsubscribeLocalHostSubscriberChanges() {
        LOGGER.info("unsubscribeLocalHostSubscriberChanges.");
        if (this.compDisposable == null) {
            LOGGER.info("The subsription for localhost subscriber changes does not exist.");
            return;
        }
        if (this.compDisposable != null) {
            this.compDisposable.dispose();
            this.compDisposable = null;
        }
    }

    private void internalAddSubscriber(byte[] nodeAddress, Long uniqueId, MessageClassEnum messageClass) {
        LOGGER.info("Add subscriber, address: {}, messageClass: {}", (Object)NodeUtils.formatAddressLong((byte[])nodeAddress), (Object)messageClass);
        this.subscribedClientTableModel.addSubscribedClient(nodeAddress, uniqueId, messageClass);
    }

    private void internalRemoveSubscriber(byte[] nodeAddress, Long uniqueId, MessageClassEnum messageClass) {
        LOGGER.info("Remove subscriber, address: {}, messageClass: {}", (Object)NodeUtils.formatAddressLong((byte[])nodeAddress), (Object)messageClass);
        this.subscribedClientTableModel.removeSubscribedClient(nodeAddress, uniqueId, messageClass);
    }

    private void nodeLost(NodeInterface node) {
        SwingUtilities.invokeLater(() -> this.internalRemoveSubscriber(node.getAddr(), null, null));
    }

    @Override
    public void viewClosed() {
        LOGGER.info("View is closed.");
        this.unsubscribeLocalHostSubscriberChanges();
        try {
            if (this.nodeListListener != null) {
                this.nodeListProvider.removeNodeListListener(this.nodeListListener);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Unregister controller as node listener failed.", (Throwable)ex);
        }
        this.nodeListListener = null;
    }
}

