/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.localhost.client.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.localhost.client.model.SubscribedClientModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribedClientTableModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscribedClientTableModel.class);
    public static final String PROPERTY_SUBSCRIBED_CLIENTS = "subscribedClients";
    private ArrayListModel<SubscribedClientModel> subscriberList = new ArrayListModel();

    public void addSubscribedClient(byte[] nodeAddress, Long uniqueId, Integer messageClasses) {
        SwingUtilities.invokeLater(() -> {
            ArrayListModel<SubscribedClientModel> arrayListModel = this.subscriberList;
            synchronized (arrayListModel) {
                SubscribedClientModel subscriber = new SubscribedClientModel(nodeAddress, uniqueId);
                if (!this.subscriberList.contains((Object)subscriber)) {
                    LOGGER.info("Add node address to subscriber list: {}", (Object)NodeUtils.formatAddressLong((byte[])nodeAddress));
                    subscriber.setMessageClasses(messageClasses);
                    LinkedList<SubscribedClientModel> oldValue = new LinkedList<SubscribedClientModel>((Collection<SubscribedClientModel>)this.subscriberList);
                    this.subscriberList.add((Object)subscriber);
                    this.firePropertyChange(PROPERTY_SUBSCRIBED_CLIENTS, oldValue, this.subscriberList);
                } else {
                    LOGGER.warn("Node address is already in subscriber list: {}", (Object)NodeUtils.formatAddressLong((byte[])nodeAddress));
                }
            }
        });
    }

    public void removeSubscribedClient(byte[] nodeAddress, Long uniqueId, Integer messageClasses) {
        SwingUtilities.invokeLater(() -> {
            ArrayListModel<SubscribedClientModel> arrayListModel = this.subscriberList;
            synchronized (arrayListModel) {
                LinkedList<SubscribedClientModel> oldValue = new LinkedList<SubscribedClientModel>((Collection<SubscribedClientModel>)this.subscriberList);
                int index = this.subscriberList.indexOf((Object)new SubscribedClientModel(nodeAddress, null));
                if (index > -1) {
                    SubscribedClientModel removed = (SubscribedClientModel)((Object)((Object)this.subscriberList.remove(index)));
                    if (removed != null) {
                        this.firePropertyChange(PROPERTY_SUBSCRIBED_CLIENTS, oldValue, this.subscriberList);
                    }
                } else {
                    LOGGER.info("The subscriber is not in the list.");
                }
            }
        });
    }

    public ArrayListModel<SubscribedClientModel> getBoosterListModel() {
        return this.subscriberList;
    }

    public List<SubscribedClientModel> getBoosters() {
        return Collections.unmodifiableList(this.subscriberList);
    }
}

