/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.localhost.client.view;

import com.jgoodies.binding.adapter.SingleListSelectionAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableSelectionListener;
import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.table.AbstractEmptyTable;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.localhost.client.controller.listener.LocalHostClientControllerListener;
import org.bidib.wizard.localhost.client.model.SubscribedClientModel;
import org.bidib.wizard.localhost.client.model.SubscribedClientTableModel;
import org.bidib.wizard.localhost.client.view.SubscribedClientTableTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHostClientView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalHostClientView.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, fill:pref:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "fill:50dlu:grow";
    private JComponent contentPanel;
    private final DockingDesktop desktop;
    private final LocalHostClientControllerListener controllerListener;
    private final DockableStateChangeListener dockableStateChangeListener;
    private DockableSelectionListener dockableSelectionListener;
    private SelectionInList<SubscribedClientModel> subscriberSelection;
    private final SubscribedClientTableModel subscribedClientTableModel;

    public LocalHostClientView(final DockingDesktop desktop, final LocalHostClientControllerListener controllerListener, SubscribedClientTableModel subscribedClientTableModel) {
        this.desktop = desktop;
        this.controllerListener = controllerListener;
        this.subscribedClientTableModel = subscribedClientTableModel;
        DockKeys.DOCKKEY_LOCALHOST_CLIENT_VIEW.setName(Resources.getString(this.getClass(), (String)"title"));
        DockKeys.DOCKKEY_LOCALHOST_CLIENT_VIEW.setFloatEnabled(true);
        DockKeys.DOCKKEY_LOCALHOST_CLIENT_VIEW.setAutoHideEnabled(false);
        this.dockableStateChangeListener = new DockableStateChangeListener(){

            public void dockableStateChanged(DockableStateChangeEvent event) {
                LOGGER.info("The state has changed, newState: {}, prevState: {}", (Object)event.getNewState(), (Object)event.getPreviousState());
                DockableState newState = event.getNewState();
                if (newState.getDockable().equals(LocalHostClientView.this) && newState.isClosed()) {
                    LOGGER.info("The NodesClientView is closed.");
                    desktop.removeDockableStateChangeListener(LocalHostClientView.this.dockableStateChangeListener);
                    if (LocalHostClientView.this.dockableSelectionListener != null) {
                        desktop.removeDockableSelectionListener(LocalHostClientView.this.dockableSelectionListener);
                        LocalHostClientView.this.dockableSelectionListener = null;
                    }
                    if (controllerListener != null) {
                        LOGGER.info("Close the view.");
                        controllerListener.viewClosed();
                    }
                }
            }
        };
        desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
    }

    public JComponent initComponents() {
        Object panel;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.subscriberSelection = new SelectionInList(this.subscribedClientTableModel.getSubscriberListModel());
        SortableTableModel tableModel = new SortableTableModel((TableModel)((Object)new SubscribedClientTableTableModel(this.subscriberSelection)));
        AbstractEmptyTable subscriberTable = new AbstractEmptyTable((TableModel)tableModel, Resources.getString(this.getClass(), (String)"empty_table")){
            private static final long serialVersionUID = 1L;
        };
        subscriberTable.adjustRowHeight();
        subscriberTable.setSelectionModel((ListSelectionModel)new SingleListSelectionAdapter(this.subscriberSelection.getSelectionIndexHolder()));
        final DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)subscriberTable));
        tableModel.addTableModelListener(new TableModelListener(){
            final /* synthetic */ TableModel val$tableModel;
            {
                this.val$tableModel = tableModel;
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                overlayTable.setOverlayVisible(this.val$tableModel.getRowCount() == 0);
            }
        });
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + subscriberTable.getEmptyTableText() + ":f:gray}")));
        dialogBuilder.add((Component)subscriberTable).xyw(1, 1, 5);
        this.contentPanel = dialogBuilder.build();
        return this.contentPanel;
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_LOCALHOST_CLIENT_VIEW;
    }

    public Component getComponent() {
        return this.contentPanel;
    }
}

