/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.localhost.client.view;

import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.list.SelectionInList;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.localhost.client.model.SubscribedClientModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribedClientTableTableModel
extends AbstractTableAdapter<SubscribedClientModel> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscribedClientTableTableModel.class);
    public static final int COLUMN_ADDRESS = 0;
    public static final int COLUMN_UNIQUE_ID = 1;
    public static final int COLUMN_SUBSCRIPTIONS = 2;
    private static final String[] COLUMNNAMES = new String[]{Resources.getString(SubscribedClientTableTableModel.class, (String)"address"), Resources.getString(SubscribedClientTableTableModel.class, (String)"uniqueId"), Resources.getString(SubscribedClientTableTableModel.class, (String)"subscriptions")};

    public SubscribedClientTableTableModel(SelectionInList<SubscribedClientModel> subscribedClientList) {
        super(subscribedClientList, COLUMNNAMES);
        LOGGER.info("Current listModel: {}", (Object)this.getListModel());
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return Object.class;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        SubscribedClientModel subscribedClient = (SubscribedClientModel)((Object)this.getRow(rowIndex));
        switch (columnIndex) {
            case 0: {
                return NodeUtils.formatAddressLong((byte[])subscribedClient.getNodeAddress());
            }
            case 1: {
                return ByteUtils.getUniqueIdAsString((Long)subscribedClient.getUniqueId());
            }
            case 2: {
                return subscribedClient.getMessageClasses() != null ? StringUtils.leftPad((String)Integer.toString(subscribedClient.getMessageClasses(), 2), (int)16, (String)"0") : null;
            }
        }
        return null;
    }
}

