/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.migration.labels;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.bidib.jbidibc.core.schema.bidibbase.PortType;
import org.bidib.jbidibc.core.schema.bidiblabels.LabelFactory;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.PortLabels;
import org.bidib.wizard.common.context.ApplicationContext;
import org.bidib.wizard.migration.labels.OldWizardLabelMigrator;
import org.bidib.wizard.migration.labels.WizardLabelMigratorTest;
import org.bidib.wizard.migration.migrator.MigrationContext;
import org.bidib.wizard.migration.schema.nodes.Nodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public class OldWizardLabelMigratorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(OldWizardLabelMigratorTest.class);
    private static final String DATA1_XML = "/xml-test/labels/wizard-old/LightPortLabels";
    private static final String DATA2_XML = "/xml-test/labels/wizard-old/NodeLabels";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="Test XSL transformation and compare to xml from file.")
    public void transformationLightPortLabelsTest() throws TransformerException, URISyntaxException, SAXException, IOException {
        InputStream inputXSL = WizardLabelMigratorTest.class.getResourceAsStream("/migration/labels-migration4.xsl");
        Assert.assertNotNull((Object)inputXSL);
        InputStream dataXML = WizardLabelMigratorTest.class.getResourceAsStream(DATA1_XML);
        Assert.assertNotNull((Object)dataXML);
        StringWriter outputXML = new StringWriter();
        try {
            OldWizardLabelMigrator migrator = new OldWizardLabelMigrator();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("port_type", "light");
            params.put("search_uniqueId", Long.toString(1464607285711414L));
            migrator.doTransform(params, inputXSL, dataXML, outputXML);
        }
        finally {
            if (outputXML != null) {
                try {
                    outputXML.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputXML writer failed.", (Throwable)ex);
                }
            }
            if (inputXSL != null) {
                try {
                    inputXSL.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close inputXSL stream failed.", (Throwable)ex);
                }
            }
        }
        LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
        Assert.assertTrue((outputXML.getBuffer().length() > 0 ? 1 : 0) != 0);
        InputStream is = WizardLabelMigratorTest.class.getResourceAsStream("/xml-test/result/wizard-old/LightPortLabels.xml");
        String xmlContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Diff myDiffSimilar = DiffBuilder.compare((Object)xmlContent).withTest((Object)outputXML.toString()).checkForSimilar().build();
        Assert.assertFalse((boolean)myDiffSimilar.hasDifferences(), (String)("XML similar " + myDiffSimilar.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="Test XSL transformation and compare to xml from file.")
    public void transformationNodeLabelsTest() throws TransformerException, URISyntaxException, SAXException, IOException {
        InputStream inputXSL = OldWizardLabelMigratorTest.class.getResourceAsStream("/migration/labels-migration5.xsl");
        Assert.assertNotNull((Object)inputXSL);
        InputStream dataXML = OldWizardLabelMigratorTest.class.getResourceAsStream(DATA2_XML);
        Assert.assertNotNull((Object)dataXML);
        StringWriter outputXML = new StringWriter();
        try {
            OldWizardLabelMigrator migrator = new OldWizardLabelMigrator();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("port_type", "node");
            params.put("search_uniqueId", Long.toString(1464607285711414L));
            migrator.doTransform(params, inputXSL, dataXML, outputXML);
        }
        finally {
            if (outputXML != null) {
                try {
                    outputXML.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputXML writer failed.", (Throwable)ex);
                }
            }
            if (inputXSL != null) {
                try {
                    inputXSL.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close inputXSL stream failed.", (Throwable)ex);
                }
            }
        }
        LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
        Assert.assertTrue((outputXML.getBuffer().length() > 0 ? 1 : 0) != 0);
        InputStream is = OldWizardLabelMigratorTest.class.getResourceAsStream("/xml-test/result/wizard-old/NodeLabels.xml");
        String xmlContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Diff myDiffSimilar = DiffBuilder.compare((Object)xmlContent).withTest((Object)outputXML.toString()).checkForSimilar().build();
        Assert.assertFalse((boolean)myDiffSimilar.hasDifferences(), (String)("XML similar " + myDiffSimilar.toString()));
    }

    @Test
    public void findAllNodesInWizardLightPortLabelsTest() {
        URL url = OldWizardLabelMigratorTest.class.getResource(DATA1_XML);
        Assert.assertNotNull((Object)url);
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getFullPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        OldWizardLabelMigrator migrator = new OldWizardLabelMigrator();
        Nodes nodes = migrator.performFindAllNodesInWizardLabels("LightPortLabels", "/migration/labels-migration5.xsl", searchPath);
        Assert.assertNotNull((Object)nodes);
        Assert.assertNotNull((Object)nodes.getNodeLabel());
        List nodeLabels = nodes.getNodeLabel();
        LOGGER.info("Current nodeLabels: {}", (Object)nodeLabels);
        Assert.assertEquals((int)nodeLabels.size(), (int)2);
    }

    @Test
    public void findAllNodesInWizardLabelsTest() {
        URL url = OldWizardLabelMigratorTest.class.getResource(DATA1_XML);
        Assert.assertNotNull((Object)url);
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getFullPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        OldWizardLabelMigrator migrator = new OldWizardLabelMigrator();
        Nodes nodes = migrator.findAllNodesInWizardLabels(searchPath);
        Assert.assertNotNull((Object)nodes);
        Assert.assertNotNull((Object)nodes.getNodeLabel());
        List nodeLabels = nodes.getNodeLabel();
        LOGGER.info("Current nodeLabels: {}", (Object)nodeLabels);
        Assert.assertEquals((int)nodeLabels.size(), (int)3);
    }

    @Test
    public void migrationOldAccessoryLabelsToNodeLabelsTest() {
        URL url = OldWizardLabelMigratorTest.class.getResource(DATA2_XML);
        Assert.assertNotNull((Object)url);
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getFullPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        MigrationContext context = new MigrationContext();
        OldWizardLabelMigrator migrator = new OldWizardLabelMigrator();
        NodeLabels nodeLabels = migrator.performWizardLabelsMigration((ApplicationContext)context, 1464607285711414L, searchPath);
        Assert.assertNotNull((Object)nodeLabels);
        Assert.assertNotNull((Object)nodeLabels.getNodeLabel());
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assert.assertEquals((long)nodeLabel.getUniqueId(), (long)1464607285711414L);
        Assert.assertEquals((String)nodeLabel.getUserName(), (String)"Node_0_Test");
        Assert.assertNotNull((Object)nodeLabels.getPortLabels());
        PortLabels portLabels = nodeLabels.getPortLabels();
        Assert.assertNotNull((Object)portLabels.getPortLabel());
        List portLabelList = portLabels.getPortLabel();
        Assert.assertEquals((int)portLabelList.size(), (int)3);
        Assert.assertEquals((int)LabelFactory.getPortsOfType((List)portLabelList, (PortType)PortType.SERVO).size(), (int)0);
        Assert.assertEquals((int)LabelFactory.getPortsOfType((List)portLabelList, (PortType)PortType.SWITCH).size(), (int)0);
        Assert.assertEquals((int)LabelFactory.getPortsOfType((List)portLabelList, (PortType)PortType.INPUT).size(), (int)0);
        Assert.assertEquals((int)LabelFactory.getPortsOfType((List)portLabelList, (PortType)PortType.LIGHT).size(), (int)3);
    }
}

