/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.migration.migrator;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.LabelFactory;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.core.utils.NodeUtils;
import org.bidib.wizard.common.context.ApplicationContext;
import org.bidib.wizard.common.locale.Resources;
import org.bidib.wizard.migration.labels.AbstractWizardLabelMigrator;
import org.bidib.wizard.migration.labels.Bidib2LabelMigrator;
import org.bidib.wizard.migration.labels.OldWizardLabelMigrator;
import org.bidib.wizard.migration.labels.WizardLabelMigrator;
import org.bidib.wizard.migration.migrator.MigrationContext;
import org.bidib.wizard.migration.migrator.MigrationException;
import org.bidib.wizard.migration.progress.MigrationProgressFrame;
import org.bidib.wizard.migration.schema.nodes.NodeLabel;
import org.bidib.wizard.migration.schema.nodes.Nodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardMigrator.class);
    private static final String MIGRATION_FILE = "wizard-migration.log";
    private static final String MIGRATION_LABELS_MARKER = "## Transformation of wizard labels performed.";
    private static final String EOL = "\r\n";
    private MigrationProgressFrame frame;
    private final ScheduledExecutorService migrationWorkers = Executors.newScheduledThreadPool(1);
    private static final String BIDIB_DEFAULT_LABEL_SUBDIR = "labels";

    protected NodeLabels migrateLabels(ApplicationContext context, Class<?> migratorClass, long uniqueId, String ... searchpaths) {
        LOGGER.info("Migrate labels for node with uniqueId: {}, migratorClass: {}, searchpaths: {}", new Object[]{uniqueId, migratorClass, searchpaths});
        NodeLabels nodeLabels = null;
        for (String searchpath : searchpaths) {
            try {
                if (migratorClass != null) {
                    LOGGER.info("Use migrator to convert labels: {}", migratorClass);
                    AbstractWizardLabelMigrator wizardLabelMigrator = (AbstractWizardLabelMigrator)migratorClass.newInstance();
                    nodeLabels = wizardLabelMigrator.performWizardLabelsMigration(context, uniqueId, searchpath);
                } else {
                    LOGGER.info("Try all available migrators to convert labels.");
                    Bidib2LabelMigrator bidib2LabelMigrator = new Bidib2LabelMigrator();
                    nodeLabels = bidib2LabelMigrator.performWizardLabelsMigration(context, uniqueId, searchpath);
                    if (nodeLabels != null) {
                        LOGGER.info("Migration of labels from Bidib2 format passed.");
                    } else {
                        WizardLabelMigrator wizardLabelMigrator = new WizardLabelMigrator();
                        nodeLabels = wizardLabelMigrator.performWizardLabelsMigration(context, uniqueId, searchpath);
                        if (nodeLabels != null) {
                            LOGGER.info("Migration of labels from Wizard format passed.");
                        } else {
                            OldWizardLabelMigrator oldWizardLabelMigrator = new OldWizardLabelMigrator();
                            nodeLabels = oldWizardLabelMigrator.performWizardLabelsMigration(context, uniqueId, searchpath);
                        }
                    }
                }
            }
            catch (MigrationException ex) {
                LOGGER.warn("Perform transformation of bidib2 migration failed.", (Throwable)ex);
                throw new MigrationException("Perform transformation for label migration failed.", ex);
            }
            catch (Exception ex) {
                LOGGER.warn("perform bidib2 or wizard labels migration failed.", (Throwable)ex);
            }
            if (nodeLabels == null) continue;
            LOGGER.info("Return found labels.");
            break;
        }
        return nodeLabels;
    }

    public Nodes findAllNodesInWizardLabels(Class<?>[] migratorClassHolder, String ... searchpaths) {
        Nodes nodes = null;
        for (String searchpath : searchpaths) {
            LOGGER.info("Search for nodes in path: {}", (Object)searchpath);
            try {
                Bidib2LabelMigrator bidib2LabelMigrator = new Bidib2LabelMigrator();
                nodes = bidib2LabelMigrator.findAllNodesInWizardLabels(searchpath);
                if (nodes != null && CollectionUtils.isNotEmpty(nodes.getNodeLabel())) {
                    LOGGER.info("Migration of labels from Bidib2 format passed.");
                    migratorClassHolder[0] = Bidib2LabelMigrator.class;
                } else {
                    WizardLabelMigrator wizardLabelMigrator = new WizardLabelMigrator();
                    nodes = wizardLabelMigrator.findAllNodesInWizardLabels(searchpath);
                    if (nodes != null && CollectionUtils.isNotEmpty(nodes.getNodeLabel())) {
                        LOGGER.info("Migration of labels from Wizard format passed.");
                        migratorClassHolder[0] = WizardLabelMigrator.class;
                    } else {
                        OldWizardLabelMigrator oldWizardLabelMigrator = new OldWizardLabelMigrator();
                        nodes = oldWizardLabelMigrator.findAllNodesInWizardLabels(searchpath);
                        if (nodes != null && CollectionUtils.isNotEmpty(nodes.getNodeLabel())) {
                            LOGGER.info("Migration of node labels from old Wizard format passed.");
                            migratorClassHolder[0] = OldWizardLabelMigrator.class;
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("perform bidib2 or wizard labels migration failed.", (Throwable)ex);
            }
            if (nodes == null) continue;
            LOGGER.info("Return found labels in searchPath: {}", (Object)searchpath);
            nodes.setSearchPath(searchpath);
            break;
        }
        return nodes;
    }

    public String checkAndPerformMigration(String targetPath, File migrationLogFile, String ... searchRoots) {
        try {
            LOGGER.info("Check if the migration log exists under: {}", (Object)migrationLogFile);
            if (migrationLogFile.exists() && this.scanFileForMarker(migrationLogFile, MIGRATION_LABELS_MARKER)) {
                LOGGER.info("The labels migration was performed already, the migration log exists under: {}", (Object)migrationLogFile);
                return null;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Check for migration failed.", (Throwable)ex);
        }
        LOGGER.info("Perform migration of labels, targetPath: {}", (Object)targetPath);
        File migrationLogFileTemp = migrationLogFile;
        if (searchRoots.length > 1 && !targetPath.equalsIgnoreCase(searchRoots[1]) && !targetPath.startsWith(searchRoots[1])) {
            LOGGER.info("The legacy labels are not stored at the default location: {}", (Object)searchRoots[1]);
            int result = 1;
            if (SwingUtilities.isEventDispatchThread()) {
                result = JOptionPane.showConfirmDialog(null, Resources.getString(this.getClass(), (String)"migration_alternate_location.text", (Object[])new Object[]{searchRoots[1], targetPath}), Resources.getString(this.getClass(), (String)"migration_alternate_location.title"), 0, 3);
            } else {
                int[] resultHolder = new int[1];
                String tempTargetPath = targetPath;
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        int tempResult = JOptionPane.showConfirmDialog(null, Resources.getString(this.getClass(), (String)"migration_alternate_location.text", (Object[])new Object[]{searchRoots[1], tempTargetPath}), Resources.getString(this.getClass(), (String)"migration_alternate_location.title"), 0, 3);
                        LOGGER.info("Received result from alternate migration location dialog: {}", (Object)tempResult);
                        resultHolder[0] = tempResult;
                    });
                    result = resultHolder[0];
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    LOGGER.warn("Show dialog to select alternate migration location failed.", (Throwable)ex);
                }
            }
            if (result == 0) {
                File bidibBaseDir = new File(searchRoots[1], BIDIB_DEFAULT_LABEL_SUBDIR);
                try {
                    LOGGER.info("Make sure the directory exists: {}", (Object)bidibBaseDir);
                    bidibBaseDir.mkdirs();
                }
                catch (Exception ex) {
                    LOGGER.warn("Create new labels directory at custom location failed: {}", (Object)bidibBaseDir, (Object)ex);
                }
                targetPath = bidibBaseDir.getPath();
                LOGGER.info("Changed target path to location: {}", (Object)targetPath);
                migrationLogFileTemp = this.getMigrationLogfile(targetPath);
            }
        }
        this.executeMigrationTask(targetPath, MigrationTaskType.labelMigration, migrationLogFileTemp, searchRoots);
        return targetPath;
    }

    protected void executeMigrationTask(String targetPath, MigrationTaskType migrationTask, File migrationLogFile, String ... searchRoots) {
        block14: {
            LOGGER.info("Execute migration task for task type: {}", (Object)migrationTask);
            FileWriter migrationFileWriter = null;
            try {
                String headless = System.getProperty("java.awt.headless");
                boolean isHeadless = false;
                if (StringUtils.isNotEmpty((CharSequence)headless)) {
                    try {
                        isHeadless = Boolean.parseBoolean(headless);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Convert headless flag failed.", (Throwable)ex);
                    }
                }
                if (!isHeadless) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        JFrame frame = this.createMigrationFrame();
                        LOGGER.info("Created migrationFrame: {}", (Object)frame);
                    } else {
                        SwingUtilities.invokeAndWait(() -> {
                            JFrame frame = this.createMigrationFrame();
                            LOGGER.info("Created migrationFrame: {}", (Object)frame);
                        });
                    }
                } else {
                    LOGGER.info("Do not show migration frame on headless env.");
                }
                if (!migrationLogFile.getParentFile().exists()) {
                    migrationLogFile.getParentFile().mkdirs();
                }
                migrationLogFile.createNewFile();
                migrationFileWriter = new FileWriter(migrationLogFile, true);
                migrationFileWriter.write("Migration started: " + new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(new Date()) + EOL);
                LabelMigrationTask migrationTaskTask = null;
                switch (migrationTask) {
                    default: 
                }
                migrationTaskTask = new LabelMigrationTask(targetPath, migrationFileWriter, this.frame, searchRoots);
                Future<?> future = this.startMigrationWorker(migrationFileWriter, migrationTaskTask);
                LOGGER.info("Wait for completion of task: {}", (Object)migrationTask);
                future.get();
                LOGGER.info("Migration task has finished: {}", (Object)migrationTask);
            }
            catch (Exception ex) {
                LOGGER.warn("Create migration logfile failed.", (Throwable)ex);
                if (migrationFileWriter == null) break block14;
                try {
                    migrationFileWriter.write("Migration failed: " + new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(new Date()));
                }
                catch (IOException ex1) {
                    LOGGER.warn("Write migration failed to migration logfile failed.", (Throwable)ex1);
                }
            }
        }
    }

    private Future<?> startMigrationWorker(FileWriter migrationFileWriter, AbstractMigrationTask migrationTask) {
        LOGGER.info("Start the migration worker. Submit task: {}", (Object)migrationTask);
        return this.migrationWorkers.submit(migrationTask);
    }

    private JFrame createMigrationFrame() {
        this.frame = new MigrationProgressFrame(Resources.getString(WizardMigrator.class, (String)"migrationFrame.title"));
        this.frame.setDefaultCloseOperation(2);
        JLabel progressLabel = new JLabel(Resources.getString(WizardMigrator.class, (String)"migrationFrame.migrationInProgress"));
        progressLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.frame.getContentPane().add((Component)progressLabel, "Center");
        this.frame.pack();
        this.frame.setSize(300, 100);
        this.frame.setLocationRelativeTo(null);
        this.frame.startCloseChecker();
        this.frame.setVisible(true);
        return this.frame;
    }

    private void performLabelMigration(String targetPath, FileWriter migrationFileWriter, String[] searchPaths) throws IOException {
        LOGGER.info("Perform the label migration, targetPath: {}, searchPaths: {}.", (Object)targetPath, (Object)new Object[]{searchPaths});
        Class[] migratorClassHolder = new Class[1];
        Nodes nodes = this.findAllNodesInWizardLabels(migratorClassHolder, searchPaths);
        LOGGER.info("Found nodes: {}", (Object)nodes);
        LOGGER.info("Returned migratorClassHolder: {}", (Object)migratorClassHolder[0]);
        if (nodes == null) {
            LOGGER.info("No nodes to migrate found.");
            return;
        }
        String searchPathForLabels = nodes.getSearchPath();
        LOGGER.info("Found searchPathForLabels: {}", (Object)searchPathForLabels);
        MigrationContext context = new MigrationContext();
        LabelFactory labelFactory = new LabelFactory();
        boolean errorDetected = false;
        for (NodeLabel nodeLabel : nodes.getNodeLabel()) {
            LOGGER.info("Collect labels for node: {}", (Object)nodeLabel);
            migrationFileWriter.write("Process labels of node with uniqueId '" + NodeUtils.formatHexUniqueId((long)nodeLabel.getUniqueId()) + EOL);
            try {
                String result;
                NodeLabels nodeLabels = this.migrateLabels(context, migratorClassHolder[0], nodeLabel.getUniqueId(), searchPathForLabels);
                LOGGER.info("Found nodeLabels: {}", (Object)nodeLabels);
                File file = new File(targetPath, LabelFactory.prepareNodeFilename((long)nodeLabel.getUniqueId()));
                LOGGER.info("Prepared file: {}", (Object)file);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                labelFactory.saveNodeLabel(nodeLabels, file, false);
                LOGGER.info("Saved labels of node with uniqueId: {}", (Object)nodeLabel.getUniqueId());
                migrationFileWriter.write("Saved labels of node with uniqueId '" + NodeUtils.formatHexUniqueId((long)nodeLabel.getUniqueId()) + "' to file: " + file.getPath() + EOL);
                if (!Bidib2LabelMigrator.class.getName().equals(nodes.getMigratorClass()) || !StringUtils.isNotBlank((CharSequence)(result = Bidib2LabelMigrator.moveSourceFileToBackupDir(nodes.getSearchPath(), nodeLabel.getUniqueId())))) continue;
                migrationFileWriter.write(result + EOL);
            }
            catch (MigrationException ex) {
                LOGGER.warn("Perform transformation of bidib2 migration failed for uniqueId: {} ({})", new Object[]{nodeLabel.getUniqueId(), NodeUtils.formatHexUniqueId((long)nodeLabel.getUniqueId()), ex});
                errorDetected = true;
                migrationFileWriter.write("Perform transformation for label migration failed. Save labels of node with uniqueId '" + NodeUtils.formatHexUniqueId((long)nodeLabel.getUniqueId()) + "' was skipped. Reason: " + ex.getMessage() + EOL);
            }
        }
        if (!errorDetected) {
            LOGGER.info("The migration was performed without errors.");
        }
        LOGGER.info("Perform the label migration finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanFileForMarker(File migrationLogFile, String marker) {
        boolean performMigrationTask = true;
        Scanner scanner = null;
        try {
            scanner = new Scanner(migrationLogFile);
            while (scanner.hasNextLine()) {
                String lineFromFile = scanner.nextLine();
                if (!lineFromFile.contains(marker)) continue;
                LOGGER.info("Found '{}' in file: {}", (Object)marker, (Object)migrationLogFile.getName());
                performMigrationTask = false;
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Scan migration log for uniqueId marker failed.", (Throwable)ex);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception ex) {
                    LOGGER.warn("Close scanner failed.", (Throwable)ex);
                }
            }
        }
        return performMigrationTask;
    }

    public File getMigrationLogfile(String path) {
        File migrationLogFile = new File(path, MIGRATION_FILE);
        return migrationLogFile;
    }

    private final class LabelMigrationTask
    extends AbstractMigrationTask {
        private final String[] searchRoot;
        private final String targetPath;

        protected LabelMigrationTask(String targetPath, FileWriter migrationFileWriter, MigrationProgressFrame frame, String[] searchRoots) {
            super(migrationFileWriter, frame);
            this.searchRoot = searchRoots;
            this.targetPath = targetPath;
        }

        @Override
        protected void doMigrationTask() throws Exception {
            LOGGER.info("Perform the migration of labels to targetPath: {}", (Object)this.targetPath);
            WizardMigrator.this.performLabelMigration(this.targetPath, this.migrationFileWriter, this.searchRoot);
            LOGGER.info("Perform the migration of labels passed.");
        }
    }

    private abstract class AbstractMigrationTask
    implements Runnable {
        protected final FileWriter migrationFileWriter;
        protected final MigrationProgressFrame frame;

        protected AbstractMigrationTask(FileWriter migrationFileWriter, MigrationProgressFrame frame) {
            this.migrationFileWriter = migrationFileWriter;
            this.frame = frame;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOGGER.info("Process the migration task.");
                this.doMigrationTask();
                LOGGER.info("Process the migration task passed.");
                this.migrationFileWriter.write("Migration finished: " + new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(new Date()) + WizardMigrator.EOL);
            }
            catch (Exception ex) {
                LOGGER.warn("Process the migration task failed.", (Throwable)ex);
            }
            finally {
                if (this.migrationFileWriter != null) {
                    try {
                        this.migrationFileWriter.close();
                    }
                    catch (IOException ex) {
                        LOGGER.warn("Close migration file writer failed.", (Throwable)ex);
                    }
                }
                if (this.frame != null) {
                    Object lock;
                    LOGGER.info("Signal that migration has finished.");
                    this.frame.getFinished().set(true);
                    Object object = lock = this.frame.getCloseLock();
                    synchronized (object) {
                        lock.notifyAll();
                    }
                    LOGGER.info("Signalled that migration has finished.");
                } else {
                    LOGGER.info("No frame available to signal that the migration has finished.");
                }
            }
        }

        protected abstract void doMigrationTask() throws Exception;
    }

    private static enum MigrationTaskType {
        labelMigration;

    }
}

