/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.migration.labels;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.bidib.jbidibc.core.schema.bidibbase.PortType;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.FeedbackPortLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.LabelFactory;
import org.bidib.jbidibc.core.schema.bidiblabels.MacroLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.PortLabels;
import org.bidib.wizard.migration.labels.Bidib2LabelMigrator;
import org.bidib.wizard.migration.labels.WizardLabelMigrator;
import org.bidib.wizard.migration.schema.nodes.Nodes;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WizardLabelMigratorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardLabelMigratorTest.class);
    private static final String NAMESPACE_PREFIX = "{http://www.bidib.org/schema/labels}";
    private static final String INPUT_XSL = "/migration/labels-migration.xsl";
    private static final String INPUT2_XSL = "/migration/labels-migration2.xsl";
    private static final String DATA1_XML = "/xml-test/labels/bidib2/05000DD00043ED.xml";
    private static final String DATA2_XML = "/xml-test/labels/bidib2/05000D6B009AEA.xml";
    private static final String DATA3_XML = "/xml-test/labels/wizard/NodeLabels.labels";
    private static final String DATA4_XML = "/xml-test/labels/wizard/AccessoryLabels.labels";
    private static final String DATA5_XML = "/xml-test/labels/wizard/MacroLabels.labels";

    @Test
    public void migrationWithUniqueIdAsIntegerTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA1_XML);
        Assert.assertNotNull((Object)url);
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        Bidib2LabelMigrator migrator = new Bidib2LabelMigrator();
        NodeLabels nodeLabels = migrator.performBidib2Migration(1407434207806445L, searchPath);
        Assert.assertNotNull((Object)nodeLabels);
        Assert.assertNotNull((Object)nodeLabels.getNodeLabel());
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assert.assertEquals((long)nodeLabel.getUniqueId(), (long)1407434207806445L);
        Assert.assertEquals((String)nodeLabel.getUserName(), (String)"NeoTest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="Test XSL transformation and compare to xml from file.")
    public void transformationWithUniqueIdAsIntegerTest() throws TransformerException, URISyntaxException, SAXException, IOException {
        InputStream inputXSL = WizardLabelMigratorTest.class.getResourceAsStream(INPUT_XSL);
        Assert.assertNotNull((Object)inputXSL);
        InputStream dataXML = WizardLabelMigratorTest.class.getResourceAsStream(DATA1_XML);
        Assert.assertNotNull((Object)dataXML);
        StringWriter outputXML = new StringWriter();
        try {
            WizardLabelMigrator migrator = new WizardLabelMigrator();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("search_uniqueId", Long.toString(1407434207806445L));
            migrator.doTransform(params, inputXSL, dataXML, outputXML);
        }
        finally {
            if (outputXML != null) {
                try {
                    outputXML.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputXML writer failed.", (Throwable)ex);
                }
            }
            if (inputXSL != null) {
                try {
                    inputXSL.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close inputXSL stream failed.", (Throwable)ex);
                }
            }
        }
        LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
        Assert.assertTrue((outputXML.getBuffer().length() > 0 ? 1 : 0) != 0);
        Document testDoc = XMLUnit.buildControlDocument((String)outputXML.toString());
        InputStream is = WizardLabelMigratorTest.class.getResourceAsStream("/xml-test/result/05000DD00043ED.xml");
        String xmlContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Document controlDoc = XMLUnit.buildControlDocument((String)xmlContent);
        XMLAssert.assertXMLEqual((Document)controlDoc, (Document)testDoc);
    }

    @Test
    public void migrationWithUniqueIdAsHexTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA2_XML);
        Assert.assertNotNull((Object)url);
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        Bidib2LabelMigrator migrator = new Bidib2LabelMigrator();
        NodeLabels nodeLabels = migrator.performBidib2Migration(1407432513329898L, searchPath);
        Assert.assertNotNull((Object)nodeLabels);
        Assert.assertNotNull((Object)nodeLabels.getNodeLabel());
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assert.assertEquals((long)nodeLabel.getUniqueId(), (long)1407432513329898L);
        Assert.assertEquals((String)nodeLabel.getUserName(), (String)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="Test XSL transformation and compare to xml from file.")
    public void transformationWithUniqueIdAsHexTest() throws TransformerException, URISyntaxException, SAXException, IOException {
        InputStream inputXSL = WizardLabelMigratorTest.class.getResourceAsStream(INPUT_XSL);
        Assert.assertNotNull((Object)inputXSL);
        InputStream dataXML = WizardLabelMigratorTest.class.getResourceAsStream(DATA2_XML);
        Assert.assertNotNull((Object)dataXML);
        StringWriter outputXML = new StringWriter();
        try {
            WizardLabelMigrator migrator = new WizardLabelMigrator();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("search_uniqueId", Long.toString(1407432513329898L));
            migrator.doTransform(params, inputXSL, dataXML, outputXML);
        }
        finally {
            if (outputXML != null) {
                try {
                    outputXML.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputXML writer failed.", (Throwable)ex);
                }
            }
            if (inputXSL != null) {
                try {
                    inputXSL.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close inputXSL stream failed.", (Throwable)ex);
                }
            }
        }
        LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
        Assert.assertTrue((outputXML.getBuffer().length() > 0 ? 1 : 0) != 0);
        Document testDoc = XMLUnit.buildControlDocument((String)outputXML.toString());
        InputStream is = WizardLabelMigratorTest.class.getResourceAsStream("/xml-test/result/05000D6B009AEA.xml");
        String xmlContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Document controlDoc = XMLUnit.buildControlDocument((String)xmlContent);
        XMLAssert.assertXMLEqual((Document)controlDoc, (Document)testDoc);
    }

    @Test(description="Test XSL transformation and compare to xml from file.")
    public void transformationOldNodeLabelsTest() throws TransformerException, URISyntaxException, SAXException, IOException {
        InputStream inputXSL = WizardLabelMigratorTest.class.getResourceAsStream(INPUT2_XSL);
        Assert.assertNotNull((Object)inputXSL);
        InputStream dataXML = WizardLabelMigratorTest.class.getResourceAsStream(DATA3_XML);
        Assert.assertNotNull((Object)dataXML);
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslStream = new StreamSource(inputXSL);
        Transformer transformer = factory.newTransformer(xslStream);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        transformer.setParameter("{http://www.bidib.org/schema/labels}search_uniqueId", "61361602502354154");
        StreamSource in = new StreamSource(dataXML);
        StringWriter outputXML = new StringWriter();
        StreamResult out = new StreamResult(outputXML);
        transformer.transform(in, out);
        LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
        Assert.assertTrue((outputXML.getBuffer().length() > 0 ? 1 : 0) != 0);
        Document testDoc = XMLUnit.buildControlDocument((String)outputXML.toString());
        InputStream is = WizardLabelMigratorTest.class.getResourceAsStream("/xml-test/result/DA000D680064EA-node.xml");
        String xmlContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Document controlDoc = XMLUnit.buildControlDocument((String)xmlContent);
        XMLAssert.assertXMLEqual((Document)controlDoc, (Document)testDoc);
    }

    @Test
    public void migrationOldNodeLabelsTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA3_XML);
        Assert.assertNotNull((Object)url);
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("search_uniqueId", Long.toString(61361602502354154L));
        WizardLabelMigrator migrator = new WizardLabelMigrator();
        NodeLabels nodeLabels = migrator.performWizardLabelsMigration(params, "NodeLabels.labels", searchPath);
        Assert.assertNotNull((Object)nodeLabels);
        Assert.assertNotNull((Object)nodeLabels.getNodeLabel());
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assert.assertEquals((long)nodeLabel.getUniqueId(), (long)61361602502354154L);
        Assert.assertEquals((String)nodeLabel.getUserName(), (String)"Test Booster Main");
    }

    @Test(description="Test XSL transformation and compare to xml from file.")
    public void transformationOldAccessoryLabelsTest() throws TransformerException, URISyntaxException, SAXException, IOException {
        InputStream inputXSL = WizardLabelMigratorTest.class.getResourceAsStream(INPUT2_XSL);
        Assert.assertNotNull((Object)inputXSL);
        InputStream dataXML = WizardLabelMigratorTest.class.getResourceAsStream(DATA4_XML);
        Assert.assertNotNull((Object)dataXML);
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslStream = new StreamSource(inputXSL);
        Transformer transformer = factory.newTransformer(xslStream);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        transformer.setParameter("{http://www.bidib.org/schema/labels}search_uniqueId", "1464607285711414");
        StreamSource in = new StreamSource(dataXML);
        StringWriter outputXML = new StringWriter();
        StreamResult out = new StreamResult(outputXML);
        transformer.transform(in, out);
        LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
        Assert.assertTrue((outputXML.getBuffer().length() > 0 ? 1 : 0) != 0);
        Document testDoc = XMLUnit.buildControlDocument((String)outputXML.toString());
        InputStream is = WizardLabelMigratorTest.class.getResourceAsStream("/xml-test/result/5340D75001236-accessories.xml");
        String xmlContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Document controlDoc = XMLUnit.buildControlDocument((String)xmlContent);
        XMLAssert.assertXMLEqual((Document)controlDoc, (Document)testDoc);
    }

    @Test
    public void migrationOldAccessoryLabelsTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA4_XML);
        Assert.assertNotNull((Object)url);
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("search_uniqueId", Long.toString(1464607285711414L));
        WizardLabelMigrator migrator = new WizardLabelMigrator();
        NodeLabels nodeLabels = migrator.performWizardLabelsMigration(params, "AccessoryLabels.labels", searchPath);
        Assert.assertNotNull((Object)nodeLabels);
        Assert.assertNotNull((Object)nodeLabels.getNodeLabel());
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assert.assertEquals((long)nodeLabel.getUniqueId(), (long)1464607285711414L);
        Assert.assertNull((Object)nodeLabel.getUserName());
    }

    @Test
    public void migrationOldAccessoryLabelsToNodeLabelsTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA4_XML);
        Assert.assertNotNull((Object)url);
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        WizardLabelMigrator migrator = new WizardLabelMigrator();
        NodeLabels nodeLabels = migrator.performWizardLabelsMigration(1464607285711414L, searchPath);
        Assert.assertNotNull((Object)nodeLabels);
        Assert.assertNotNull((Object)nodeLabels.getNodeLabel());
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assert.assertEquals((long)nodeLabel.getUniqueId(), (long)1464607285711414L);
        Assert.assertEquals((String)nodeLabel.getUserName(), (String)"OneControl Test 1");
        Assert.assertNotNull((Object)nodeLabels.getMacroLabels());
        MacroLabels macroLabels = nodeLabels.getMacroLabels();
        Assert.assertNotNull((Object)macroLabels.getMacroLabel());
        Assert.assertEquals((int)macroLabels.getMacroLabel().size(), (int)32);
        Assert.assertNotNull((Object)nodeLabels.getAccessoryLabels());
        AccessoryLabels acecssoryLabels = nodeLabels.getAccessoryLabels();
        Assert.assertNotNull((Object)acecssoryLabels.getAccessoryLabel());
        Assert.assertEquals((int)acecssoryLabels.getAccessoryLabel().size(), (int)20);
        Assert.assertNotNull((Object)nodeLabels.getFeedbackPortLabels());
        FeedbackPortLabels feedbackPortLabels = nodeLabels.getFeedbackPortLabels();
        Assert.assertNotNull((Object)feedbackPortLabels.getPortLabel());
        Assert.assertEquals((int)feedbackPortLabels.getPortLabel().size(), (int)1);
        Assert.assertNotNull((Object)nodeLabels.getPortLabels());
        PortLabels portLabels = nodeLabels.getPortLabels();
        Assert.assertNotNull((Object)portLabels.getPortLabel());
        List portLabelList = portLabels.getPortLabel();
        Assert.assertEquals((int)portLabelList.size(), (int)40);
        Assert.assertEquals((int)LabelFactory.getPortsOfType((List)portLabelList, (PortType)PortType.SERVO).size(), (int)8);
        Assert.assertEquals((int)LabelFactory.getPortsOfType((List)portLabelList, (PortType)PortType.SWITCH).size(), (int)16);
        Assert.assertEquals((int)LabelFactory.getPortsOfType((List)portLabelList, (PortType)PortType.INPUT).size(), (int)16);
        Assert.assertEquals((int)LabelFactory.getPortsOfType((List)portLabelList, (PortType)PortType.LIGHT).size(), (int)0);
    }

    @Test(description="Test XSL transformation and compare to xml from file.")
    public void transformationOldMacroLabelsTest() throws TransformerException, URISyntaxException, SAXException, IOException {
        InputStream inputXSL = WizardLabelMigratorTest.class.getResourceAsStream(INPUT2_XSL);
        Assert.assertNotNull((Object)inputXSL);
        InputStream dataXML = WizardLabelMigratorTest.class.getResourceAsStream(DATA5_XML);
        Assert.assertNotNull((Object)dataXML);
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslStream = new StreamSource(inputXSL);
        Transformer transformer = factory.newTransformer(xslStream);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        transformer.setParameter("{http://www.bidib.org/schema/labels}search_uniqueId", "1464607285711414");
        StreamSource in = new StreamSource(dataXML);
        StringWriter outputXML = new StringWriter();
        StreamResult out = new StreamResult(outputXML);
        transformer.transform(in, out);
        LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
        Assert.assertTrue((outputXML.getBuffer().length() > 0 ? 1 : 0) != 0);
        Document testDoc = XMLUnit.buildControlDocument((String)outputXML.toString());
        InputStream is = WizardLabelMigratorTest.class.getResourceAsStream("/xml-test/result/5340D75001236-macros.xml");
        String xmlContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Document controlDoc = XMLUnit.buildControlDocument((String)xmlContent);
        XMLAssert.assertXMLEqual((Document)controlDoc, (Document)testDoc);
    }

    @Test
    public void migrationOldMacroLabelsTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA5_XML);
        Assert.assertNotNull((Object)url);
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("search_uniqueId", Long.toString(1464607285711414L));
        WizardLabelMigrator migrator = new WizardLabelMigrator();
        NodeLabels nodeLabels = migrator.performWizardLabelsMigration(params, "MacroLabels.labels", searchPath);
        Assert.assertNotNull((Object)nodeLabels);
        Assert.assertNotNull((Object)nodeLabels.getNodeLabel());
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assert.assertEquals((long)nodeLabel.getUniqueId(), (long)1464607285711414L);
        Assert.assertNull((Object)nodeLabel.getUserName());
    }

    @Test
    public void findAllNodesInWizardLabelsTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA3_XML);
        Assert.assertNotNull((Object)url);
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        WizardLabelMigrator migrator = new WizardLabelMigrator();
        Nodes nodes = migrator.findAllNodesInWizardLabels(searchPath);
        Assert.assertNotNull((Object)nodes);
        Assert.assertNotNull((Object)nodes.getNodeLabel());
        List nodeLabels = nodes.getNodeLabel();
        LOGGER.info("Current nodeLabels: {}", (Object)nodeLabels);
        Assert.assertEquals((int)nodeLabels.size(), (int)6);
    }
}

