/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.migration.migrator;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.bidib.jbidibc.core.schema.bidiblabels.LabelFactory;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.migration.labels.Bidib2LabelMigrator;
import org.bidib.wizard.migration.labels.WizardLabelMigratorTest;
import org.bidib.wizard.migration.migrator.WizardMigrator;
import org.bidib.wizard.migration.schema.nodes.NodeLabel;
import org.bidib.wizard.migration.schema.nodes.Nodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class WizardMigratorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardMigratorTest.class);
    private static final String DATA1_XML = "/xml-test/labels/bidib2/05000DD00043ED.xml";
    private static final String DATA1_COPY_XML = "target/xml-mig/bidib2/nodeLabels/05000DD00043ED.xml";
    private static final String DATA3_XML = "/xml-test/labels/wizard/NodeLabels.labels";
    private static final String OUTPUT_TARGET_DIR_BIDIB2 = "target/xml-mig/bidib2/nodeLabels";
    private static final String OUTPUT_TARGET_DIR_WIZARD = "target/xml-mig/wizard/nodeLabels";

    @BeforeClass
    public void prepareOutputDirectory() {
        File outputDir;
        LOGGER.info("Prepare the target directory for the migrated labels");
        try {
            outputDir = new File(OUTPUT_TARGET_DIR_WIZARD);
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            } else {
                FileUtils.cleanDirectory((File)outputDir);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Create output directory failed: {}", (Object)OUTPUT_TARGET_DIR_WIZARD, (Object)ex);
        }
        try {
            outputDir = new File(OUTPUT_TARGET_DIR_BIDIB2);
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            } else {
                FileUtils.cleanDirectory((File)outputDir);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Create output directory failed: {}", (Object)OUTPUT_TARGET_DIR_BIDIB2, (Object)ex);
        }
        try {
            URL url = WizardLabelMigratorTest.class.getResource(DATA1_XML);
            File source = new File(url.toURI());
            IOFileFilter txtSuffixFilter = FileFilterUtils.suffixFileFilter((String)".xml");
            IOFileFilter txtFiles = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, txtSuffixFilter});
            Path target = Paths.get(OUTPUT_TARGET_DIR_BIDIB2, new String[0]);
            LOGGER.info("Copy file: {}, to target: {}", (Object)source, (Object)target);
            FileUtils.copyDirectory((File)source.getParentFile(), (File)target.toFile(), (FileFilter)txtFiles);
        }
        catch (Exception ex) {
            LOGGER.warn("Copy files to migration dir failed.", (Throwable)ex);
        }
    }

    @Test
    public void migrateWizardLabels() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA3_XML);
        Assert.assertNotNull((Object)url);
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getPath((String)searchPath);
        String[] searchpaths = new String[]{searchPath};
        WizardMigrator migrator = new WizardMigrator();
        Nodes nodes = migrator.findAllNodesInWizardLabels(searchpaths);
        Assert.assertNotNull((Object)nodes);
        Assert.assertNotNull((Object)nodes.getSearchPath());
        LOGGER.info("Found nodes: {}", (Object)nodes);
        Assert.assertNotNull((Object)nodes.getNodeLabel());
        Assert.assertEquals((int)nodes.getNodeLabel().size(), (int)6);
        String searchPathForLabels = nodes.getSearchPath();
        LabelFactory labelFactory = new LabelFactory();
        for (NodeLabel nodeLabel : nodes.getNodeLabel()) {
            LOGGER.info("Collect labels for node: {}", (Object)nodeLabel);
            NodeLabels nodeLabels = migrator.migrateLabels(nodeLabel.getUniqueId(), new String[]{searchPathForLabels});
            Assert.assertNotNull((Object)nodeLabels);
            LOGGER.info("Found nodeLabels: {}", (Object)nodeLabels);
            File file = new File(OUTPUT_TARGET_DIR_WIZARD, LabelFactory.prepareNodeFilename((long)nodeLabel.getUniqueId()));
            LOGGER.info("Prepared file: {}", (Object)file);
            labelFactory.saveNodeLabel(nodeLabels, file, false);
        }
    }

    @Test
    public void migrateBidib2Labels() {
        File source = new File(DATA1_COPY_XML);
        Assert.assertNotNull((Object)source);
        LOGGER.info("Prepared source file: {}", (Object)source);
        String searchPath = source.toString();
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        searchPath = FilenameUtils.getPath((String)searchPath);
        String[] searchpaths = new String[]{searchPath};
        WizardMigrator migrator = new WizardMigrator();
        Nodes nodes = migrator.findAllNodesInWizardLabels(searchpaths);
        Assert.assertNotNull((Object)nodes);
        Assert.assertNotNull((Object)nodes.getSearchPath());
        LOGGER.info("Found nodes: {}", (Object)nodes);
        Assert.assertNotNull((Object)nodes.getNodeLabel());
        Assert.assertEquals((int)nodes.getNodeLabel().size(), (int)2);
        String searchPathForLabels = nodes.getSearchPath();
        LabelFactory labelFactory = new LabelFactory();
        for (NodeLabel nodeLabel : nodes.getNodeLabel()) {
            LOGGER.info("Collect labels for node: {}", (Object)nodeLabel);
            NodeLabels nodeLabels = migrator.migrateLabels(nodeLabel.getUniqueId(), new String[]{searchPathForLabels});
            Assert.assertNotNull((Object)nodeLabels);
            LOGGER.info("Found nodeLabels: {}", (Object)nodeLabels);
            File file = new File(OUTPUT_TARGET_DIR_BIDIB2, LabelFactory.prepareNodeFilename((long)nodeLabel.getUniqueId()));
            LOGGER.info("Prepared file: {}", (Object)file);
            labelFactory.saveNodeLabel(nodeLabels, file, false);
            if (!Bidib2LabelMigrator.class.getName().equals(nodes.getMigratorClass())) continue;
            Bidib2LabelMigrator.moveSourceFileToBackupDir((String)nodes.getSearchPath(), (long)nodeLabel.getUniqueId());
        }
    }
}

