/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.migration.progress;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import javax.swing.Timer;
import org.bidib.wizard.migration.progress.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationProgressFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationProgressFrame.class);
    private Object closeLock = new Object();
    private Timer closeChecker;
    private AtomicBoolean finished = new AtomicBoolean();

    public MigrationProgressFrame(String title) {
        super(title);
        this.setIconImage(ImageUtils.createImageIcon(this.getClass(), "/icons/frameIcon_48x48.png").getImage());
        this.setAlwaysOnTop(true);
    }

    public void startCloseChecker() {
        this.closeChecker = new Timer(1000, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Check if migration has finished.");
                Object object = MigrationProgressFrame.this.closeLock;
                synchronized (object) {
                    try {
                        MigrationProgressFrame.this.closeLock.wait(2000L);
                        if (MigrationProgressFrame.this.finished.get()) {
                            LOGGER.info("Migration has finished.");
                            MigrationProgressFrame.this.closeChecker.stop();
                            MigrationProgressFrame.this.setVisible(false);
                        } else {
                            LOGGER.info("Migration has not finished yet.");
                        }
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Wait for close lock was interrupted.", (Throwable)ex);
                    }
                }
            }
        });
        this.closeChecker.setInitialDelay(100);
        this.closeChecker.start();
    }

    public Object getCloseLock() {
        return this.closeLock;
    }

    public AtomicBoolean getFinished() {
        return this.finished;
    }
}

