/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.migration.labels;

import java.util.HashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.FeedbackPortLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.MacroLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.migration.labels.AbstractWizardLabelMigrator;
import org.bidib.wizard.migration.schema.nodes.Nodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardLabelMigrator
extends AbstractWizardLabelMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardLabelMigrator.class);
    private static final String INPUT3_XSL = "/migration/labels-migration3.xsl";

    @Override
    public Nodes findAllNodesInWizardLabels(String searchpath) {
        LOGGER.info("Find all nodes in wizard labels, searchpath: {}", (Object)searchpath);
        Nodes nodes = null;
        try {
            Nodes inputPortNodes;
            Nodes lightPortNodes;
            Nodes backlightPortNodes;
            Nodes servoPortNodes;
            Nodes switchPortNodes;
            Nodes feedbackPortNodes;
            Nodes accessoryNodes;
            nodes = this.performFindAllNodesInWizardLabels("NodeLabels.labels", INPUT3_XSL, searchpath);
            if (nodes == null) {
                LOGGER.info("No nodes found in searchPath: {}", (Object)searchpath);
                return nodes;
            }
            Nodes macroNodes = this.performFindAllNodesInWizardLabels("MacroLabels.labels", INPUT3_XSL, searchpath);
            if (macroNodes != null && CollectionUtils.isNotEmpty(macroNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), macroNodes.getNodeLabel());
            }
            if ((accessoryNodes = this.performFindAllNodesInWizardLabels("AccessoryLabels.labels", INPUT3_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(accessoryNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), accessoryNodes.getNodeLabel());
            }
            if ((feedbackPortNodes = this.performFindAllNodesInWizardLabels("FeedbackPortLabels.labels", INPUT3_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(feedbackPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), feedbackPortNodes.getNodeLabel());
            }
            if ((switchPortNodes = this.performFindAllNodesInWizardLabels("SwitchPortLabels.labels", INPUT3_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(switchPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), switchPortNodes.getNodeLabel());
            }
            if ((servoPortNodes = this.performFindAllNodesInWizardLabels("ServoPortLabels.labels", INPUT3_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(servoPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), servoPortNodes.getNodeLabel());
            }
            if ((backlightPortNodes = this.performFindAllNodesInWizardLabels("BacklightPortLabels.labels", INPUT3_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(backlightPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), backlightPortNodes.getNodeLabel());
            }
            if ((lightPortNodes = this.performFindAllNodesInWizardLabels("LightPortLabels.labels", INPUT3_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(lightPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), lightPortNodes.getNodeLabel());
            }
            if ((inputPortNodes = this.performFindAllNodesInWizardLabels("InputPortLabels.labels", INPUT3_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(inputPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), inputPortNodes.getNodeLabel());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("find all nodes in wizard labels failed.", (Throwable)ex);
        }
        if (nodes != null) {
            LOGGER.info("Set the migrator class.");
            nodes.setMigratorClass(this.getClass().getName());
        }
        return nodes;
    }

    @Override
    public NodeLabels performWizardLabelsMigration(long uniqueId, String searchpath) {
        NodeLabels macroNodeLabels;
        String nodeFileName = "NodeLabels.labels";
        LOGGER.info("Search for node file: {}", (Object)nodeFileName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("search_uniqueId", Long.toString(uniqueId));
        NodeLabels nodeLabels = this.performWizardLabelsMigration(params, nodeFileName, searchpath);
        if (nodeLabels == null || nodeLabels.getNodeLabel() == null) {
            LOGGER.info("No migrated node labels found for uniqueId: {}", (Object)uniqueId);
            if (nodeLabels == null) {
                nodeLabels = new NodeLabels();
            }
            nodeLabels.withNodeLabel(new NodeLabel().withUniqueId(uniqueId));
        }
        if ((macroNodeLabels = this.performWizardLabelsMigration(params, "MacroLabels.labels", searchpath)) != null && macroNodeLabels.getMacroLabels() != null) {
            LOGGER.info("Merge macro labels for uniqueId: {}", (Object)uniqueId);
            MacroLabels macroLabels = macroNodeLabels.getMacroLabels();
            nodeLabels.setMacroLabels(macroLabels);
        } else {
            LOGGER.info("No migrated macro labels found for uniqueId: {}", (Object)uniqueId);
        }
        NodeLabels accessoryNodeLabels = this.performWizardLabelsMigration(params, "AccessoryLabels.labels", searchpath);
        if (accessoryNodeLabels != null && accessoryNodeLabels.getAccessoryLabels() != null) {
            LOGGER.info("Merge accessory labels for uniqueId: {}", (Object)uniqueId);
            AccessoryLabels accessoryLabels = accessoryNodeLabels.getAccessoryLabels();
            nodeLabels.setAccessoryLabels(accessoryLabels);
        } else {
            LOGGER.info("No migrated accessory labels found for uniqueId: {}", (Object)uniqueId);
        }
        NodeLabels feedbackPortNodeLabels = this.performWizardLabelsMigration(params, "FeedbackPortLabels.labels", searchpath);
        if (feedbackPortNodeLabels != null && feedbackPortNodeLabels.getFeedbackPortLabels() != null) {
            LOGGER.info("Merge feedback port labels for uniqueId: {}", (Object)uniqueId);
            FeedbackPortLabels feedbackPortLabels = feedbackPortNodeLabels.getFeedbackPortLabels();
            nodeLabels.setFeedbackPortLabels(feedbackPortLabels);
        } else {
            LOGGER.info("No migrated feedback port labels found for uniqueId: {}", (Object)uniqueId);
        }
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "ServoPortLabels.labels", "servo");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "SwitchPortLabels.labels", "switch");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "LightPortLabels.labels", "light");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "BacklightPortLabels.labels", "backlight");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "InputPortLabels.labels", "input");
        return nodeLabels;
    }
}

