/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.migration.labels;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.Predicate;
import org.bidib.jbidibc.core.schema.bidiblabels.LabelFactory;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.PortLabels;
import org.bidib.wizard.common.context.ApplicationContext;
import org.bidib.wizard.migration.labels.NodesFactory;
import org.bidib.wizard.migration.migrator.MigrationException;
import org.bidib.wizard.migration.schema.nodes.NodeLabel;
import org.bidib.wizard.migration.schema.nodes.Nodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWizardLabelMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWizardLabelMigrator.class);
    private static final String NAMESPACE_PREFIX = "{http://www.bidib.org/schema/labels}";
    public static final String INPUT2_XSL = "/migration/labels-migration2.xsl";
    public static final String INPUT2A_XSL = "/migration/labels-migration2a.xsl";
    protected static final String KEY_MIGRATIONXSL = "migrationXSL";

    public abstract Nodes findAllNodesInWizardLabels(String var1);

    public abstract NodeLabels performWizardLabelsMigration(ApplicationContext var1, long var2, String var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Nodes performFindAllNodesInWizardLabels(String fileName, String transformationXSL, String searchpath) {
        LOGGER.info("Perform find all nodes in wizard label, fileName: {}, searchpath: {}", (Object)fileName, (Object)searchpath);
        Nodes nodes = null;
        FileInputStream dataXML = null;
        try {
            File searchFile = new File(searchpath, fileName);
            LOGGER.info("Search for node file: {}", (Object)searchFile);
            dataXML = new FileInputStream(searchFile);
            LOGGER.info("Prepared dataXML: {}", (Object)dataXML);
            nodes = this.performFindNodes(null, dataXML, transformationXSL);
        }
        catch (FileNotFoundException ex) {
            LOGGER.warn("Perform find nodes failed because file is not available: {}", (Object)ex.getMessage());
        }
        finally {
            if (dataXML != null) {
                try {
                    dataXML.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close dataXML stream failed.", (Throwable)ex);
                }
            }
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Nodes performFindNodes(Map<String, String> params, InputStream dataXML, String migrationXSL) {
        LOGGER.info("perform find nodes with migrationXSL: {}", (Object)migrationXSL);
        InputStream inputXSL = null;
        StringWriter outputXML = null;
        InputStream is = null;
        Nodes nodes = null;
        try {
            inputXSL = AbstractWizardLabelMigrator.class.getResourceAsStream(migrationXSL);
            outputXML = new StringWriter();
            LOGGER.info("Prepared inputXSL: {}", (Object)inputXSL);
            this.doTransform(params, inputXSL, dataXML, outputXML);
            LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
            is = new ByteArrayInputStream(outputXML.getBuffer().toString().getBytes("UTF-8"));
            nodes = NodesFactory.loadNodes(is);
            LOGGER.info("Prepared migrated nodes: {}", (Object)nodes);
        }
        catch (UnsupportedEncodingException | TransformerException ex) {
            LOGGER.warn("Perform find nodes with transformation failed.", (Throwable)ex);
        }
        finally {
            if (outputXML != null) {
                try {
                    outputXML.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputXML writer failed.", (Throwable)ex);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close inputStream failed.", (Throwable)ex);
                }
            }
            if (inputXSL != null) {
                try {
                    inputXSL.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close inputXSL stream failed.", (Throwable)ex);
                }
            }
        }
        return nodes;
    }

    protected void doTransform(Map<String, String> params, InputStream inputXSL, InputStream dataXML, StringWriter outputXML) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://saxon.sf.net/feature/suppressXsltNamespaceCheck", true);
        StreamSource xslStream = new StreamSource(inputXSL);
        Transformer transformer = factory.newTransformer(xslStream);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        if (MapUtils.isNotEmpty(params)) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (!KEY_MIGRATIONXSL.equals(param.getKey())) {
                    LOGGER.info("Set transformer parameter: {}", param);
                    transformer.setParameter(NAMESPACE_PREFIX + param.getKey(), param.getValue());
                    continue;
                }
                LOGGER.info("Skip KEY_MIGRATIONXSL.");
            }
        }
        StreamSource in = new StreamSource(dataXML);
        StreamResult out = new StreamResult(outputXML);
        transformer.transform(in, out);
        outputXML.flush();
    }

    protected void appendNodeLabels(final List<NodeLabel> exisiting, List<NodeLabel> toAdd) {
        List toMerge = ListUtils.select(toAdd, (Predicate)new Predicate<NodeLabel>(){

            public boolean evaluate(NodeLabel nodeLabel) {
                for (NodeLabel current : exisiting) {
                    if (current.getUniqueId() != nodeLabel.getUniqueId()) continue;
                    return false;
                }
                return true;
            }
        });
        exisiting.addAll(toMerge);
    }

    protected NodeLabels performMigration(Map<String, String> params, InputStream dataXML, String migrationXSL) {
        LOGGER.info("perform migration with migrationXSL: {}", (Object)migrationXSL);
        InputStream inputXSL = null;
        StringWriter outputXML = null;
        InputStream is = null;
        NodeLabels nodeLabels = null;
        try {
            inputXSL = AbstractWizardLabelMigrator.class.getResourceAsStream(migrationXSL);
            outputXML = new StringWriter();
            LOGGER.info("Prepared inputXSL: {}", (Object)inputXSL);
            this.doTransform(params, inputXSL, dataXML, outputXML);
            LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
            is = new ByteArrayInputStream(outputXML.getBuffer().toString().getBytes("UTF-8"));
            nodeLabels = new LabelFactory().loadLabels(is);
            LOGGER.info("Prepared migrated nodeLabels: {}", (Object)nodeLabels);
        }
        catch (UnsupportedEncodingException | TransformerException ex) {
            LOGGER.warn("Perform transformation of bidib2 migration failed.", (Throwable)ex);
            throw new MigrationException("Perform transformation for label migration failed.", ex);
        }
        finally {
            if (outputXML != null) {
                try {
                    outputXML.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputXML writer failed.", (Throwable)ex);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close inputStream failed.", (Throwable)ex);
                }
            }
            if (inputXSL != null) {
                try {
                    inputXSL.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close inputXSL stream failed.", (Throwable)ex);
                }
            }
        }
        return nodeLabels;
    }

    protected void migrateAndAppendWizardPortLabels(NodeLabels nodeLabels, Map<String, String> params, String searchpath, String fileName, String migrationXSL, String portTypeIdentifier) {
        LOGGER.info("migrateAndAppendWizardPortLabels, portTypeIdentifier: {}, fileName: {}, migrationXSL: {}", new Object[]{portTypeIdentifier, fileName, migrationXSL});
        params.put("forced_porttype", portTypeIdentifier);
        NodeLabels portNodeLabels = this.performWizardLabelsMigration(params, fileName, migrationXSL, searchpath);
        if (portNodeLabels != null && portNodeLabels.getPortLabels() != null && CollectionUtils.isNotEmpty((Collection)portNodeLabels.getPortLabels().getPortLabel())) {
            LOGGER.info("Merge {} port labels for params: {}", (Object)portTypeIdentifier, params);
            PortLabels portLabels = portNodeLabels.getPortLabels();
            if (nodeLabels.getPortLabels() == null) {
                LOGGER.info("Create new PortLabels instance.");
                nodeLabels.setPortLabels(new PortLabels());
            }
            nodeLabels.getPortLabels().getPortLabel().addAll(portLabels.getPortLabel());
        } else {
            LOGGER.info("No migrated {} port labels found for params: {}", (Object)portTypeIdentifier, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeLabels performWizardLabelsMigration(Map<String, String> params, String fileName, String migrationXSL, String searchpath) {
        LOGGER.info("perform wizard label migration for params: {}, fileName: {}, migrationXSL: {}, searchpath: {}", new Object[]{params, fileName, migrationXSL, searchpath});
        NodeLabels nodeLabels = null;
        FileInputStream dataXML = null;
        try {
            File searchFile = new File(searchpath, fileName);
            LOGGER.info("Search for node file: {}", (Object)searchFile);
            dataXML = new FileInputStream(searchFile);
            LOGGER.info("Prepared dataXML: {}", (Object)dataXML);
            nodeLabels = this.performMigration(params, dataXML, migrationXSL);
        }
        catch (MigrationException ex) {
            LOGGER.warn("Perform transformation of label migration failed for fileName: {}", (Object)fileName, (Object)ex);
            throw new MigrationException("Perform transformation for label migration failed for fileName: " + fileName, ex.getCause());
        }
        catch (FileNotFoundException ex) {
            LOGGER.warn("perform WizardLabelsMigration failed.", (Throwable)ex);
        }
        finally {
            if (dataXML != null) {
                try {
                    dataXML.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close dataXML stream failed.", (Throwable)ex);
                }
            }
        }
        return nodeLabels;
    }
}

