/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.migration.labels;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.FeedbackPortLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.MacroLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.common.context.ApplicationContext;
import org.bidib.wizard.migration.labels.AbstractWizardLabelMigrator;
import org.bidib.wizard.migration.migrator.MigrationException;
import org.bidib.wizard.migration.schema.nodes.Nodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldWizardLabelMigrator
extends AbstractWizardLabelMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OldWizardLabelMigrator.class);
    protected static final String INPUT4_XSL = "/migration/labels-migration4.xsl";
    protected static final String INPUT5_XSL = "/migration/labels-migration5.xsl";

    @Override
    public NodeLabels performWizardLabelsMigration(ApplicationContext context, long uniqueId, String searchpath) {
        String nodeFileName = "NodeLabels";
        LOGGER.info("Search for node file: {}", (Object)nodeFileName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("search_uniqueId", Long.toString(uniqueId));
        NodeLabels nodeLabels = this.performWizardLabelsMigration(params, nodeFileName, "/migration/labels-migration2.xsl", searchpath);
        if (nodeLabels == null || nodeLabels.getNodeLabel() == null) {
            LOGGER.info("No migrated node labels found for uniqueId: {}", (Object)uniqueId);
            if (nodeLabels == null) {
                nodeLabels = new NodeLabels();
            }
            nodeLabels.withNodeLabel(new NodeLabel().withUniqueId(uniqueId));
        }
        params.put("XSL_FILE", "/migration/labels-migration4a.xsl");
        NodeLabels macroNodeLabels = this.performWizardLabelsMigration(params, "MacroLabels", "/migration/labels-migration2.xsl", searchpath);
        if (macroNodeLabels != null && macroNodeLabels.getMacroLabels() != null) {
            LOGGER.info("Merge macro labels for uniqueId: {}", (Object)uniqueId);
            MacroLabels macroLabels = macroNodeLabels.getMacroLabels();
            nodeLabels.setMacroLabels(macroLabels);
        } else {
            LOGGER.info("No migrated macro labels found for uniqueId: {}", (Object)uniqueId);
        }
        params.put("XSL_FILE", "/migration/labels-migration4b.xsl");
        NodeLabels accessoryNodeLabels = this.performWizardLabelsMigration(params, "AccessoryLabels", "/migration/labels-migration2.xsl", searchpath);
        if (accessoryNodeLabels != null && accessoryNodeLabels.getAccessoryLabels() != null) {
            LOGGER.info("Merge accessory labels for uniqueId: {}", (Object)uniqueId);
            AccessoryLabels accessoryLabels = accessoryNodeLabels.getAccessoryLabels();
            nodeLabels.setAccessoryLabels(accessoryLabels);
        } else {
            LOGGER.info("No migrated accessory labels found for uniqueId: {}", (Object)uniqueId);
        }
        params.put("XSL_FILE", "/migration/labels-migration4c.xsl");
        NodeLabels feedbackPortNodeLabels = this.performWizardLabelsMigration(params, "FeedbackPortLabels", "/migration/labels-migration2.xsl", searchpath);
        if (feedbackPortNodeLabels != null && feedbackPortNodeLabels.getFeedbackPortLabels() != null) {
            LOGGER.info("Merge feedback port labels for uniqueId: {}", (Object)uniqueId);
            FeedbackPortLabels feedbackPortLabels = feedbackPortNodeLabels.getFeedbackPortLabels();
            nodeLabels.setFeedbackPortLabels(feedbackPortLabels);
        } else {
            LOGGER.info("No migrated feedback port labels found for uniqueId: {}", (Object)uniqueId);
        }
        params.remove("XSL_FILE");
        params.put("port_type", "servo");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "ServoPortLabels", "/migration/labels-migration2.xsl", "servo");
        params.put("port_type", "switch");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "SwitchPortLabels", "/migration/labels-migration2.xsl", "switch");
        params.put("port_type", "light");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "LightPortLabels", "/migration/labels-migration2.xsl", "light");
        params.put("port_type", "backlight");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "BacklightPortLabels", "/migration/labels-migration2.xsl", "backlight");
        params.put("port_type", "input");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "InputPortLabels", "/migration/labels-migration2.xsl", "input");
        return nodeLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NodeLabels performWizardLabelsMigration(Map<String, String> params, String fileName, String migrationXSL, String searchpath) {
        LOGGER.info("perform wizard label migration for params: {}, fileName: {}, migrationXSL: {}, searchpath: {}", new Object[]{params, fileName, migrationXSL, searchpath});
        NodeLabels nodeLabels = null;
        FileInputStream dataXML = null;
        try {
            File searchFile = new File(searchpath, fileName);
            LOGGER.info("Search for node file: {}", (Object)searchFile);
            dataXML = new FileInputStream(searchFile);
            LOGGER.info("Prepared dataXML: {}", (Object)dataXML);
            String xslFile = params.get("XSL_FILE");
            if (StringUtils.isNotBlank((CharSequence)xslFile)) {
                LOGGER.info("Use XSL file: {}", (Object)xslFile);
                nodeLabels = this.performMigration(params, dataXML, xslFile);
            } else {
                nodeLabels = this.performMigration(params, dataXML, INPUT4_XSL);
            }
        }
        catch (MigrationException ex) {
            LOGGER.warn("Perform transformation of label migration failed for fileName: {}", (Object)fileName, (Object)ex);
            throw new MigrationException("Perform transformation for label migration failed for fileName: " + fileName, ex.getCause());
        }
        catch (FileNotFoundException ex) {
            LOGGER.warn("Perform migration of old wizard labels was not possible: {}", (Object)ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.warn("performWizardLabelsMigration failed.", (Throwable)ex);
        }
        finally {
            if (dataXML != null) {
                try {
                    dataXML.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close dataXML stream failed.", (Throwable)ex);
                }
            }
        }
        return nodeLabels;
    }

    @Override
    public Nodes findAllNodesInWizardLabels(String searchpath) {
        LOGGER.info("Find all nodes in old wizard labels, searchpath: {}", new Object[]{searchpath});
        Nodes nodes = null;
        try {
            Nodes inputPortNodes;
            Nodes lightPortNodes;
            Nodes backlightPortNodes;
            Nodes servoPortNodes;
            Nodes switchPortNodes;
            Nodes feedbackPortNodes;
            Nodes accessoryNodes;
            nodes = this.performFindAllNodesInWizardLabels("NodeLabels", INPUT5_XSL, searchpath);
            if (nodes == null) {
                LOGGER.info("No nodes found in searchPath: {}", (Object)searchpath);
            }
            LOGGER.info("Found nodes in searchPath: {}", (Object)searchpath);
            LOGGER.info("Continue migration of other labels.");
            Nodes macroNodes = this.performFindAllNodesInWizardLabels("MacroLabels", INPUT5_XSL, searchpath);
            if (macroNodes != null && CollectionUtils.isNotEmpty(macroNodes.getNodeLabel())) {
                if (nodes == null) {
                    nodes = new Nodes();
                }
                this.appendNodeLabels(nodes.getNodeLabel(), macroNodes.getNodeLabel());
            }
            if ((accessoryNodes = this.performFindAllNodesInWizardLabels("AccessoryLabels", INPUT5_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(accessoryNodes.getNodeLabel())) {
                if (nodes == null) {
                    nodes = new Nodes();
                }
                this.appendNodeLabels(nodes.getNodeLabel(), accessoryNodes.getNodeLabel());
            }
            if ((feedbackPortNodes = this.performFindAllNodesInWizardLabels("FeedbackPortLabels", INPUT5_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(feedbackPortNodes.getNodeLabel())) {
                if (nodes == null) {
                    nodes = new Nodes();
                }
                this.appendNodeLabels(nodes.getNodeLabel(), feedbackPortNodes.getNodeLabel());
            }
            if ((switchPortNodes = this.performFindAllNodesInWizardLabels("SwitchPortLabels", INPUT5_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(switchPortNodes.getNodeLabel())) {
                if (nodes == null) {
                    nodes = new Nodes();
                }
                this.appendNodeLabels(nodes.getNodeLabel(), switchPortNodes.getNodeLabel());
            }
            if ((servoPortNodes = this.performFindAllNodesInWizardLabels("ServoPortLabels", INPUT5_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(servoPortNodes.getNodeLabel())) {
                if (nodes == null) {
                    nodes = new Nodes();
                }
                this.appendNodeLabels(nodes.getNodeLabel(), servoPortNodes.getNodeLabel());
            }
            if ((backlightPortNodes = this.performFindAllNodesInWizardLabels("BacklightPortLabels", INPUT5_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(backlightPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), backlightPortNodes.getNodeLabel());
            }
            if ((lightPortNodes = this.performFindAllNodesInWizardLabels("LightPortLabels", INPUT5_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(lightPortNodes.getNodeLabel())) {
                LOGGER.info("Found lightPort labels to merge: {}", (Object)lightPortNodes);
                if (nodes == null) {
                    nodes = new Nodes();
                }
                this.appendNodeLabels(nodes.getNodeLabel(), lightPortNodes.getNodeLabel());
            }
            if ((inputPortNodes = this.performFindAllNodesInWizardLabels("InputPortLabels", INPUT5_XSL, searchpath)) != null && CollectionUtils.isNotEmpty(inputPortNodes.getNodeLabel())) {
                if (nodes == null) {
                    nodes = new Nodes();
                }
                this.appendNodeLabels(nodes.getNodeLabel(), inputPortNodes.getNodeLabel());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("find all nodes in old wizard labels failed.", (Throwable)ex);
        }
        if (nodes != null) {
            LOGGER.info("Set the migrator class.");
            nodes.setMigratorClass(this.getClass().getName());
        }
        return nodes;
    }
}

