/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.migration.labels;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.core.schema.bidibbase.PortType;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.FeedbackPortLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.LabelFactory;
import org.bidib.jbidibc.core.schema.bidiblabels.MacroLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.PortLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.PortLabels;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.migration.labels.Bidib2LabelMigrator;
import org.bidib.wizard.migration.labels.WizardLabelMigrator;
import org.bidib.wizard.migration.migrator.MigrationContext;
import org.bidib.wizard.migration.schema.nodes.Nodes;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public class WizardLabelMigratorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardLabelMigratorTest.class);
    private static final String NAMESPACE_PREFIX = "{http://www.bidib.org/schema/labels}";
    private static final String INPUT_XSL = "/migration/labels-migration.xsl";
    private static final String INPUT2_XSL = "/migration/labels-migration2.xsl";
    private static final String DATA1_XML = "/xml-test/labels/bidib2/05000DD00043ED.xml";
    private static final String DATA2_XML = "/xml-test/labels/bidib2/05000D6B009AEA.xml";
    private static final String DATA3_XML = "/xml-test/labels/wizard/NodeLabels.labels";
    private static final String DATA4_XML = "/xml-test/labels/wizard/AccessoryLabels.labels";
    private static final String DATA5_XML = "/xml-test/labels/wizard/MacroLabels.labels";
    private static final String DATA6_XML = "/xml-test/labels/wizard-wrong-type/SwitchPortLabels.labels";

    @Test
    public void migrationWithUniqueIdAsIntegerTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA1_XML);
        Assertions.assertThat((URL)url).isNotNull();
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getFullPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        MigrationContext context = new MigrationContext();
        Bidib2LabelMigrator migrator = new Bidib2LabelMigrator();
        NodeLabels nodeLabels = migrator.performWizardLabelsMigration((ApplicationContext)context, 1407434207806445L, searchPath);
        Assertions.assertThat((Object)nodeLabels).isNotNull();
        Assertions.assertThat((Object)nodeLabels.getNodeLabel()).isNotNull();
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assertions.assertThat((long)nodeLabel.getUniqueId()).isEqualTo(1407434207806445L);
        Assertions.assertThat((String)nodeLabel.getUserName()).isEqualTo("NeoTest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisplayName(value="Test XSL transformation and compare to xml from file.")
    public void transformationWithUniqueIdAsIntegerTest() throws TransformerException, URISyntaxException, SAXException, IOException {
        InputStream inputXSL = WizardLabelMigratorTest.class.getResourceAsStream(INPUT_XSL);
        Assertions.assertThat((InputStream)inputXSL).isNotNull();
        InputStream dataXML = WizardLabelMigratorTest.class.getResourceAsStream(DATA1_XML);
        Assertions.assertThat((InputStream)dataXML).isNotNull();
        StringWriter outputXML = new StringWriter();
        try {
            WizardLabelMigrator migrator = new WizardLabelMigrator();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("search_uniqueId", Long.toString(1407434207806445L));
            migrator.doTransform(params, inputXSL, dataXML, outputXML);
        }
        finally {
            if (outputXML != null) {
                try {
                    outputXML.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputXML writer failed.", (Throwable)ex);
                }
            }
            if (inputXSL != null) {
                try {
                    inputXSL.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close inputXSL stream failed.", (Throwable)ex);
                }
            }
        }
        LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
        Assertions.assertThat((int)outputXML.getBuffer().length()).isGreaterThan(0);
        InputStream is = WizardLabelMigratorTest.class.getResourceAsStream("/xml-test/result/05000DD00043ED.xml");
        String xmlContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Diff myDiffSimilar = DiffBuilder.compare((Object)xmlContent).withTest((Object)outputXML.toString()).checkForSimilar().build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)myDiffSimilar.hasDifferences()).withFailMessage("XML similar " + myDiffSimilar.toString(), new Object[0])).isFalse();
    }

    @Test
    public void migrationWithUniqueIdAsHexTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA2_XML);
        Assertions.assertThat((URL)url).isNotNull();
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getFullPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        MigrationContext context = new MigrationContext();
        Bidib2LabelMigrator migrator = new Bidib2LabelMigrator();
        NodeLabels nodeLabels = migrator.performWizardLabelsMigration((ApplicationContext)context, 1407432513329898L, searchPath);
        Assertions.assertThat((Object)nodeLabels).isNotNull();
        Assertions.assertThat((Object)nodeLabels.getNodeLabel()).isNotNull();
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assertions.assertThat((long)nodeLabel.getUniqueId()).isEqualTo(1407432513329898L);
        Assertions.assertThat((String)nodeLabel.getUserName()).isEqualTo("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisplayName(value="Test XSL transformation and compare to xml from file.")
    public void transformationWithUniqueIdAsHexTest() throws TransformerException, URISyntaxException, SAXException, IOException {
        InputStream inputXSL = WizardLabelMigratorTest.class.getResourceAsStream(INPUT_XSL);
        Assertions.assertThat((InputStream)inputXSL).isNotNull();
        InputStream dataXML = WizardLabelMigratorTest.class.getResourceAsStream(DATA2_XML);
        Assertions.assertThat((InputStream)dataXML).isNotNull();
        StringWriter outputXML = new StringWriter();
        try {
            WizardLabelMigrator migrator = new WizardLabelMigrator();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("search_uniqueId", Long.toString(1407432513329898L));
            migrator.doTransform(params, inputXSL, dataXML, outputXML);
        }
        finally {
            if (outputXML != null) {
                try {
                    outputXML.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputXML writer failed.", (Throwable)ex);
                }
            }
            if (inputXSL != null) {
                try {
                    inputXSL.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close inputXSL stream failed.", (Throwable)ex);
                }
            }
        }
        LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
        Assertions.assertThat((int)outputXML.getBuffer().length()).isGreaterThan(0);
        InputStream is = WizardLabelMigratorTest.class.getResourceAsStream("/xml-test/result/05000D6B009AEA.xml");
        String xmlContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Diff myDiffSimilar = DiffBuilder.compare((Object)xmlContent).withTest((Object)outputXML.toString()).checkForSimilar().build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)myDiffSimilar.hasDifferences()).withFailMessage("XML similar " + myDiffSimilar.toString(), new Object[0])).isFalse();
    }

    @Test
    @DisplayName(value="Test XSL transformation and compare to xml from file.")
    public void transformationOldNodeLabelsTest() throws TransformerException, URISyntaxException, SAXException, IOException {
        InputStream inputXSL = WizardLabelMigratorTest.class.getResourceAsStream(INPUT2_XSL);
        Assertions.assertThat((InputStream)inputXSL).isNotNull();
        InputStream dataXML = WizardLabelMigratorTest.class.getResourceAsStream(DATA3_XML);
        Assertions.assertThat((InputStream)dataXML).isNotNull();
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("XSL transformer implementation doesn't support {} feature", (Object)"http://javax.xml.XMLConstants/property/accessExternalDTD");
        }
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("XSL transformer implementation doesn't support {} feature", (Object)"http://javax.xml.XMLConstants/property/accessExternalDTD");
        }
        StreamSource xslStream = new StreamSource(inputXSL);
        Transformer transformer = factory.newTransformer(xslStream);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        transformer.setParameter("{http://www.bidib.org/schema/labels}search_uniqueId", "61361602502354154");
        StreamSource in = new StreamSource(dataXML);
        StringWriter outputXML = new StringWriter();
        StreamResult out = new StreamResult(outputXML);
        transformer.transform(in, out);
        LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
        Assertions.assertThat((int)outputXML.getBuffer().length()).isGreaterThan(0);
        InputStream is = WizardLabelMigratorTest.class.getResourceAsStream("/xml-test/result/DA000D680064EA-node.xml");
        String xmlContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Diff myDiffSimilar = DiffBuilder.compare((Object)xmlContent).withTest((Object)outputXML.toString()).checkForSimilar().build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)myDiffSimilar.hasDifferences()).withFailMessage("XML similar " + myDiffSimilar.toString(), new Object[0])).isFalse();
    }

    @Test
    public void migrationOldNodeLabelsTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA3_XML);
        Assertions.assertThat((URL)url).isNotNull();
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getFullPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("search_uniqueId", Long.toString(61361602502354154L));
        WizardLabelMigrator migrator = new WizardLabelMigrator();
        NodeLabels nodeLabels = migrator.performWizardLabelsMigration(params, "NodeLabels.labels", INPUT2_XSL, searchPath);
        Assertions.assertThat((Object)nodeLabels).isNotNull();
        Assertions.assertThat((Object)nodeLabels.getNodeLabel()).isNotNull();
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assertions.assertThat((long)nodeLabel.getUniqueId()).isEqualTo(61361602502354154L);
        Assertions.assertThat((String)nodeLabel.getUserName()).isEqualTo("Test Booster Main");
    }

    @Test
    @DisplayName(value="Test XSL transformation and compare to xml from file.")
    public void transformationOldAccessoryLabelsTest() throws TransformerException, URISyntaxException, SAXException, IOException {
        InputStream inputXSL = WizardLabelMigratorTest.class.getResourceAsStream(INPUT2_XSL);
        Assertions.assertThat((InputStream)inputXSL).isNotNull();
        InputStream dataXML = WizardLabelMigratorTest.class.getResourceAsStream(DATA4_XML);
        Assertions.assertThat((InputStream)dataXML).isNotNull();
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("XSL transformer implementation doesn't support {} feature", (Object)"http://javax.xml.XMLConstants/property/accessExternalDTD");
        }
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("XSL transformer implementation doesn't support {} feature", (Object)"http://javax.xml.XMLConstants/property/accessExternalDTD");
        }
        StreamSource xslStream = new StreamSource(inputXSL);
        Transformer transformer = factory.newTransformer(xslStream);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        transformer.setParameter("{http://www.bidib.org/schema/labels}search_uniqueId", "1464607285711414");
        StreamSource in = new StreamSource(dataXML);
        StringWriter outputXML = new StringWriter();
        StreamResult out = new StreamResult(outputXML);
        transformer.transform(in, out);
        LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
        Assertions.assertThat((int)outputXML.getBuffer().length()).isGreaterThan(0);
        InputStream is = WizardLabelMigratorTest.class.getResourceAsStream("/xml-test/result/5340D75001236-accessories.xml");
        String xmlContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Diff myDiffSimilar = DiffBuilder.compare((Object)xmlContent).withTest((Object)outputXML.toString()).checkForSimilar().build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)myDiffSimilar.hasDifferences()).withFailMessage("XML similar " + myDiffSimilar.toString(), new Object[0])).isFalse();
    }

    @Test
    public void migrationOldAccessoryLabelsTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA4_XML);
        Assertions.assertThat((URL)url).isNotNull();
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getFullPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("search_uniqueId", Long.toString(1464607285711414L));
        WizardLabelMigrator migrator = new WizardLabelMigrator();
        NodeLabels nodeLabels = migrator.performWizardLabelsMigration(params, "AccessoryLabels.labels", INPUT2_XSL, searchPath);
        Assertions.assertThat((Object)nodeLabels).isNotNull();
        Assertions.assertThat((Object)nodeLabels.getNodeLabel()).isNotNull();
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assertions.assertThat((long)nodeLabel.getUniqueId()).isEqualTo(1464607285711414L);
        Assertions.assertThat((String)nodeLabel.getUserName()).isNull();
    }

    @Test
    public void migrationOldAccessoryLabelsToNodeLabelsTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA4_XML);
        Assertions.assertThat((URL)url).isNotNull();
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getFullPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        MigrationContext context = new MigrationContext();
        WizardLabelMigrator migrator = new WizardLabelMigrator();
        NodeLabels nodeLabels = migrator.performWizardLabelsMigration((ApplicationContext)context, 1464607285711414L, searchPath);
        Assertions.assertThat((Object)nodeLabels).isNotNull();
        Assertions.assertThat((Object)nodeLabels.getNodeLabel()).isNotNull();
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assertions.assertThat((long)nodeLabel.getUniqueId()).isEqualTo(1464607285711414L);
        Assertions.assertThat((String)nodeLabel.getUserName()).isEqualTo("OneControl Test 1");
        Assertions.assertThat((Object)nodeLabels.getMacroLabels()).isNotNull();
        MacroLabels macroLabels = nodeLabels.getMacroLabels();
        Assertions.assertThat((List)macroLabels.getMacroLabel()).isNotNull();
        Assertions.assertThat((int)macroLabels.getMacroLabel().size()).isEqualTo(32);
        Assertions.assertThat((Object)nodeLabels.getAccessoryLabels()).isNotNull();
        AccessoryLabels acecssoryLabels = nodeLabels.getAccessoryLabels();
        Assertions.assertThat((List)acecssoryLabels.getAccessoryLabel()).isNotNull();
        Assertions.assertThat((int)acecssoryLabels.getAccessoryLabel().size()).isEqualTo(20);
        Assertions.assertThat((Object)nodeLabels.getFeedbackPortLabels()).isNotNull();
        FeedbackPortLabels feedbackPortLabels = nodeLabels.getFeedbackPortLabels();
        Assertions.assertThat((List)feedbackPortLabels.getPortLabel()).isNotNull();
        Assertions.assertThat((int)feedbackPortLabels.getPortLabel().size()).isEqualTo(1);
        Assertions.assertThat((Object)nodeLabels.getPortLabels()).isNotNull();
        PortLabels portLabels = nodeLabels.getPortLabels();
        Assertions.assertThat((List)portLabels.getPortLabel()).isNotNull();
        List portLabelList = portLabels.getPortLabel();
        Assertions.assertThat((int)portLabelList.size()).isEqualTo(40);
        Assertions.assertThat((int)LabelFactory.getPortsOfType((List)portLabelList, (PortType)PortType.SERVO).size()).isEqualTo(8);
        Assertions.assertThat((int)LabelFactory.getPortsOfType((List)portLabelList, (PortType)PortType.SWITCH).size()).isEqualTo(16);
        Assertions.assertThat((int)LabelFactory.getPortsOfType((List)portLabelList, (PortType)PortType.INPUT).size()).isEqualTo(16);
        Assertions.assertThat((int)LabelFactory.getPortsOfType((List)portLabelList, (PortType)PortType.LIGHT).size()).isEqualTo(0);
    }

    @Test
    @DisplayName(value="Test XSL transformation and compare to xml from file.")
    public void transformationOldMacroLabelsTest() throws TransformerException, URISyntaxException, SAXException, IOException {
        InputStream inputXSL = WizardLabelMigratorTest.class.getResourceAsStream(INPUT2_XSL);
        Assertions.assertThat((InputStream)inputXSL).isNotNull();
        InputStream dataXML = WizardLabelMigratorTest.class.getResourceAsStream(DATA5_XML);
        Assertions.assertThat((InputStream)dataXML).isNotNull();
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("XSL transformer implementation doesn't support {} feature", (Object)"http://javax.xml.XMLConstants/property/accessExternalDTD");
        }
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("XSL transformer implementation doesn't support {} feature", (Object)"http://javax.xml.XMLConstants/property/accessExternalDTD");
        }
        StreamSource xslStream = new StreamSource(inputXSL);
        Transformer transformer = factory.newTransformer(xslStream);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        transformer.setParameter("{http://www.bidib.org/schema/labels}search_uniqueId", "1464607285711414");
        StreamSource in = new StreamSource(dataXML);
        StringWriter outputXML = new StringWriter();
        StreamResult out = new StreamResult(outputXML);
        transformer.transform(in, out);
        LOGGER.info("The generated XML document is:\r\n{}", (Object)outputXML);
        Assertions.assertThat((int)outputXML.getBuffer().length()).isGreaterThan(0);
        InputStream is = WizardLabelMigratorTest.class.getResourceAsStream("/xml-test/result/5340D75001236-macros.xml");
        String xmlContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Diff myDiffSimilar = DiffBuilder.compare((Object)xmlContent).withTest((Object)outputXML.toString()).checkForSimilar().build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)myDiffSimilar.hasDifferences()).withFailMessage("XML similar " + myDiffSimilar.toString(), new Object[0])).isFalse();
    }

    @Test
    public void migrationOldMacroLabelsTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA5_XML);
        Assertions.assertThat((URL)url).isNotNull();
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getFullPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("search_uniqueId", Long.toString(1464607285711414L));
        WizardLabelMigrator migrator = new WizardLabelMigrator();
        NodeLabels nodeLabels = migrator.performWizardLabelsMigration(params, "MacroLabels.labels", INPUT2_XSL, searchPath);
        Assertions.assertThat((Object)nodeLabels).isNotNull();
        Assertions.assertThat((Object)nodeLabels.getNodeLabel()).isNotNull();
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assertions.assertThat((long)nodeLabel.getUniqueId()).isEqualTo(1464607285711414L);
        Assertions.assertThat((String)nodeLabel.getUserName()).isNull();
    }

    @Test
    public void findAllNodesInWizardLabelsTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA3_XML);
        Assertions.assertThat((URL)url).isNotNull();
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getFullPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        WizardLabelMigrator migrator = new WizardLabelMigrator();
        Nodes nodes = migrator.findAllNodesInWizardLabels(searchPath);
        Assertions.assertThat((Object)nodes).isNotNull();
        Assertions.assertThat((List)nodes.getNodeLabel()).isNotNull();
        List nodeLabels = nodes.getNodeLabel();
        LOGGER.info("Current nodeLabels: {}", (Object)nodeLabels);
        Assertions.assertThat((int)nodeLabels.size()).isEqualTo(6);
    }

    @Test
    public void migrateSwitchPortForcedLabelsTest() {
        URL url = WizardLabelMigratorTest.class.getResource(DATA6_XML);
        Assertions.assertThat((URL)url).isNotNull();
        String searchPath = url.getPath();
        searchPath = FilenameUtils.getFullPath((String)searchPath);
        LOGGER.info("Prepared search path: {}", (Object)searchPath);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("search_uniqueId", Long.toString(1407432681110250L));
        params.put("forced_porttype", "switch");
        WizardLabelMigrator migrator = new WizardLabelMigrator();
        NodeLabels nodeLabels = migrator.performWizardLabelsMigration(params, "SwitchPortLabels.labels", INPUT2_XSL, searchPath);
        Assertions.assertThat((Object)nodeLabels).isNotNull();
        Assertions.assertThat((Object)nodeLabels.getNodeLabel()).isNotNull();
        NodeLabel nodeLabel = nodeLabels.getNodeLabel();
        Assertions.assertThat((long)nodeLabel.getUniqueId()).isEqualTo(1407432681110250L);
        Assertions.assertThat((String)nodeLabel.getUserName()).isNull();
        Assertions.assertThat((Object)nodeLabels.getPortLabels()).isNotNull();
        PortLabels portLabels = nodeLabels.getPortLabels();
        Assertions.assertThat((int)portLabels.getPortLabel().size()).isEqualTo(36);
        for (PortLabel portLabel : portLabels.getPortLabel()) {
            Assertions.assertThat((Comparable)portLabel.getType()).isEqualTo((Object)PortType.SWITCH);
        }
    }
}

