/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.migration.labels;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.FeedbackPortLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.MacroLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.exception.UnexpectedCharacterException;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.migration.labels.AbstractWizardLabelMigrator;
import org.bidib.wizard.migration.schema.nodes.Nodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardLabelMigrator
extends AbstractWizardLabelMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardLabelMigrator.class);
    private static final String INPUT3_XSL = "/migration/labels-migration3.xsl";
    private static final String INPUT3A_XSL = "/migration/labels-migration3a.xsl";

    @Override
    public Nodes findAllNodesInWizardLabels(String searchpath) {
        LOGGER.info("Find all nodes in wizard labels, searchpath: {}", (Object)searchpath);
        Nodes nodes = null;
        try {
            Nodes inputPortNodes;
            Nodes lightPortNodes;
            Nodes backlightPortNodes;
            Nodes servoPortNodes;
            Nodes switchPortNodes;
            Nodes feedbackPortNodes;
            Nodes accessoryNodes;
            Nodes macroNodes;
            nodes = this.performFindAllNodesInWizardLabels("NodeLabels.labels", INPUT3_XSL, searchpath);
            if (nodes == null) {
                LOGGER.info("No nodes found in searchPath: {}", (Object)searchpath);
                return nodes;
            }
            String migrationXsl = nodes.getMigrationXsl();
            if (StringUtils.isBlank((CharSequence)migrationXsl)) {
                migrationXsl = INPUT3_XSL;
            }
            if ((macroNodes = this.performFindAllNodesInWizardLabels("MacroLabels.labels", migrationXsl, searchpath)) != null && CollectionUtils.isNotEmpty(macroNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), macroNodes.getNodeLabel());
            }
            if ((accessoryNodes = this.performFindAllNodesInWizardLabels("AccessoryLabels.labels", migrationXsl, searchpath)) != null && CollectionUtils.isNotEmpty(accessoryNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), accessoryNodes.getNodeLabel());
            }
            if ((feedbackPortNodes = this.performFindAllNodesInWizardLabels("FeedbackPortLabels.labels", migrationXsl, searchpath)) != null && CollectionUtils.isNotEmpty(feedbackPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), feedbackPortNodes.getNodeLabel());
            }
            if ((switchPortNodes = this.performFindAllNodesInWizardLabels("SwitchPortLabels.labels", migrationXsl, searchpath)) != null && CollectionUtils.isNotEmpty(switchPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), switchPortNodes.getNodeLabel());
            }
            if ((servoPortNodes = this.performFindAllNodesInWizardLabels("ServoPortLabels.labels", migrationXsl, searchpath)) != null && CollectionUtils.isNotEmpty(servoPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), servoPortNodes.getNodeLabel());
            }
            if ((backlightPortNodes = this.performFindAllNodesInWizardLabels("BacklightPortLabels.labels", migrationXsl, searchpath)) != null && CollectionUtils.isNotEmpty(backlightPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), backlightPortNodes.getNodeLabel());
            }
            if ((lightPortNodes = this.performFindAllNodesInWizardLabels("LightPortLabels.labels", migrationXsl, searchpath)) != null && CollectionUtils.isNotEmpty(lightPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), lightPortNodes.getNodeLabel());
            }
            if ((inputPortNodes = this.performFindAllNodesInWizardLabels("InputPortLabels.labels", migrationXsl, searchpath)) != null && CollectionUtils.isNotEmpty(inputPortNodes.getNodeLabel())) {
                this.appendNodeLabels(nodes.getNodeLabel(), inputPortNodes.getNodeLabel());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("find all nodes in wizard labels failed.", (Throwable)ex);
        }
        if (nodes != null) {
            LOGGER.info("Set the migrator class.");
            nodes.setMigratorClass(this.getClass().getName());
        }
        return nodes;
    }

    @Override
    protected Nodes performFindAllNodesInWizardLabels(String fileName, String transformationXSL, String searchpath) {
        Nodes nodes;
        block3: {
            nodes = null;
            try {
                nodes = super.performFindAllNodesInWizardLabels(fileName, transformationXSL, searchpath);
                if (nodes != null) {
                    nodes.setMigrationXsl(transformationXSL);
                }
            }
            catch (UnexpectedCharacterException ex) {
                LOGGER.warn("Perform find nodes with transformation failed due to an unexpected character.", (Throwable)ex);
                nodes = super.performFindAllNodesInWizardLabels(fileName, INPUT3A_XSL, searchpath);
                if (nodes == null) break block3;
                nodes.setMigrationXsl(INPUT3A_XSL);
            }
        }
        return nodes;
    }

    @Override
    public NodeLabels performWizardLabelsMigration(ApplicationContext context, long uniqueId, String searchpath) {
        NodeLabels nodeLabels;
        String nodeFileName = "NodeLabels.labels";
        LOGGER.info("Search for node file: {}", (Object)nodeFileName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("search_uniqueId", Long.toString(uniqueId));
        params.put("forced_porttype", "");
        String migrationXsl = (String)context.get("migrationXSL", String.class);
        LOGGER.info("Fetched migrationXsl from context: {}", (Object)migrationXsl);
        if (StringUtils.isBlank((CharSequence)migrationXsl)) {
            migrationXsl = "/migration/labels-migration2.xsl";
        }
        if ((nodeLabels = this.performWizardLabelsMigration(params, nodeFileName, migrationXsl, searchpath)) == null || nodeLabels.getNodeLabel() == null) {
            LOGGER.info("No migrated node labels found for uniqueId: {}", (Object)uniqueId);
            if (nodeLabels == null) {
                nodeLabels = new NodeLabels();
            }
            nodeLabels.withNodeLabel(new NodeLabel().withUniqueId(uniqueId));
        }
        if (StringUtils.isBlank((CharSequence)(migrationXsl = (String)params.get("migrationXSL")))) {
            migrationXsl = "/migration/labels-migration2.xsl";
        } else {
            context.register("migrationXSL", (Object)migrationXsl);
        }
        NodeLabels macroNodeLabels = this.performWizardLabelsMigration(params, "MacroLabels.labels", migrationXsl, searchpath);
        if (macroNodeLabels != null && macroNodeLabels.getMacroLabels() != null) {
            LOGGER.info("Merge macro labels for uniqueId: {}", (Object)uniqueId);
            MacroLabels macroLabels = macroNodeLabels.getMacroLabels();
            nodeLabels.setMacroLabels(macroLabels);
        } else {
            LOGGER.info("No migrated macro labels found for uniqueId: {}", (Object)uniqueId);
        }
        NodeLabels accessoryNodeLabels = this.performWizardLabelsMigration(params, "AccessoryLabels.labels", migrationXsl, searchpath);
        if (accessoryNodeLabels != null && accessoryNodeLabels.getAccessoryLabels() != null) {
            LOGGER.info("Merge accessory labels for uniqueId: {}", (Object)uniqueId);
            AccessoryLabels accessoryLabels = accessoryNodeLabels.getAccessoryLabels();
            nodeLabels.setAccessoryLabels(accessoryLabels);
        } else {
            LOGGER.info("No migrated accessory labels found for uniqueId: {}", (Object)uniqueId);
        }
        NodeLabels feedbackPortNodeLabels = this.performWizardLabelsMigration(params, "FeedbackPortLabels.labels", migrationXsl, searchpath);
        if (feedbackPortNodeLabels != null && feedbackPortNodeLabels.getFeedbackPortLabels() != null) {
            LOGGER.info("Merge feedback port labels for uniqueId: {}", (Object)uniqueId);
            FeedbackPortLabels feedbackPortLabels = feedbackPortNodeLabels.getFeedbackPortLabels();
            nodeLabels.setFeedbackPortLabels(feedbackPortLabels);
        } else {
            LOGGER.info("No migrated feedback port labels found for uniqueId: {}", (Object)uniqueId);
        }
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "ServoPortLabels.labels", migrationXsl, "servo");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "SwitchPortLabels.labels", migrationXsl, "switch");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "LightPortLabels.labels", migrationXsl, "light");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "BacklightPortLabels.labels", migrationXsl, "backlight");
        this.migrateAndAppendWizardPortLabels(nodeLabels, params, searchpath, "InputPortLabels.labels", migrationXsl, "input");
        return nodeLabels;
    }

    @Override
    protected NodeLabels performWizardLabelsMigration(Map<String, String> params, String fileName, String migrationXSL, String searchpath) {
        NodeLabels nodeLabels = null;
        try {
            nodeLabels = super.performWizardLabelsMigration(params, fileName, migrationXSL, searchpath);
            params.put("migrationXSL", migrationXSL);
        }
        catch (UnexpectedCharacterException ex) {
            LOGGER.warn("Perform find nodes with transformation failed due to an unexpected character.", (Throwable)ex);
            nodeLabels = super.performWizardLabelsMigration(params, fileName, "/migration/labels-migration2a.xsl", searchpath);
            params.put("migrationXSL", "/migration/labels-migration2a.xsl");
        }
        return nodeLabels;
    }
}

