/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation.client.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.vlsolutions.swing.docking.DockKey;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.MessageClassEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.jbidibc.simulation.events.GuestRequestSendAccessoryAspectEvent;
import org.bidib.jbidibc.simulation.events.GuestRequestSendCsSetStateEvent;
import org.bidib.jbidibc.simulation.events.GuestSubscribeEvent;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.simulation.ReadyXPSimulator;
import org.bidib.wizard.simulation.client.view.panel.AbstractSimulatorNodePanel;
import org.bidib.wizard.simulation.client.view.panel.SimulationViewContainer;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadyXPPanel
extends AbstractSimulatorNodePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadyXPPanel.class);
    private final DockKey DOCKKEY;
    private final SimulationViewContainer container;

    public ReadyXPPanel(SimulationViewContainer container, NodeInterface node) {
        super(node);
        this.container = container;
        String uuid = ByteUtils.getUniqueIdAsString((long)node.getUniqueId());
        this.DOCKKEY = new DockKey(this.getClass().getSimpleName() + "-" + StringUtils.trimToEmpty((String)uuid));
        this.DOCKKEY.setFloatEnabled(true);
    }

    @Override
    public void createComponents(SimulatorNode simulator) {
        if (!(simulator instanceof ReadyXPSimulator)) {
            LOGGER.warn("The provided simulator is not a ReadyXPSimulator: {}", (Object)simulator);
            throw new IllegalArgumentException("The provided simulator is not a ReadyXPSimulator!");
        }
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:50dlu:grow", new Object[0]).rows("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p", new Object[0]);
        formBuilder.border((Border)Paddings.TABBED_DIALOG);
        final JTextField csNodeAddress = new JTextField("0");
        formBuilder.add("CS Addr:", new Object[0]).xy(1, 1);
        formBuilder.add((Component)csNodeAddress).xy(3, 1);
        JButton guestSubscribeButtonCommandStation = new JButton("Guest subscribe: CS");
        guestSubscribeButtonCommandStation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int nodeAddress = Integer.parseInt(csNodeAddress.getText());
                    byte[] targetNodeAddress = new byte[]{ByteUtils.getLowByte((int)nodeAddress)};
                    ReadyXPPanel.this.publishGuestSubscribe(targetNodeAddress, MessageClassEnum.BIDIB_MESSAGE_CLASS_COMMANDSTATION);
                }
                catch (Exception ex) {
                    LOGGER.warn("Prepare and send command station state request failed.", (Throwable)ex);
                }
            }
        });
        formBuilder.add((Component)guestSubscribeButtonCommandStation).xy(5, 1);
        JButton guestRequestSendCommandStationQueryButton = new JButton("Guest send: CS QUERY");
        guestRequestSendCommandStationQueryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int nodeAddress = Integer.parseInt(csNodeAddress.getText());
                    byte[] targetNodeAddress = new byte[]{ByteUtils.getLowByte((int)nodeAddress)};
                    ReadyXPPanel.this.publishGuestRequestSend(targetNodeAddress, CommandStationState.QUERY);
                }
                catch (Exception ex) {
                    LOGGER.warn("Prepare and send command station state request failed.", (Throwable)ex);
                }
            }
        });
        formBuilder.add((Component)guestRequestSendCommandStationQueryButton).xy(7, 1);
        JButton guestRequestSendCommandStationOnButton = new JButton("Guest send: CS GO");
        guestRequestSendCommandStationOnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int nodeAddress = Integer.parseInt(csNodeAddress.getText());
                    byte[] targetNodeAddress = new byte[]{ByteUtils.getLowByte((int)nodeAddress)};
                    ReadyXPPanel.this.publishGuestRequestSend(targetNodeAddress, CommandStationState.GO);
                }
                catch (Exception ex) {
                    LOGGER.warn("Prepare and send command station state request failed.", (Throwable)ex);
                }
            }
        });
        formBuilder.add((Component)guestRequestSendCommandStationOnButton).xy(9, 1);
        JButton guestRequestSendCommandStationStopButton = new JButton("Guest send: CS STOP");
        guestRequestSendCommandStationStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int nodeAddress = Integer.parseInt(csNodeAddress.getText());
                    byte[] targetNodeAddress = new byte[]{ByteUtils.getLowByte((int)nodeAddress)};
                    ReadyXPPanel.this.publishGuestRequestSend(targetNodeAddress, CommandStationState.STOP);
                }
                catch (Exception ex) {
                    LOGGER.warn("Prepare and send command station state request failed.", (Throwable)ex);
                }
            }
        });
        formBuilder.add((Component)guestRequestSendCommandStationStopButton).xy(11, 1);
        final JTextField accessoryNodeAddress = new JTextField("11");
        formBuilder.add("ACC Addr:", new Object[0]).xy(1, 3);
        formBuilder.add((Component)accessoryNodeAddress).xy(3, 3);
        JButton guestSubscribeButtonAccessory = new JButton("Guest subscribe: ACC");
        guestSubscribeButtonAccessory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int nodeAddress = Integer.parseInt(accessoryNodeAddress.getText());
                    byte[] targetNodeAddress = new byte[]{ByteUtils.getLowByte((int)nodeAddress)};
                    ReadyXPPanel.this.publishGuestSubscribe(targetNodeAddress, MessageClassEnum.BIDIB_MESSAGE_CLASS_ACCESSORY);
                }
                catch (Exception ex) {
                    LOGGER.warn("Prepare and send accessory state request failed.", (Throwable)ex);
                }
            }
        });
        formBuilder.add((Component)guestSubscribeButtonAccessory).xy(5, 3);
        JButton guestRequestSendAccessory1SetAspect0Button = new JButton("Guest send: ACC 1 Aspect 0");
        guestRequestSendAccessory1SetAspect0Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int nodeAddress = Integer.parseInt(accessoryNodeAddress.getText());
                    byte[] targetNodeAddress = new byte[]{ByteUtils.getLowByte((int)nodeAddress)};
                    ReadyXPPanel.this.publishGuestRequestAccessoryStateSend(targetNodeAddress, 1, 0);
                }
                catch (Exception ex) {
                    LOGGER.warn("Prepare and send accessory state request failed.", (Throwable)ex);
                }
            }
        });
        formBuilder.add((Component)guestRequestSendAccessory1SetAspect0Button).xy(7, 3);
        JButton guestRequestSendAccessory1SetAspect1Button = new JButton("Guest send: ACC 1 Aspect 1");
        guestRequestSendAccessory1SetAspect1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int nodeAddress = Integer.parseInt(accessoryNodeAddress.getText());
                    byte[] targetNodeAddress = new byte[]{ByteUtils.getLowByte((int)nodeAddress)};
                    ReadyXPPanel.this.publishGuestRequestAccessoryStateSend(targetNodeAddress, 1, 1);
                }
                catch (Exception ex) {
                    LOGGER.warn("Prepare and send accessory state request failed.", (Throwable)ex);
                }
            }
        });
        formBuilder.add((Component)guestRequestSendAccessory1SetAspect1Button).xy(9, 3);
        final JTextField boosterNodeAddress = new JTextField("0");
        formBuilder.add("BST Addr:", new Object[0]).xy(1, 5);
        formBuilder.add((Component)boosterNodeAddress).xy(3, 5);
        JButton guestSubscribeButtonBooster = new JButton("Guest subscribe: BOOSTER");
        guestSubscribeButtonBooster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int nodeAddress = Integer.parseInt(boosterNodeAddress.getText());
                    byte[] targetNodeAddress = new byte[]{ByteUtils.getLowByte((int)nodeAddress)};
                    ReadyXPPanel.this.publishGuestSubscribe(targetNodeAddress, MessageClassEnum.BIDIB_MESSAGE_CLASS_BOOSTER);
                }
                catch (Exception ex) {
                    LOGGER.warn("Prepare and send booster state request failed.", (Throwable)ex);
                }
            }
        });
        formBuilder.add((Component)guestSubscribeButtonBooster).xy(5, 5);
        this.contentPanel = formBuilder.build();
        AnnotationProcessor.process((Object)this);
    }

    public DockKey getDockKey() {
        return this.DOCKKEY;
    }

    @Override
    public void stop() {
        AnnotationProcessor.unprocess((Object)this);
        this.container.close(this);
    }

    private void publishGuestSubscribe(byte[] targetNodeAddress, MessageClassEnum messageClass) {
        GuestSubscribeEvent guestSubscribeEvent = new GuestSubscribeEvent(targetNodeAddress, messageClass);
        LOGGER.info("Publish the guestSubscribeEvent: {}", (Object)guestSubscribeEvent);
        EventBus.publish((Object)guestSubscribeEvent);
    }

    private void publishGuestRequestSend(byte[] targetNodeAddress, CommandStationState csState) {
        GuestRequestSendCsSetStateEvent guestRequestSendEvent = new GuestRequestSendCsSetStateEvent(targetNodeAddress, csState);
        LOGGER.info("Publish the guestRequestSendEvent: {}", (Object)guestRequestSendEvent);
        EventBus.publish((Object)guestRequestSendEvent);
    }

    private void publishGuestRequestAccessoryStateSend(byte[] targetNodeAddress, int accessoryNumber, int aspectNumber) {
        GuestRequestSendAccessoryAspectEvent guestRequestSendEvent = new GuestRequestSendAccessoryAspectEvent(targetNodeAddress, accessoryNumber, aspectNumber);
        LOGGER.info("Publish the guestRequestSendEvent: {}", (Object)guestRequestSendEvent);
        EventBus.publish((Object)guestRequestSendEvent);
    }
}

