/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation.client.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.vlsolutions.swing.docking.DockKey;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.led.LED;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.simulation.OneStepControlSimulator;
import org.bidib.wizard.simulation.client.view.panel.AbstractSimulatorNodePanel;
import org.bidib.wizard.simulation.client.view.panel.SimulationViewContainer;
import org.bidib.wizard.simulation.events.EmergencyStopSetEvent;
import org.bidib.wizard.simulation.events.EmergencyStopStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackConfidenceSetEvent;
import org.bidib.wizard.simulation.events.FeedbackConfidenceStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortSetStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortStatusEvent;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneStepControlSimulatorPanel
extends AbstractSimulatorNodePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(OneStepControlSimulatorPanel.class);
    private static final String ENCODED_ROW_SPECS = "pref";
    private final DockKey DOCKKEY;
    private final SimulationViewContainer container;
    private Map<Integer, LED> feedbackPortLeds = new HashMap<Integer, LED>();
    private final AtomicBoolean statusFreeze = new AtomicBoolean();
    private final AtomicBoolean statusValid = new AtomicBoolean();
    private final AtomicBoolean statusSignal = new AtomicBoolean();
    private JToggleButton freezeButton;
    private JToggleButton emergencyStopButton;
    private final AtomicBoolean statusEmergencyStop = new AtomicBoolean();

    public OneStepControlSimulatorPanel(SimulationViewContainer container, NodeInterface node) {
        super(node);
        this.container = container;
        String uuid = ByteUtils.getUniqueIdAsString((long)node.getUniqueId());
        this.DOCKKEY = new DockKey(this.getClass().getSimpleName() + "-" + StringUtils.trimToEmpty((String)uuid));
        this.DOCKKEY.setFloatEnabled(true);
    }

    @Override
    public void createComponents(SimulatorNode simulator) {
        Object panel;
        if (!(simulator instanceof OneStepControlSimulator)) {
            LOGGER.warn("The provided simulator is not a OneStepControlSimulator: {}", (Object)simulator);
            throw new IllegalArgumentException("The provided simulator is not a OneStepControlSimulator!");
        }
        FormBuilder formBuilder = null;
        boolean debug = false;
        if (debug) {
            panel = new FormDebugPanel();
            formBuilder = FormBuilder.create().columns("pref, fill:50dlu:grow", new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            formBuilder = FormBuilder.create().columns("pref, fill:50dlu:grow", new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        int row = 1;
        Feature feedbackPortCount = simulator.getFeature(0);
        if (feedbackPortCount != null && feedbackPortCount.getValue() > 0) {
            JPanel feedbackPorts = new JPanel();
            feedbackPorts.setBorder(new EmptyBorder(5, 5, 5, 5));
            feedbackPorts.setLayout(new GridLayout(2, 8, 5, 5));
            int feedbackPortCountValue = feedbackPortCount.getValue();
            MouseAdapter ledMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LED clickedLed = (LED)e.getSource();
                    OneStepControlSimulatorPanel.this.toggleFeedbackPort(clickedLed);
                }
            };
            LOGGER.info("Initializing lightPort LEDs.");
            for (int i = 0; i < feedbackPortCountValue; ++i) {
                LED led = new LED(Color.GREEN, Color.RED, false);
                led.setIndex(i);
                led.setSize(20, 20);
                led.setToolTipText("Feedback " + i);
                led.addMouseListener((MouseListener)ledMouseListener);
                this.feedbackPortLeds.put(i, led);
                feedbackPorts.add((Component)led);
            }
            formBuilder.add("Feedback ports", new Object[0]).xy(1, row);
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            formBuilder.add((Component)feedbackPorts).xy(1, row += 2);
            row += 2;
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            this.freezeButton = new JToggleButton("Freeze");
            this.freezeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OneStepControlSimulatorPanel.this.statusFreeze.set(!OneStepControlSimulatorPanel.this.statusFreeze.get());
                    String nodeAddress = ByteUtils.bytesToHex((byte[])OneStepControlSimulatorPanel.this.getNode().getNode().getAddr());
                    FeedbackConfidenceSetEvent feedbackConfidenceEvent = new FeedbackConfidenceSetEvent(nodeAddress, OneStepControlSimulatorPanel.this.statusValid.get(), OneStepControlSimulatorPanel.this.statusFreeze.get(), OneStepControlSimulatorPanel.this.statusSignal.get());
                    LOGGER.info("Publish the feedbackConfidenceEvent: {}", (Object)feedbackConfidenceEvent);
                    EventBus.publish((Object)feedbackConfidenceEvent);
                }
            });
            this.freezeButton.setForeground(Color.GREEN.darker());
            formBuilder.add((Component)this.freezeButton).xy(1, row);
            row += 2;
            formBuilder.appendRows("3dlu, pref", new Object[0]);
        } else {
            LOGGER.warn("No configured FeedbackPorts available.");
        }
        this.emergencyStopButton = new JToggleButton("EmergencyStop");
        this.emergencyStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneStepControlSimulatorPanel.this.statusEmergencyStop.set(!OneStepControlSimulatorPanel.this.statusEmergencyStop.get());
                String nodeAddress = ByteUtils.bytesToHex((byte[])OneStepControlSimulatorPanel.this.getNode().getNode().getAddr());
                EmergencyStopSetEvent emergencyStopEvent = new EmergencyStopSetEvent(nodeAddress, OneStepControlSimulatorPanel.this.statusEmergencyStop.get());
                LOGGER.info("Publish the emergencyStopEvent: {}", (Object)emergencyStopEvent);
                EventBus.publish((Object)emergencyStopEvent);
            }
        });
        this.emergencyStopButton.setForeground(Color.GREEN.darker());
        formBuilder.add((Component)this.emergencyStopButton).xy(1, row);
        this.contentPanel = formBuilder.build();
        AnnotationProcessor.process((Object)this);
        simulator.queryStatus(FeedbackPort.class);
    }

    public DockKey getDockKey() {
        return this.DOCKKEY;
    }

    @Override
    public void stop() {
        AnnotationProcessor.unprocess((Object)this);
        this.container.close(this);
    }

    @EventSubscriber(eventClass=FeedbackPortStatusEvent.class)
    public void updateStatus(FeedbackPortStatusEvent statusEvent) {
        LOGGER.info("The feedbackport status has changed, status: {}, node: {}", (Object)statusEvent, (Object)this.getNode());
        FeedbackPortStatus status = statusEvent.getStatus();
        int id = statusEvent.getPortNumber();
        LED led = this.feedbackPortLeds.get(id);
        if (led != null) {
            LOGGER.trace("Found led to switch.");
            if (status == FeedbackPortStatus.FREE) {
                led.usePrimary();
            } else {
                led.useSecondary();
            }
        } else {
            LOGGER.trace("Led not found.");
        }
    }

    @EventSubscriber(eventClass=FeedbackConfidenceStatusEvent.class)
    public void updateFeedbackConfidenceStatus(FeedbackConfidenceStatusEvent statusEvent) {
        LOGGER.info("The feedbackport confidence status has changed, status: {}, node: {}", (Object)statusEvent, (Object)this.getNode());
        this.statusValid.set(statusEvent.getValid());
        this.statusFreeze.set(statusEvent.getFreeze());
        this.statusSignal.set(statusEvent.getSignal());
        this.freezeButton.setSelected(this.statusFreeze.get());
        this.freezeButton.setForeground(this.statusFreeze.get() ? Color.RED : Color.GREEN.darker());
    }

    @EventSubscriber(eventClass=EmergencyStopStatusEvent.class)
    public void updateEmergencyStopStatus(EmergencyStopStatusEvent statusEvent) {
        LOGGER.info("The emergency stop status has changed, status: {}, node: {}", (Object)statusEvent, (Object)this.getNode());
        this.statusEmergencyStop.set(statusEvent.getEmergencyStop());
        this.emergencyStopButton.setSelected(this.statusEmergencyStop.get());
        this.emergencyStopButton.setForeground(this.statusEmergencyStop.get() ? Color.RED : Color.GREEN.darker());
    }

    private void toggleFeedbackPort(LED ledButton) {
        String nodeAddress = ByteUtils.bytesToHex((byte[])this.getNode().getNode().getAddr());
        int portNum = ledButton.getIndex();
        FeedbackPortSetStatusEvent feedbackPortSetStatusEvent = new FeedbackPortSetStatusEvent(nodeAddress, portNum, ledButton.isUsePrimary() ? FeedbackPortStatus.OCCUPIED : FeedbackPortStatus.FREE);
        LOGGER.info("Publish the FeedbackPortSetStatusEvent: {}", (Object)feedbackPortSetStatusEvent);
        EventBus.publish((Object)feedbackPortSetStatusEvent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(", dockKey: ");
        sb.append(this.DOCKKEY).append(", node: ").append(this.getNode());
        return sb.toString();
    }
}

