/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation.client.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.vlsolutions.swing.docking.DockKey;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.led.ColorIcon;
import org.bidib.wizard.client.common.led.LED;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.status.BacklightPortStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.simulation.client.view.panel.AbstractSimulatorNodePanel;
import org.bidib.wizard.simulation.client.view.panel.SimulationViewContainer;
import org.bidib.wizard.simulation.events.BacklightPortStatusEvent;
import org.bidib.wizard.simulation.events.InputPortSetStatusEvent;
import org.bidib.wizard.simulation.events.InputPortStatusEvent;
import org.bidib.wizard.simulation.events.LightPortStatusEvent;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneDMXPanel
extends AbstractSimulatorNodePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(OneDMXPanel.class);
    private static final String ENCODED_ROW_SPECS = "pref";
    private final DockKey DOCKKEY;
    private final SimulationViewContainer container;
    private Map<Integer, LED> lightPortLeds = new HashMap<Integer, LED>();
    private Map<Integer, LedButton> inputPortLeds = new HashMap<Integer, LedButton>();
    private Map<Integer, LED> backlightPortLeds = new HashMap<Integer, LED>();

    public OneDMXPanel(SimulationViewContainer container, NodeInterface node) {
        super(node);
        this.container = container;
        String uuid = ByteUtils.getUniqueIdAsString((long)node.getUniqueId());
        this.DOCKKEY = new DockKey(this.getClass().getSimpleName() + "-" + StringUtils.trimToEmpty((String)uuid));
        this.DOCKKEY.setFloatEnabled(true);
    }

    @Override
    public void createComponents(SimulatorNode simulator) {
        Object panel;
        FormBuilder formBuilder = null;
        boolean debug = false;
        if (debug) {
            panel = new FormDebugPanel();
            formBuilder = FormBuilder.create().columns("pref, fill:50dlu:grow", new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            formBuilder = FormBuilder.create().columns("pref, fill:50dlu:grow", new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        int row = 1;
        Feature lightPortCount = simulator.getFeature(53);
        if (lightPortCount != null && lightPortCount.getValue() > 0) {
            JPanel lightPorts = new JPanel();
            lightPorts.setBorder(new EmptyBorder(5, 5, 5, 5));
            lightPorts.setLayout(new GridLayout(0, 8, 5, 5));
            LOGGER.info("Initializing lightPort LEDs.");
            for (int i = 0; i < lightPortCount.getValue(); ++i) {
                LED led = new LED(Color.LIGHT_GRAY, Color.GREEN, true);
                led.setSize(10, 10);
                led.setToolTipText("Light " + i);
                this.lightPortLeds.put(i, led);
                lightPorts.add((Component)led);
            }
            formBuilder.add("Light ports", new Object[0]).xy(1, row);
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            formBuilder.add((Component)lightPorts).xy(1, row += 2);
            row += 2;
            formBuilder.appendRows("3dlu, pref", new Object[0]);
        } else {
            LOGGER.warn("No configured LightPorts available.");
        }
        Feature inputPortCount = simulator.getFeature(50);
        if (inputPortCount != null && inputPortCount.getValue() > 0) {
            JPanel inputPorts = new JPanel();
            inputPorts.setBorder(new EmptyBorder(5, 5, 5, 5));
            inputPorts.setLayout(new GridLayout(0, 8, 5, 5));
            LOGGER.info("Initializing inputPort LEDs.");
            for (int portNum = 0; portNum < inputPortCount.getValue(); ++portNum) {
                final LedButton led = new LedButton(portNum);
                led.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OneDMXPanel.this.toggleInputPort(led.getPortNum());
                    }
                });
                led.setSize(new Dimension(12, 12));
                led.setMinimumSize(new Dimension(12, 12));
                led.setPreferredSize(new Dimension(12, 12));
                led.setMargin(new Insets(5, 5, 5, 5));
                led.setToolTipText("Input " + portNum);
                this.inputPortLeds.put(portNum, led);
                inputPorts.add(led);
            }
            formBuilder.add("Input ports", new Object[0]).xy(1, row);
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            formBuilder.add((Component)inputPorts).xy(1, row += 2);
            row += 2;
            formBuilder.appendRows("3dlu, pref", new Object[0]);
        } else {
            LOGGER.warn("No configured InputPorts available.");
        }
        Feature backlightPortCount = simulator.getFeature(59);
        if (backlightPortCount != null && backlightPortCount.getValue() > 0) {
            JPanel backlightPorts = new JPanel();
            backlightPorts.setBorder(new EmptyBorder(5, 5, 5, 5));
            backlightPorts.setLayout(new GridLayout(0, 8, 5, 5));
            LOGGER.info("Initializing backlightPort LEDs.");
            for (int i = 0; i < backlightPortCount.getValue(); ++i) {
                LED led = new LED(Color.LIGHT_GRAY, Color.GREEN, true);
                led.setSize(10, 10);
                led.setToolTipText("Backlight " + i);
                this.backlightPortLeds.put(i, led);
                backlightPorts.add((Component)led);
            }
            formBuilder.add("Backlight ports", new Object[0]).xy(1, row);
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            formBuilder.add((Component)backlightPorts).xy(1, row += 2);
            row += 2;
            formBuilder.appendRows("3dlu, pref", new Object[0]);
        } else {
            LOGGER.warn("No configured BacklightPorts available.");
        }
        this.contentPanel = formBuilder.build();
        AnnotationProcessor.process((Object)this);
        simulator.queryStatus(InputPort.class);
        simulator.queryStatus(LightPort.class);
        simulator.queryStatus(BacklightPort.class);
    }

    public DockKey getDockKey() {
        return this.DOCKKEY;
    }

    @Override
    public void stop() {
        AnnotationProcessor.unprocess((Object)this);
        this.container.close(this);
    }

    private void toggleInputPort(int portNum) {
        LedButton ledButton = this.inputPortLeds.get(portNum);
        String nodeAddress = ByteUtils.bytesToHex((byte[])this.getNode().getNode().getAddr());
        InputPortSetStatusEvent inputPortSetStatusEvent = new InputPortSetStatusEvent(nodeAddress, portNum, ledButton.getStatus());
        LOGGER.info("Publish the inputPortSetStatusEvent: {}", (Object)inputPortSetStatusEvent);
        EventBus.publish((Object)inputPortSetStatusEvent);
    }

    @EventSubscriber(eventClass=InputPortStatusEvent.class)
    public void inputPortStatusChanged(InputPortStatusEvent statusEvent) {
        LOGGER.info("The inputport status has changed, portNumber: {}, status: {}, node: {}", new Object[]{statusEvent.getPortNumber(), statusEvent.getStatus(), this.getNode()});
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        int id = statusEvent.getPortNumber();
        InputPortStatus status = statusEvent.getStatus();
        LedButton led = this.inputPortLeds.get(id);
        if (led != null) {
            LOGGER.trace("Found input to switch.");
            led.setStatus(status);
        } else {
            LOGGER.trace("Led not found.");
        }
    }

    @EventSubscriber(eventClass=LightPortStatusEvent.class)
    public void lightPortStatusChanged(LightPortStatusEvent statusEvent) {
        LOGGER.info("The lightport status has changed, port: {}, status: {}, node: {}", new Object[]{statusEvent.getPortNumber(), statusEvent.getStatus(), this.getNode()});
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        LightPortStatus status = statusEvent.getStatus();
        int id = statusEvent.getPortNumber();
        LED led = this.lightPortLeds.get(id);
        if (led != null) {
            LOGGER.trace("Found led to switch.");
            if (status == LightPortStatus.OFF) {
                led.usePrimary();
            } else {
                led.useSecondary();
            }
        } else {
            LOGGER.trace("Led not found.");
        }
    }

    @EventSubscriber(eventClass=BacklightPortStatusEvent.class)
    public void backlightPortStatusChanged(BacklightPortStatusEvent statusEvent) {
        LOGGER.info("The backlightport status has changed, status: {}, node: {}", (Object)statusEvent.getStatus(), (Object)this.getNode());
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        BacklightPortStatus status = statusEvent.getStatus();
        int id = statusEvent.getPortNumber();
        LED led = this.backlightPortLeds.get(id);
        if (led != null) {
            LOGGER.trace("Found led to switch.");
            if (status == BacklightPortStatus.START) {
                led.usePrimary();
            } else {
                led.useSecondary();
            }
        } else {
            LOGGER.trace("Led not found.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OneDMXPanel, dockKey: ");
        sb.append(this.DOCKKEY).append(", node: ").append(this.getNode());
        return sb.toString();
    }

    private static final class LedButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private int portNum;
        private InputPortStatus status = InputPortStatus.OFF;
        private ColorIcon offIcon = new ColorIcon(10, Color.GRAY);
        private ColorIcon onIcon = new ColorIcon(10, Color.RED);

        public LedButton(int portNum) {
            this.setIcon((Icon)this.offIcon);
            this.portNum = portNum;
        }

        public int getPortNum() {
            return this.portNum;
        }

        public InputPortStatus getStatus() {
            return this.status;
        }

        public void setStatus(InputPortStatus status) {
            this.status = status;
            if (status == InputPortStatus.OFF) {
                this.setIcon((Icon)this.offIcon);
            } else {
                this.setIcon((Icon)this.onIcon);
            }
        }
    }
}

