/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation.client.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.vlsolutions.swing.docking.DockKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.led.LED;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.simulation.client.view.panel.AbstractSimulatorNodePanel;
import org.bidib.wizard.simulation.client.view.panel.SimulationViewContainer;
import org.bidib.wizard.simulation.events.FeedbackConfidenceSetEvent;
import org.bidib.wizard.simulation.events.FeedbackConfidenceStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortSetStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortStatusEvent;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GBMboostMasterPanel
extends AbstractSimulatorNodePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(GBMboostMasterPanel.class);
    private final DockKey DOCKKEY;
    private final SimulationViewContainer container;
    private Map<Integer, LED> feedbackPortLeds = new HashMap<Integer, LED>();
    private final AtomicBoolean statusFreeze = new AtomicBoolean();
    private final AtomicBoolean statusInvalid = new AtomicBoolean();
    private final AtomicBoolean statusNoSignal = new AtomicBoolean();
    private JToggleButton freezeButton;
    private JToggleButton voidButton;
    private JToggleButton noSignalButton;

    public GBMboostMasterPanel(SimulationViewContainer container, NodeInterface node) {
        super(node);
        this.container = container;
        String uuid = ByteUtils.getUniqueIdAsString((long)node.getUniqueId());
        this.DOCKKEY = new DockKey(this.getClass().getSimpleName() + "-" + StringUtils.trimToEmpty((String)uuid));
        this.DOCKKEY.setFloatEnabled(true);
    }

    @Override
    public void createComponents(SimulatorNode simulator) {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 3dlu, pref, fill:50dlu:grow", new Object[0]).rows("p, 3dlu, p, 3dlu, p, 3dlu, p", new Object[0]);
        formBuilder.border((Border)Paddings.TABBED_DIALOG);
        Feature feedbackPortCount = simulator.getFeature(0);
        if (feedbackPortCount != null && feedbackPortCount.getValue() > 0) {
            JPanel feedbackPorts = new JPanel();
            feedbackPorts.setBorder(new EmptyBorder(5, 5, 5, 5));
            feedbackPorts.setLayout(new GridLayout(2, 8, 5, 5));
            int feedbackPortCountValue = feedbackPortCount.getValue();
            LOGGER.info("Initializing lightPort LEDs.");
            for (int i = 0; i < feedbackPortCountValue; ++i) {
                final LED led = new LED(Color.GREEN, Color.RED, false);
                led.setSize(20, 20);
                led.setToolTipText("Feedback " + i);
                led.putClientProperty((Object)"portId", (Object)i);
                led.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        LOGGER.info("Mouse clicked on led: {}", (Object)led);
                        Integer portId = (Integer)led.getClientProperty((Object)"portId");
                        String nodeAddress = NodeUtils.formatAddress((byte[])GBMboostMasterPanel.this.getNode().getNode().getAddr());
                        FeedbackPortStatus feedbackPortStatus = !led.isUsePrimary() ? FeedbackPortStatus.OCCUPIED : FeedbackPortStatus.FREE;
                        FeedbackPortSetStatusEvent feedbackPortSetStatusEvent = new FeedbackPortSetStatusEvent(nodeAddress, portId.intValue(), feedbackPortStatus);
                        LOGGER.info("Publish the feedbackPortSetStatusEvent: {}", (Object)feedbackPortSetStatusEvent);
                        EventBus.publish((Object)feedbackPortSetStatusEvent);
                    }
                });
                this.feedbackPortLeds.put(i, led);
                feedbackPorts.add((Component)led);
            }
            formBuilder.add("Feedback ports", new Object[0]).xy(1, 1);
            formBuilder.add((Component)feedbackPorts).xyw(3, 1, 2);
        } else {
            LOGGER.warn("No configured FeedbackPorts available.");
        }
        this.freezeButton = new JToggleButton("Freeze");
        this.freezeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GBMboostMasterPanel.this.statusFreeze.set(!GBMboostMasterPanel.this.statusFreeze.get());
                String nodeAddress = NodeUtils.formatAddress((byte[])GBMboostMasterPanel.this.getNode().getNode().getAddr());
                FeedbackConfidenceSetEvent feedbackConfidenceEvent = new FeedbackConfidenceSetEvent(nodeAddress, GBMboostMasterPanel.this.statusInvalid.get(), GBMboostMasterPanel.this.statusFreeze.get(), GBMboostMasterPanel.this.statusNoSignal.get());
                LOGGER.info("Publish the feedbackConfidenceEvent: {}", (Object)feedbackConfidenceEvent);
                EventBus.publish((Object)feedbackConfidenceEvent);
            }
        });
        this.freezeButton.setForeground(Color.GREEN.darker());
        formBuilder.add((Component)this.freezeButton).xy(1, 3);
        this.voidButton = new JToggleButton("Void");
        this.voidButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GBMboostMasterPanel.this.statusInvalid.set(!GBMboostMasterPanel.this.statusInvalid.get());
                String nodeAddress = NodeUtils.formatAddress((byte[])GBMboostMasterPanel.this.getNode().getNode().getAddr());
                FeedbackConfidenceSetEvent feedbackConfidenceEvent = new FeedbackConfidenceSetEvent(nodeAddress, GBMboostMasterPanel.this.statusInvalid.get(), GBMboostMasterPanel.this.statusFreeze.get(), GBMboostMasterPanel.this.statusNoSignal.get());
                LOGGER.info("Publish the feedbackConfidenceEvent: {}", (Object)feedbackConfidenceEvent);
                EventBus.publish((Object)feedbackConfidenceEvent);
            }
        });
        this.voidButton.setForeground(Color.GREEN.darker());
        formBuilder.add((Component)this.voidButton).xy(1, 5);
        this.noSignalButton = new JToggleButton("noSignal");
        this.noSignalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GBMboostMasterPanel.this.statusNoSignal.set(!GBMboostMasterPanel.this.statusNoSignal.get());
                String nodeAddress = NodeUtils.formatAddress((byte[])GBMboostMasterPanel.this.getNode().getNode().getAddr());
                FeedbackConfidenceSetEvent feedbackConfidenceEvent = new FeedbackConfidenceSetEvent(nodeAddress, GBMboostMasterPanel.this.statusInvalid.get(), GBMboostMasterPanel.this.statusFreeze.get(), GBMboostMasterPanel.this.statusNoSignal.get());
                LOGGER.info("Publish the feedbackConfidenceEvent: {}", (Object)feedbackConfidenceEvent);
                EventBus.publish((Object)feedbackConfidenceEvent);
            }
        });
        this.noSignalButton.setForeground(Color.GREEN.darker());
        formBuilder.add((Component)this.noSignalButton).xy(1, 7);
        this.contentPanel = formBuilder.build();
        AnnotationProcessor.process((Object)this);
        simulator.queryStatus(FeedbackPort.class);
    }

    public DockKey getDockKey() {
        return this.DOCKKEY;
    }

    @Override
    public void stop() {
        AnnotationProcessor.unprocess((Object)this);
        this.container.close(this);
    }

    @EventSubscriber(eventClass=FeedbackPortStatusEvent.class)
    public void updateStatus(FeedbackPortStatusEvent statusEvent) {
        LOGGER.info("The feedbackport status has changed, status: {}, node: {}", (Object)statusEvent, (Object)this.getNode());
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        FeedbackPortStatus status = statusEvent.getStatus();
        int id = statusEvent.getPortNumber();
        LED led = this.feedbackPortLeds.get(id);
        if (led != null) {
            LOGGER.trace("Found led to switch.");
            if (status == FeedbackPortStatus.FREE) {
                led.usePrimary();
            } else {
                led.useSecondary();
            }
        } else {
            LOGGER.trace("Led not found.");
        }
    }

    @EventSubscriber(eventClass=FeedbackConfidenceStatusEvent.class)
    public void updateFeedbackConfidenceStatus(FeedbackConfidenceStatusEvent statusEvent) {
        LOGGER.info("The feedbackport confidence status has changed, status: {}, node: {}", (Object)statusEvent, (Object)this.getNode());
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        this.statusInvalid.set(statusEvent.getValid());
        this.statusFreeze.set(statusEvent.getFreeze());
        this.statusNoSignal.set(statusEvent.getSignal());
        this.freezeButton.setSelected(this.statusFreeze.get());
        this.freezeButton.setForeground(this.statusFreeze.get() ? Color.RED : Color.GREEN.darker());
        this.voidButton.setSelected(this.statusInvalid.get());
        this.voidButton.setForeground(this.statusInvalid.get() ? Color.RED : Color.GREEN.darker());
        this.noSignalButton.setSelected(this.statusNoSignal.get());
        this.noSignalButton.setForeground(this.statusNoSignal.get() ? Color.RED : Color.GREEN.darker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(", dockKey: ");
        sb.append(this.DOCKKEY).append(", node: ").append(this.getNode());
        return sb.toString();
    }
}

