/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation.client.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.vlsolutions.swing.docking.DockKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.AccessoryStateErrorEnum;
import org.bidib.jbidibc.messages.enums.SysErrorEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.jbidibc.simulation.events.AccessoryStateErrorEvent;
import org.bidib.jbidibc.simulation.events.IdentifyEvent;
import org.bidib.jbidibc.simulation.events.StallEvent;
import org.bidib.jbidibc.simulation.events.SysErrorEvent;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.led.ColorIcon;
import org.bidib.wizard.client.common.led.LED;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.simulation.LightControlSimulator;
import org.bidib.wizard.simulation.client.view.panel.AbstractSimulatorNodePanel;
import org.bidib.wizard.simulation.client.view.panel.SimulationViewContainer;
import org.bidib.wizard.simulation.events.InputPortSetStatusEvent;
import org.bidib.wizard.simulation.events.InputPortStatusEvent;
import org.bidib.wizard.simulation.events.LightPortStatusEvent;
import org.bidib.wizard.simulation.events.SwitchPortStatusEvent;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightControlPanel
extends AbstractSimulatorNodePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightControlPanel.class);
    private final DockKey DOCKKEY;
    private final SimulationViewContainer container;
    private Map<Integer, LED> lightPortLeds = new HashMap<Integer, LED>();
    private Map<Integer, LedButton> inputPortLeds = new HashMap<Integer, LedButton>();
    private Map<Integer, LED> switchPortLeds = new HashMap<Integer, LED>();
    private AtomicBoolean nodeStall = new AtomicBoolean();

    public LightControlPanel(SimulationViewContainer container, NodeInterface node) {
        super(node);
        this.container = container;
        String uuid = ByteUtils.getUniqueIdAsString((long)node.getUniqueId());
        this.DOCKKEY = new DockKey(this.getClass().getSimpleName() + "-" + StringUtils.trimToEmpty((String)uuid));
        this.DOCKKEY.setFloatEnabled(true);
    }

    @Override
    public void createComponents(SimulatorNode simulator) {
        if (!(simulator instanceof LightControlSimulator)) {
            LOGGER.warn("The provided simulator is not a LightControlSimulator: {}", (Object)simulator);
            throw new IllegalArgumentException("The provided simulator is not a LightControlSimulator!");
        }
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 3dlu, p, fill:50dlu:grow", new Object[0]).rows("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p", new Object[0]);
        formBuilder.border((Border)Paddings.TABBED_DIALOG);
        Feature lightPortCount = simulator.getFeature(53);
        if (lightPortCount != null && lightPortCount.getValue() > 0) {
            JPanel lightPorts = new JPanel();
            lightPorts.setBorder(new EmptyBorder(5, 5, 5, 5));
            lightPorts.setLayout(new GridLayout(0, 8, 5, 5));
            LOGGER.info("Initializing lightPort LEDs.");
            for (int i = 0; i < lightPortCount.getValue(); ++i) {
                LED led = new LED(Color.LIGHT_GRAY, Color.GREEN, true);
                led.setSize(10, 10);
                led.setToolTipText("Light " + i);
                this.lightPortLeds.put(i, led);
                lightPorts.add((Component)led);
            }
            formBuilder.add((Component)new JLabel("Light ports")).xy(1, 1);
            formBuilder.add((Component)lightPorts).xy(3, 1);
        } else {
            LOGGER.warn("No configured LightPorts available.");
        }
        Feature inputPortCount = simulator.getFeature(50);
        if (inputPortCount != null && inputPortCount.getValue() > 0) {
            JPanel inputPorts = new JPanel();
            inputPorts.setBorder(new EmptyBorder(5, 5, 5, 5));
            inputPorts.setLayout(new GridLayout(0, 8, 5, 5));
            LightControlSimulator lightControlSimulator = (LightControlSimulator)simulator;
            int inputPortOffset = lightControlSimulator.getInputPortOffset();
            LOGGER.info("Initializing inputPort LEDs.");
            for (int portNum = 0; portNum < inputPortCount.getValue(); ++portNum) {
                final LedButton led = new LedButton(portNum + inputPortOffset);
                led.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LOGGER.info("Toggle the input port with portnum: {}", (Object)led.getPortNum());
                        LightControlPanel.this.toggleInputPort(led.getPortNum());
                    }
                });
                led.setSize(new Dimension(12, 12));
                led.setMinimumSize(new Dimension(12, 12));
                led.setPreferredSize(new Dimension(12, 12));
                led.setMargin(new Insets(5, 5, 5, 5));
                led.setToolTipText("Input " + (portNum + inputPortOffset));
                this.inputPortLeds.put(portNum + inputPortOffset, led);
                inputPorts.add(led);
            }
            formBuilder.add((Component)new JLabel("Input ports")).xy(1, 3);
            formBuilder.add((Component)inputPorts).xy(3, 3);
        } else {
            LOGGER.warn("No configured InputPorts available.");
        }
        Feature switchPortCount = simulator.getFeature(52);
        if (switchPortCount != null && switchPortCount.getValue() > 0) {
            JPanel switchPorts = new JPanel();
            switchPorts.setBorder(new EmptyBorder(5, 5, 5, 5));
            switchPorts.setLayout(new GridLayout(0, 8, 5, 5));
            LOGGER.info("Initializing switchPort LEDs.");
            for (int i = 0; i < switchPortCount.getValue(); ++i) {
                LED led = new LED(Color.LIGHT_GRAY, Color.GREEN, true);
                led.setSize(10, 10);
                led.setToolTipText("Switch " + i);
                this.switchPortLeds.put(i, led);
                switchPorts.add((Component)led);
            }
            formBuilder.add((Component)new JLabel("Switch ports")).xy(1, 5);
            formBuilder.add((Component)switchPorts).xy(3, 5);
        } else {
            LOGGER.warn("No configured SwitchPorts available.");
        }
        JButton identifyButton = new JButton("Identify");
        identifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightControlPanel.this.publishIdentify(null);
            }
        });
        formBuilder.add((Component)identifyButton).xyw(1, 7, 3);
        JButton forceRestartNodeButton = new JButton("Force restart.");
        forceRestartNodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightControlPanel.this.publishSysError(SysErrorEnum.BIDIB_ERR_RESET_REQUIRED, new byte[0]);
            }
        });
        formBuilder.add((Component)forceRestartNodeButton).xyw(1, 9, 3);
        JButton forceAddrStackButton = new JButton("Force BIDIB_ERR_ADDRSTACK.");
        forceAddrStackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightControlPanel.this.publishSysError(SysErrorEnum.BIDIB_ERR_ADDRSTACK, new byte[0]);
            }
        });
        formBuilder.add((Component)forceAddrStackButton).xyw(1, 11, 3);
        JButton clearNodeErrorButton = new JButton("Clear error.");
        clearNodeErrorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightControlPanel.this.publishSysError(SysErrorEnum.BIDIB_ERR_NONE, new byte[0]);
            }
        });
        formBuilder.add((Component)clearNodeErrorButton).xyw(1, 13, 3);
        JButton setStallButton = new JButton("STALL");
        setStallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightControlPanel.this.toggleStall();
            }
        });
        formBuilder.add((Component)setStallButton).xyw(1, 15, 3);
        JButton forceAccStateErrorServoButton = new JButton("Force BIDIB_ACC_STATE_ERROR_SERVO.");
        forceAccStateErrorServoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightControlPanel.this.publishAccessoryStateError(AccessoryStateErrorEnum.BIDIB_ACC_STATE_ERROR_SERVO);
            }
        });
        formBuilder.add((Component)forceAccStateErrorServoButton).xyw(1, 17, 3);
        this.contentPanel = formBuilder.build();
        AnnotationProcessor.process((Object)this);
        simulator.queryStatus(InputPort.class);
        simulator.queryStatus(LightPort.class);
        simulator.queryStatus(SwitchPort.class);
    }

    public DockKey getDockKey() {
        return this.DOCKKEY;
    }

    @Override
    public void stop() {
        AnnotationProcessor.unprocess((Object)this);
        this.container.close(this);
    }

    private void publishSysError(SysErrorEnum sysErrorEnum, byte ... reason) {
        String nodeAddress = NodeUtils.formatAddress((byte[])this.getNode().getNode().getAddr());
        SysErrorEvent sysErrorEvent = new SysErrorEvent(nodeAddress, sysErrorEnum, reason);
        LOGGER.info("Publish the sysErrorEvent: {}", (Object)sysErrorEvent);
        EventBus.publish((Object)sysErrorEvent);
    }

    private void publishAccessoryStateError(AccessoryStateErrorEnum accessoryStateErrorEnum) {
        String nodeAddress = NodeUtils.formatAddress((byte[])this.getNode().getNode().getAddr());
        AccessoryStateErrorEvent accessoryStateErrorEvent = new AccessoryStateErrorEvent(nodeAddress, accessoryStateErrorEnum);
        LOGGER.info("Publish the accessoryStateErrorEvent: {}", (Object)accessoryStateErrorEvent);
        EventBus.publish((Object)accessoryStateErrorEvent);
    }

    private void toggleStall() {
        boolean stall = this.nodeStall.get();
        stall = !stall;
        this.nodeStall.set(stall);
        String nodeAddress = NodeUtils.formatAddress((byte[])this.getNode().getNode().getAddr());
        StallEvent stallEvent = new StallEvent(nodeAddress, stall);
        LOGGER.info("Publish the stallEvent: {}", (Object)stallEvent);
        EventBus.publish((Object)stallEvent);
    }

    private void publishIdentify(Boolean identify) {
        String nodeAddress = NodeUtils.formatAddress((byte[])this.getNode().getNode().getAddr());
        IdentifyEvent identifyEvent = new IdentifyEvent(nodeAddress, identify);
        LOGGER.info("Publish the identifyEvent: {}", (Object)identifyEvent);
        EventBus.publish((Object)identifyEvent);
    }

    private void toggleInputPort(int portNum) {
        LedButton ledButton = this.inputPortLeds.get(portNum);
        String nodeAddress = NodeUtils.formatAddress((byte[])this.getNode().getNode().getAddr());
        InputPortSetStatusEvent inputPortSetStatusEvent = new InputPortSetStatusEvent(nodeAddress, portNum, ledButton.getStatus());
        LOGGER.info("Publish the inputPortSetStatusEvent: {}", (Object)inputPortSetStatusEvent);
        EventBus.publish((Object)inputPortSetStatusEvent);
    }

    @EventSubscriber(eventClass=InputPortStatusEvent.class)
    public void inputPortStatusChanged(InputPortStatusEvent statusEvent) {
        LOGGER.info("The inputport status has changed, portNumber: {}, status: {}, node: {}", new Object[]{statusEvent.getPortNumber(), statusEvent.getStatus(), this.getNode()});
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        int id = statusEvent.getPortNumber();
        InputPortStatus status = statusEvent.getStatus();
        LedButton led = this.inputPortLeds.get(id);
        if (led != null) {
            LOGGER.trace("Found input to switch.");
            led.setStatus(status);
        } else {
            LOGGER.trace("Led not found.");
        }
    }

    @EventSubscriber(eventClass=LightPortStatusEvent.class)
    public void lightPortStatusChanged(LightPortStatusEvent statusEvent) {
        LOGGER.info("The lightport status has changed, port: {}, status: {}, node: {}", new Object[]{statusEvent.getPortNumber(), statusEvent.getStatus(), this.getNode()});
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        LightPortStatus status = statusEvent.getStatus();
        int id = statusEvent.getPortNumber();
        LED led = this.lightPortLeds.get(id);
        if (led != null) {
            LOGGER.trace("Found led to switch.");
            if (status == LightPortStatus.OFF) {
                led.usePrimary();
            } else {
                led.useSecondary();
            }
        } else {
            LOGGER.trace("Led not found.");
        }
    }

    @EventSubscriber(eventClass=SwitchPortStatusEvent.class)
    public void switchPortStatusChanged(SwitchPortStatusEvent statusEvent) {
        LOGGER.info("The switchport status has changed, port: {}, status: {}, node: {}", new Object[]{statusEvent.getPortNumber(), statusEvent.getStatus(), this.getNode()});
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        SwitchPortStatus status = statusEvent.getStatus();
        int id = statusEvent.getPortNumber();
        LED led = this.switchPortLeds.get(id);
        if (led != null) {
            LOGGER.trace("Found led to switch.");
            if (status == SwitchPortStatus.OFF) {
                led.usePrimary();
            } else {
                led.useSecondary();
            }
        } else {
            LOGGER.trace("Led not found.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LightControlPanel, dockKey: ");
        sb.append(this.DOCKKEY).append(", node: ").append(this.getNode());
        return sb.toString();
    }

    private static final class LedButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private int portNum;
        private InputPortStatus status = InputPortStatus.OFF;
        private ColorIcon offIcon = new ColorIcon(10, Color.GRAY);
        private ColorIcon onIcon = new ColorIcon(10, Color.RED);

        public LedButton(int portNum) {
            this.setIcon((Icon)this.offIcon);
            this.portNum = portNum;
        }

        public int getPortNum() {
            return this.portNum;
        }

        public InputPortStatus getStatus() {
            return this.status;
        }

        public void setStatus(InputPortStatus status) {
            this.status = status;
            if (status == InputPortStatus.OFF) {
                this.setIcon((Icon)this.offIcon);
            } else {
                this.setIcon((Icon)this.onIcon);
            }
        }
    }
}

