/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation.client.view.panel;

import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.events.SimulatorStatusEvent;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.simulation.client.view.SimulationNodePanel;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSimulatorNodePanel
implements SimulationNodePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSimulatorNodePanel.class);
    private final NodeInterface node;
    protected JPanel contentPanel;
    private JScrollPane scrollContent;

    public AbstractSimulatorNodePanel(NodeInterface node) {
        this.node = node;
    }

    protected boolean isMatchingAddress(String address) {
        return NodeUtils.formatAddress((byte[])this.node.getAddr()).equals(address);
    }

    public Component getComponent() {
        if (this.scrollContent == null) {
            this.scrollContent = new JScrollPane(this.contentPanel);
        }
        return this.scrollContent;
    }

    @Override
    public NodeInterface getNode() {
        return this.node;
    }

    @EventSubscriber(eventClass=SimulatorStatusEvent.class)
    public void simulatortStatusChanged(SimulatorStatusEvent statusEvent) {
        LOGGER.info("The inputport status has changed, nodeAddr: {}, status: {}", (Object)statusEvent.getNodeAddr(), (Object)statusEvent.getStatus());
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        if (statusEvent.getStatus().equals((Object)SimulatorStatusEvent.Status.stopped)) {
            LOGGER.info("The simulator was stopped. Close the simulator node panel.");
            this.stop();
        }
    }

    public abstract void stop();

    public void dockableStateChanged(DockableStateChangeEvent event) {
        LOGGER.debug("The dockable state has changed: {}", (Object)event);
    }
}

