/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation.client.controller;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.jbidibc.simulation.annotation.BidibVidPid;
import org.bidib.jbidibc.simulation.nodes.BacklightPortParamsType;
import org.bidib.jbidibc.simulation.nodes.BacklightPortType;
import org.bidib.jbidibc.simulation.nodes.FeatureType;
import org.bidib.jbidibc.simulation.nodes.FeaturesType;
import org.bidib.jbidibc.simulation.nodes.HubType;
import org.bidib.jbidibc.simulation.nodes.InputPortParamsType;
import org.bidib.jbidibc.simulation.nodes.InputPortType;
import org.bidib.jbidibc.simulation.nodes.LightPortParamsType;
import org.bidib.jbidibc.simulation.nodes.LightPortType;
import org.bidib.jbidibc.simulation.nodes.MasterType;
import org.bidib.jbidibc.simulation.nodes.NodeType;
import org.bidib.jbidibc.simulation.nodes.ServoPortParamsType;
import org.bidib.jbidibc.simulation.nodes.ServoPortType;
import org.bidib.jbidibc.simulation.nodes.Simulation;
import org.bidib.jbidibc.simulation.nodes.SubNodesType;
import org.bidib.jbidibc.simulation.nodes.SwitchPortParamsType;
import org.bidib.jbidibc.simulation.nodes.SwitchPortType;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeProvider;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.core.utils.BidibNodeSimulatorScanner;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationExport {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulationExport.class);
    private final Map<BidibVidPid, String> lookupSimulatorClass = BidibNodeSimulatorScanner.findSimulatorClasses();

    public Simulation exportNodeTreeToSimulation(BidibConnection connection) {
        LOGGER.info("Export simulation.");
        Simulation simulation = new Simulation();
        NodeProvider nodeProvider = connection.getNodeProvider();
        LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>(nodeProvider.getNodes());
        NodeInterface masterNode = nodes.stream().filter(node -> Arrays.equals(NodeUtils.ROOT_ADDRESS, node.getAddr())).findFirst().orElse(null);
        if (masterNode != null) {
            MasterType master = new MasterType();
            master.withSubNodes(new SubNodesType());
            this.createSimulationFromNode(masterNode, (NodeType)master);
            simulation.setMaster(master);
            nodes.remove(masterNode);
            for (NodeInterface node2 : nodes) {
                LOGGER.info("Current node: {}", (Object)node2);
                if (!NodeUtils.isDirectSubNode((byte[])masterNode.getAddr(), (byte[])node2.getAddr())) continue;
                NodeType nodeType = NodeUtils.hasSubNodesFunctions((long)node2.getUniqueId()) ? new HubType().withSubNodes(new SubNodesType()) : new NodeType();
                try {
                    this.createSimulationFromNode(node2, nodeType);
                    LOGGER.info("Prepared nodeType: {}", (Object)nodeType);
                    master.getSubNodes().withNode(new NodeType[]{nodeType});
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Add node to simulation failed.", (Throwable)ex);
                }
                if (!(nodeType instanceof HubType)) continue;
                List<NodeInterface> subNodes = this.getSubNodes(node2, nodes);
                this.processNodes(simulation, subNodes, node2.getAddr(), (HubType)nodeType);
            }
        }
        LOGGER.info("Prepared simulation: {}", (Object)simulation);
        return simulation;
    }

    private void processNodes(Simulation simulation, List<NodeInterface> nodes, byte[] parentAddress, HubType parentNodeType) {
        LOGGER.info("Process nodes of parent: {}", (Object)parentNodeType);
        for (NodeInterface node : nodes) {
            LOGGER.info("Current node: {}", (Object)node);
            if (!NodeUtils.isDirectSubNode((byte[])parentAddress, (byte[])node.getAddr())) continue;
            NodeType nodeType = NodeUtils.hasSubNodesFunctions((long)node.getUniqueId()) ? new HubType().withSubNodes(new SubNodesType()) : new NodeType();
            try {
                this.createSimulationFromNode(node, nodeType);
                LOGGER.info("Prepared nodeType: {}", (Object)nodeType);
                parentNodeType.getSubNodes().withNode(new NodeType[]{nodeType});
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Add node to simulation failed.", (Throwable)ex);
            }
            if (!(nodeType instanceof HubType)) continue;
            List<NodeInterface> subNodes = this.getSubNodes(node, nodes);
            this.processNodes(simulation, subNodes, node.getAddr(), (HubType)nodeType);
        }
    }

    private List<NodeInterface> getSubNodes(NodeInterface parent, List<NodeInterface> nodes) {
        LinkedList<NodeInterface> subNodes = new LinkedList<NodeInterface>();
        subNodes.addAll(nodes.stream().filter(node -> NodeUtils.isSubNode((Node)parent.getNode(), (Node)node.getNode())).collect(Collectors.toList()));
        LOGGER.info("Prepared subNodes: {}", subNodes);
        return subNodes;
    }

    private void createSimulationFromNode(NodeInterface node, NodeType nodeType) {
        SwitchPortParamsType portParamsType;
        String simulatorClassName = this.lookupSimulatorClass.get(BidibVidPid.of((long)node.getUniqueId()));
        if (simulatorClassName == null) {
            LOGGER.warn("No supported interface node: {}", (Object)ByteUtils.getUniqueIdAsString((long)node.getUniqueId()));
            throw new IllegalArgumentException("Not supported interface node: " + ByteUtils.getUniqueIdAsString((long)node.getUniqueId()));
        }
        nodeType.withAddress(Integer.toString(NodeUtils.getLocalAddress((byte[])node.getAddr()))).withUniqueId(NodeUtils.getUniqueId((long)node.getUniqueId())).withClassName(simulatorClassName).withProductName(this.getSafeProductName(node, simulatorClassName)).withUserName(node.getNode().getStoredString(1)).withProtocolVersion(node.getNode().getProtocolVersion().toString()).withSoftwareVersion(node.getNode().getSoftwareVersion().toString());
        FeaturesType features = new FeaturesType();
        for (Object feature : node.getNode().getFeatures()) {
            features.withFeature(new FeatureType[]{new FeatureType().withType(feature.getFeatureName()).withValue(Integer.valueOf(feature.getValue()))});
        }
        nodeType.withFeatures(features);
        if (node.hasLightPorts()) {
            LightPortType lightPortType = new LightPortType().withCount(node.getLightPorts().size());
            nodeType.withLPORT(lightPortType);
            for (LightPort lightPort : node.getLightPorts()) {
                portParamsType = new LightPortParamsType().withPortId(lightPort.getId()).withDimSlopeDown(Integer.valueOf(lightPort.getDimMin())).withDimSlopeUp(Integer.valueOf(lightPort.getDimMax())).withIntensityOff(Integer.valueOf(lightPort.getPwmMin())).withIntensityOn(Integer.valueOf(lightPort.getPwmMax())).withDmxMapping(lightPort.getDmxMapping()).withRgbValue(lightPort.getRgbValue() != null ? Integer.toString(lightPort.getRgbValue(), 16) : null).withTransitionTime(lightPort.getTransitionTime());
                lightPortType.withPort(new LightPortParamsType[]{portParamsType});
            }
        }
        if (node.hasBacklightPorts()) {
            BacklightPortType backlightPortType = new BacklightPortType().withCount(node.getBacklightPorts().size());
            nodeType.withBACKLIGHT(backlightPortType);
            for (BacklightPort backlightPort : node.getBacklightPorts()) {
                portParamsType = new BacklightPortParamsType().withPortId(backlightPort.getId()).withDimSlopeDown(Integer.valueOf(backlightPort.getDimSlopeDown())).withDimSlopeUp(Integer.valueOf(backlightPort.getDimSlopeUp())).withDmxMapping(backlightPort.getDmxMapping());
                backlightPortType.withPort(new BacklightPortParamsType[]{portParamsType});
            }
        }
        if (node.hasServoPorts()) {
            ServoPortType servoPortType = new ServoPortType().withCount(node.getServoPorts().size());
            nodeType.withSERVO(servoPortType);
            for (ServoPort servoPort : node.getServoPorts()) {
                portParamsType = new ServoPortParamsType().withPortId(servoPort.getId()).withAdjustLow(Integer.valueOf(servoPort.getTrimDown())).withAdjustHigh(Integer.valueOf(servoPort.getTrimUp())).withSpeed(Integer.valueOf(servoPort.getSpeed()));
                servoPortType.withPort(new ServoPortParamsType[]{portParamsType});
            }
        }
        if (node.hasSwitchPorts()) {
            SwitchPortType switchPortType = new SwitchPortType().withCount(node.getSwitchPorts().size());
            nodeType.withSPORT(switchPortType);
            for (SwitchPort switchPort : node.getSwitchPorts()) {
                portParamsType = new SwitchPortParamsType().withPortId(switchPort.getId()).withTicks(switchPort.getTicks());
                switchPortType.withPort(new SwitchPortParamsType[]{portParamsType});
            }
        }
        if (node.hasInputPorts()) {
            List portList;
            InputPortType inputPortType = new InputPortType().withCount(node.getInputPorts().size());
            nodeType.withINPUT(inputPortType);
            for (InputPort inputPort : node.getInputPorts()) {
                portParamsType = new InputPortParamsType().withPortId(inputPort.getId()).withTicks(inputPort.getTicks());
                inputPortType.withPort(new InputPortParamsType[]{portParamsType});
            }
            if (node.isFlatPortModel() && !(portList = PortListUtils.sortPortsByNumber((List)node.getInputPorts())).isEmpty()) {
                int portOffset = ((InputPort)portList.get(0)).getId();
                inputPortType.withOffset(Integer.valueOf(portOffset));
            }
        }
        if (ProductUtils.isOneDMX((long)node.getUniqueId())) {
            LOGGER.info("The current node is a OneDMX: {}", (Object)node);
        }
    }

    private String getSafeProductName(NodeInterface node, String simulatorClassName) {
        if (node.getNode().getStoredString(0) != null) {
            String productName = node.getNode().getStoredString(0).trim();
            if (productName.length() > 0) {
                return productName;
            }
            return " ";
        }
        return simulatorClassName;
    }
}

