/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation.client.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.vlsolutions.swing.docking.DockKey;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.AccessoryStateErrorEnum;
import org.bidib.jbidibc.messages.enums.SysErrorEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.jbidibc.simulation.events.AccessoryStateErrorEvent;
import org.bidib.jbidibc.simulation.events.StallEvent;
import org.bidib.jbidibc.simulation.events.SysErrorEvent;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.led.ColorIcon;
import org.bidib.wizard.client.common.led.LED;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.simulation.LightControlSimulator;
import org.bidib.wizard.simulation.client.view.panel.AbstractSimulatorNodePanel;
import org.bidib.wizard.simulation.client.view.panel.SimulationViewContainer;
import org.bidib.wizard.simulation.events.FeedbackConfidenceSetEvent;
import org.bidib.wizard.simulation.events.FeedbackConfidenceStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortSetStatusEvent;
import org.bidib.wizard.simulation.events.FeedbackPortStatusEvent;
import org.bidib.wizard.simulation.events.InputPortSetStatusEvent;
import org.bidib.wizard.simulation.events.InputPortStatusEvent;
import org.bidib.wizard.simulation.events.LightPortStatusEvent;
import org.bidib.wizard.simulation.events.SwitchPortStatusEvent;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneControlPanel
extends AbstractSimulatorNodePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(OneControlPanel.class);
    private static final String ENCODED_ROW_SPECS = "pref";
    private final DockKey DOCKKEY;
    private final SimulationViewContainer container;
    private Map<Integer, LED> lightPortLeds = new HashMap<Integer, LED>();
    private Map<Integer, LedButton> inputPortLeds = new HashMap<Integer, LedButton>();
    private Map<Integer, LED> switchPortLeds = new HashMap<Integer, LED>();
    private Map<Integer, LED> feedbackPortLeds = new HashMap<Integer, LED>();
    private final AtomicBoolean statusFreeze = new AtomicBoolean();
    private final AtomicBoolean statusValid = new AtomicBoolean();
    private final AtomicBoolean statusSignal = new AtomicBoolean();
    private JToggleButton freezeButton;

    public OneControlPanel(SimulationViewContainer container, NodeInterface node) {
        super(node);
        this.container = container;
        String uuid = ByteUtils.getUniqueIdAsString((long)node.getUniqueId());
        this.DOCKKEY = new DockKey(this.getClass().getSimpleName() + "-" + StringUtils.trimToEmpty((String)uuid));
        this.DOCKKEY.setFloatEnabled(true);
    }

    @Override
    public void createComponents(SimulatorNode simulator) {
        LED led;
        int i;
        Object panel;
        if (!(simulator instanceof LightControlSimulator)) {
            LOGGER.warn("The provided simulator is not a LightControlSimulator: {}", (Object)simulator);
            throw new IllegalArgumentException("The provided simulator is not a LightControlSimulator!");
        }
        FormBuilder formBuilder = null;
        boolean debug = false;
        if (debug) {
            panel = new FormDebugPanel();
            formBuilder = FormBuilder.create().columns("pref, fill:50dlu:grow", new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            formBuilder = FormBuilder.create().columns("pref, fill:50dlu:grow", new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        int row = 1;
        Feature feedbackPortCount = simulator.getFeature(0);
        if (feedbackPortCount != null && feedbackPortCount.getValue() > 0) {
            JPanel feedbackPorts = new JPanel();
            feedbackPorts.setBorder(new EmptyBorder(5, 5, 5, 5));
            feedbackPorts.setLayout(new GridLayout(2, 8, 5, 5));
            int feedbackPortCountValue = feedbackPortCount.getValue();
            LOGGER.info("Initializing feedbackport LEDs.");
            for (i = 0; i < feedbackPortCountValue; ++i) {
                led = new LED(Color.GREEN, Color.RED, false);
                led.setSize(20, 20);
                led.setToolTipText("Feedback " + i);
                led.putClientProperty((Object)"portId", (Object)i);
                led.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        LOGGER.info("Mouse clicked on led: {}", (Object)led);
                        Integer portId = (Integer)led.getClientProperty((Object)"portId");
                        String nodeAddress = NodeUtils.formatAddress((byte[])OneControlPanel.this.getNode().getNode().getAddr());
                        FeedbackPortStatus feedbackPortStatus = !led.isUsePrimary() ? FeedbackPortStatus.OCCUPIED : FeedbackPortStatus.FREE;
                        FeedbackPortSetStatusEvent feedbackPortSetStatusEvent = new FeedbackPortSetStatusEvent(nodeAddress, portId.intValue(), feedbackPortStatus);
                        LOGGER.info("Publish the feedbackPortSetStatusEvent: {}", (Object)feedbackPortSetStatusEvent);
                        EventBus.publish((Object)feedbackPortSetStatusEvent);
                    }
                });
                this.feedbackPortLeds.put(i, led);
                feedbackPorts.add((Component)led);
            }
            formBuilder.add("Feedback ports", new Object[0]).xy(1, row);
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            formBuilder.add((Component)feedbackPorts).xy(1, row += 2);
            row += 2;
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            this.freezeButton = new JToggleButton("Freeze");
            this.freezeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OneControlPanel.this.statusFreeze.set(!OneControlPanel.this.statusFreeze.get());
                    String nodeAddress = NodeUtils.formatAddress((byte[])OneControlPanel.this.getNode().getNode().getAddr());
                    FeedbackConfidenceSetEvent feedbackConfidenceEvent = new FeedbackConfidenceSetEvent(nodeAddress, OneControlPanel.this.statusValid.get(), OneControlPanel.this.statusFreeze.get(), OneControlPanel.this.statusSignal.get());
                    LOGGER.info("Publish the feedbackConfidenceEvent: {}", (Object)feedbackConfidenceEvent);
                    EventBus.publish((Object)feedbackConfidenceEvent);
                }
            });
            this.freezeButton.setForeground(Color.GREEN.darker());
            formBuilder.add((Component)this.freezeButton).xy(1, row);
            row += 2;
            formBuilder.appendRows("3dlu, pref", new Object[0]);
        } else {
            LOGGER.warn("No configured FeedbackPorts available.");
        }
        Feature lightPortCount = simulator.getFeature(53);
        if (lightPortCount != null && lightPortCount.getValue() > 0) {
            JPanel lightPorts = new JPanel();
            lightPorts.setBorder(new EmptyBorder(5, 5, 5, 5));
            lightPorts.setLayout(new GridLayout(0, 8, 5, 5));
            LOGGER.info("Initializing lightPort LEDs.");
            for (i = 0; i < lightPortCount.getValue(); ++i) {
                led = new LED(Color.LIGHT_GRAY, Color.GREEN, true);
                led.setSize(10, 10);
                led.setToolTipText("Light " + i);
                this.lightPortLeds.put(i, led);
                lightPorts.add((Component)led);
            }
            formBuilder.add("Light ports", new Object[0]).xy(1, row);
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            formBuilder.add((Component)lightPorts).xy(1, row += 2);
            row += 2;
            formBuilder.appendRows("3dlu, pref", new Object[0]);
        } else {
            LOGGER.warn("No configured LightPorts available.");
        }
        Feature inputPortCount = simulator.getFeature(50);
        if (inputPortCount != null && inputPortCount.getValue() > 0) {
            JPanel inputPorts = new JPanel();
            inputPorts.setBorder(new EmptyBorder(5, 5, 5, 5));
            inputPorts.setLayout(new GridLayout(0, 8, 5, 5));
            LightControlSimulator lightControlSimulator = (LightControlSimulator)simulator;
            int inputPortOffset = lightControlSimulator.getInputPortOffset();
            LOGGER.info("Initializing inputPort LEDs.");
            for (int portNum = 0; portNum < inputPortCount.getValue(); ++portNum) {
                final LedButton led2 = new LedButton(portNum + inputPortOffset);
                led2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OneControlPanel.this.toggleInputPort(led2.getPortNum());
                    }
                });
                led2.setSize(new Dimension(12, 12));
                led2.setMinimumSize(new Dimension(12, 12));
                led2.setPreferredSize(new Dimension(12, 12));
                led2.setMargin(new Insets(5, 5, 5, 5));
                led2.setToolTipText("Input " + (portNum + inputPortOffset));
                this.inputPortLeds.put(portNum + inputPortOffset, led2);
                inputPorts.add(led2);
            }
            formBuilder.add("Input ports", new Object[0]).xy(1, row);
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            formBuilder.add((Component)inputPorts).xy(1, row += 2);
            row += 2;
            formBuilder.appendRows("3dlu, pref", new Object[0]);
        } else {
            LOGGER.warn("No configured InputPorts available.");
        }
        Feature switchPortCount = simulator.getFeature(52);
        if (switchPortCount != null && switchPortCount.getValue() > 0) {
            JPanel switchPorts = new JPanel();
            switchPorts.setBorder(new EmptyBorder(5, 5, 5, 5));
            switchPorts.setLayout(new GridLayout(0, 8, 5, 5));
            LOGGER.info("Initializing switchPort LEDs.");
            for (int i2 = 0; i2 < switchPortCount.getValue(); ++i2) {
                LED led3 = new LED(Color.LIGHT_GRAY, Color.GREEN, true);
                led3.setSize(10, 10);
                led3.setToolTipText("Switch " + i2);
                this.switchPortLeds.put(i2, led3);
                switchPorts.add((Component)led3);
            }
            formBuilder.add("Switch ports", new Object[0]).xy(1, row);
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            formBuilder.add((Component)switchPorts).xy(1, row += 2);
            row += 2;
            formBuilder.appendRows("3dlu, pref", new Object[0]);
        } else {
            LOGGER.warn("No configured SwitchPorts available.");
        }
        JButton forceRestartNodeButton = new JButton("Force restart.");
        forceRestartNodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneControlPanel.this.publishSysError(SysErrorEnum.BIDIB_ERR_RESET_REQUIRED, new byte[0]);
            }
        });
        formBuilder.add((Component)forceRestartNodeButton).xy(1, row);
        formBuilder.appendRows("3dlu, pref", new Object[0]);
        JButton forceAddrStackButton = new JButton("Force BIDIB_ERR_ADDRSTACK.");
        forceAddrStackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneControlPanel.this.publishSysError(SysErrorEnum.BIDIB_ERR_ADDRSTACK, new byte[0]);
            }
        });
        formBuilder.add((Component)forceAddrStackButton).xy(1, row += 2);
        formBuilder.appendRows("3dlu, pref", new Object[0]);
        JButton clearNodeErrorButton = new JButton("Clear error.");
        clearNodeErrorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneControlPanel.this.publishSysError(SysErrorEnum.BIDIB_ERR_NONE, new byte[0]);
            }
        });
        formBuilder.add((Component)clearNodeErrorButton).xy(1, row += 2);
        formBuilder.appendRows("3dlu, pref", new Object[0]);
        JButton setStallButton = new JButton("STALL");
        setStallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneControlPanel.this.publishStall(true);
            }
        });
        formBuilder.add((Component)setStallButton).xy(1, row += 2);
        formBuilder.appendRows("3dlu, pref", new Object[0]);
        JButton forceAccStateErrorServoButton = new JButton("Force BIDIB_ACC_STATE_ERROR_SERVO.");
        forceAccStateErrorServoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneControlPanel.this.publishAccessoryStateError(AccessoryStateErrorEnum.BIDIB_ACC_STATE_ERROR_SERVO);
            }
        });
        formBuilder.add((Component)forceAccStateErrorServoButton).xy(1, row += 2);
        this.contentPanel = formBuilder.build();
        AnnotationProcessor.process((Object)this);
        simulator.queryStatus(InputPort.class);
        simulator.queryStatus(LightPort.class);
        simulator.queryStatus(SwitchPort.class);
        simulator.queryStatus(FeedbackPort.class);
    }

    public DockKey getDockKey() {
        return this.DOCKKEY;
    }

    @Override
    public void stop() {
        AnnotationProcessor.unprocess((Object)this);
        this.container.close(this);
    }

    private void publishSysError(SysErrorEnum sysErrorEnum, byte ... reason) {
        String nodeAddress = NodeUtils.formatAddress((byte[])this.getNode().getNode().getAddr());
        SysErrorEvent sysErrorEvent = new SysErrorEvent(nodeAddress, sysErrorEnum, reason);
        LOGGER.info("Publish the sysErrorEvent: {}", (Object)sysErrorEvent);
        EventBus.publish((Object)sysErrorEvent);
    }

    private void publishAccessoryStateError(AccessoryStateErrorEnum accessoryStateErrorEnum) {
        String nodeAddress = NodeUtils.formatAddress((byte[])this.getNode().getNode().getAddr());
        AccessoryStateErrorEvent accessoryStateErrorEvent = new AccessoryStateErrorEvent(nodeAddress, accessoryStateErrorEnum);
        LOGGER.info("Publish the accessoryStateErrorEvent: {}", (Object)accessoryStateErrorEvent);
        EventBus.publish((Object)accessoryStateErrorEvent);
    }

    private void publishStall(boolean stall) {
        String nodeAddress = NodeUtils.formatAddress((byte[])this.getNode().getNode().getAddr());
        StallEvent stallEvent = new StallEvent(nodeAddress, stall);
        LOGGER.info("Publish the stallEvent: {}", (Object)stallEvent);
        EventBus.publish((Object)stallEvent);
    }

    private void toggleInputPort(int portNum) {
        LedButton ledButton = this.inputPortLeds.get(portNum);
        String nodeAddress = NodeUtils.formatAddress((byte[])this.getNode().getNode().getAddr());
        InputPortSetStatusEvent inputPortSetStatusEvent = new InputPortSetStatusEvent(nodeAddress, portNum, ledButton.getStatus());
        LOGGER.info("Publish the inputPortSetStatusEvent: {}", (Object)inputPortSetStatusEvent);
        EventBus.publish((Object)inputPortSetStatusEvent);
    }

    @EventSubscriber(eventClass=InputPortStatusEvent.class)
    public void inputPortStatusChanged(InputPortStatusEvent statusEvent) {
        LOGGER.info("The inputport status has changed, portNumber: {}, status: {}, node: {}", new Object[]{statusEvent.getPortNumber(), statusEvent.getStatus(), this.getNode()});
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        int id = statusEvent.getPortNumber();
        InputPortStatus status = statusEvent.getStatus();
        LedButton led = this.inputPortLeds.get(id);
        if (led != null) {
            LOGGER.trace("Found input to switch.");
            led.setStatus(status);
        } else {
            LOGGER.trace("Led not found.");
        }
    }

    @EventSubscriber(eventClass=LightPortStatusEvent.class)
    public void lightPortStatusChanged(LightPortStatusEvent statusEvent) {
        LOGGER.info("The lightport status has changed, portNumber: {}, status: {}, node: {}", new Object[]{statusEvent.getPortNumber(), statusEvent.getStatus(), this.getNode()});
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        LightPortStatus status = statusEvent.getStatus();
        int id = statusEvent.getPortNumber();
        LED led = this.lightPortLeds.get(id);
        if (led != null) {
            LOGGER.trace("Found led to switch.");
            if (status == LightPortStatus.OFF) {
                led.usePrimary();
            } else {
                led.useSecondary();
            }
        } else {
            LOGGER.trace("Led not found.");
        }
    }

    @EventSubscriber(eventClass=SwitchPortStatusEvent.class)
    public void switchPortStatusChanged(SwitchPortStatusEvent statusEvent) {
        LOGGER.info("The switchport status has changed, port: {}, status: {}, node: {}", new Object[]{statusEvent.getPortNumber(), statusEvent.getStatus(), this.getNode()});
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        SwitchPortStatus status = statusEvent.getStatus();
        int id = statusEvent.getPortNumber();
        LED led = this.switchPortLeds.get(id);
        if (led != null) {
            LOGGER.trace("Found led to switch.");
            if (status == SwitchPortStatus.OFF) {
                led.usePrimary();
            } else {
                led.useSecondary();
            }
        } else {
            LOGGER.trace("Led not found.");
        }
    }

    @EventSubscriber(eventClass=FeedbackPortStatusEvent.class)
    public void updateStatus(FeedbackPortStatusEvent statusEvent) {
        LOGGER.info("The feedbackport status has changed, status: {}, node: {}", (Object)statusEvent, (Object)this.getNode());
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        FeedbackPortStatus status = statusEvent.getStatus();
        int id = statusEvent.getPortNumber();
        LED led = this.feedbackPortLeds.get(id);
        if (led != null) {
            LOGGER.trace("Found led to switch.");
            if (status == FeedbackPortStatus.FREE) {
                led.usePrimary();
            } else {
                led.useSecondary();
            }
        } else {
            LOGGER.trace("Led not found.");
        }
    }

    @EventSubscriber(eventClass=FeedbackConfidenceStatusEvent.class)
    public void updateFeedbackConfidenceStatus(FeedbackConfidenceStatusEvent statusEvent) {
        LOGGER.info("The feedbackport confidence status has changed, status: {}, node: {}", (Object)statusEvent, (Object)this.getNode());
        if (!this.isMatchingAddress(statusEvent.getNodeAddr())) {
            return;
        }
        this.statusValid.set(statusEvent.getValid());
        this.statusFreeze.set(statusEvent.getFreeze());
        this.statusSignal.set(statusEvent.getSignal());
        if (this.freezeButton != null) {
            this.freezeButton.setSelected(this.statusFreeze.get());
            this.freezeButton.setForeground(this.statusFreeze.get() ? Color.RED : Color.GREEN.darker());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LightControlPanel, dockKey: ");
        sb.append(this.DOCKKEY).append(", node: ").append(this.getNode());
        return sb.toString();
    }

    private static final class LedButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private int portNum;
        private InputPortStatus status = InputPortStatus.OFF;
        private ColorIcon offIcon = new ColorIcon(10, Color.GRAY);
        private ColorIcon onIcon = new ColorIcon(10, Color.RED);

        public LedButton(int portNum) {
            this.setIcon((Icon)this.offIcon);
            this.portNum = portNum;
        }

        public int getPortNum() {
            return this.portNum;
        }

        public InputPortStatus getStatus() {
            return this.status;
        }

        public void setStatus(InputPortStatus status) {
            this.status = status;
            if (status == InputPortStatus.OFF) {
                this.setIcon((Icon)this.offIcon);
            } else {
                this.setIcon((Icon)this.onIcon);
            }
        }
    }
}

