/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation.client.view;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.simulation.client.view.SimulationNodePanel;
import org.bidib.wizard.simulation.client.view.SimulatorProvider;
import org.bidib.wizard.simulation.client.view.panel.SimulationViewContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationView
implements Dockable,
SimulationViewContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulationView.class);
    private Map<NodeInterface, SimulationNodePanel> mapUUIDtoSimulation = new LinkedHashMap<NodeInterface, SimulationNodePanel>();
    private final SimulatorProvider simulatorProvider;
    private final DockingDesktop desktop;

    public SimulationView(SimulatorProvider simulatorProvider, DockingDesktop desktop) {
        this.simulatorProvider = simulatorProvider;
        this.desktop = desktop;
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_SIMULATION_VIEW;
    }

    public Component getComponent() {
        return null;
    }

    private void createSimulationNode(NodeInterface node, DockingDesktop desktop) {
        LOGGER.info("Create new simulation node: {}", (Object)node);
        SimulationNodePanel simulationNodePanel = this.mapUUIDtoSimulation.get(node);
        if (simulationNodePanel == null) {
            LOGGER.info("Create new simulationNodePanel for node: {}", (Object)node);
            SimulatorNode simulator = this.simulatorProvider.getSimulator(node);
            String simulationPanelClass = simulator.getSimulationPanelClass();
            simulationNodePanel = this.createSimulationNodePanel(simulationPanelClass, node);
            if (simulationNodePanel == null) {
                LOGGER.warn("No simulationNodePanel available for node: {}", (Object)node);
                return;
            }
            simulationNodePanel.createComponents(simulator);
            this.mapUUIDtoSimulation.put(node, simulationNodePanel);
        }
        LOGGER.info("Adding the new simulationNodePanel.");
        this.addSimulationNodeTab(desktop, simulationNodePanel);
    }

    private SimulationNodePanel createSimulationNodePanel(String className, NodeInterface node) {
        LOGGER.info("Create new SimulationNodePanel of class: {}, node: {}", (Object)className, (Object)node);
        SimulationNodePanel simulationNodePanel = null;
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> ctor = clazz.getDeclaredConstructor(SimulationViewContainer.class, NodeInterface.class);
            simulationNodePanel = (SimulationNodePanel)ctor.newInstance(this, node);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.warn("Create instance of SimulationNodePanel failed.", (Throwable)e);
        }
        return simulationNodePanel;
    }

    private void addSimulationNodeTab(DockingDesktop desktop, SimulationNodePanel simulationNodePanel) {
        LOGGER.info("Create new tab to add the simulationNodePanel.");
        boolean oldImpl = false;
        if (oldImpl) {
            int order = 1;
            TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)this);
            if (container != null) {
                order = container.getTabCount();
            }
            LOGGER.info("Add new simulationNodePanel at order: {}", (Object)order);
            SimulationView base = this;
            DockableState dockable = desktop.getDockableState((Dockable)base);
            if (dockable == null || dockable.isClosed()) {
                this.simulatorProvider.restoreSimulationView();
            }
            desktop.addDockable((Dockable)simulationNodePanel, RelativeDockablePosition.BOTTOM_RIGHT);
            desktop.addDockableStateChangeListener((DockableStateChangeListener)simulationNodePanel);
        } else {
            DockableState[] dockables = desktop.getDockables();
            LOGGER.info("Current dockables: {}", new Object[]{dockables});
            if (desktop.getDockables().length > 1) {
                DockableState consoleView = null;
                for (DockableState dockable : dockables) {
                    if (!DockKeys.DOCKKEY_CONSOLE_VIEW.equals((Object)dockable.getDockable().getDockKey())) continue;
                    LOGGER.info("Found the console view dockable.");
                    consoleView = dockable;
                    break;
                }
                Dockable dock = desktop.getDockables()[1].getDockable();
                if (consoleView != null) {
                    LOGGER.info("Add the console view to the console view panel.");
                    dock = consoleView.getDockable();
                    int order = 0;
                    LOGGER.info("Add new simulator view at order: {}", (Object)order);
                    desktop.createTab(dock, (Dockable)simulationNodePanel, order, true);
                    TabbedDockableContainer baseTab = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                    baseTab.removeDockable((Dockable)simulationNodePanel);
                    baseTab.addDockable((Dockable)simulationNodePanel, order);
                    baseTab.setSelectedDockable((Dockable)simulationNodePanel);
                } else if (desktop.getDockables().length > 1) {
                    desktop.split(dock, (Dockable)simulationNodePanel, DockingConstants.SPLIT_BOTTOM);
                    desktop.setDockableHeight((Dockable)simulationNodePanel, 0.2);
                } else {
                    desktop.split(dock, (Dockable)simulationNodePanel, DockingConstants.SPLIT_RIGHT);
                }
            } else {
                desktop.addDockable((Dockable)simulationNodePanel, RelativeDockablePosition.RIGHT);
            }
        }
    }

    public void activate(NodeInterface node, DockingDesktop desktop) {
        SimulationNodePanel simulationNodePanel = this.mapUUIDtoSimulation.get(node);
        if (simulationNodePanel != null) {
            DockableState dockable = desktop.getDockableState((Dockable)simulationNodePanel);
            if (dockable == null || dockable.isClosed()) {
                LOGGER.info("simulationNodePanel is closed or hidden.");
                this.addSimulationNodeTab(desktop, simulationNodePanel);
            } else if (dockable.isHidden()) {
                LOGGER.info("Restore the hidden dockable.");
                desktop.setAutoHide(dockable.getDockable(), false);
            } else {
                this.selectWindow(simulationNodePanel);
            }
        } else {
            this.createSimulationNode(node, desktop);
        }
    }

    private void selectWindow(Dockable dockable) {
        TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dockable);
        if (container != null) {
            container.setSelectedDockable(dockable);
        } else {
            LOGGER.warn("Container not available, select component directly.");
            dockable.getComponent().requestFocusInWindow();
        }
    }

    @Override
    public void close(final SimulationNodePanel simulationNodePanel) {
        LOGGER.info("Close simulationNodePanel: {}", (Object)simulationNodePanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimulationView.this.mapUUIDtoSimulation.remove(simulationNodePanel.getNode());
                DockableState dockable = SimulationView.this.desktop.getDockableState((Dockable)simulationNodePanel);
                if (dockable != null && !dockable.isClosed()) {
                    SimulationView.this.desktop.removeDockableStateChangeListener((DockableStateChangeListener)simulationNodePanel);
                    SimulationView.this.desktop.unregisterDockable((Dockable)simulationNodePanel);
                } else {
                    LOGGER.info("The current simulation panel is not registered on the desktop.");
                }
            }
        });
    }
}

